/*
 * Decompiled with CFR 0.152.
 */
package com.kp.md.picker.recurrencepicker;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ToggleButton;
import com.kp.md.picker.drawables.CheckableDrawable;

public class WeekButton
extends ToggleButton {
    private static int mDefaultTextColor;
    private static int mCheckedTextColor;
    private CheckableDrawable mDrawable;
    private boolean noAnimate = false;
    private CheckableDrawable.OnAnimationDone mCallback = new CheckableDrawable.OnAnimationDone(){

        @Override
        public void animationIsDone() {
            WeekButton.this.setTextColor(WeekButton.this.isChecked() ? mCheckedTextColor : mDefaultTextColor);
            WeekButton.this.mDrawable.setChecked(WeekButton.this.isChecked());
        }

        @Override
        public void animationHasBeenCancelled() {
            WeekButton.this.setTextColor(WeekButton.this.isChecked() ? mCheckedTextColor : mDefaultTextColor);
            WeekButton.this.mDrawable.setChecked(WeekButton.this.isChecked());
        }
    };

    public WeekButton(Context context) {
        super(context);
    }

    public WeekButton(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public WeekButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setCheckedNoAnimate(boolean checked) {
        this.noAnimate = true;
        this.setChecked(checked);
        this.noAnimate = false;
    }

    public void setChecked(boolean checked) {
        super.setChecked(checked);
        if (this.mDrawable != null) {
            if (this.noAnimate) {
                this.mDrawable.setChecked(checked);
                this.setTextColor(this.isChecked() ? mCheckedTextColor : mDefaultTextColor);
            } else {
                this.setTextColor(mCheckedTextColor);
                this.mDrawable.setCheckedOnClick(this.isChecked(), this.mCallback);
            }
        }
    }

    public void setBackgroundDrawable(Drawable d) {
        super.setBackgroundDrawable(d);
        this.mDrawable = d instanceof CheckableDrawable ? (CheckableDrawable)d : null;
    }

    public static void setStateColors(int defaultColor, int checkedColor) {
        mDefaultTextColor = defaultColor;
        mCheckedTextColor = checkedColor;
    }
}

