/*
 * Decompiled with CFR 0.152.
 */
package com.kp.md.picker.recurrencepicker;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.format.Time;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TimeFormatException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TableLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.kp.md.picker.R;
import com.kp.md.picker.common.DecisionButtonLayout;
import com.kp.md.picker.datepicker.RecurrenceEndDatePicker;
import com.kp.md.picker.drawables.CheckableDrawable;
import com.kp.md.picker.recurrencepicker.EventRecurrence;
import com.kp.md.picker.recurrencepicker.MRecurrencePicker;
import com.kp.md.picker.recurrencepicker.WeekButton;
import com.kp.md.picker.utilities.MUtils;
import com.kp.md.picker.utilities.RecurrenceUtils;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class RecurrenceOptionCreator
extends FrameLayout
implements AdapterView.OnItemSelectedListener,
RadioGroup.OnCheckedChangeListener,
CompoundButton.OnCheckedChangeListener,
View.OnClickListener,
RecurrenceEndDatePicker.OnDateSetListener {
    private static final String TAG = "RecurrenceOptionCreator";
    private static final int INTERVAL_MAX = 99;
    private static final int INTERVAL_DEFAULT = 1;
    private static final int COUNT_MAX = 730;
    private static final int COUNT_DEFAULT = 5;
    private static final int FIFTH_WEEK_IN_A_MONTH = 5;
    private static final int LAST_NTH_DAY_OF_WEEK = -1;
    private RecurrenceEndDatePicker mDateOnlyPicker;
    private View mRecurrencePicker;
    private DecisionButtonLayout mButtonLayout;
    private DateFormat mEndDateFormatter;
    private Resources mResources;
    private EventRecurrence mRecurrence = new EventRecurrence();
    private Time mTime = new Time();
    private RecurrenceModel mModel = new RecurrenceModel();
    private Toast mToast;
    private final int[] TIME_DAY_TO_CALENDAR_DAY = new int[]{1, 2, 3, 4, 5, 6, 7};
    private Spinner mFreqSpinner;
    private static final int[] mFreqModelToEventRecurrence = new int[]{4, 5, 6, 7};
    private EditText mInterval;
    private TextView mIntervalPreText;
    private TextView mIntervalPostText;
    private int mIntervalResId = -1;
    private Spinner mEndSpinner;
    private TextView mEndDateTextView;
    private EditText mEndCount;
    private TextView mPostEndCount;
    private boolean mHidePostEndCount;
    private ArrayList<CharSequence> mEndSpinnerArray = new ArrayList(3);
    private EndSpinnerAdapter mEndSpinnerAdapter;
    private String mEndNeverStr;
    private String mEndDateLabel;
    private String mEndCountLabel;
    private LinearLayout mWeekGroup;
    private LinearLayout mWeekGroup2;
    private WeekButton[] mWeekByDayButtons = new WeekButton[7];
    private String[][] mMonthRepeatByDayOfWeekStrs;
    private RadioGroup mMonthRepeatByRadioGroup;
    private RadioButton mRepeatMonthlyByNthDayOfWeek;
    private RadioButton mRepeatMonthlyByNthDayOfMonth;
    private String mMonthRepeatByDayOfWeekStr;
    private OnRecurrenceSetListener mRecurrenceSetListener;
    int mHeaderBackgroundColor;
    private DecisionButtonLayout.Callback mButtonLayoutCallback = new DecisionButtonLayout.Callback(){

        @Override
        public void onOkay() {
            String rrule;
            if (((RecurrenceOptionCreator)RecurrenceOptionCreator.this).mModel.recurrenceState == 0) {
                rrule = null;
            } else {
                RecurrenceOptionCreator.copyModelToEventRecurrence(RecurrenceOptionCreator.this.mModel, RecurrenceOptionCreator.this.mRecurrence);
                rrule = RecurrenceOptionCreator.this.mRecurrence.toString();
            }
            RecurrenceOptionCreator.this.mRecurrenceSetListener.onRecurrenceSet(rrule);
        }

        @Override
        public void onCancel() {
            RecurrenceOptionCreator.this.mRecurrenceSetListener.onCancelled();
        }
    };

    MRecurrencePicker.RecurrenceOption resolveRepeatOption() {
        if (this.mModel.freq == 0 && this.mModel.interval == 1 && this.mModel.end == 0) {
            return MRecurrencePicker.RecurrenceOption.DAILY;
        }
        return MRecurrencePicker.RecurrenceOption.CUSTOM;
    }

    public static boolean isSupportedMonthlyByNthDayOfWeek(int num) {
        return num > 0 && num <= 5 || num == -1;
    }

    public static boolean canHandleRecurrenceRule(EventRecurrence er) {
        switch (er.freq) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                return false;
            }
        }
        if (er.count > 0 && !TextUtils.isEmpty((CharSequence)er.until)) {
            return false;
        }
        int numOfByDayNum = 0;
        for (int i = 0; i < er.bydayCount; ++i) {
            if (!RecurrenceOptionCreator.isSupportedMonthlyByNthDayOfWeek(er.bydayNum[i])) continue;
            ++numOfByDayNum;
        }
        if (numOfByDayNum > 1) {
            return false;
        }
        if (numOfByDayNum > 0 && er.freq != 6) {
            return false;
        }
        if (er.bymonthdayCount > 1) {
            return false;
        }
        if (er.freq == 6) {
            if (er.bydayCount > 1) {
                return false;
            }
            if (er.bydayCount > 0 && er.bymonthdayCount > 0) {
                return false;
            }
        }
        return true;
    }

    private static void copyEventRecurrenceToModel(EventRecurrence er, RecurrenceModel model) {
        switch (er.freq) {
            case 4: {
                model.freq = 0;
                break;
            }
            case 6: {
                model.freq = 2;
                break;
            }
            case 7: {
                model.freq = 3;
                break;
            }
            case 5: {
                model.freq = 1;
                break;
            }
            default: {
                throw new IllegalStateException("freq=" + er.freq);
            }
        }
        if (er.interval > 0) {
            model.interval = er.interval;
        }
        model.endCount = er.count;
        if (model.endCount > 0) {
            model.end = 2;
        }
        if (!TextUtils.isEmpty((CharSequence)er.until)) {
            if (model.endDate == null) {
                model.endDate = new Time();
            }
            try {
                model.endDate.parse(er.until);
            }
            catch (TimeFormatException e) {
                model.endDate = null;
            }
            if (model.end == 2 && model.endDate != null) {
                throw new IllegalStateException("freq=" + er.freq);
            }
            model.end = 1;
        }
        Arrays.fill(model.weeklyByDayOfWeek, false);
        if (er.bydayCount > 0) {
            int count = 0;
            for (int i = 0; i < er.bydayCount; ++i) {
                int dayOfWeek = EventRecurrence.day2TimeDay(er.byday[i]);
                model.weeklyByDayOfWeek[dayOfWeek] = true;
                if (model.freq != 2 || !RecurrenceOptionCreator.isSupportedMonthlyByNthDayOfWeek(er.bydayNum[i])) continue;
                model.monthlyByDayOfWeek = dayOfWeek;
                model.monthlyByNthDayOfWeek = er.bydayNum[i];
                model.monthlyRepeat = 1;
                ++count;
            }
            if (model.freq == 2) {
                if (er.bydayCount != 1) {
                    throw new IllegalStateException("Can handle only 1 byDayOfWeek in monthly");
                }
                if (count != 1) {
                    throw new IllegalStateException("Didn't specify which nth day of week to repeat for a monthly");
                }
            }
        }
        if (model.freq == 2) {
            if (er.bymonthdayCount == 1) {
                if (model.monthlyRepeat == 1) {
                    throw new IllegalStateException("Can handle only by monthday or by nth day of week, not both");
                }
                model.monthlyByMonthDay = er.bymonthday[0];
                model.monthlyRepeat = 0;
            } else if (er.bymonthCount > 1) {
                throw new IllegalStateException("Can handle only one bymonthday");
            }
        }
    }

    private static void copyModelToEventRecurrence(RecurrenceModel model, EventRecurrence er) {
        if (model.recurrenceState == 0) {
            throw new IllegalStateException("There's no recurrence");
        }
        er.freq = mFreqModelToEventRecurrence[model.freq];
        er.interval = model.interval <= 1 ? 0 : model.interval;
        switch (model.end) {
            case 1: {
                if (model.endDate != null) {
                    model.endDate.switchTimezone("UTC");
                    model.endDate.normalize(false);
                    er.until = model.endDate.format2445();
                    er.count = 0;
                    break;
                }
                throw new IllegalStateException("end = END_BY_DATE but endDate is null");
            }
            case 2: {
                er.count = model.endCount;
                er.until = null;
                if (er.count > 0) break;
                throw new IllegalStateException("count is " + er.count);
            }
            default: {
                er.count = 0;
                er.until = null;
            }
        }
        er.bydayCount = 0;
        er.bymonthdayCount = 0;
        switch (model.freq) {
            case 2: {
                if (model.monthlyRepeat == 0) {
                    if (model.monthlyByMonthDay <= 0) break;
                    if (er.bymonthday == null || er.bymonthdayCount < 1) {
                        er.bymonthday = new int[1];
                    }
                    er.bymonthday[0] = model.monthlyByMonthDay;
                    er.bymonthdayCount = 1;
                    break;
                }
                if (model.monthlyRepeat != 1) break;
                if (!RecurrenceOptionCreator.isSupportedMonthlyByNthDayOfWeek(model.monthlyByNthDayOfWeek)) {
                    throw new IllegalStateException("month repeat by nth week but n is " + model.monthlyByNthDayOfWeek);
                }
                int count = 1;
                if (er.bydayCount < count || er.byday == null || er.bydayNum == null) {
                    er.byday = new int[count];
                    er.bydayNum = new int[count];
                }
                er.bydayCount = count;
                er.byday[0] = EventRecurrence.timeDay2Day(model.monthlyByDayOfWeek);
                er.bydayNum[0] = model.monthlyByNthDayOfWeek;
                break;
            }
            case 1: {
                int i;
                int count = 0;
                for (i = 0; i < 7; ++i) {
                    if (!model.weeklyByDayOfWeek[i]) continue;
                    ++count;
                }
                if (er.bydayCount < count || er.byday == null || er.bydayNum == null) {
                    er.byday = new int[count];
                    er.bydayNum = new int[count];
                }
                er.bydayCount = count;
                for (i = 6; i >= 0; --i) {
                    if (!model.weeklyByDayOfWeek[i]) continue;
                    er.bydayNum[--count] = 0;
                    er.byday[count] = EventRecurrence.timeDay2Day(i);
                }
                break;
            }
        }
        if (!RecurrenceOptionCreator.canHandleRecurrenceRule(er)) {
            throw new IllegalStateException("UI generated recurrence that it can't handle. ER:" + er.toString() + " Model: " + model.toString());
        }
    }

    public RecurrenceOptionCreator(Context context) {
        this(context, null);
    }

    public RecurrenceOptionCreator(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.spRecurrenceOptionCreatorStyle);
    }

    public RecurrenceOptionCreator(Context context, AttributeSet attrs, int defStyleAttr) {
        super((Context)MUtils.createThemeWrapper(context, R.attr.mPickerStyle, R.style.MPickerStyleLight, R.attr.spRecurrenceOptionCreatorStyle, R.style.RecurrenceOptionCreatorStyle), attrs, defStyleAttr);
        this.initializeLayout();
    }

    @TargetApi(value=21)
    public RecurrenceOptionCreator(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super((Context)MUtils.createThemeWrapper(context, R.attr.mPickerStyle, R.style.MPickerStyleLight, R.attr.spRecurrenceOptionCreatorStyle, R.style.RecurrenceOptionCreatorStyle), attrs, defStyleAttr, defStyleRes);
        this.initializeLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeLayout() {
        int weekButtonSelectedCircleColor;
        int weekButtonSelectedTextColor;
        int weekButtonUnselectedTextColor;
        TypedArray a = this.getContext().obtainStyledAttributes(R.styleable.RecurrenceOptionCreator);
        try {
            this.mHeaderBackgroundColor = a.getColor(R.styleable.RecurrenceOptionCreator_spHeaderBackground, 0);
            int endDateFormat = a.getInt(R.styleable.RecurrenceOptionCreator_spEndDateFormat, 1);
            this.mEndDateFormatter = DateFormat.getDateInstance(endDateFormat == 0 ? 3 : 2, Locale.getDefault());
            weekButtonUnselectedTextColor = a.getColor(R.styleable.RecurrenceOptionCreator_spWeekButtonUnselectedTextColor, MUtils.COLOR_ACCENT);
            weekButtonSelectedTextColor = a.getColor(R.styleable.RecurrenceOptionCreator_spWeekButtonSelectedTextColor, MUtils.COLOR_TEXT_PRIMARY_INVERSE);
            weekButtonSelectedCircleColor = a.getColor(R.styleable.RecurrenceOptionCreator_spWeekButtonSelectedCircleColor, MUtils.COLOR_ACCENT);
        }
        finally {
            a.recycle();
        }
        this.mResources = this.getResources();
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.recurrence_picker, (ViewGroup)this);
        this.mRecurrencePicker = this.findViewById(R.id.recurrence_picker);
        this.mDateOnlyPicker = (RecurrenceEndDatePicker)this.findViewById(R.id.date_only_picker);
        this.mDateOnlyPicker.setVisibility(8);
        this.mButtonLayout = (DecisionButtonLayout)this.findViewById(R.id.roc_decision_button_layout);
        this.mButtonLayout.applyOptions(this.mButtonLayoutCallback);
        MUtils.setViewBackground(this.findViewById(R.id.freqSpinnerHolder), this.mHeaderBackgroundColor, 3);
        this.mFreqSpinner = (Spinner)this.findViewById(R.id.freqSpinner);
        this.mFreqSpinner.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
        ArrayAdapter freqAdapter = ArrayAdapter.createFromResource((Context)this.getContext(), (int)R.array.recurrence_freq, (int)R.layout.roc_freq_spinner_item);
        freqAdapter.setDropDownViewResource(R.layout.roc_spinner_dropdown_item);
        this.mFreqSpinner.setAdapter((SpinnerAdapter)freqAdapter);
        Drawable freqSpinnerBg = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.abc_spinner_mtrl_am_alpha);
        PorterDuffColorFilter cfFreqSpinner = new PorterDuffColorFilter(MUtils.COLOR_TEXT_PRIMARY_INVERSE, PorterDuff.Mode.SRC_IN);
        if (freqSpinnerBg != null) {
            freqSpinnerBg.setColorFilter((ColorFilter)cfFreqSpinner);
            MUtils.setViewBackground((View)this.mFreqSpinner, freqSpinnerBg);
        }
        this.mInterval = (EditText)this.findViewById(R.id.interval);
        this.mInterval.addTextChangedListener((TextWatcher)new minMaxTextWatcher(1, 1, 99){

            @Override
            void onChange(int v) {
                if (RecurrenceOptionCreator.this.mIntervalResId != -1 && RecurrenceOptionCreator.this.mInterval.getText().toString().length() > 0) {
                    ((RecurrenceOptionCreator)RecurrenceOptionCreator.this).mModel.interval = v;
                    RecurrenceOptionCreator.this.updateIntervalText();
                    RecurrenceOptionCreator.this.mInterval.requestLayout();
                }
            }
        });
        this.mIntervalPreText = (TextView)this.findViewById(R.id.intervalPreText);
        this.mIntervalPostText = (TextView)this.findViewById(R.id.intervalPostText);
        this.mEndNeverStr = this.mResources.getString(R.string.recurrence_end_continously);
        this.mEndDateLabel = this.mResources.getString(R.string.recurrence_end_date_label);
        this.mEndCountLabel = this.mResources.getString(R.string.recurrence_end_count_label);
        this.mEndSpinnerArray.add(this.mEndNeverStr);
        this.mEndSpinnerArray.add(this.mEndDateLabel);
        this.mEndSpinnerArray.add(this.mEndCountLabel);
        this.mEndSpinner = (Spinner)this.findViewById(R.id.endSpinner);
        this.mEndSpinner.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
        this.mEndSpinnerAdapter = new EndSpinnerAdapter(this.getContext(), this.mEndSpinnerArray, R.layout.roc_end_spinner_item, R.id.spinner_item, R.layout.roc_spinner_dropdown_item);
        this.mEndSpinner.setAdapter((SpinnerAdapter)this.mEndSpinnerAdapter);
        this.mEndCount = (EditText)this.findViewById(R.id.endCount);
        this.mEndCount.addTextChangedListener((TextWatcher)new minMaxTextWatcher(1, 5, 730){

            @Override
            void onChange(int v) {
                if (((RecurrenceOptionCreator)RecurrenceOptionCreator.this).mModel.endCount != v) {
                    ((RecurrenceOptionCreator)RecurrenceOptionCreator.this).mModel.endCount = v;
                    RecurrenceOptionCreator.this.updateEndCountText();
                    RecurrenceOptionCreator.this.mEndCount.requestLayout();
                }
            }
        });
        this.mPostEndCount = (TextView)this.findViewById(R.id.postEndCount);
        this.mEndDateTextView = (TextView)this.findViewById(R.id.endDate);
        this.mEndDateTextView.setOnClickListener((View.OnClickListener)this);
        MUtils.setViewBackground((View)this.mEndDateTextView, MUtils.createButtonBg(this.getContext(), MUtils.COLOR_BUTTON_NORMAL, MUtils.COLOR_CONTROL_HIGHLIGHT));
        WeekButton.setStateColors(weekButtonUnselectedTextColor, weekButtonSelectedTextColor);
        this.mWeekGroup = (LinearLayout)this.findViewById(R.id.weekGroup);
        this.mWeekGroup2 = (LinearLayout)this.findViewById(R.id.weekGroup2);
        View eighthWeekDay = this.findViewById(R.id.week_day_8);
        if (eighthWeekDay != null) {
            eighthWeekDay.setVisibility(4);
        }
        this.mMonthRepeatByDayOfWeekStrs = new String[7][];
        this.mMonthRepeatByDayOfWeekStrs[0] = this.mResources.getStringArray(R.array.repeat_by_nth_sun);
        this.mMonthRepeatByDayOfWeekStrs[1] = this.mResources.getStringArray(R.array.repeat_by_nth_mon);
        this.mMonthRepeatByDayOfWeekStrs[2] = this.mResources.getStringArray(R.array.repeat_by_nth_tues);
        this.mMonthRepeatByDayOfWeekStrs[3] = this.mResources.getStringArray(R.array.repeat_by_nth_wed);
        this.mMonthRepeatByDayOfWeekStrs[4] = this.mResources.getStringArray(R.array.repeat_by_nth_thurs);
        this.mMonthRepeatByDayOfWeekStrs[5] = this.mResources.getStringArray(R.array.repeat_by_nth_fri);
        this.mMonthRepeatByDayOfWeekStrs[6] = this.mResources.getStringArray(R.array.repeat_by_nth_sat);
        int idx = RecurrenceUtils.getFirstDayOfWeek();
        String[] dayOfWeekString = new DateFormatSymbols().getShortWeekdays();
        int expandedWidthHeight = this.mResources.getDimensionPixelSize(R.dimen.week_button_state_on_circle_size);
        WeekButton[] tempWeekButtons = new WeekButton[]{(WeekButton)this.findViewById(R.id.week_day_1), (WeekButton)this.findViewById(R.id.week_day_2), (WeekButton)this.findViewById(R.id.week_day_3), (WeekButton)this.findViewById(R.id.week_day_4), (WeekButton)this.findViewById(R.id.week_day_5), (WeekButton)this.findViewById(R.id.week_day_6), (WeekButton)this.findViewById(R.id.week_day_7)};
        for (int i = 0; i < this.mWeekByDayButtons.length; ++i) {
            this.mWeekByDayButtons[idx] = tempWeekButtons[i];
            MUtils.setViewBackground((View)this.mWeekByDayButtons[idx], new CheckableDrawable(weekButtonSelectedCircleColor, false, expandedWidthHeight));
            this.mWeekByDayButtons[idx].setTextColor(weekButtonUnselectedTextColor);
            this.mWeekByDayButtons[idx].setTextOff(dayOfWeekString[this.TIME_DAY_TO_CALENDAR_DAY[idx]]);
            this.mWeekByDayButtons[idx].setTextOn(dayOfWeekString[this.TIME_DAY_TO_CALENDAR_DAY[idx]]);
            this.mWeekByDayButtons[idx].setOnCheckedChangeListener(this);
            if (++idx < 7) continue;
            idx = 0;
        }
        this.mMonthRepeatByRadioGroup = (RadioGroup)this.findViewById(R.id.monthGroup);
        this.mMonthRepeatByRadioGroup.setOnCheckedChangeListener((RadioGroup.OnCheckedChangeListener)this);
        this.mRepeatMonthlyByNthDayOfWeek = (RadioButton)this.findViewById(R.id.repeatMonthlyByNthDayOfTheWeek);
        this.mRepeatMonthlyByNthDayOfMonth = (RadioButton)this.findViewById(R.id.repeatMonthlyByNthDayOfMonth);
    }

    public void initializeData(long currentlyChosenTime, String timeZone, String recurrenceRule, @NonNull OnRecurrenceSetListener callback) {
        this.mRecurrence.wkst = EventRecurrence.timeDay2Day(RecurrenceUtils.getFirstDayOfWeek());
        this.mRecurrenceSetListener = callback;
        this.mTime.set(currentlyChosenTime);
        if (!TextUtils.isEmpty((CharSequence)timeZone)) {
            this.mTime.timezone = timeZone;
        }
        this.mTime.normalize(false);
        this.mModel.weeklyByDayOfWeek[this.mTime.weekDay] = true;
        if (!TextUtils.isEmpty((CharSequence)recurrenceRule)) {
            this.mModel.recurrenceState = 1;
            this.mRecurrence.parse(recurrenceRule);
            RecurrenceOptionCreator.copyEventRecurrenceToModel(this.mRecurrence, this.mModel);
            if (this.mRecurrence.bydayCount == 0) {
                this.mModel.weeklyByDayOfWeek[this.mTime.weekDay] = true;
            }
        } else {
            this.mModel.recurrenceState = 1;
        }
        if (this.mModel.endDate == null) {
            this.mModel.endDate = new Time(this.mTime);
            switch (this.mModel.freq) {
                case 0: 
                case 1: {
                    ++this.mModel.endDate.month;
                    break;
                }
                case 2: {
                    this.mModel.endDate.month += 3;
                    break;
                }
                case 3: {
                    this.mModel.endDate.year += 3;
                }
            }
            this.mModel.endDate.normalize(false);
        }
        this.togglePickerOptions();
        this.updateDialog();
        this.showRecurrencePicker();
    }

    private void togglePickerOptions() {
        if (this.mModel.recurrenceState == 0) {
            this.mFreqSpinner.setEnabled(false);
            this.mEndSpinner.setEnabled(false);
            this.mIntervalPreText.setEnabled(false);
            this.mInterval.setEnabled(false);
            this.mIntervalPostText.setEnabled(false);
            this.mMonthRepeatByRadioGroup.setEnabled(false);
            this.mEndCount.setEnabled(false);
            this.mPostEndCount.setEnabled(false);
            this.mEndDateTextView.setEnabled(false);
            this.mRepeatMonthlyByNthDayOfWeek.setEnabled(false);
            this.mRepeatMonthlyByNthDayOfMonth.setEnabled(false);
            for (WeekButton button : this.mWeekByDayButtons) {
                button.setEnabled(false);
            }
        } else {
            this.findViewById(R.id.options).setEnabled(true);
            this.mFreqSpinner.setEnabled(true);
            this.mEndSpinner.setEnabled(true);
            this.mIntervalPreText.setEnabled(true);
            this.mInterval.setEnabled(true);
            this.mIntervalPostText.setEnabled(true);
            this.mMonthRepeatByRadioGroup.setEnabled(true);
            this.mEndCount.setEnabled(true);
            this.mPostEndCount.setEnabled(true);
            this.mEndDateTextView.setEnabled(true);
            this.mRepeatMonthlyByNthDayOfWeek.setEnabled(true);
            this.mRepeatMonthlyByNthDayOfMonth.setEnabled(true);
            for (WeekButton button : this.mWeekByDayButtons) {
                button.setEnabled(true);
            }
        }
        this.updateDoneButtonState();
    }

    private void updateDoneButtonState() {
        if (this.mModel.recurrenceState == 0) {
            this.mButtonLayout.updateValidity(true);
            return;
        }
        if (this.mInterval.getText().toString().length() == 0) {
            this.mButtonLayout.updateValidity(false);
            return;
        }
        if (this.mEndCount.getVisibility() == 0 && this.mEndCount.getText().toString().length() == 0) {
            this.mButtonLayout.updateValidity(false);
            return;
        }
        if (this.mModel.freq == 1) {
            for (WeekButton b : this.mWeekByDayButtons) {
                if (!b.isChecked()) continue;
                this.mButtonLayout.updateValidity(true);
                return;
            }
            this.mButtonLayout.updateValidity(false);
            return;
        }
        this.mButtonLayout.updateValidity(true);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.mModel, this.mEndCount.hasFocus(), this.mRecurrencePicker.getVisibility() == 0 ? CurrentView.RECURRENCE_PICKER : CurrentView.DATE_ONLY_PICKER);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        View.BaseSavedState bss = (View.BaseSavedState)state;
        super.onRestoreInstanceState(bss.getSuperState());
        SavedState ss = (SavedState)bss;
        final boolean endCountHasFocus = ss.getEndCountHasFocus();
        RecurrenceModel m = ss.getRecurrenceModel();
        if (m != null) {
            this.mModel = m;
        }
        this.mRecurrence.wkst = EventRecurrence.timeDay2Day(RecurrenceUtils.getFirstDayOfWeek());
        this.togglePickerOptions();
        this.updateDialog();
        if (ss.getCurrentView() == CurrentView.RECURRENCE_PICKER) {
            this.showRecurrencePicker();
            this.post(new Runnable(){

                @Override
                public void run() {
                    if (RecurrenceOptionCreator.this.mEndCount != null && endCountHasFocus) {
                        RecurrenceOptionCreator.this.mEndCount.requestFocus();
                    }
                }
            });
        } else {
            this.showDateOnlyPicker();
        }
    }

    public void updateDialog() {
        String countStr;
        String intervalStr = Integer.toString(this.mModel.interval);
        if (!intervalStr.equals(this.mInterval.getText().toString())) {
            this.mInterval.setText((CharSequence)intervalStr);
        }
        this.mFreqSpinner.setSelection(this.mModel.freq);
        this.mWeekGroup.setVisibility(this.mModel.freq == 1 ? 0 : 8);
        if (this.mWeekGroup2 != null) {
            this.mWeekGroup2.setVisibility(this.mModel.freq == 1 ? 0 : 8);
        }
        this.mMonthRepeatByRadioGroup.setVisibility(this.mModel.freq == 2 ? 0 : 8);
        switch (this.mModel.freq) {
            case 0: {
                this.mIntervalResId = R.plurals.recurrence_interval_daily;
                break;
            }
            case 1: {
                this.mIntervalResId = R.plurals.recurrence_interval_weekly;
                for (int i = 0; i < 7; ++i) {
                    this.mWeekByDayButtons[i].setCheckedNoAnimate(this.mModel.weeklyByDayOfWeek[i]);
                }
                break;
            }
            case 2: {
                this.mIntervalResId = R.plurals.recurrence_interval_monthly;
                if (this.mModel.monthlyRepeat == 0) {
                    this.mMonthRepeatByRadioGroup.check(R.id.repeatMonthlyByNthDayOfMonth);
                } else if (this.mModel.monthlyRepeat == 1) {
                    this.mMonthRepeatByRadioGroup.check(R.id.repeatMonthlyByNthDayOfTheWeek);
                }
                if (this.mMonthRepeatByDayOfWeekStr != null) break;
                if (this.mModel.monthlyByNthDayOfWeek == 0) {
                    this.mModel.monthlyByNthDayOfWeek = (this.mTime.monthDay + 6) / 7;
                    if (this.mModel.monthlyByNthDayOfWeek >= 5) {
                        this.mModel.monthlyByNthDayOfWeek = -1;
                    }
                    this.mModel.monthlyByDayOfWeek = this.mTime.weekDay;
                }
                String[] monthlyByNthDayOfWeekStrs = this.mMonthRepeatByDayOfWeekStrs[this.mModel.monthlyByDayOfWeek];
                int msgIndex = this.mModel.monthlyByNthDayOfWeek < 0 ? 5 : this.mModel.monthlyByNthDayOfWeek;
                this.mMonthRepeatByDayOfWeekStr = monthlyByNthDayOfWeekStrs[msgIndex - 1];
                this.mRepeatMonthlyByNthDayOfWeek.setText((CharSequence)this.mMonthRepeatByDayOfWeekStr);
                break;
            }
            case 3: {
                this.mIntervalResId = R.plurals.recurrence_interval_yearly;
            }
        }
        this.updateIntervalText();
        this.updateDoneButtonState();
        this.mEndSpinner.setSelection(this.mModel.end);
        if (this.mModel.end == 1) {
            this.mEndDateTextView.setText((CharSequence)this.mEndDateFormatter.format(this.mModel.endDate.toMillis(false)));
        } else if (this.mModel.end == 2 && !(countStr = Integer.toString(this.mModel.endCount)).equals(this.mEndCount.getText().toString())) {
            this.mEndCount.setText((CharSequence)countStr);
        }
    }

    private void setEndSpinnerEndDateStr(String endDateString) {
        this.mEndSpinnerArray.set(1, endDateString);
        this.mEndSpinnerAdapter.notifyDataSetChanged();
    }

    private void doToast() {
        String rrule;
        Log.e((String)TAG, (String)("Model = " + this.mModel.toString()));
        if (this.mModel.recurrenceState == 0) {
            rrule = "Not repeating";
        } else {
            RecurrenceOptionCreator.copyModelToEventRecurrence(this.mModel, this.mRecurrence);
            rrule = this.mRecurrence.toString();
        }
        if (this.mToast != null) {
            this.mToast.cancel();
        }
        this.mToast = Toast.makeText((Context)this.getContext(), (CharSequence)rrule, (int)1);
        this.mToast.show();
    }

    private void updateIntervalText() {
        if (this.mIntervalResId == -1) {
            return;
        }
        String INTERVAL_COUNT_MARKER = "%d";
        String intervalString = this.mResources.getQuantityString(this.mIntervalResId, this.mModel.interval);
        int markerStart = intervalString.indexOf("%d");
        if (markerStart != -1) {
            int postTextStart = markerStart + "%d".length();
            this.mIntervalPostText.setText((CharSequence)intervalString.substring(postTextStart, intervalString.length()).trim());
            this.mIntervalPreText.setText((CharSequence)intervalString.substring(0, markerStart).trim());
        }
    }

    private void updateEndCountText() {
        String END_COUNT_MARKER = "%d";
        String endString = this.mResources.getQuantityString(R.plurals.recurrence_end_count, this.mModel.endCount);
        int markerStart = endString.indexOf("%d");
        if (markerStart != -1) {
            if (markerStart == 0) {
                Log.e((String)TAG, (String)"No text to put in to recurrence's end spinner.");
            } else {
                int postTextStart = markerStart + "%d".length();
                this.mPostEndCount.setText((CharSequence)endString.substring(postTextStart, endString.length()).trim());
            }
        }
    }

    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
        if (parent == this.mFreqSpinner) {
            this.mModel.freq = position;
        } else if (parent == this.mEndSpinner) {
            switch (position) {
                case 0: {
                    this.mModel.end = 0;
                    break;
                }
                case 1: {
                    this.mModel.end = 1;
                    break;
                }
                case 2: {
                    this.mModel.end = 2;
                    if (this.mModel.endCount <= 1) {
                        this.mModel.endCount = 1;
                    } else if (this.mModel.endCount > 730) {
                        this.mModel.endCount = 730;
                    }
                    this.updateEndCountText();
                }
            }
            this.mEndCount.setVisibility(this.mModel.end == 2 ? 0 : 8);
            this.mEndDateTextView.setVisibility(this.mModel.end == 1 ? 0 : 8);
            this.mPostEndCount.setVisibility(this.mModel.end == 2 && !this.mHidePostEndCount ? 0 : 8);
        }
        this.updateDialog();
    }

    public void onNothingSelected(AdapterView<?> arg0) {
    }

    @Override
    public void onDateSet(RecurrenceEndDatePicker view, int year, int monthOfYear, int dayOfMonth) {
        this.showRecurrencePicker();
        if (this.mModel.endDate == null) {
            this.mModel.endDate = new Time(this.mTime.timezone);
            this.mModel.endDate.second = 0;
            this.mModel.endDate.minute = 0;
            this.mModel.endDate.hour = 0;
        }
        this.mModel.endDate.year = year;
        this.mModel.endDate.month = monthOfYear;
        this.mModel.endDate.monthDay = dayOfMonth;
        this.mModel.endDate.normalize(false);
        this.updateDialog();
    }

    @Override
    public void onDateOnlyPickerCancelled(RecurrenceEndDatePicker view) {
        this.showRecurrencePicker();
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        int itemIdx = -1;
        for (int i = 0; i < 7; ++i) {
            if (itemIdx != -1 || buttonView != this.mWeekByDayButtons[i]) continue;
            itemIdx = i;
            this.mModel.weeklyByDayOfWeek[i] = isChecked;
        }
        this.updateDialog();
    }

    public void onCheckedChanged(RadioGroup group, int checkedId) {
        if (checkedId == R.id.repeatMonthlyByNthDayOfMonth) {
            this.mModel.monthlyRepeat = 0;
        } else if (checkedId == R.id.repeatMonthlyByNthDayOfTheWeek) {
            this.mModel.monthlyRepeat = 1;
        }
        this.updateDialog();
    }

    public void onClick(View v) {
        if (this.mEndDateTextView == v) {
            this.showDateOnlyPicker();
        }
    }

    private void showRecurrencePicker() {
        this.mDateOnlyPicker.setVisibility(8);
        this.mRecurrencePicker.setVisibility(0);
    }

    private void showDateOnlyPicker() {
        this.mDateOnlyPicker.init(this.mModel.endDate.year, this.mModel.endDate.month, this.mModel.endDate.monthDay, this);
        this.mDateOnlyPicker.setFirstDayOfWeek(RecurrenceUtils.getFirstDayOfWeekAsCalendar());
        this.mRecurrencePicker.setVisibility(8);
        this.mDateOnlyPicker.setVisibility(0);
    }

    private class EndSpinnerAdapter
    extends ArrayAdapter<CharSequence> {
        final String END_DATE_MARKER = "%s";
        final String END_COUNT_MARKER = "%d";
        private LayoutInflater mInflater;
        private int mItemLayoutId;
        private int mDropDownLayoutId;
        private int mTextResourceId;
        private ArrayList<CharSequence> mStrings;
        private String mEndDateString;
        private boolean mUseFormStrings;

        public EndSpinnerAdapter(Context context, ArrayList<CharSequence> strings, int itemLayoutId, int textResourceId, int dropDownLayoutId) {
            super(context, itemLayoutId, strings);
            this.END_DATE_MARKER = "%s";
            this.END_COUNT_MARKER = "%d";
            this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
            this.mItemLayoutId = itemLayoutId;
            this.mTextResourceId = textResourceId;
            this.mDropDownLayoutId = dropDownLayoutId;
            this.mStrings = strings;
            this.mEndDateString = RecurrenceOptionCreator.this.getResources().getString(R.string.recurrence_end_date);
            int markerStart = this.mEndDateString.indexOf("%s");
            if (markerStart <= 0) {
                this.mUseFormStrings = true;
            } else {
                String countEndStr = RecurrenceOptionCreator.this.getResources().getQuantityString(R.plurals.recurrence_end_count, 1);
                markerStart = countEndStr.indexOf("%d");
                if (markerStart <= 0) {
                    this.mUseFormStrings = true;
                }
            }
            if (this.mUseFormStrings) {
                RecurrenceOptionCreator.this.mEndSpinner.setLayoutParams((ViewGroup.LayoutParams)new TableLayout.LayoutParams(0, -2, 1.0f));
            }
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            View v = convertView == null ? this.mInflater.inflate(this.mItemLayoutId, parent, false) : convertView;
            TextView item = (TextView)v.findViewById(this.mTextResourceId);
            switch (position) {
                case 0: {
                    item.setText(this.mStrings.get(0));
                    break;
                }
                case 1: {
                    int markerStart = this.mEndDateString.indexOf("%s");
                    if (markerStart == -1) break;
                    if (this.mUseFormStrings || markerStart == 0) {
                        item.setText((CharSequence)RecurrenceOptionCreator.this.mEndDateLabel);
                        break;
                    }
                    item.setText((CharSequence)this.mEndDateString.substring(0, markerStart).trim());
                    break;
                }
                case 2: {
                    String endString = RecurrenceOptionCreator.this.mResources.getQuantityString(R.plurals.recurrence_end_count, ((RecurrenceOptionCreator)RecurrenceOptionCreator.this).mModel.endCount);
                    int markerStart = endString.indexOf("%d");
                    if (markerStart == -1) break;
                    if (this.mUseFormStrings || markerStart == 0) {
                        item.setText((CharSequence)RecurrenceOptionCreator.this.mEndCountLabel);
                        RecurrenceOptionCreator.this.mPostEndCount.setVisibility(8);
                        RecurrenceOptionCreator.this.mHidePostEndCount = true;
                        break;
                    }
                    int postTextStart = markerStart + "%d".length();
                    RecurrenceOptionCreator.this.mPostEndCount.setText((CharSequence)endString.substring(postTextStart, endString.length()).trim());
                    if (((RecurrenceOptionCreator)RecurrenceOptionCreator.this).mModel.end == 2) {
                        RecurrenceOptionCreator.this.mPostEndCount.setVisibility(0);
                    }
                    if (endString.charAt(markerStart - 1) == ' ') {
                        --markerStart;
                    }
                    item.setText((CharSequence)endString.substring(0, markerStart).trim());
                    break;
                }
                default: {
                    v = null;
                }
            }
            return v;
        }

        public View getDropDownView(int position, View convertView, ViewGroup parent) {
            View v = convertView == null ? this.mInflater.inflate(this.mDropDownLayoutId, parent, false) : convertView;
            TextView item = (TextView)v.findViewById(this.mTextResourceId);
            item.setText(this.mStrings.get(position));
            return v;
        }
    }

    public static interface OnRecurrenceSetListener {
        public void onRecurrenceSet(String var1);

        public void onCancelled();
    }

    private static class SavedState
    extends View.BaseSavedState {
        private final RecurrenceModel mRecurrenceModel;
        private final boolean mEndCountHasFocus;
        private final CurrentView sCurrentView;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, RecurrenceModel recurrenceModel, boolean endCountHasFocus, CurrentView currentView) {
            super(superState);
            this.mRecurrenceModel = recurrenceModel;
            this.mEndCountHasFocus = endCountHasFocus;
            this.sCurrentView = currentView;
        }

        private SavedState(Parcel in) {
            super(in);
            this.mRecurrenceModel = (RecurrenceModel)in.readParcelable(RecurrenceModel.class.getClassLoader());
            this.mEndCountHasFocus = in.readByte() != 0;
            this.sCurrentView = CurrentView.valueOf(in.readString());
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeParcelable((Parcelable)this.mRecurrenceModel, flags);
            dest.writeByte((byte)(this.mEndCountHasFocus ? 1 : 0));
            dest.writeString(this.sCurrentView.name());
        }

        public RecurrenceModel getRecurrenceModel() {
            return this.mRecurrenceModel;
        }

        public boolean getEndCountHasFocus() {
            return this.mEndCountHasFocus;
        }

        public CurrentView getCurrentView() {
            return this.sCurrentView;
        }
    }

    class minMaxTextWatcher
    implements TextWatcher {
        private int mMin;
        private int mMax;
        private int mDefault;

        public minMaxTextWatcher(int min, int defaultInt, int max) {
            this.mMin = min;
            this.mMax = max;
            this.mDefault = defaultInt;
        }

        public void afterTextChanged(Editable s) {
            int value;
            boolean updated = false;
            try {
                value = Integer.parseInt(s.toString());
            }
            catch (NumberFormatException e) {
                value = this.mDefault;
            }
            if (value < this.mMin) {
                value = this.mMin;
                updated = true;
            } else if (value > this.mMax) {
                updated = true;
                value = this.mMax;
            }
            if (updated) {
                s.clear();
                s.append((CharSequence)Integer.toString(value));
            }
            RecurrenceOptionCreator.this.updateDoneButtonState();
            this.onChange(value);
        }

        void onChange(int value) {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }
    }

    private class RecurrenceModel
    implements Parcelable {
        static final int FREQ_DAILY = 0;
        static final int FREQ_WEEKLY = 1;
        static final int FREQ_MONTHLY = 2;
        static final int FREQ_YEARLY = 3;
        static final int END_NEVER = 0;
        static final int END_BY_DATE = 1;
        static final int END_BY_COUNT = 2;
        static final int MONTHLY_BY_DATE = 0;
        static final int MONTHLY_BY_NTH_DAY_OF_WEEK = 1;
        static final int STATE_NO_RECURRENCE = 0;
        static final int STATE_RECURRENCE = 1;
        int recurrenceState;
        int freq = 1;
        int interval = 1;
        int end;
        Time endDate;
        int endCount = 5;
        boolean[] weeklyByDayOfWeek = new boolean[7];
        int monthlyRepeat;
        int monthlyByMonthDay;
        int monthlyByDayOfWeek;
        int monthlyByNthDayOfWeek;
        public final Parcelable.Creator<RecurrenceModel> CREATOR = new Parcelable.Creator<RecurrenceModel>(){

            public RecurrenceModel createFromParcel(Parcel in) {
                return new RecurrenceModel(in);
            }

            public RecurrenceModel[] newArray(int size) {
                return new RecurrenceModel[size];
            }
        };

        public String toString() {
            return "Model [freq=" + this.freq + ", interval=" + this.interval + ", end=" + this.end + ", endDate=" + this.endDate + ", endCount=" + this.endCount + ", weeklyByDayOfWeek=" + Arrays.toString(this.weeklyByDayOfWeek) + ", monthlyRepeat=" + this.monthlyRepeat + ", monthlyByMonthDay=" + this.monthlyByMonthDay + ", monthlyByDayOfWeek=" + this.monthlyByDayOfWeek + ", monthlyByNthDayOfWeek=" + this.monthlyByNthDayOfWeek + "]";
        }

        public int describeContents() {
            return 0;
        }

        public RecurrenceModel() {
        }

        public RecurrenceModel(Parcel in) {
            this.readFromParcel(in);
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.freq);
            dest.writeInt(this.interval);
            dest.writeInt(this.end);
            dest.writeInt(this.endDate.year);
            dest.writeInt(this.endDate.month);
            dest.writeInt(this.endDate.monthDay);
            dest.writeInt(this.endCount);
            dest.writeBooleanArray(this.weeklyByDayOfWeek);
            dest.writeInt(this.monthlyRepeat);
            dest.writeInt(this.monthlyByMonthDay);
            dest.writeInt(this.monthlyByDayOfWeek);
            dest.writeInt(this.monthlyByNthDayOfWeek);
            dest.writeInt(this.recurrenceState);
        }

        private void readFromParcel(Parcel in) {
            this.freq = in.readInt();
            this.interval = in.readInt();
            this.end = in.readInt();
            this.endDate = new Time();
            this.endDate.year = in.readInt();
            this.endDate.month = in.readInt();
            this.endDate.monthDay = in.readInt();
            this.endCount = in.readInt();
            in.readBooleanArray(this.weeklyByDayOfWeek);
            this.monthlyRepeat = in.readInt();
            this.monthlyByMonthDay = in.readInt();
            this.monthlyByDayOfWeek = in.readInt();
            this.monthlyByNthDayOfWeek = in.readInt();
            this.recurrenceState = in.readInt();
        }
    }

    private static enum CurrentView {
        RECURRENCE_PICKER,
        DATE_ONLY_PICKER;

    }
}

