/*
 * Decompiled with CFR 0.152.
 */
package com.kp.md.picker.recurrencepicker;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.text.format.Time;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.kp.md.picker.R;
import com.kp.md.picker.recurrencepicker.EventRecurrence;
import com.kp.md.picker.recurrencepicker.EventRecurrenceFormatter;
import com.kp.md.picker.recurrencepicker.RecurrenceOptionCreator;
import com.kp.md.picker.utilities.MUtils;
import java.util.ArrayList;
import java.util.TimeZone;

public class MRecurrencePicker
extends FrameLayout
implements View.OnClickListener {
    RecurrenceOption mCurrentRecurrenceOption;
    CurrentView mCurrentView = CurrentView.RECURRENCE_OPTIONS_MENU;
    int mSelectedStateTextColor;
    int mUnselectedStateTextColor;
    int mPressedStateColor;
    int mSelectedOptionDrawablePadding;
    LinearLayout llRecurrenceOptionsMenu;
    OnRepeatOptionSetListener mCallback;
    String mRecurrenceRule;
    Drawable mCheckmarkDrawable;
    RecurrenceOptionCreator mRecurrenceOptionCreator;
    long mCurrentlyChosenTime;
    ArrayList<TextView> mRepeatOptionTextViews;
    RecurrenceOptionCreator.OnRecurrenceSetListener mOnRecurrenceSetListener = new RecurrenceOptionCreator.OnRecurrenceSetListener(){

        @Override
        public void onRecurrenceSet(String rrule) {
            MRecurrencePicker.this.mRecurrenceRule = rrule;
            MRecurrencePicker.this.mCurrentRecurrenceOption = RecurrenceOption.CUSTOM;
            MRecurrencePicker.this.mCurrentView = CurrentView.RECURRENCE_OPTIONS_MENU;
            if (MRecurrencePicker.this.mCallback != null) {
                MRecurrencePicker.this.mCallback.onRepeatOptionSet(RecurrenceOption.CUSTOM, rrule);
            }
        }

        @Override
        public void onCancelled() {
            MRecurrencePicker.this.mCurrentView = CurrentView.RECURRENCE_OPTIONS_MENU;
            MRecurrencePicker.this.updateView();
        }
    };

    public MRecurrencePicker(Context context) {
        this(context, null);
    }

    public MRecurrencePicker(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.spRecurrencePickerStyle);
    }

    public MRecurrencePicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super((Context)MUtils.createThemeWrapper(context, R.attr.mPickerStyle, R.style.MPickerStyleLight, R.attr.spRecurrencePickerStyle, R.style.MRecurrencePickerStyle), attrs, defStyleAttr);
        this.initializeLayout();
    }

    @TargetApi(value=21)
    public MRecurrencePicker(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super((Context)MUtils.createThemeWrapper(context, R.attr.mPickerStyle, R.style.MPickerStyleLight, R.attr.spRecurrencePickerStyle, R.style.MRecurrencePickerStyle), attrs, defStyleAttr, defStyleRes);
        this.initializeLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeLayout() {
        Context context = this.getContext();
        LayoutInflater.from((Context)context).inflate(R.layout.m_recurrence_picker, (ViewGroup)this);
        this.llRecurrenceOptionsMenu = (LinearLayout)this.findViewById(R.id.llRecurrenceOptionsMenu);
        this.mRecurrenceOptionCreator = (RecurrenceOptionCreator)this.findViewById(R.id.recurrenceOptionCreator);
        TextView tvRecurrenceHeading = (TextView)this.findViewById(R.id.tvHeading);
        this.mSelectedOptionDrawablePadding = context.getResources().getDimensionPixelSize(R.dimen.selected_recurrence_option_drawable_padding);
        TypedArray a = context.obtainStyledAttributes(R.styleable.MRecurrencePicker);
        try {
            int headingBgColor = a.getColor(R.styleable.MRecurrencePicker_spHeaderBackground, MUtils.COLOR_ACCENT);
            int n = a.getColor(R.styleable.MRecurrencePicker_spPickerBackground, MUtils.COLOR_BACKGROUND);
            if (n != 0) {
                MUtils.setViewBackground((View)this, n, 15);
            }
            MUtils.setViewBackground((View)tvRecurrenceHeading, headingBgColor, 3);
            this.mSelectedStateTextColor = a.getColor(R.styleable.MRecurrencePicker_spSelectedOptionTextColor, MUtils.COLOR_ACCENT);
            this.mUnselectedStateTextColor = a.getColor(R.styleable.MRecurrencePicker_spUnselectedOptionsTextColor, MUtils.COLOR_TEXT_PRIMARY);
            this.mPressedStateColor = a.getColor(R.styleable.MRecurrencePicker_spPressedOptionBgColor, MUtils.COLOR_CONTROL_HIGHLIGHT);
            this.mCheckmarkDrawable = a.getDrawable(R.styleable.MRecurrencePicker_spSelectedOptionDrawable);
            if (this.mCheckmarkDrawable == null) {
                this.mCheckmarkDrawable = context.getResources().getDrawable(R.drawable.checkmark_medium_ff);
            }
            if (this.mCheckmarkDrawable != null) {
                this.mCheckmarkDrawable.setColorFilter(this.mSelectedStateTextColor, PorterDuff.Mode.MULTIPLY);
            }
        }
        finally {
            a.recycle();
        }
        this.mRepeatOptionTextViews = new ArrayList();
        this.mRepeatOptionTextViews.add((TextView)this.findViewById(R.id.tvChosenCustomOption));
        this.mRepeatOptionTextViews.add((TextView)this.findViewById(R.id.tvDoesNotRepeat));
        this.mRepeatOptionTextViews.add((TextView)this.findViewById(R.id.tvDaily));
        this.mRepeatOptionTextViews.add((TextView)this.findViewById(R.id.tvWeekly));
        this.mRepeatOptionTextViews.add((TextView)this.findViewById(R.id.tvMonthly));
        this.mRepeatOptionTextViews.add((TextView)this.findViewById(R.id.tvYearly));
        this.mRepeatOptionTextViews.add((TextView)this.findViewById(R.id.tvCustom));
        for (View view : this.mRepeatOptionTextViews) {
            MUtils.setViewBackground(view, this.createOptionBg(this.mPressedStateColor));
        }
    }

    public void initializeData(OnRepeatOptionSetListener callback, RecurrenceOption initialOption, String recurrenceRule, long currentlyChosenTime) {
        this.mCallback = callback;
        this.mRecurrenceRule = recurrenceRule;
        this.mCurrentlyChosenTime = currentlyChosenTime;
        this.mCurrentRecurrenceOption = initialOption;
        this.mRecurrenceOptionCreator.initializeData(this.mCurrentlyChosenTime, null, this.mRecurrenceRule, this.mOnRecurrenceSetListener);
    }

    public void updateView() {
        if (this.mCurrentView == CurrentView.RECURRENCE_OPTIONS_MENU) {
            this.mRecurrenceOptionCreator.setVisibility(8);
            this.llRecurrenceOptionsMenu.setVisibility(0);
            this.updateFlowLayout(this.mCurrentRecurrenceOption);
            final ScrollView scrollView = (ScrollView)this.llRecurrenceOptionsMenu.findViewById(R.id.svRecurrenceOptionsMenu);
            this.llRecurrenceOptionsMenu.post(new Runnable(){

                @Override
                public void run() {
                    if (scrollView.getScrollY() != 0) {
                        scrollView.fullScroll(33);
                    }
                }
            });
        } else if (this.mCurrentView == CurrentView.RECURRENCE_CREATOR) {
            this.llRecurrenceOptionsMenu.setVisibility(8);
            this.mRecurrenceOptionCreator.setVisibility(0);
        }
    }

    void updateFlowLayout(RecurrenceOption recurrenceOption) {
        int viewIdToSelect;
        switch (recurrenceOption) {
            case DOES_NOT_REPEAT: {
                viewIdToSelect = R.id.tvDoesNotRepeat;
                break;
            }
            case DAILY: {
                viewIdToSelect = R.id.tvDaily;
                break;
            }
            case WEEKLY: {
                viewIdToSelect = R.id.tvWeekly;
                break;
            }
            case MONTHLY: {
                viewIdToSelect = R.id.tvMonthly;
                break;
            }
            case YEARLY: {
                viewIdToSelect = R.id.tvYearly;
                break;
            }
            case CUSTOM: {
                viewIdToSelect = R.id.tvChosenCustomOption;
                break;
            }
            default: {
                viewIdToSelect = R.id.tvDoesNotRepeat;
            }
        }
        for (TextView tv : this.mRepeatOptionTextViews) {
            tv.setOnClickListener((View.OnClickListener)this);
            if (tv.getId() == R.id.tvChosenCustomOption) {
                if (!TextUtils.isEmpty((CharSequence)this.mRecurrenceRule)) {
                    EventRecurrence eventRecurrence = new EventRecurrence();
                    eventRecurrence.parse(this.mRecurrenceRule);
                    Time startDate = new Time(TimeZone.getDefault().getID());
                    startDate.set(this.mCurrentlyChosenTime);
                    eventRecurrence.setStartDate(startDate);
                    tv.setVisibility(0);
                    tv.setText((CharSequence)EventRecurrenceFormatter.getRepeatString(this.getContext(), this.getContext().getResources(), eventRecurrence, true));
                } else {
                    tv.setVisibility(8);
                    continue;
                }
            }
            if (tv.getId() == viewIdToSelect) {
                tv.setCompoundDrawablesWithIntrinsicBounds(null, null, this.mCheckmarkDrawable, null);
                tv.setCompoundDrawablePadding(this.mSelectedOptionDrawablePadding);
                tv.setTextColor(this.mSelectedStateTextColor);
                continue;
            }
            tv.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
            tv.setTextColor(this.mUnselectedStateTextColor);
        }
    }

    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.tvChosenCustomOption) {
            this.mCurrentRecurrenceOption = RecurrenceOption.CUSTOM;
            if (this.mCallback != null) {
                this.mCallback.onRepeatOptionSet(RecurrenceOption.CUSTOM, this.mRecurrenceRule);
            }
            return;
        }
        if (v.getId() == R.id.tvDoesNotRepeat) {
            this.mCurrentRecurrenceOption = RecurrenceOption.DOES_NOT_REPEAT;
        } else if (v.getId() == R.id.tvDaily) {
            this.mCurrentRecurrenceOption = RecurrenceOption.DAILY;
        } else if (v.getId() == R.id.tvWeekly) {
            this.mCurrentRecurrenceOption = RecurrenceOption.WEEKLY;
        } else if (v.getId() == R.id.tvMonthly) {
            this.mCurrentRecurrenceOption = RecurrenceOption.MONTHLY;
        } else if (v.getId() == R.id.tvYearly) {
            this.mCurrentRecurrenceOption = RecurrenceOption.YEARLY;
        } else {
            if (v.getId() == R.id.tvCustom) {
                this.mCurrentView = CurrentView.RECURRENCE_CREATOR;
                this.updateView();
                return;
            }
            this.mCurrentRecurrenceOption = RecurrenceOption.DOES_NOT_REPEAT;
        }
        if (this.mCallback != null) {
            this.mCallback.onRepeatOptionSet(this.mCurrentRecurrenceOption, null);
        }
    }

    Drawable createOptionBg(int pressedBgColor) {
        if (MUtils.isApi_21_OrHigher()) {
            return this.createRippleDrawableForOption(pressedBgColor);
        }
        return this.createStateListDrawableForOption(pressedBgColor);
    }

    private Drawable createStateListDrawableForOption(int pressedBgColor) {
        StateListDrawable sld = new StateListDrawable();
        sld.addState(new int[]{16842919}, (Drawable)new ColorDrawable(pressedBgColor));
        sld.addState(new int[0], (Drawable)new ColorDrawable(0));
        return sld;
    }

    @TargetApi(value=21)
    private Drawable createRippleDrawableForOption(int pressedBgColor) {
        return new RippleDrawable(ColorStateList.valueOf((int)pressedBgColor), null, (Drawable)new ColorDrawable(-16777216));
    }

    protected Parcelable onSaveInstanceState() {
        return new SavedState(super.onSaveInstanceState(), this.mCurrentView, this.mCurrentRecurrenceOption, this.mRecurrenceRule);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        View.BaseSavedState bss = (View.BaseSavedState)state;
        super.onRestoreInstanceState(bss.getSuperState());
        SavedState ss = (SavedState)bss;
        this.mCurrentView = ss.getCurrentView();
        this.mCurrentRecurrenceOption = ss.getCurrentRepeatOption();
        this.mRecurrenceRule = ss.getRecurrenceRule();
        this.updateView();
    }

    public static interface OnRepeatOptionSetListener {
        public void onRepeatOptionSet(RecurrenceOption var1, String var2);

        public void onDone();
    }

    private static class SavedState
    extends View.BaseSavedState {
        private final CurrentView sCurrentView;
        private final RecurrenceOption sCurrentRecurrenceOption;
        private final String sRecurrenceRule;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, CurrentView currentView, RecurrenceOption currentRecurrenceOption, String recurrenceRule) {
            super(superState);
            this.sCurrentView = currentView;
            this.sCurrentRecurrenceOption = currentRecurrenceOption;
            this.sRecurrenceRule = recurrenceRule;
        }

        private SavedState(Parcel in) {
            super(in);
            this.sCurrentView = CurrentView.valueOf(in.readString());
            this.sCurrentRecurrenceOption = RecurrenceOption.valueOf(in.readString());
            this.sRecurrenceRule = in.readString();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeString(this.sCurrentView.name());
            dest.writeString(this.sCurrentRecurrenceOption.name());
            dest.writeString(this.sRecurrenceRule);
        }

        public CurrentView getCurrentView() {
            return this.sCurrentView;
        }

        public RecurrenceOption getCurrentRepeatOption() {
            return this.sCurrentRecurrenceOption;
        }

        public String getRecurrenceRule() {
            return this.sRecurrenceRule;
        }
    }

    private static enum CurrentView {
        RECURRENCE_OPTIONS_MENU,
        RECURRENCE_CREATOR;

    }

    public static enum RecurrenceOption {
        DOES_NOT_REPEAT("DOES NOT REPEAT"),
        DAILY("DAILY"),
        WEEKLY("WEEKLY"),
        MONTHLY("MONTHLY"),
        YEARLY("YEARLY"),
        CUSTOM("CUSTOM...");

        private final String optionName;

        private RecurrenceOption(String name) {
            this.optionName = name;
        }

        public String toString() {
            return this.optionName;
        }
    }
}

