/*
 * Decompiled with CFR 0.152.
 */
package com.kp.md.picker.helpers;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.kp.md.picker.datepicker.SelectedDate;
import com.kp.md.picker.utilities.MUtils;
import java.util.Calendar;
import java.util.Locale;

public class MOptions
implements Parcelable {
    public static final int ACTIVATE_DATE_PICKER = 1;
    public static final int ACTIVATE_TIME_PICKER = 2;
    public static final int ACTIVATE_RECURRENCE_PICKER = 4;
    private int mDisplayOptions = 7;
    private int mStartYear = -1;
    private int mStartMonth = -1;
    private int mStartDayOfMonth = -1;
    private int mEndYear = -1;
    private int mEndMonth = -1;
    private int mEndDayOfMonth = -1;
    private int mHourOfDay = -1;
    private int mMinute = -1;
    private long mMinDate = Long.MIN_VALUE;
    private long mMaxDate = Long.MIN_VALUE;
    private boolean mAnimateLayoutChanges;
    private boolean mIs24HourView;
    private String mRecurrenceRule = "";
    private boolean mCanPickDateRange;
    private Picker mPickerToShow = Picker.DATE_PICKER;
    public static final Parcelable.Creator<MOptions> CREATOR = new Parcelable.Creator<MOptions>(){

        public MOptions createFromParcel(Parcel in) {
            return new MOptions(in);
        }

        public MOptions[] newArray(int size) {
            return new MOptions[size];
        }
    };

    public MOptions() {
    }

    private MOptions(Parcel in) {
        this.readFromParcel(in);
    }

    public MOptions setAnimateLayoutChanges(boolean animateLayoutChanges) {
        this.mAnimateLayoutChanges = animateLayoutChanges;
        return this;
    }

    public boolean animateLayoutChanges() {
        return this.mAnimateLayoutChanges;
    }

    public MOptions setPickerToShow(Picker picker) {
        this.mPickerToShow = picker;
        return this;
    }

    private boolean isPickerActive(Picker picker) {
        switch (picker) {
            case DATE_PICKER: {
                return this.isDatePickerActive();
            }
            case TIME_PICKER: {
                return this.isTimePickerActive();
            }
            case REPEAT_OPTION_PICKER: {
                return this.isRecurrencePickerActive();
            }
        }
        return false;
    }

    public Picker getPickerToShow() {
        return this.mPickerToShow;
    }

    public MOptions setDisplayOptions(int displayOptions) {
        if (!this.areValidDisplayOptions(displayOptions)) {
            throw new IllegalArgumentException("Invalid display options.");
        }
        this.mDisplayOptions = displayOptions;
        return this;
    }

    private boolean areValidDisplayOptions(int displayOptions) {
        int flags = 7;
        return (displayOptions & ~flags) == 0;
    }

    public MOptions setDateParams(int year, int month, int dayOfMonth) {
        return this.setDateParams(year, month, dayOfMonth, year, month, dayOfMonth);
    }

    public MOptions setDateParams(int startYear, int startMonth, int startDayOfMonth, int endYear, int endMonth, int endDayOfMonth) {
        this.mStartYear = startYear;
        this.mStartMonth = startMonth;
        this.mStartDayOfMonth = startDayOfMonth;
        this.mEndYear = endYear;
        this.mEndMonth = endMonth;
        this.mEndDayOfMonth = endDayOfMonth;
        return this;
    }

    public MOptions setDateParams(@NonNull Calendar calendar) {
        return this.setDateParams(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(1), calendar.get(2), calendar.get(5));
    }

    public MOptions setDateParams(@NonNull Calendar startCal, @NonNull Calendar endCal) {
        return this.setDateParams(startCal.get(1), startCal.get(2), startCal.get(5), endCal.get(1), endCal.get(2), endCal.get(5));
    }

    public MOptions setDateParams(@NonNull SelectedDate selectedDate) {
        return this.setDateParams(selectedDate.getStartDate().get(1), selectedDate.getStartDate().get(2), selectedDate.getStartDate().get(5), selectedDate.getEndDate().get(1), selectedDate.getEndDate().get(2), selectedDate.getEndDate().get(5));
    }

    public MOptions setDateRange(long minDate, long maxDate) {
        this.mMinDate = minDate;
        this.mMaxDate = maxDate;
        return this;
    }

    public MOptions setTimeParams(int hourOfDay, int minute, boolean is24HourView) {
        this.mHourOfDay = hourOfDay;
        this.mMinute = minute;
        this.mIs24HourView = is24HourView;
        return this;
    }

    public MOptions setRecurrenceParams(String recurrenceRule) {
        this.mRecurrenceRule = recurrenceRule;
        return this;
    }

    public String getRecurrenceRule() {
        return this.mRecurrenceRule == null ? "" : this.mRecurrenceRule;
    }

    public boolean isDatePickerActive() {
        return (this.mDisplayOptions & 1) == 1;
    }

    public boolean isTimePickerActive() {
        return (this.mDisplayOptions & 2) == 2;
    }

    public boolean isRecurrencePickerActive() {
        return (this.mDisplayOptions & 4) == 4;
    }

    public SelectedDate getDateParams() {
        Calendar startCal = MUtils.getCalendarForLocale(null, Locale.getDefault());
        if (this.mStartYear == -1 || this.mStartMonth == -1 || this.mStartDayOfMonth == -1) {
            this.mStartYear = startCal.get(1);
            this.mStartMonth = startCal.get(2);
            this.mStartDayOfMonth = startCal.get(5);
        } else {
            startCal.set(this.mStartYear, this.mStartMonth, this.mStartDayOfMonth);
        }
        Calendar endCal = MUtils.getCalendarForLocale(null, Locale.getDefault());
        if (this.mEndYear == -1 || this.mEndMonth == -1 || this.mEndDayOfMonth == -1) {
            this.mEndYear = endCal.get(1);
            this.mEndMonth = endCal.get(2);
            this.mEndDayOfMonth = endCal.get(5);
        } else {
            endCal.set(this.mEndYear, this.mEndMonth, this.mEndDayOfMonth);
        }
        return new SelectedDate(startCal, endCal);
    }

    public long[] getDateRange() {
        return new long[]{this.mMinDate, this.mMaxDate};
    }

    public int[] getTimeParams() {
        if (this.mHourOfDay == -1 || this.mMinute == -1) {
            Calendar cal = MUtils.getCalendarForLocale(null, Locale.getDefault());
            this.mHourOfDay = cal.get(11);
            this.mMinute = cal.get(12);
        }
        return new int[]{this.mHourOfDay, this.mMinute};
    }

    public boolean is24HourView() {
        return this.mIs24HourView;
    }

    public void verifyValidity() {
        if (this.mPickerToShow == null || this.mPickerToShow == Picker.INVALID) {
            throw new InvalidOptionsException("The picker set using setPickerToShow(Picker) cannot be null or Picker.INVALID.");
        }
        if (!this.isPickerActive(this.mPickerToShow)) {
            throw new InvalidOptionsException("The picker you have requested to show(" + this.mPickerToShow.name() + ") is not activated. " + "Use setDisplayOptions(int) " + "to activate it, or use an activated Picker with setPickerToShow(Picker).");
        }
    }

    public MOptions setCanPickDateRange(boolean canPickDateRange) {
        this.mCanPickDateRange = canPickDateRange;
        return this;
    }

    public boolean canPickDateRange() {
        return this.mCanPickDateRange;
    }

    public int describeContents() {
        return 0;
    }

    private void readFromParcel(Parcel in) {
        this.mAnimateLayoutChanges = in.readByte() != 0;
        this.mPickerToShow = Picker.valueOf(in.readString());
        this.mDisplayOptions = in.readInt();
        this.mStartYear = in.readInt();
        this.mStartMonth = in.readInt();
        this.mStartDayOfMonth = in.readInt();
        this.mEndYear = in.readInt();
        this.mEndMonth = in.readInt();
        this.mEndDayOfMonth = in.readInt();
        this.mHourOfDay = in.readInt();
        this.mMinute = in.readInt();
        this.mIs24HourView = in.readByte() != 0;
        this.mRecurrenceRule = in.readString();
        this.mCanPickDateRange = in.readByte() != 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte)(this.mAnimateLayoutChanges ? 1 : 0));
        dest.writeString(this.mPickerToShow.name());
        dest.writeInt(this.mDisplayOptions);
        dest.writeInt(this.mStartYear);
        dest.writeInt(this.mStartMonth);
        dest.writeInt(this.mStartDayOfMonth);
        dest.writeInt(this.mEndYear);
        dest.writeInt(this.mEndMonth);
        dest.writeInt(this.mEndDayOfMonth);
        dest.writeInt(this.mHourOfDay);
        dest.writeInt(this.mMinute);
        dest.writeByte((byte)(this.mIs24HourView ? 1 : 0));
        dest.writeString(this.mRecurrenceRule);
        dest.writeByte((byte)(this.mCanPickDateRange ? 1 : 0));
    }

    public class InvalidOptionsException
    extends RuntimeException {
        public InvalidOptionsException(String detailMessage) {
            super(detailMessage);
        }
    }

    public static enum Picker {
        DATE_PICKER,
        TIME_PICKER,
        REPEAT_OPTION_PICKER,
        INVALID;

    }
}

