/*
 * Decompiled with CFR 0.152.
 */
package com.kp.md.picker.drawables;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import com.kp.md.picker.R;

public class OverflowDrawable
extends Drawable {
    Paint mPaintCircle;
    PointF center1;
    PointF center2;
    PointF center3;
    float mRadius;
    int mWidthHeight;

    public OverflowDrawable(Context context, int color2) {
        Resources res = context.getResources();
        this.mWidthHeight = res.getDimensionPixelSize(R.dimen.options_size);
        float density = (float)res.getDisplayMetrics().densityDpi / 160.0f;
        this.mRadius = 2.0f * density;
        float centerXY = (float)this.mWidthHeight / 2.0f;
        this.center1 = new PointF(centerXY, centerXY - 6.0f * density);
        this.center2 = new PointF(centerXY, centerXY);
        this.center3 = new PointF(centerXY, centerXY + 6.0f * density);
        this.mPaintCircle = new Paint();
        this.mPaintCircle.setColor(color2);
        this.mPaintCircle.setAntiAlias(true);
    }

    public void draw(Canvas canvas) {
        canvas.drawCircle(this.center1.x, this.center1.y, this.mRadius, this.mPaintCircle);
        canvas.drawCircle(this.center2.x, this.center2.y, this.mRadius, this.mPaintCircle);
        canvas.drawCircle(this.center3.x, this.center3.y, this.mRadius, this.mPaintCircle);
    }

    public int getMinimumHeight() {
        return this.mWidthHeight;
    }

    public int getMinimumWidth() {
        return this.mWidthHeight;
    }

    public int getIntrinsicHeight() {
        return this.mWidthHeight;
    }

    public int getIntrinsicWidth() {
        return this.mWidthHeight;
    }

    public void setAlpha(int alpha) {
        this.mPaintCircle.setAlpha(alpha);
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaintCircle.setColorFilter(cf);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -1;
    }
}

