/*
 * Decompiled with CFR 0.152.
 */
package com.kp.md.picker.drawables;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.OvershootInterpolator;
import com.kp.md.picker.drawables.CRectFEvaluator;

public class CheckableDrawable
extends Drawable {
    private final int ANIMATION_DURATION_EXPAND = 500;
    private final int ANIMATION_DURATION_COLLAPSE = 400;
    private int mMinAlpha;
    private int mMaxAlpha;
    private Paint mPaint;
    private AnimatorSet asTransition;
    private final OvershootInterpolator mExpandInterpolator = new OvershootInterpolator();
    private final AnticipateInterpolator mCollapseInterpolator = new AnticipateInterpolator();
    private final CRectFEvaluator mRectEvaluator = new CRectFEvaluator();
    private RectF mRectToDraw;
    private RectF mCollapsedRect;
    private RectF mExpandedRect;
    private int mExpandedWidthHeight;
    private boolean mChecked;
    private boolean mReady;

    public CheckableDrawable(int color2, boolean checked, int expandedWidthHeight) {
        this.mChecked = checked;
        this.mExpandedWidthHeight = expandedWidthHeight;
        this.mMaxAlpha = Color.alpha((int)color2);
        this.mMinAlpha = 0;
        this.mRectToDraw = new RectF();
        this.mExpandedRect = new RectF();
        this.mCollapsedRect = new RectF();
        this.mPaint = new Paint();
        this.mPaint.setColor(color2);
        this.mPaint.setAlpha(this.mMaxAlpha);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    private void setDimens(int width, int height) {
        this.mReady = true;
        float expandedLeft = (float)(width - this.mExpandedWidthHeight) / 2.0f;
        float expandedTop = (float)(height - this.mExpandedWidthHeight) / 2.0f;
        float expandedRight = (float)(width + this.mExpandedWidthHeight) / 2.0f;
        float expandedBottom = (float)(height + this.mExpandedWidthHeight) / 2.0f;
        float collapsedLeft = (float)width / 2.0f;
        float collapsedTop = (float)height / 2.0f;
        float collapsedRight = (float)width / 2.0f;
        float collapsedBottom = (float)height / 2.0f;
        this.mCollapsedRect = new RectF(collapsedLeft, collapsedTop, collapsedRight, collapsedBottom);
        this.mExpandedRect = new RectF(expandedLeft, expandedTop, expandedRight, expandedBottom);
        this.reset();
    }

    public void setCheckedOnClick(boolean checked, OnAnimationDone callback) {
        this.mChecked = checked;
        if (!this.mReady) {
            this.invalidateSelf();
            return;
        }
        this.reset();
        this.onClick(callback);
    }

    private void onClick(OnAnimationDone callback) {
        this.animate(this.mChecked, callback);
    }

    private void cancelAnimationInTracks() {
        if (this.asTransition != null && this.asTransition.isRunning()) {
            this.asTransition.cancel();
        }
    }

    public void setChecked(boolean checked) {
        if (this.mChecked == checked) {
            return;
        }
        this.mChecked = checked;
        this.reset();
    }

    private void reset() {
        this.cancelAnimationInTracks();
        if (this.mChecked) {
            this.mRectToDraw.set(this.mExpandedRect);
        } else {
            this.mRectToDraw.set(this.mCollapsedRect);
        }
        this.invalidateSelf();
    }

    private void animate(boolean expand, final OnAnimationDone callback) {
        RectF from = expand ? this.mCollapsedRect : this.mExpandedRect;
        RectF to = expand ? this.mExpandedRect : this.mCollapsedRect;
        this.mRectToDraw.set(from);
        ObjectAnimator oaTransition = ObjectAnimator.ofObject((Object)((Object)this), (String)"newRectBounds", (TypeEvaluator)this.mRectEvaluator, (Object[])new Object[]{from, to});
        int duration = expand ? 500 : 400;
        oaTransition.setDuration((long)duration);
        oaTransition.setInterpolator((TimeInterpolator)(expand ? this.mExpandInterpolator : this.mCollapseInterpolator));
        ObjectAnimator oaAlpha = ObjectAnimator.ofInt((Object)((Object)this), (String)"alpha", (int[])new int[]{expand ? this.mMinAlpha : this.mMaxAlpha, expand ? this.mMaxAlpha : this.mMinAlpha});
        oaAlpha.setDuration((long)duration);
        this.asTransition = new AnimatorSet();
        this.asTransition.playTogether(new Animator[]{oaTransition, oaAlpha});
        this.asTransition.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (callback != null) {
                    callback.animationIsDone();
                }
            }

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                if (callback != null) {
                    callback.animationHasBeenCancelled();
                }
            }
        });
        this.asTransition.start();
    }

    public void draw(Canvas canvas) {
        if (!this.mReady) {
            this.setDimens(this.getBounds().width(), this.getBounds().height());
            return;
        }
        canvas.drawOval(this.mRectToDraw, this.mPaint);
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public int getOpacity() {
        return -3;
    }

    public void setNewRectBounds(RectF newRectBounds) {
        this.mRectToDraw = newRectBounds;
        this.invalidateSelf();
    }

    public static interface OnAnimationDone {
        public void animationIsDone();

        public void animationHasBeenCancelled();
    }
}

