/*
 * Decompiled with CFR 0.152.
 */
package com.kp.md.picker.datepicker;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.widget.ExploreByTouchHelper;
import android.text.TextPaint;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityEvent;
import android.widget.TextView;
import com.kp.md.picker.R;
import com.kp.md.picker.common.DateTimePatternHelper;
import com.kp.md.picker.datepicker.SelectedDate;
import com.kp.md.picker.utilities.MUtils;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

class SimpleMonthView
extends View {
    private static final String TAG = SimpleMonthView.class.getSimpleName();
    private static final int DAYS_IN_WEEK = 7;
    private static final int MAX_WEEKS_IN_MONTH = 6;
    private static final int DEFAULT_SELECTED_DAY = -1;
    private static final int DEFAULT_WEEK_START = 1;
    private static final String DEFAULT_TITLE_FORMAT = "MMMMy";
    private static final String DAY_OF_WEEK_FORMAT = MUtils.isApi_18_OrHigher() ? "EEEEE" : "E";
    private final int DRAW_RECT = 0;
    private final int DRAW_RECT_WITH_CURVE_ON_LEFT = 1;
    private final int DRAW_RECT_WITH_CURVE_ON_RIGHT = 2;
    private final TextPaint mMonthPaint = new TextPaint();
    private final TextPaint mDayOfWeekPaint = new TextPaint();
    private final TextPaint mDayPaint = new TextPaint();
    private final Paint mDaySelectorPaint = new Paint();
    private final Paint mDayHighlightPaint = new Paint();
    private final Paint mDayRangeSelectorPaint = new Paint();
    private final Calendar mCalendar = Calendar.getInstance();
    private final Calendar mDayOfWeekLabelCalendar = Calendar.getInstance();
    private MonthViewTouchHelper mTouchHelper;
    private SimpleDateFormat mTitleFormatter;
    private SimpleDateFormat mDayOfWeekFormatter;
    private NumberFormat mDayFormatter;
    private int mDesiredMonthHeight;
    private int mDesiredDayOfWeekHeight;
    private int mDesiredDayHeight;
    private int mDesiredCellWidth;
    private int mDesiredDaySelectorRadius;
    private CharSequence mTitle;
    private int mMonth;
    private int mYear;
    private int mMonthHeight;
    private int mDayOfWeekHeight;
    private int mDayHeight;
    private int mCellWidth;
    private int mDaySelectorRadius;
    private int mPaddedWidth;
    private int mPaddedHeight;
    private final ActivatedDays mActivatedDays = new ActivatedDays();
    private int mToday = -1;
    private int mWeekStart = 1;
    private int mDaysInMonth;
    private int mDayOfWeekStart;
    private int mEnabledDayStart = 1;
    private int mEnabledDayEnd = 31;
    private OnDayClickListener mOnDayClickListener;
    private ColorStateList mDayTextColor;
    private int mTouchedItem = -1;
    private Context mContext;
    private int mTouchSlopSquared;
    private float mPaddingRangeIndicator;
    private CheckForTap mPendingCheckForTap;
    private int mInitialTarget = -1;
    private int mDownX;
    private int mDownY;

    public SimpleMonthView(Context context) {
        this(context, null);
    }

    public SimpleMonthView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.spMonthViewStyle);
    }

    public SimpleMonthView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public SimpleMonthView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.mContext = this.getContext();
        this.mTouchSlopSquared = ViewConfiguration.get((Context)this.mContext).getScaledTouchSlop() * ViewConfiguration.get((Context)this.mContext).getScaledTouchSlop();
        Resources res = this.mContext.getResources();
        this.mDesiredMonthHeight = res.getDimensionPixelSize(R.dimen.sp_date_picker_month_height);
        this.mDesiredDayOfWeekHeight = res.getDimensionPixelSize(R.dimen.sp_date_picker_day_of_week_height);
        this.mDesiredDayHeight = res.getDimensionPixelSize(R.dimen.sp_date_picker_day_height);
        this.mDesiredCellWidth = res.getDimensionPixelSize(R.dimen.sp_date_picker_day_width);
        this.mDesiredDaySelectorRadius = res.getDimensionPixelSize(R.dimen.sp_date_picker_day_selector_radius);
        this.mPaddingRangeIndicator = res.getDimensionPixelSize(R.dimen.sp_month_view_range_padding);
        this.mTouchHelper = new MonthViewTouchHelper(this);
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)this.mTouchHelper);
        ViewCompat.setImportantForAccessibility((View)this, (int)1);
        Locale locale = res.getConfiguration().locale;
        String titleFormat = MUtils.isApi_18_OrHigher() ? DateFormat.getBestDateTimePattern((Locale)locale, (String)DEFAULT_TITLE_FORMAT) : DateTimePatternHelper.getBestDateTimePattern(locale, 1);
        this.mTitleFormatter = new SimpleDateFormat(titleFormat, locale);
        this.mDayOfWeekFormatter = new SimpleDateFormat(DAY_OF_WEEK_FORMAT, locale);
        this.mDayFormatter = NumberFormat.getIntegerInstance(locale);
        this.initPaints(res);
    }

    private ColorStateList applyTextAppearance(Paint p, int resId) {
        TextView tv = new TextView(this.mContext);
        if (MUtils.isApi_23_OrHigher()) {
            tv.setTextAppearance(resId);
        } else {
            tv.setTextAppearance(this.mContext, resId);
        }
        p.setTypeface(tv.getTypeface());
        p.setTextSize(tv.getTextSize());
        ColorStateList textColor = tv.getTextColors();
        if (textColor != null) {
            int enabledColor = textColor.getColorForState(ENABLED_STATE_SET, 0);
            p.setColor(enabledColor);
        }
        return textColor;
    }

    public int getMonthHeight() {
        return this.mMonthHeight;
    }

    public int getCellWidth() {
        return this.mCellWidth;
    }

    public void setMonthTextAppearance(int resId) {
        this.applyTextAppearance((Paint)this.mMonthPaint, resId);
        this.invalidate();
    }

    public void setDayOfWeekTextAppearance(int resId) {
        this.applyTextAppearance((Paint)this.mDayOfWeekPaint, resId);
        this.invalidate();
    }

    public void setDayTextAppearance(int resId) {
        ColorStateList textColor = this.applyTextAppearance((Paint)this.mDayPaint, resId);
        if (textColor != null) {
            this.mDayTextColor = textColor;
        }
        this.invalidate();
    }

    public CharSequence getTitle() {
        if (this.mTitle == null) {
            this.mTitle = this.mTitleFormatter.format(this.mCalendar.getTime());
        }
        return this.mTitle;
    }

    private void initPaints(Resources res) {
        String monthTypeface = res.getString(R.string.sp_date_picker_month_typeface);
        String dayOfWeekTypeface = res.getString(R.string.sp_date_picker_day_of_week_typeface);
        String dayTypeface = res.getString(R.string.sp_date_picker_day_typeface);
        int monthTextSize = res.getDimensionPixelSize(R.dimen.sp_date_picker_month_text_size);
        int dayOfWeekTextSize = res.getDimensionPixelSize(R.dimen.sp_date_picker_day_of_week_text_size);
        int dayTextSize = res.getDimensionPixelSize(R.dimen.sp_date_picker_day_text_size);
        this.mMonthPaint.setAntiAlias(true);
        this.mMonthPaint.setTextSize((float)monthTextSize);
        this.mMonthPaint.setTypeface(Typeface.create((String)monthTypeface, (int)0));
        this.mMonthPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthPaint.setStyle(Paint.Style.FILL);
        this.mDayOfWeekPaint.setAntiAlias(true);
        this.mDayOfWeekPaint.setTextSize((float)dayOfWeekTextSize);
        this.mDayOfWeekPaint.setTypeface(Typeface.create((String)dayOfWeekTypeface, (int)0));
        this.mDayOfWeekPaint.setTextAlign(Paint.Align.CENTER);
        this.mDayOfWeekPaint.setStyle(Paint.Style.FILL);
        this.mDaySelectorPaint.setAntiAlias(true);
        this.mDaySelectorPaint.setStyle(Paint.Style.FILL);
        this.mDayHighlightPaint.setAntiAlias(true);
        this.mDayHighlightPaint.setStyle(Paint.Style.FILL);
        this.mDayRangeSelectorPaint.setAntiAlias(true);
        this.mDayRangeSelectorPaint.setStyle(Paint.Style.FILL);
        this.mDayPaint.setAntiAlias(true);
        this.mDayPaint.setTextSize((float)dayTextSize);
        this.mDayPaint.setTypeface(Typeface.create((String)dayTypeface, (int)0));
        this.mDayPaint.setTextAlign(Paint.Align.CENTER);
        this.mDayPaint.setStyle(Paint.Style.FILL);
    }

    void setMonthTextColor(ColorStateList monthTextColor) {
        int enabledColor = monthTextColor.getColorForState(ENABLED_STATE_SET, 0);
        this.mMonthPaint.setColor(enabledColor);
        this.invalidate();
    }

    void setDayOfWeekTextColor(ColorStateList dayOfWeekTextColor) {
        int enabledColor = dayOfWeekTextColor.getColorForState(ENABLED_STATE_SET, 0);
        this.mDayOfWeekPaint.setColor(enabledColor);
        this.invalidate();
    }

    void setDayTextColor(ColorStateList dayTextColor) {
        this.mDayTextColor = dayTextColor;
        this.invalidate();
    }

    void setDaySelectorColor(ColorStateList dayBackgroundColor) {
        int activatedColor = dayBackgroundColor.getColorForState(MUtils.resolveStateSet(3), 0);
        this.mDaySelectorPaint.setColor(activatedColor);
        this.mDayRangeSelectorPaint.setColor(activatedColor);
        this.mDayRangeSelectorPaint.setAlpha(150);
        this.invalidate();
    }

    void setDayHighlightColor(ColorStateList dayHighlightColor) {
        int pressedColor = dayHighlightColor.getColorForState(MUtils.resolveStateSet(5), 0);
        this.mDayHighlightPaint.setColor(pressedColor);
        this.invalidate();
    }

    public void setOnDayClickListener(OnDayClickListener listener) {
        this.mOnDayClickListener = listener;
    }

    public boolean dispatchHoverEvent(MotionEvent event) {
        return this.mTouchHelper.dispatchHoverEvent(event) || super.dispatchHoverEvent(event);
    }

    private boolean isStillAClick(int x, int y) {
        return (x - this.mDownX) * (x - this.mDownX) + (y - this.mDownY) * (y - this.mDownY) <= this.mTouchSlopSquared;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int x = (int)(event.getX() + 0.5f);
        int y = (int)(event.getY() + 0.5f);
        int action = event.getAction();
        switch (action) {
            case 0: {
                this.mDownX = x;
                this.mDownY = y;
                this.mInitialTarget = this.getDayAtLocation(this.mDownX, this.mDownY);
                if (this.mInitialTarget < 0) {
                    return false;
                }
                if (this.mPendingCheckForTap == null) {
                    this.mPendingCheckForTap = new CheckForTap();
                }
                this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
                break;
            }
            case 2: {
                if (this.isStillAClick(x, y)) break;
                if (this.mPendingCheckForTap != null) {
                    this.removeCallbacks(this.mPendingCheckForTap);
                }
                this.mInitialTarget = -1;
                if (this.mTouchedItem < 0) break;
                this.mTouchedItem = -1;
                this.invalidate();
                break;
            }
            case 1: {
                this.onDayClicked(this.mInitialTarget);
            }
            case 3: {
                if (this.mPendingCheckForTap != null) {
                    this.removeCallbacks(this.mPendingCheckForTap);
                }
                this.mTouchedItem = -1;
                this.mInitialTarget = -1;
                this.invalidate();
            }
        }
        return true;
    }

    protected void onDraw(Canvas canvas) {
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        canvas.translate((float)paddingLeft, (float)paddingTop);
        this.drawMonth(canvas);
        this.drawDaysOfWeek(canvas);
        this.drawDays(canvas);
        canvas.translate((float)(-paddingLeft), (float)(-paddingTop));
    }

    private void drawMonth(Canvas canvas) {
        float x = (float)this.mPaddedWidth / 2.0f;
        float lineHeight = this.mMonthPaint.ascent() + this.mMonthPaint.descent();
        float y = ((float)this.mMonthHeight - lineHeight) / 2.0f;
        canvas.drawText(this.getTitle().toString(), x, y, (Paint)this.mMonthPaint);
    }

    private void drawDaysOfWeek(Canvas canvas) {
        TextPaint p = this.mDayOfWeekPaint;
        int headerHeight = this.mMonthHeight;
        int rowHeight = this.mDayOfWeekHeight;
        int colWidth = this.mCellWidth;
        float halfLineHeight = (p.ascent() + p.descent()) / 2.0f;
        int rowCenter = headerHeight + rowHeight / 2;
        for (int col = 0; col < 7; ++col) {
            int colCenter = colWidth * col + colWidth / 2;
            int colCenterRtl = MUtils.isLayoutRtlCompat(this) ? this.mPaddedWidth - colCenter : colCenter;
            int dayOfWeek = (col + this.mWeekStart) % 7;
            String label = this.getDayOfWeekLabel(dayOfWeek);
            canvas.drawText(label, (float)colCenterRtl, (float)rowCenter - halfLineHeight, (Paint)p);
        }
    }

    private String getDayOfWeekLabel(int dayOfWeek) {
        this.mDayOfWeekLabelCalendar.set(7, dayOfWeek);
        return this.mDayOfWeekFormatter.format(this.mDayOfWeekLabelCalendar.getTime());
    }

    private void drawDays(Canvas canvas) {
        TextPaint p = this.mDayPaint;
        int headerHeight = this.mMonthHeight + this.mDayOfWeekHeight;
        float rowHeight = this.mDayHeight;
        float colWidth = this.mCellWidth;
        float halfLineHeight = (p.ascent() + p.descent()) / 2.0f;
        float rowCenter = (float)headerHeight + rowHeight / 2.0f;
        int col = this.findDayOffset();
        for (int day = 1; day <= this.mDaysInMonth; ++day) {
            int dayTextColor;
            boolean isDayToday;
            float colCenter = colWidth * (float)col + colWidth / 2.0f;
            float colCenterRtl = MUtils.isLayoutRtlCompat(this) ? (float)this.mPaddedWidth - colCenter : colCenter;
            int stateMask = 0;
            boolean isDayEnabled = this.isDayEnabled(day);
            if (isDayEnabled) {
                stateMask |= 1;
            }
            boolean isDayInActivatedRange = this.mActivatedDays.isValid() && this.mActivatedDays.isActivated(day);
            boolean isSelected = this.mActivatedDays.isSelected(day);
            if (isSelected) {
                stateMask |= 2;
                canvas.drawCircle(colCenterRtl, rowCenter, (float)this.mDaySelectorRadius, this.mDaySelectorPaint);
            } else if (isDayInActivatedRange) {
                stateMask |= 2;
                int bgShape = 0;
                if (this.mActivatedDays.isSingleDay()) {
                    bgShape = this.mActivatedDays.isStartOfMonth() ? 2 : 1;
                } else if (this.mActivatedDays.isStartingDayOfRange(day)) {
                    bgShape = 1;
                } else if (this.mActivatedDays.isEndingDayOfRange(day)) {
                    bgShape = 2;
                }
                boolean constrainProtrusion = colWidth > rowHeight - 2.0f * this.mPaddingRangeIndicator;
                float horDistFromCenter = constrainProtrusion ? rowHeight / 2.0f - this.mPaddingRangeIndicator : colWidth / 2.0f;
                switch (bgShape) {
                    case 1: {
                        int leftRectArcLeft = (int)(colCenterRtl - horDistFromCenter) % 2 == 1 ? (int)(colCenterRtl - horDistFromCenter) + 1 : (int)(colCenterRtl - horDistFromCenter);
                        int leftRectArcRight = (int)(colCenterRtl + horDistFromCenter) % 2 == 1 ? (int)(colCenterRtl + horDistFromCenter) + 1 : (int)(colCenterRtl + horDistFromCenter);
                        RectF leftArcRect = new RectF((float)leftRectArcLeft, rowCenter - rowHeight / 2.0f + this.mPaddingRangeIndicator, (float)leftRectArcRight, rowCenter + rowHeight / 2.0f - this.mPaddingRangeIndicator);
                        canvas.drawArc(leftArcRect, 90.0f, 180.0f, true, this.mDayRangeSelectorPaint);
                        canvas.drawRect(new RectF(leftArcRect.centerX(), rowCenter - rowHeight / 2.0f + this.mPaddingRangeIndicator, colCenterRtl + colWidth / 2.0f, rowCenter + rowHeight / 2.0f - this.mPaddingRangeIndicator), this.mDayRangeSelectorPaint);
                        break;
                    }
                    case 2: {
                        int rightRectArcLeft = (int)(colCenterRtl - horDistFromCenter) % 2 == 1 ? (int)(colCenterRtl - horDistFromCenter) + 1 : (int)(colCenterRtl - horDistFromCenter);
                        int rightRectArcRight = (int)(colCenterRtl + horDistFromCenter) % 2 == 1 ? (int)(colCenterRtl + horDistFromCenter) + 1 : (int)(colCenterRtl + horDistFromCenter);
                        RectF rightArcRect = new RectF((float)rightRectArcLeft, rowCenter - rowHeight / 2.0f + this.mPaddingRangeIndicator, (float)rightRectArcRight, rowCenter + rowHeight / 2.0f - this.mPaddingRangeIndicator);
                        canvas.drawArc(rightArcRect, 270.0f, 180.0f, true, this.mDayRangeSelectorPaint);
                        canvas.drawRect(new RectF(colCenterRtl - colWidth / 2.0f, rowCenter - rowHeight / 2.0f + this.mPaddingRangeIndicator, rightArcRect.centerX(), rowCenter + rowHeight / 2.0f - this.mPaddingRangeIndicator), this.mDayRangeSelectorPaint);
                        break;
                    }
                    default: {
                        canvas.drawRect(new RectF(colCenterRtl - colWidth / 2.0f, rowCenter - rowHeight / 2.0f + this.mPaddingRangeIndicator, colCenterRtl + colWidth / 2.0f, rowCenter + rowHeight / 2.0f - this.mPaddingRangeIndicator), this.mDayRangeSelectorPaint);
                    }
                }
            }
            if (this.mTouchedItem == day) {
                stateMask |= 4;
                if (isDayEnabled) {
                    canvas.drawCircle(colCenterRtl, rowCenter, (float)this.mDaySelectorRadius, this.mDayHighlightPaint);
                }
            }
            boolean bl = isDayToday = this.mToday == day;
            if (isDayToday && !isDayInActivatedRange) {
                dayTextColor = this.mDaySelectorPaint.getColor();
            } else {
                int[] stateSet = MUtils.resolveStateSet(stateMask);
                dayTextColor = this.mDayTextColor.getColorForState(stateSet, 0);
            }
            p.setColor(dayTextColor);
            canvas.drawText(this.mDayFormatter.format(day), colCenterRtl, rowCenter - halfLineHeight, (Paint)p);
            if (++col != 7) continue;
            col = 0;
            rowCenter += rowHeight;
        }
    }

    private boolean isDayEnabled(int day) {
        return day >= this.mEnabledDayStart && day <= this.mEnabledDayEnd;
    }

    private boolean isValidDayOfMonth(int day) {
        return day >= 1 && day <= this.mDaysInMonth;
    }

    private static boolean isValidDayOfWeek(int day) {
        return day >= 1 && day <= 7;
    }

    private static boolean isValidMonth(int month) {
        return month >= 0 && month <= 11;
    }

    public void selectAllDays() {
        this.setSelectedDays(1, MUtils.getDaysInMonth(this.mMonth, this.mYear), SelectedDate.Type.RANGE);
    }

    public void setSelectedDays(int selectedDayStart, int selectedDayEnd, SelectedDate.Type selectedDateType) {
        this.mActivatedDays.startingDay = selectedDayStart;
        this.mActivatedDays.endingDay = selectedDayEnd;
        this.mActivatedDays.selectedDateType = selectedDateType;
        this.mTouchHelper.invalidateRoot();
        this.invalidate();
    }

    public void setFirstDayOfWeek(int weekStart) {
        this.mWeekStart = SimpleMonthView.isValidDayOfWeek(weekStart) ? weekStart : this.mCalendar.getFirstDayOfWeek();
        this.mTouchHelper.invalidateRoot();
        this.invalidate();
    }

    void setMonthParams(int month, int year, int weekStart, int enabledDayStart, int enabledDayEnd, int selectedDayStart, int selectedDayEnd, SelectedDate.Type selectedDateType) {
        if (SimpleMonthView.isValidMonth(month)) {
            this.mMonth = month;
        }
        this.mYear = year;
        this.mCalendar.set(2, this.mMonth);
        this.mCalendar.set(1, this.mYear);
        this.mCalendar.set(5, 1);
        this.mDayOfWeekStart = this.mCalendar.get(7);
        this.mWeekStart = SimpleMonthView.isValidDayOfWeek(weekStart) ? weekStart : this.mCalendar.getFirstDayOfWeek();
        Calendar today = Calendar.getInstance();
        this.mToday = -1;
        this.mDaysInMonth = MUtils.getDaysInMonth(this.mMonth, this.mYear);
        for (int i = 0; i < this.mDaysInMonth; ++i) {
            int day = i + 1;
            if (!this.sameDay(day, today)) continue;
            this.mToday = day;
        }
        this.mEnabledDayStart = MUtils.constrain(enabledDayStart, 1, this.mDaysInMonth);
        this.mEnabledDayEnd = MUtils.constrain(enabledDayEnd, this.mEnabledDayStart, this.mDaysInMonth);
        this.mTitle = null;
        this.mActivatedDays.startingDay = selectedDayStart;
        this.mActivatedDays.endingDay = selectedDayEnd;
        this.mActivatedDays.selectedDateType = selectedDateType;
        this.mTouchHelper.invalidateRoot();
    }

    private boolean sameDay(int day, Calendar today) {
        return this.mYear == today.get(1) && this.mMonth == today.get(2) && day == today.get(5);
    }

    @TargetApi(value=17)
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int preferredHeight = this.mDesiredDayHeight * 6 + this.mDesiredDayOfWeekHeight + this.mDesiredMonthHeight + this.getPaddingTop() + this.getPaddingBottom();
        int preferredWidth = this.mDesiredCellWidth * 7 + (MUtils.isApi_17_OrHigher() ? this.getPaddingStart() : this.getPaddingLeft()) + (MUtils.isApi_17_OrHigher() ? this.getPaddingEnd() : this.getPaddingRight());
        int resolvedWidth = SimpleMonthView.resolveSize((int)preferredWidth, (int)widthMeasureSpec);
        int resolvedHeight = SimpleMonthView.resolveSize((int)preferredHeight, (int)heightMeasureSpec);
        this.setMeasuredDimension(resolvedWidth, resolvedHeight);
    }

    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        this.requestLayout();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (!changed) {
            return;
        }
        int w = right - left;
        int h = bottom - top;
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        int paddedRight = w - paddingRight;
        int paddedBottom = h - paddingBottom;
        int paddedWidth = paddedRight - paddingLeft;
        int paddedHeight = paddedBottom - paddingTop;
        if (paddedWidth == this.mPaddedWidth || paddedHeight == this.mPaddedHeight) {
            return;
        }
        this.mPaddedWidth = paddedWidth;
        this.mPaddedHeight = paddedHeight;
        int measuredPaddedHeight = this.getMeasuredHeight() - paddingTop - paddingBottom;
        float scaleH = (float)paddedHeight / (float)measuredPaddedHeight;
        int monthHeight = (int)((float)this.mDesiredMonthHeight * scaleH);
        int cellWidth = this.mPaddedWidth / 7;
        this.mMonthHeight = monthHeight;
        this.mDayOfWeekHeight = (int)((float)this.mDesiredDayOfWeekHeight * scaleH);
        this.mDayHeight = (int)((float)this.mDesiredDayHeight * scaleH);
        this.mCellWidth = cellWidth;
        int maxSelectorWidth = cellWidth / 2 + Math.min(paddingLeft, paddingRight);
        int maxSelectorHeight = this.mDayHeight / 2 + paddingBottom;
        this.mDaySelectorRadius = Math.min(this.mDesiredDaySelectorRadius, Math.min(maxSelectorWidth, maxSelectorHeight));
        this.mTouchHelper.invalidateRoot();
    }

    private int findDayOffset() {
        int offset = this.mDayOfWeekStart - this.mWeekStart;
        if (this.mDayOfWeekStart < this.mWeekStart) {
            return offset + 7;
        }
        return offset;
    }

    public int getDayAtLocation(int x, int y) {
        int row;
        int paddedX = x - this.getPaddingLeft();
        if (paddedX < 0 || paddedX >= this.mPaddedWidth) {
            return -1;
        }
        int headerHeight = this.mMonthHeight + this.mDayOfWeekHeight;
        int paddedY = y - this.getPaddingTop();
        if (paddedY < headerHeight || paddedY >= this.mPaddedHeight) {
            return -1;
        }
        int paddedXRtl = MUtils.isLayoutRtlCompat(this) ? this.mPaddedWidth - paddedX : paddedX;
        int col = paddedXRtl * 7 / this.mPaddedWidth;
        int index = col + (row = (paddedY - headerHeight) / this.mDayHeight) * 7;
        int day = index + 1 - this.findDayOffset();
        if (!this.isValidDayOfMonth(day)) {
            return -1;
        }
        return day;
    }

    private boolean getBoundsForDay(int id2, Rect outBounds) {
        if (!this.isValidDayOfMonth(id2)) {
            return false;
        }
        int index = id2 - 1 + this.findDayOffset();
        int col = index % 7;
        int colWidth = this.mCellWidth;
        int left = MUtils.isLayoutRtlCompat(this) ? this.getWidth() - this.getPaddingRight() - (col + 1) * colWidth : this.getPaddingLeft() + col * colWidth;
        int row = index / 7;
        int rowHeight = this.mDayHeight;
        int headerHeight = this.mMonthHeight + this.mDayOfWeekHeight;
        int top = this.getPaddingTop() + headerHeight + row * rowHeight;
        outBounds.set(left, top, left + colWidth, top + rowHeight);
        return true;
    }

    private boolean onDayClicked(int day) {
        if (!this.isValidDayOfMonth(day) || !this.isDayEnabled(day)) {
            return false;
        }
        if (this.mOnDayClickListener != null) {
            Calendar date = Calendar.getInstance();
            date.set(this.mYear, this.mMonth, day);
            this.mOnDayClickListener.onDayClick(this, date);
        }
        this.mTouchHelper.sendEventForVirtualView(day, 1);
        return true;
    }

    public Calendar composeDate(int day) {
        if (!this.isValidDayOfMonth(day) || !this.isDayEnabled(day)) {
            return null;
        }
        Calendar date = Calendar.getInstance();
        date.set(this.mYear, this.mMonth, day);
        return date;
    }

    public static interface OnDayClickListener {
        public void onDayClick(SimpleMonthView var1, Calendar var2);
    }

    public class ActivatedDays {
        public int startingDay = -1;
        public int endingDay = -1;
        public SelectedDate.Type selectedDateType;

        public void reset() {
            this.endingDay = -1;
            this.startingDay = -1;
        }

        public boolean isValid() {
            return this.startingDay != -1 && this.endingDay != -1;
        }

        public boolean isActivated(int day) {
            return day >= this.startingDay && day <= this.endingDay;
        }

        public boolean isStartingDayOfRange(int day) {
            return day == this.startingDay;
        }

        public boolean isEndingDayOfRange(int day) {
            return day == this.endingDay;
        }

        public boolean isSingleDay() {
            return this.startingDay == this.endingDay;
        }

        public boolean isSelected(int day) {
            return this.selectedDateType == SelectedDate.Type.SINGLE && this.startingDay == day && this.endingDay == day;
        }

        public int getSelectedDay() {
            if (this.selectedDateType == SelectedDate.Type.SINGLE && this.startingDay == this.endingDay) {
                return this.startingDay;
            }
            return -1;
        }

        public boolean hasSelectedDay() {
            return this.selectedDateType == SelectedDate.Type.SINGLE && this.startingDay == this.endingDay && this.startingDay != -1;
        }

        public boolean isStartOfMonth() {
            return this.startingDay == 1;
        }
    }

    private class MonthViewTouchHelper
    extends ExploreByTouchHelper {
        private static final String DATE_FORMAT = "dd MMMM yyyy";
        private final Rect mTempRect;
        private final Calendar mTempCalendar;

        public MonthViewTouchHelper(View forView) {
            super(forView);
            this.mTempRect = new Rect();
            this.mTempCalendar = Calendar.getInstance();
        }

        protected int getVirtualViewAt(float x, float y) {
            int day = SimpleMonthView.this.getDayAtLocation((int)(x + 0.5f), (int)(y + 0.5f));
            if (day != -1) {
                return day;
            }
            return Integer.MIN_VALUE;
        }

        protected void getVisibleVirtualViews(List<Integer> virtualViewIds) {
            for (int day = 1; day <= SimpleMonthView.this.mDaysInMonth; ++day) {
                virtualViewIds.add(day);
            }
        }

        protected void onPopulateEventForVirtualView(int virtualViewId, AccessibilityEvent event) {
            event.setContentDescription(this.getDayDescription(virtualViewId));
        }

        protected void onPopulateNodeForVirtualView(int virtualViewId, AccessibilityNodeInfoCompat node) {
            boolean hasBounds = SimpleMonthView.this.getBoundsForDay(virtualViewId, this.mTempRect);
            if (!hasBounds) {
                this.mTempRect.setEmpty();
                node.setContentDescription((CharSequence)"");
                node.setBoundsInParent(this.mTempRect);
                node.setVisibleToUser(false);
                return;
            }
            node.setText(this.getDayText(virtualViewId));
            node.setContentDescription(this.getDayDescription(virtualViewId));
            node.setBoundsInParent(this.mTempRect);
            boolean isDayEnabled = SimpleMonthView.this.isDayEnabled(virtualViewId);
            if (isDayEnabled) {
                node.addAction(16);
            }
            node.setEnabled(isDayEnabled);
            if (SimpleMonthView.this.mActivatedDays.isValid() && SimpleMonthView.this.mActivatedDays.isActivated(virtualViewId)) {
                node.setChecked(true);
            }
        }

        protected boolean onPerformActionForVirtualView(int virtualViewId, int action, Bundle arguments) {
            switch (action) {
                case 16: {
                    return SimpleMonthView.this.onDayClicked(virtualViewId);
                }
            }
            return false;
        }

        private CharSequence getDayDescription(int id2) {
            if (SimpleMonthView.this.isValidDayOfMonth(id2)) {
                this.mTempCalendar.set(SimpleMonthView.this.mYear, SimpleMonthView.this.mMonth, id2);
                return DateFormat.format((CharSequence)DATE_FORMAT, (long)this.mTempCalendar.getTimeInMillis());
            }
            return "";
        }

        private CharSequence getDayText(int id2) {
            if (SimpleMonthView.this.isValidDayOfMonth(id2)) {
                return SimpleMonthView.this.mDayFormatter.format(id2);
            }
            return null;
        }
    }

    private final class CheckForTap
    implements Runnable {
        private CheckForTap() {
        }

        @Override
        public void run() {
            SimpleMonthView.this.mTouchedItem = SimpleMonthView.this.getDayAtLocation(SimpleMonthView.this.mDownX, SimpleMonthView.this.mDownY);
            SimpleMonthView.this.invalidate();
        }
    }
}

