/*
 * Decompiled with CFR 0.152.
 */
package com.kp.md.picker.datepicker;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.FrameLayout;
import com.kp.md.picker.R;
import com.kp.md.picker.common.DecisionButtonLayout;
import com.kp.md.picker.datepicker.DayPickerView;
import com.kp.md.picker.datepicker.MDatePicker;
import com.kp.md.picker.datepicker.SelectedDate;
import com.kp.md.picker.utilities.AccessibilityUtils;
import com.kp.md.picker.utilities.MUtils;
import java.util.Calendar;
import java.util.Locale;

public class RecurrenceEndDatePicker
extends FrameLayout {
    private static final String TAG = RecurrenceEndDatePicker.class.getSimpleName();
    private static final int DEFAULT_START_YEAR = 1900;
    private static final int DEFAULT_END_YEAR = 2100;
    private Context mContext;
    private ViewGroup mContainer;
    private DayPickerView mDayPickerView;
    private OnDateSetListener mOnDateSetListener;
    private SelectedDate mCurrentDate;
    private Calendar mTempDate;
    private Calendar mMinDate;
    private Calendar mMaxDate;
    private int mFirstDayOfWeek;
    private Locale mCurrentLocale;
    private DatePickerValidationCallback mValidationCallback;
    private DecisionButtonLayout mDecisionButtonLayout;
    private DecisionButtonLayout.Callback mDecisionButtonLayoutCallback = new DecisionButtonLayout.Callback(){

        @Override
        public void onOkay() {
            if (RecurrenceEndDatePicker.this.mOnDateSetListener != null) {
                RecurrenceEndDatePicker.this.mOnDateSetListener.onDateSet(RecurrenceEndDatePicker.this, RecurrenceEndDatePicker.this.mCurrentDate.getStartDate().get(1), RecurrenceEndDatePicker.this.mCurrentDate.getStartDate().get(2), RecurrenceEndDatePicker.this.mCurrentDate.getStartDate().get(5));
            }
        }

        @Override
        public void onCancel() {
            if (RecurrenceEndDatePicker.this.mOnDateSetListener != null) {
                RecurrenceEndDatePicker.this.mOnDateSetListener.onDateOnlyPickerCancelled(RecurrenceEndDatePicker.this);
            }
        }
    };
    private final DayPickerView.ProxyDaySelectionEventListener mProxyDaySelectionEventListener = new DayPickerView.ProxyDaySelectionEventListener(){

        @Override
        public void onDaySelected(DayPickerView view, Calendar day) {
            RecurrenceEndDatePicker.this.mCurrentDate = new SelectedDate(day);
            RecurrenceEndDatePicker.this.onDateChanged(true, true);
        }

        @Override
        public void onDateRangeSelectionStarted(@NonNull SelectedDate selectedDate) {
            RecurrenceEndDatePicker.this.mCurrentDate = new SelectedDate(selectedDate);
            RecurrenceEndDatePicker.this.onDateChanged(false, false);
        }

        @Override
        public void onDateRangeSelectionEnded(@Nullable SelectedDate selectedDate) {
            if (selectedDate != null) {
                RecurrenceEndDatePicker.this.mCurrentDate = new SelectedDate(selectedDate);
                RecurrenceEndDatePicker.this.onDateChanged(false, false);
            }
        }

        @Override
        public void onDateRangeSelectionUpdated(@NonNull SelectedDate selectedDate) {
            RecurrenceEndDatePicker.this.mCurrentDate = new SelectedDate(selectedDate);
            RecurrenceEndDatePicker.this.onDateChanged(false, false);
        }
    };

    public RecurrenceEndDatePicker(Context context) {
        this(context, null);
    }

    public RecurrenceEndDatePicker(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.spDatePickerStyle);
    }

    public RecurrenceEndDatePicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initializeLayout(attrs, defStyleAttr, R.style.MDatePickerStyle);
    }

    @TargetApi(value=21)
    public RecurrenceEndDatePicker(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initializeLayout(attrs, defStyleAttr, defStyleRes);
    }

    private void initializeLayout(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        long maxDateMillis;
        this.mContext = this.getContext();
        this.setCurrentLocale(Locale.getDefault());
        this.mCurrentDate = new SelectedDate(Calendar.getInstance(this.mCurrentLocale));
        this.mTempDate = Calendar.getInstance(this.mCurrentLocale);
        this.mMinDate = Calendar.getInstance(this.mCurrentLocale);
        this.mMaxDate = Calendar.getInstance(this.mCurrentLocale);
        this.mMinDate.set(1900, 0, 1);
        this.mMaxDate.set(2100, 11, 31);
        Resources res = this.getResources();
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.MDatePicker, defStyleAttr, defStyleRes);
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        int layoutResourceId = R.layout.recurrence_end_date_picker;
        try {
            this.mContainer = (ViewGroup)inflater.inflate(layoutResourceId, (ViewGroup)this, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addView((View)this.mContainer);
        int firstDayOfWeek = a.getInt(R.styleable.MDatePicker_spFirstDayOfWeek, this.mCurrentDate.getFirstDate().getFirstDayOfWeek());
        String minDate = a.getString(R.styleable.MDatePicker_spMinDate);
        String maxDate = a.getString(R.styleable.MDatePicker_spMaxDate);
        Calendar tempDate = Calendar.getInstance();
        if (!MUtils.parseDate(minDate, tempDate)) {
            tempDate.set(1900, 0, 1);
        }
        long minDateMillis = tempDate.getTimeInMillis();
        if (!MUtils.parseDate(maxDate, tempDate)) {
            tempDate.set(2100, 11, 31);
        }
        if ((maxDateMillis = tempDate.getTimeInMillis()) < minDateMillis) {
            throw new IllegalArgumentException("maxDate must be >= minDate");
        }
        long setDateMillis = MUtils.constrain(System.currentTimeMillis(), minDateMillis, maxDateMillis);
        this.mMinDate.setTimeInMillis(minDateMillis);
        this.mMaxDate.setTimeInMillis(maxDateMillis);
        this.mCurrentDate.setTimeInMillis(setDateMillis);
        a.recycle();
        this.mDecisionButtonLayout = (DecisionButtonLayout)this.mContainer.findViewById(R.id.redp_decision_button_layout);
        this.mDecisionButtonLayout.applyOptions(this.mDecisionButtonLayoutCallback);
        this.mDayPickerView = (DayPickerView)this.mContainer.findViewById(R.id.redp_day_picker);
        this.setFirstDayOfWeek(firstDayOfWeek);
        this.mDayPickerView.setMinDate(this.mMinDate.getTimeInMillis());
        this.mDayPickerView.setMaxDate(this.mMaxDate.getTimeInMillis());
        this.mDayPickerView.setDate(this.mCurrentDate);
        this.mDayPickerView.setProxyDaySelectionEventListener(this.mProxyDaySelectionEventListener);
        this.mDayPickerView.setCanPickRange(false);
        String selectDay = res.getString(R.string.select_day);
        this.onLocaleChanged(this.mCurrentLocale);
        AccessibilityUtils.makeAnnouncement((View)this.mDayPickerView, selectDay);
    }

    private void onLocaleChanged(Locale locale) {
        DayPickerView dayPickerView = this.mDayPickerView;
        if (dayPickerView == null) {
            return;
        }
        this.onCurrentDateChanged(false);
    }

    private void onCurrentDateChanged(boolean announce) {
        if (this.mDayPickerView == null) {
            return;
        }
        if (announce) {
            long millis = this.mCurrentDate.getStartDate().getTimeInMillis();
            int flags = 20;
            String fullDateText = DateUtils.formatDateTime((Context)this.mContext, (long)millis, (int)20);
            AccessibilityUtils.makeAnnouncement((View)this.mDayPickerView, fullDateText);
        }
    }

    public void init(int year, int monthOfYear, int dayOfMonth, OnDateSetListener callback) {
        this.mCurrentDate.set(1, year);
        this.mCurrentDate.set(2, monthOfYear);
        this.mCurrentDate.set(5, dayOfMonth);
        this.mOnDateSetListener = callback;
        this.onDateChanged(false, true);
    }

    public void updateDate(int year, int month, int dayOfMonth) {
        this.mCurrentDate.set(1, year);
        this.mCurrentDate.set(2, month);
        this.mCurrentDate.set(5, dayOfMonth);
        this.onDateChanged(false, true);
    }

    private void onDateChanged(boolean fromUser, boolean goToPosition) {
        this.mDayPickerView.setDate(new SelectedDate(this.mCurrentDate), false, goToPosition);
        this.onCurrentDateChanged(fromUser);
        if (fromUser) {
            MUtils.vibrateForDatePicker((View)this);
        }
    }

    public SelectedDate getSelectedDate() {
        return new SelectedDate(this.mCurrentDate);
    }

    public long getSelectedDateInMillis() {
        return this.mCurrentDate.getStartDate().getTimeInMillis();
    }

    public void setMinDate(long minDate) {
        this.mTempDate.setTimeInMillis(minDate);
        if (this.mTempDate.get(1) == this.mMinDate.get(1) && this.mTempDate.get(6) != this.mMinDate.get(6)) {
            return;
        }
        if (this.mCurrentDate.getStartDate().before(this.mTempDate)) {
            this.mCurrentDate.getStartDate().setTimeInMillis(minDate);
            this.onDateChanged(false, true);
        }
        this.mMinDate.setTimeInMillis(minDate);
        this.mDayPickerView.setMinDate(minDate);
    }

    public Calendar getMinDate() {
        return this.mMinDate;
    }

    public void setMaxDate(long maxDate) {
        this.mTempDate.setTimeInMillis(maxDate);
        if (this.mTempDate.get(1) == this.mMaxDate.get(1) && this.mTempDate.get(6) != this.mMaxDate.get(6)) {
            return;
        }
        if (this.mCurrentDate.getEndDate().after(this.mTempDate)) {
            this.mCurrentDate.getEndDate().setTimeInMillis(maxDate);
            this.onDateChanged(false, true);
        }
        this.mMaxDate.setTimeInMillis(maxDate);
        this.mDayPickerView.setMaxDate(maxDate);
    }

    public Calendar getMaxDate() {
        return this.mMaxDate;
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        if (firstDayOfWeek < 1 || firstDayOfWeek > 7) {
            firstDayOfWeek = this.mCurrentDate.getFirstDate().getFirstDayOfWeek();
        }
        this.mFirstDayOfWeek = firstDayOfWeek;
        this.mDayPickerView.setFirstDayOfWeek(firstDayOfWeek);
    }

    public int getFirstDayOfWeek() {
        return this.mFirstDayOfWeek;
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled() == enabled) {
            return;
        }
        this.mContainer.setEnabled(enabled);
        this.mDayPickerView.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.mContainer.isEnabled();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        this.setCurrentLocale(newConfig.locale);
    }

    private void setCurrentLocale(Locale locale) {
        if (!locale.equals(this.mCurrentLocale)) {
            this.mCurrentLocale = locale;
            this.onLocaleChanged(locale);
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        int listPosition = this.mDayPickerView.getMostVisiblePosition();
        return new SavedState(superState, this.mCurrentDate, this.mMinDate.getTimeInMillis(), this.mMaxDate.getTimeInMillis(), listPosition);
    }

    @SuppressLint(value={"NewApi"})
    public void onRestoreInstanceState(Parcelable state) {
        View.BaseSavedState bss = (View.BaseSavedState)state;
        super.onRestoreInstanceState(bss.getSuperState());
        SavedState ss = (SavedState)bss;
        Calendar date = Calendar.getInstance(this.mCurrentLocale);
        date.set(ss.getSelectedYear(), ss.getSelectedMonth(), ss.getSelectedDay());
        this.mCurrentDate.setDate(date);
        this.mMinDate.setTimeInMillis(ss.getMinDate());
        this.mMaxDate.setTimeInMillis(ss.getMaxDate());
        this.onCurrentDateChanged(false);
        int listPosition = ss.getListPosition();
        if (listPosition != -1) {
            this.mDayPickerView.setPosition(listPosition);
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        super.onPopulateAccessibilityEvent(event);
        event.getText().add(this.mCurrentDate.getStartDate().getTime().toString());
    }

    public CharSequence getAccessibilityClassName() {
        return MDatePicker.class.getName();
    }

    public void setValidationCallback(DatePickerValidationCallback callback) {
        this.mValidationCallback = callback;
    }

    protected void onValidationChanged(boolean valid) {
        if (this.mValidationCallback != null) {
            this.mValidationCallback.onDatePickerValidationChanged(valid);
        }
        this.mDecisionButtonLayout.updateValidity(valid);
    }

    public static interface OnDateSetListener {
        public void onDateSet(RecurrenceEndDatePicker var1, int var2, int var3, int var4);

        public void onDateOnlyPickerCancelled(RecurrenceEndDatePicker var1);
    }

    public static interface OnDateChangedListener {
        public void onDateChanged(RecurrenceEndDatePicker var1, SelectedDate var2);
    }

    private static class SavedState
    extends View.BaseSavedState {
        private final int mSelectedYear;
        private final int mSelectedMonth;
        private final int mSelectedDay;
        private final long mMinDate;
        private final long mMaxDate;
        private final int mListPosition;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, SelectedDate selectedDate, long minDate, long maxDate, int listPosition) {
            super(superState);
            this.mSelectedYear = selectedDate.getStartDate().get(1);
            this.mSelectedMonth = selectedDate.getStartDate().get(2);
            this.mSelectedDay = selectedDate.getStartDate().get(5);
            this.mMinDate = minDate;
            this.mMaxDate = maxDate;
            this.mListPosition = listPosition;
        }

        private SavedState(Parcel in) {
            super(in);
            this.mSelectedYear = in.readInt();
            this.mSelectedMonth = in.readInt();
            this.mSelectedDay = in.readInt();
            this.mMinDate = in.readLong();
            this.mMaxDate = in.readLong();
            this.mListPosition = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mSelectedYear);
            dest.writeInt(this.mSelectedMonth);
            dest.writeInt(this.mSelectedDay);
            dest.writeLong(this.mMinDate);
            dest.writeLong(this.mMaxDate);
            dest.writeInt(this.mListPosition);
        }

        public int getSelectedDay() {
            return this.mSelectedDay;
        }

        public int getSelectedMonth() {
            return this.mSelectedMonth;
        }

        public int getSelectedYear() {
            return this.mSelectedYear;
        }

        public long getMinDate() {
            return this.mMinDate;
        }

        public long getMaxDate() {
            return this.mMaxDate;
        }

        public int getListPosition() {
            return this.mListPosition;
        }
    }

    public static interface DatePickerValidationCallback {
        public void onDatePickerValidationChanged(boolean var1);
    }
}

