/*
 * Decompiled with CFR 0.152.
 */
package com.kp.md.picker.datepicker;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ViewAnimator;
import java.util.ArrayList;

public class PickerViewAnimator
extends ViewAnimator {
    private final ArrayList<View> mMatchParentChildren = new ArrayList(1);

    public PickerViewAnimator(Context context) {
        super(context);
    }

    public PickerViewAnimator(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean measureMatchParentChildren = View.MeasureSpec.getMode((int)widthMeasureSpec) != 0x40000000 || View.MeasureSpec.getMode((int)heightMeasureSpec) != 0x40000000;
        int maxHeight = 0;
        int maxWidth = 0;
        int childState = 0;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            boolean matchHeight;
            View child = this.getChildAt(i);
            if (!this.getMeasureAllChildren() && child.getVisibility() == 8) continue;
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
            boolean matchWidth = lp.width == -1;
            boolean bl = matchHeight = lp.height == -1;
            if (measureMatchParentChildren && (matchWidth || matchHeight)) {
                this.mMatchParentChildren.add(child);
            }
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            int state = 0;
            if (measureMatchParentChildren && !matchWidth) {
                maxWidth = Math.max(maxWidth, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
                state |= child.getMeasuredWidthAndState() & 0xFF000000;
            }
            if (measureMatchParentChildren && !matchHeight) {
                maxHeight = Math.max(maxHeight, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
                state |= child.getMeasuredHeightAndState() >> 16 & 0xFFFFFF00;
            }
            childState = PickerViewAnimator.combineMeasuredStates((int)childState, (int)state);
        }
        maxWidth += this.getPaddingLeft() + this.getPaddingRight();
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        Drawable drawable = this.getForeground();
        if (drawable != null) {
            maxHeight = Math.max(maxHeight, drawable.getMinimumHeight());
            maxWidth = Math.max(maxWidth, drawable.getMinimumWidth());
        }
        this.setMeasuredDimension(PickerViewAnimator.resolveSizeAndState((int)maxWidth, (int)widthMeasureSpec, (int)childState), PickerViewAnimator.resolveSizeAndState((int)maxHeight, (int)heightMeasureSpec, (int)(childState << 16)));
        int matchCount = this.mMatchParentChildren.size();
        for (int i = 0; i < matchCount; ++i) {
            View child = this.mMatchParentChildren.get(i);
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int childWidthMeasureSpec = lp.width == -1 ? View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight() - lp.leftMargin - lp.rightMargin), (int)0x40000000) : PickerViewAnimator.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin), (int)lp.width);
            int childHeightMeasureSpec = lp.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom() - lp.topMargin - lp.bottomMargin), (int)0x40000000) : PickerViewAnimator.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin), (int)lp.height);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        }
        this.mMatchParentChildren.clear();
    }
}

