/*
 * Decompiled with CFR 0.152.
 */
package com.kp.md.picker.datepicker;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Layout;
import android.text.SpannableString;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.text.style.AlignmentSpan;
import android.text.style.RelativeSizeSpan;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.ViewAnimator;
import com.kp.md.picker.R;
import com.kp.md.picker.common.DateTimePatternHelper;
import com.kp.md.picker.datepicker.DayPickerView;
import com.kp.md.picker.datepicker.SelectedDate;
import com.kp.md.picker.datepicker.YearPickerView;
import com.kp.md.picker.utilities.AccessibilityUtils;
import com.kp.md.picker.utilities.MUtils;
import com.kp.md.picker.utilities.TextColorHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class MDatePicker
extends FrameLayout {
    private static final String TAG = MDatePicker.class.getSimpleName();
    private static final int UNINITIALIZED = -1;
    private static final int VIEW_MONTH_DAY = 0;
    private static final int VIEW_YEAR = 1;
    private static final int RANGE_ACTIVATED_NONE = 0;
    private static final int RANGE_ACTIVATED_START = 1;
    private static final int RANGE_ACTIVATED_END = 2;
    private static final int DEFAULT_START_YEAR = 1900;
    private static final int DEFAULT_END_YEAR = 2100;
    private Context mContext;
    private SimpleDateFormat mYearFormat;
    private SimpleDateFormat mMonthDayFormat;
    private ViewGroup mContainer;
    private LinearLayout llHeaderDateSingleCont;
    private TextView mHeaderYear;
    private TextView mHeaderMonthDay;
    private LinearLayout llHeaderDateRangeCont;
    private TextView tvHeaderDateStart;
    private TextView tvHeaderDateEnd;
    private ImageView ivHeaderDateReset;
    private ViewAnimator mAnimator;
    private DayPickerView mDayPickerView;
    private YearPickerView mYearPickerView;
    private String mSelectDay;
    private String mSelectYear;
    private OnDateChangedListener mDateChangedListener;
    private int mCurrentView = -1;
    private SelectedDate mCurrentDate;
    private Calendar mTempDate;
    private Calendar mMinDate;
    private Calendar mMaxDate;
    private int mFirstDayOfWeek;
    private Locale mCurrentLocale;
    private DatePickerValidationCallback mValidationCallback;
    private int mCurrentlyActivatedRangeItem = 0;
    private boolean mIsInLandscapeMode;
    private final DayPickerView.ProxyDaySelectionEventListener mProxyDaySelectionEventListener = new DayPickerView.ProxyDaySelectionEventListener(){

        @Override
        public void onDaySelected(DayPickerView view, Calendar day) {
            boolean goToPosition = true;
            if (MDatePicker.this.llHeaderDateRangeCont.getVisibility() == 0) {
                if (MDatePicker.this.tvHeaderDateStart.isActivated()) {
                    if (SelectedDate.compareDates(day, MDatePicker.this.mCurrentDate.getEndDate()) > 0) {
                        MDatePicker.this.mCurrentDate = new SelectedDate(day);
                    } else {
                        goToPosition = false;
                        MDatePicker.this.mCurrentDate = new SelectedDate(day, MDatePicker.this.mCurrentDate.getEndDate());
                    }
                } else if (MDatePicker.this.tvHeaderDateEnd.isActivated()) {
                    if (SelectedDate.compareDates(day, MDatePicker.this.mCurrentDate.getStartDate()) < 0) {
                        MDatePicker.this.mCurrentDate = new SelectedDate(day);
                    } else {
                        goToPosition = false;
                        MDatePicker.this.mCurrentDate = new SelectedDate(MDatePicker.this.mCurrentDate.getStartDate(), day);
                    }
                }
            } else {
                MDatePicker.this.mCurrentDate = new SelectedDate(day);
            }
            MDatePicker.this.onDateChanged(true, false, goToPosition);
        }

        @Override
        public void onDateRangeSelectionStarted(@NonNull SelectedDate selectedDate) {
            MDatePicker.this.mCurrentDate = new SelectedDate(selectedDate);
            MDatePicker.this.onDateChanged(false, false, false);
        }

        @Override
        public void onDateRangeSelectionEnded(@Nullable SelectedDate selectedDate) {
            if (selectedDate != null) {
                MDatePicker.this.mCurrentDate = new SelectedDate(selectedDate);
                MDatePicker.this.onDateChanged(false, false, false);
            }
        }

        @Override
        public void onDateRangeSelectionUpdated(@NonNull SelectedDate selectedDate) {
            MDatePicker.this.mCurrentDate = new SelectedDate(selectedDate);
            MDatePicker.this.onDateChanged(false, false, false);
        }
    };
    private final YearPickerView.OnYearSelectedListener mOnYearSelectedListener = new YearPickerView.OnYearSelectedListener(){

        @Override
        public void onYearChanged(YearPickerView view, int year) {
            int month;
            int daysInMonth;
            int day = MDatePicker.this.mCurrentDate.getStartDate().get(5);
            if (day > (daysInMonth = MUtils.getDaysInMonth(month = MDatePicker.this.mCurrentDate.getStartDate().get(2), year))) {
                MDatePicker.this.mCurrentDate.set(5, daysInMonth);
            }
            MDatePicker.this.mCurrentDate.set(1, year);
            MDatePicker.this.onDateChanged(true, true, true);
            MDatePicker.this.setCurrentView(0);
        }
    };
    private final View.OnClickListener mOnHeaderClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            MUtils.vibrateForDatePicker((View)MDatePicker.this);
            if (v.getId() == R.id.date_picker_header_year) {
                MDatePicker.this.setCurrentView(1);
            } else if (v.getId() == R.id.date_picker_header_date) {
                MDatePicker.this.setCurrentView(0);
            } else if (v.getId() == R.id.tv_header_date_start) {
                MDatePicker.this.mCurrentlyActivatedRangeItem = 1;
                MDatePicker.this.tvHeaderDateStart.setActivated(true);
                MDatePicker.this.tvHeaderDateEnd.setActivated(false);
            } else if (v.getId() == R.id.tv_header_date_end) {
                MDatePicker.this.mCurrentlyActivatedRangeItem = 2;
                MDatePicker.this.tvHeaderDateStart.setActivated(false);
                MDatePicker.this.tvHeaderDateEnd.setActivated(true);
            } else if (v.getId() == R.id.iv_header_date_reset) {
                MDatePicker.this.mCurrentDate = new SelectedDate(MDatePicker.this.mCurrentDate.getStartDate());
                MDatePicker.this.onDateChanged(true, false, true);
            }
        }
    };

    public MDatePicker(Context context) {
        this(context, null);
    }

    public MDatePicker(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.spDatePickerStyle);
    }

    public MDatePicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initializeLayout(attrs, defStyleAttr, R.style.MDatePickerStyle);
    }

    @TargetApi(value=21)
    public MDatePicker(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initializeLayout(attrs, defStyleAttr, defStyleRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLayout(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        long maxDateMillis;
        int pressedStateBgColor;
        int iconColor;
        this.mContext = this.getContext();
        this.mIsInLandscapeMode = this.mContext.getResources().getConfiguration().orientation == 2;
        this.setCurrentLocale(Locale.getDefault());
        this.mCurrentDate = new SelectedDate(Calendar.getInstance(this.mCurrentLocale));
        this.mTempDate = Calendar.getInstance(this.mCurrentLocale);
        this.mMinDate = Calendar.getInstance(this.mCurrentLocale);
        this.mMaxDate = Calendar.getInstance(this.mCurrentLocale);
        this.mMinDate.set(1900, 0, 1);
        this.mMaxDate.set(2100, 11, 31);
        Resources res = this.getResources();
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.MDatePicker, defStyleAttr, defStyleRes);
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        int layoutResourceId = R.layout.date_picker_layout;
        try {
            this.mContainer = (ViewGroup)inflater.inflate(layoutResourceId, (ViewGroup)this, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addView((View)this.mContainer);
        ViewGroup header = (ViewGroup)this.mContainer.findViewById(R.id.date_picker_header);
        this.llHeaderDateSingleCont = (LinearLayout)header.findViewById(R.id.ll_header_date_single_cont);
        this.mHeaderYear = (TextView)header.findViewById(R.id.date_picker_header_year);
        this.mHeaderYear.setOnClickListener(this.mOnHeaderClickListener);
        this.mHeaderMonthDay = (TextView)header.findViewById(R.id.date_picker_header_date);
        this.mHeaderMonthDay.setOnClickListener(this.mOnHeaderClickListener);
        this.llHeaderDateRangeCont = (LinearLayout)header.findViewById(R.id.ll_header_date_range_cont);
        this.tvHeaderDateStart = (TextView)header.findViewById(R.id.tv_header_date_start);
        this.tvHeaderDateStart.setOnClickListener(this.mOnHeaderClickListener);
        this.tvHeaderDateEnd = (TextView)header.findViewById(R.id.tv_header_date_end);
        this.tvHeaderDateEnd.setOnClickListener(this.mOnHeaderClickListener);
        this.ivHeaderDateReset = (ImageView)header.findViewById(R.id.iv_header_date_reset);
        this.ivHeaderDateReset.setOnClickListener(this.mOnHeaderClickListener);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(R.styleable.MPicker);
        try {
            iconColor = typedArray.getColor(R.styleable.MPicker_spOverflowIconColor, MUtils.COLOR_TEXT_PRIMARY_INVERSE);
            pressedStateBgColor = typedArray.getColor(R.styleable.MPicker_spOverflowIconPressedBgColor, MUtils.COLOR_TEXT_PRIMARY);
        }
        finally {
            typedArray.recycle();
        }
        MUtils.setImageTintList(this.ivHeaderDateReset, ColorStateList.valueOf((int)iconColor));
        MUtils.setViewBackground((View)this.ivHeaderDateReset, MUtils.createOverflowButtonBg(pressedStateBgColor));
        ColorStateList headerTextColor = a.getColorStateList(R.styleable.MDatePicker_spHeaderTextColor);
        if (headerTextColor == null) {
            headerTextColor = TextColorHelper.resolveMaterialHeaderTextColor();
        }
        if (headerTextColor != null) {
            this.mHeaderYear.setTextColor(headerTextColor);
            this.mHeaderMonthDay.setTextColor(headerTextColor);
        }
        if (MUtils.isApi_22_OrHigher()) {
            if (a.hasValueOrEmpty(R.styleable.MDatePicker_spHeaderBackground)) {
                MUtils.setViewBackground((View)header, a.getDrawable(R.styleable.MDatePicker_spHeaderBackground));
            }
        } else if (a.hasValue(R.styleable.MDatePicker_spHeaderBackground)) {
            MUtils.setViewBackground((View)header, a.getDrawable(R.styleable.MDatePicker_spHeaderBackground));
        }
        int firstDayOfWeek = a.getInt(R.styleable.MDatePicker_spFirstDayOfWeek, this.mCurrentDate.getFirstDate().getFirstDayOfWeek());
        String minDate = a.getString(R.styleable.MDatePicker_spMinDate);
        String maxDate = a.getString(R.styleable.MDatePicker_spMaxDate);
        Calendar tempDate = Calendar.getInstance();
        if (!MUtils.parseDate(minDate, tempDate)) {
            tempDate.set(1900, 0, 1);
        }
        long minDateMillis = tempDate.getTimeInMillis();
        if (!MUtils.parseDate(maxDate, tempDate)) {
            tempDate.set(2100, 11, 31);
        }
        if ((maxDateMillis = tempDate.getTimeInMillis()) < minDateMillis) {
            throw new IllegalArgumentException("maxDate must be >= minDate");
        }
        long setDateMillis = MUtils.constrain(System.currentTimeMillis(), minDateMillis, maxDateMillis);
        this.mMinDate.setTimeInMillis(minDateMillis);
        this.mMaxDate.setTimeInMillis(maxDateMillis);
        this.mCurrentDate.setTimeInMillis(setDateMillis);
        a.recycle();
        this.mAnimator = (ViewAnimator)this.mContainer.findViewById(R.id.animator);
        this.mDayPickerView = (DayPickerView)this.mAnimator.findViewById(R.id.date_picker_day_picker);
        this.setFirstDayOfWeek(firstDayOfWeek);
        this.mDayPickerView.setMinDate(this.mMinDate.getTimeInMillis());
        this.mDayPickerView.setMaxDate(this.mMaxDate.getTimeInMillis());
        this.mDayPickerView.setDate(this.mCurrentDate);
        this.mDayPickerView.setProxyDaySelectionEventListener(this.mProxyDaySelectionEventListener);
        this.mYearPickerView = (YearPickerView)this.mAnimator.findViewById(R.id.date_picker_year_picker);
        this.mYearPickerView.setRange(this.mMinDate, this.mMaxDate);
        this.mYearPickerView.setOnYearSelectedListener(this.mOnYearSelectedListener);
        this.mSelectDay = res.getString(R.string.select_day);
        this.mSelectYear = res.getString(R.string.select_year);
        this.onLocaleChanged(this.mCurrentLocale);
        this.setCurrentView(0);
    }

    private void onLocaleChanged(Locale locale) {
        TextView headerYear = this.mHeaderYear;
        if (headerYear == null) {
            return;
        }
        String datePattern = MUtils.isApi_18_OrHigher() ? DateFormat.getBestDateTimePattern((Locale)locale, (String)"EMMMd") : DateTimePatternHelper.getBestDateTimePattern(locale, 0);
        this.mMonthDayFormat = new SimpleDateFormat(datePattern, locale);
        this.mYearFormat = new SimpleDateFormat("y", locale);
        this.onCurrentDateChanged(false);
    }

    private void onCurrentDateChanged(boolean announce) {
        if (this.mHeaderYear == null) {
            return;
        }
        String year = this.mYearFormat.format(this.mCurrentDate.getStartDate().getTime());
        this.mHeaderYear.setText((CharSequence)year);
        String monthDay = this.mMonthDayFormat.format(this.mCurrentDate.getStartDate().getTime());
        this.mHeaderMonthDay.setText((CharSequence)monthDay);
        String yearStrStart = this.mYearFormat.format(this.mCurrentDate.getStartDate().getTime());
        String monthDayStrStart = this.mMonthDayFormat.format(this.mCurrentDate.getStartDate().getTime());
        String dateStrStart = yearStrStart + "\n" + monthDayStrStart;
        String yearStrEnd = this.mYearFormat.format(this.mCurrentDate.getEndDate().getTime());
        String monthDayStrEnd = this.mMonthDayFormat.format(this.mCurrentDate.getEndDate().getTime());
        String dateStrEnd = yearStrEnd + "\n" + monthDayStrEnd;
        SpannableString spDateStart = new SpannableString((CharSequence)dateStrStart);
        spDateStart.setSpan((Object)new RelativeSizeSpan(0.7f), 0, yearStrStart.length(), 33);
        SpannableString spDateEnd = new SpannableString((CharSequence)dateStrEnd);
        spDateEnd.setSpan((Object)new RelativeSizeSpan(0.7f), 0, yearStrEnd.length(), 33);
        if (!this.mIsInLandscapeMode && !MUtils.isApi_17_OrHigher()) {
            spDateEnd.setSpan((Object)new AlignmentSpan.Standard(Layout.Alignment.ALIGN_OPPOSITE), 0, dateStrEnd.length(), 33);
        }
        this.tvHeaderDateStart.setText((CharSequence)spDateStart);
        this.tvHeaderDateEnd.setText((CharSequence)spDateEnd);
        if (announce) {
            long millis = this.mCurrentDate.getStartDate().getTimeInMillis();
            int flags = 20;
            String fullDateText = DateUtils.formatDateTime((Context)this.mContext, (long)millis, (int)20);
            AccessibilityUtils.makeAnnouncement((View)this.mAnimator, fullDateText);
        }
    }

    private void setCurrentView(int viewIndex) {
        switch (viewIndex) {
            case 0: {
                this.mDayPickerView.setDate(this.mCurrentDate);
                if (this.mCurrentDate.getType() == SelectedDate.Type.SINGLE) {
                    this.switchToSingleDateView();
                } else if (this.mCurrentDate.getType() == SelectedDate.Type.RANGE) {
                    this.switchToDateRangeView();
                }
                if (this.mCurrentView != viewIndex) {
                    if (this.mAnimator.getDisplayedChild() != 0) {
                        this.mAnimator.setDisplayedChild(0);
                    }
                    this.mCurrentView = viewIndex;
                }
                AccessibilityUtils.makeAnnouncement((View)this.mAnimator, this.mSelectDay);
                break;
            }
            case 1: {
                if (this.mCurrentView != viewIndex) {
                    this.mHeaderMonthDay.setActivated(false);
                    this.mHeaderYear.setActivated(true);
                    this.mAnimator.setDisplayedChild(1);
                    this.mCurrentView = viewIndex;
                }
                AccessibilityUtils.makeAnnouncement((View)this.mAnimator, this.mSelectYear);
            }
        }
    }

    public void init(SelectedDate selectedDate, boolean canPickRange, OnDateChangedListener callback) {
        this.mCurrentDate = new SelectedDate(selectedDate);
        this.mDayPickerView.setCanPickRange(canPickRange);
        this.mDateChangedListener = callback;
        this.onDateChanged(false, false, true);
    }

    public void updateDate(int year, int month, int dayOfMonth) {
        this.mCurrentDate.set(1, year);
        this.mCurrentDate.set(2, month);
        this.mCurrentDate.set(5, dayOfMonth);
        this.onDateChanged(false, true, true);
    }

    private void onDateChanged(boolean fromUser, boolean callbackToClient, boolean goToPosition) {
        int year = this.mCurrentDate.getStartDate().get(1);
        if (callbackToClient && this.mDateChangedListener != null) {
            this.mDateChangedListener.onDateChanged(this, this.mCurrentDate);
        }
        this.updateHeaderViews();
        this.mDayPickerView.setDate(new SelectedDate(this.mCurrentDate), false, goToPosition);
        if (this.mCurrentDate.getType() == SelectedDate.Type.SINGLE) {
            this.mYearPickerView.setYear(year);
        }
        this.onCurrentDateChanged(fromUser);
        if (fromUser) {
            MUtils.vibrateForDatePicker((View)this);
        }
    }

    private void updateHeaderViews() {
        if (this.mCurrentDate.getType() == SelectedDate.Type.SINGLE) {
            this.switchToSingleDateView();
        } else if (this.mCurrentDate.getType() == SelectedDate.Type.RANGE) {
            this.switchToDateRangeView();
        }
    }

    private void switchToSingleDateView() {
        this.mCurrentlyActivatedRangeItem = 0;
        this.ivHeaderDateReset.setVisibility(8);
        this.llHeaderDateRangeCont.setVisibility(4);
        this.llHeaderDateSingleCont.setVisibility(0);
        this.mHeaderMonthDay.setActivated(true);
        this.mHeaderYear.setActivated(false);
    }

    private void switchToDateRangeView() {
        if (this.mCurrentlyActivatedRangeItem == 0) {
            this.mCurrentlyActivatedRangeItem = 1;
        }
        this.llHeaderDateSingleCont.setVisibility(4);
        this.ivHeaderDateReset.setVisibility(0);
        this.llHeaderDateRangeCont.setVisibility(0);
        this.tvHeaderDateStart.setActivated(this.mCurrentlyActivatedRangeItem == 1);
        this.tvHeaderDateEnd.setActivated(this.mCurrentlyActivatedRangeItem == 2);
    }

    public SelectedDate getSelectedDate() {
        return new SelectedDate(this.mCurrentDate);
    }

    public long getSelectedDateInMillis() {
        return this.mCurrentDate.getStartDate().getTimeInMillis();
    }

    public void setMinDate(long minDate) {
        this.mTempDate.setTimeInMillis(minDate);
        if (this.mTempDate.get(1) == this.mMinDate.get(1) && this.mTempDate.get(6) != this.mMinDate.get(6)) {
            return;
        }
        if (this.mCurrentDate.getStartDate().before(this.mTempDate)) {
            this.mCurrentDate.getStartDate().setTimeInMillis(minDate);
            this.onDateChanged(false, true, true);
        }
        this.mMinDate.setTimeInMillis(minDate);
        this.mDayPickerView.setMinDate(minDate);
        this.mYearPickerView.setRange(this.mMinDate, this.mMaxDate);
    }

    public Calendar getMinDate() {
        return this.mMinDate;
    }

    public void setMaxDate(long maxDate) {
        this.mTempDate.setTimeInMillis(maxDate);
        if (this.mTempDate.get(1) == this.mMaxDate.get(1) && this.mTempDate.get(6) != this.mMaxDate.get(6)) {
            return;
        }
        if (this.mCurrentDate.getEndDate().after(this.mTempDate)) {
            this.mCurrentDate.getEndDate().setTimeInMillis(maxDate);
            this.onDateChanged(false, true, true);
        }
        this.mMaxDate.setTimeInMillis(maxDate);
        this.mDayPickerView.setMaxDate(maxDate);
        this.mYearPickerView.setRange(this.mMinDate, this.mMaxDate);
    }

    public Calendar getMaxDate() {
        return this.mMaxDate;
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        if (firstDayOfWeek < 1 || firstDayOfWeek > 7) {
            firstDayOfWeek = this.mCurrentDate.getFirstDate().getFirstDayOfWeek();
        }
        this.mFirstDayOfWeek = firstDayOfWeek;
        this.mDayPickerView.setFirstDayOfWeek(firstDayOfWeek);
    }

    public int getFirstDayOfWeek() {
        return this.mFirstDayOfWeek;
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled() == enabled) {
            return;
        }
        this.mContainer.setEnabled(enabled);
        this.mDayPickerView.setEnabled(enabled);
        this.mYearPickerView.setEnabled(enabled);
        this.mHeaderYear.setEnabled(enabled);
        this.mHeaderMonthDay.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.mContainer.isEnabled();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        this.setCurrentLocale(newConfig.locale);
    }

    private void setCurrentLocale(Locale locale) {
        if (!locale.equals(this.mCurrentLocale)) {
            this.mCurrentLocale = locale;
            this.onLocaleChanged(locale);
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        int listPosition = -1;
        int listPositionOffset = -1;
        if (this.mCurrentView == 0) {
            listPosition = this.mDayPickerView.getMostVisiblePosition();
        } else if (this.mCurrentView == 1) {
            listPosition = this.mYearPickerView.getFirstVisiblePosition();
            listPositionOffset = this.mYearPickerView.getFirstPositionOffset();
        }
        return new SavedState(superState, this.mCurrentDate, this.mMinDate.getTimeInMillis(), this.mMaxDate.getTimeInMillis(), this.mCurrentView, listPosition, listPositionOffset, this.mCurrentlyActivatedRangeItem);
    }

    @SuppressLint(value={"NewApi"})
    public void onRestoreInstanceState(Parcelable state) {
        View.BaseSavedState bss = (View.BaseSavedState)state;
        super.onRestoreInstanceState(bss.getSuperState());
        SavedState ss = (SavedState)bss;
        Calendar startDate = Calendar.getInstance(this.mCurrentLocale);
        Calendar endDate = Calendar.getInstance(this.mCurrentLocale);
        startDate.set(ss.getSelectedYearStart(), ss.getSelectedMonthStart(), ss.getSelectedDayStart());
        endDate.set(ss.getSelectedYearEnd(), ss.getSelectedMonthEnd(), ss.getSelectedDayEnd());
        this.mCurrentDate.setFirstDate(startDate);
        this.mCurrentDate.setSecondDate(endDate);
        int currentView = ss.getCurrentView();
        this.mMinDate.setTimeInMillis(ss.getMinDate());
        this.mMaxDate.setTimeInMillis(ss.getMaxDate());
        this.mCurrentlyActivatedRangeItem = ss.getCurrentlyActivatedRangeItem();
        this.onCurrentDateChanged(false);
        this.setCurrentView(currentView);
        int listPosition = ss.getListPosition();
        if (listPosition != -1) {
            if (currentView == 0) {
                this.mDayPickerView.setPosition(listPosition);
            } else if (currentView == 1) {
                int listPositionOffset = ss.getListPositionOffset();
                this.mYearPickerView.setSelectionFromTop(listPosition, listPositionOffset);
            }
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        super.onPopulateAccessibilityEvent(event);
        event.getText().add(this.mCurrentDate.getStartDate().getTime().toString());
    }

    public CharSequence getAccessibilityClassName() {
        return MDatePicker.class.getName();
    }

    public void setValidationCallback(DatePickerValidationCallback callback) {
        this.mValidationCallback = callback;
    }

    protected void onValidationChanged(boolean valid) {
        if (this.mValidationCallback != null) {
            this.mValidationCallback.onDatePickerValidationChanged(valid);
        }
    }

    public static interface OnDateChangedListener {
        public void onDateChanged(MDatePicker var1, SelectedDate var2);
    }

    private static class SavedState
    extends View.BaseSavedState {
        private final int mSelectedYearStart;
        private final int mSelectedMonthStart;
        private final int mSelectedDayStart;
        private final int mSelectedYearEnd;
        private final int mSelectedMonthEnd;
        private final int mSelectedDayEnd;
        private final long mMinDate;
        private final long mMaxDate;
        private final int mCurrentView;
        private final int mListPosition;
        private final int mListPositionOffset;
        private final int ssCurrentlyActivatedRangeItem;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, SelectedDate selectedDate, long minDate, long maxDate, int currentView, int listPosition, int listPositionOffset, int currentlyActivatedRangeItem) {
            super(superState);
            this.mSelectedYearStart = selectedDate.getStartDate().get(1);
            this.mSelectedMonthStart = selectedDate.getStartDate().get(2);
            this.mSelectedDayStart = selectedDate.getStartDate().get(5);
            this.mSelectedYearEnd = selectedDate.getEndDate().get(1);
            this.mSelectedMonthEnd = selectedDate.getEndDate().get(2);
            this.mSelectedDayEnd = selectedDate.getEndDate().get(5);
            this.mMinDate = minDate;
            this.mMaxDate = maxDate;
            this.mCurrentView = currentView;
            this.mListPosition = listPosition;
            this.mListPositionOffset = listPositionOffset;
            this.ssCurrentlyActivatedRangeItem = currentlyActivatedRangeItem;
        }

        private SavedState(Parcel in) {
            super(in);
            this.mSelectedYearStart = in.readInt();
            this.mSelectedMonthStart = in.readInt();
            this.mSelectedDayStart = in.readInt();
            this.mSelectedYearEnd = in.readInt();
            this.mSelectedMonthEnd = in.readInt();
            this.mSelectedDayEnd = in.readInt();
            this.mMinDate = in.readLong();
            this.mMaxDate = in.readLong();
            this.mCurrentView = in.readInt();
            this.mListPosition = in.readInt();
            this.mListPositionOffset = in.readInt();
            this.ssCurrentlyActivatedRangeItem = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mSelectedYearStart);
            dest.writeInt(this.mSelectedMonthStart);
            dest.writeInt(this.mSelectedDayStart);
            dest.writeInt(this.mSelectedYearEnd);
            dest.writeInt(this.mSelectedMonthEnd);
            dest.writeInt(this.mSelectedDayEnd);
            dest.writeLong(this.mMinDate);
            dest.writeLong(this.mMaxDate);
            dest.writeInt(this.mCurrentView);
            dest.writeInt(this.mListPosition);
            dest.writeInt(this.mListPositionOffset);
            dest.writeInt(this.ssCurrentlyActivatedRangeItem);
        }

        public int getSelectedDayStart() {
            return this.mSelectedDayStart;
        }

        public int getSelectedMonthStart() {
            return this.mSelectedMonthStart;
        }

        public int getSelectedYearStart() {
            return this.mSelectedYearStart;
        }

        public int getSelectedDayEnd() {
            return this.mSelectedDayEnd;
        }

        public int getSelectedMonthEnd() {
            return this.mSelectedMonthEnd;
        }

        public int getSelectedYearEnd() {
            return this.mSelectedYearEnd;
        }

        public long getMinDate() {
            return this.mMinDate;
        }

        public long getMaxDate() {
            return this.mMaxDate;
        }

        public int getCurrentView() {
            return this.mCurrentView;
        }

        public int getListPosition() {
            return this.mListPosition;
        }

        public int getListPositionOffset() {
            return this.mListPositionOffset;
        }

        public int getCurrentlyActivatedRangeItem() {
            return this.ssCurrentlyActivatedRangeItem;
        }
    }

    public static interface DatePickerValidationCallback {
        public void onDatePickerValidationChanged(boolean var1);
    }
}

