/*
 * Decompiled with CFR 0.152.
 */
package com.kp.md.picker.datepicker;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import com.kp.md.picker.R;
import com.kp.md.picker.datepicker.DayPickerPagerAdapter;
import com.kp.md.picker.datepicker.SelectedDate;
import com.kp.md.picker.utilities.MUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

class DayPickerViewPager
extends ViewPager {
    private static final String TAG = DayPickerViewPager.class.getSimpleName();
    private final int MONTH_SCROLL_THRESHOLD;
    private final int TOUCH_SLOP_SQUARED;
    private final ArrayList<View> mMatchParentChildren = new ArrayList(1);
    private Method mPopulateMethod;
    private boolean mAlreadyTriedAccessingMethod;
    private boolean mCanPickRange;
    private DayPickerPagerAdapter mDayPickerPagerAdapter;
    private float mInitialDownX;
    private float mInitialDownY;
    private boolean mIsLongPressed = false;
    private CheckForLongPress mCheckForLongPress;
    private SelectedDate mTempSelectedDate;
    private static final int SCROLLING_LEFT = -1;
    private static final int NOT_SCROLLING = 0;
    private static final int SCROLLING_RIGHT = 1;
    private ScrollerRunnable mScrollerRunnable;
    private int mScrollingDirection = 0;

    public DayPickerViewPager(Context context) {
        this(context, null);
    }

    public DayPickerViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.TOUCH_SLOP_SQUARED = ViewConfiguration.get((Context)context).getScaledTouchSlop() * ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.MONTH_SCROLL_THRESHOLD = context.getResources().getDimensionPixelSize(R.dimen.sp_month_scroll_threshold);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Drawable drawable;
        ViewPager.LayoutParams lp;
        View child;
        int i;
        this.callPopulate();
        int count = this.getChildCount();
        boolean measureMatchParentChildren = View.MeasureSpec.getMode((int)widthMeasureSpec) != 0x40000000 || View.MeasureSpec.getMode((int)heightMeasureSpec) != 0x40000000;
        int maxHeight = 0;
        int maxWidth = 0;
        int childState = 0;
        for (i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            lp = (ViewPager.LayoutParams)child.getLayoutParams();
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth());
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight());
            childState = DayPickerViewPager.combineMeasuredStates((int)childState, (int)child.getMeasuredState());
            if (!measureMatchParentChildren || lp.width != -1 && lp.height != -1) continue;
            this.mMatchParentChildren.add(child);
        }
        maxWidth += this.getPaddingLeft() + this.getPaddingRight();
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        if (MUtils.isApi_23_OrHigher() && (drawable = this.getForeground()) != null) {
            maxHeight = Math.max(maxHeight, drawable.getMinimumHeight());
            maxWidth = Math.max(maxWidth, drawable.getMinimumWidth());
        }
        this.setMeasuredDimension(DayPickerViewPager.resolveSizeAndState((int)maxWidth, (int)widthMeasureSpec, (int)childState), DayPickerViewPager.resolveSizeAndState((int)maxHeight, (int)heightMeasureSpec, (int)(childState << 16)));
        count = this.mMatchParentChildren.size();
        if (count > 1) {
            for (i = 0; i < count; ++i) {
                child = this.mMatchParentChildren.get(i);
                lp = (ViewPager.LayoutParams)child.getLayoutParams();
                int childWidthMeasureSpec = lp.width == -1 ? View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight()), (int)0x40000000) : DayPickerViewPager.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight()), (int)lp.width);
                int childHeightMeasureSpec = lp.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom()), (int)0x40000000) : DayPickerViewPager.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom()), (int)lp.height);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
        this.mMatchParentChildren.clear();
    }

    private void initializePopulateMethod() {
        try {
            this.mPopulateMethod = ViewPager.class.getDeclaredMethod("populate", null);
            this.mPopulateMethod.setAccessible(true);
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
        }
        this.mAlreadyTriedAccessingMethod = true;
    }

    private void callPopulate() {
        if (!this.mAlreadyTriedAccessingMethod) {
            this.initializePopulateMethod();
        }
        if (this.mPopulateMethod != null) {
            try {
                this.mPopulateMethod.invoke((Object)this, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            Log.e((String)TAG, (String)"Could not call `ViewPager.populate()`");
        }
    }

    protected void setCanPickRange(boolean canPickRange) {
        this.mCanPickRange = canPickRange;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.mCanPickRange) {
            return super.onInterceptTouchEvent(ev);
        }
        if (ev.getAction() == 0) {
            this.mInitialDownX = ev.getX();
            this.mInitialDownY = ev.getY();
            if (this.mCheckForLongPress == null) {
                this.mCheckForLongPress = new CheckForLongPress();
            }
            this.postDelayed(this.mCheckForLongPress, ViewConfiguration.getLongPressTimeout());
        } else if (ev.getAction() == 1 || ev.getAction() == 3) {
            if (this.mCheckForLongPress != null) {
                this.removeCallbacks(this.mCheckForLongPress);
            }
            this.mIsLongPressed = false;
            this.mInitialDownX = -1.0f;
            this.mInitialDownY = -1.0f;
        } else if (ev.getAction() == 2 && !this.isStillALongPress((int)ev.getX(), (int)ev.getY()) && this.mCheckForLongPress != null) {
            this.removeCallbacks(this.mCheckForLongPress);
        }
        return this.mIsLongPressed || super.onInterceptTouchEvent(ev);
    }

    private boolean isStillALongPress(int x, int y) {
        return ((float)x - this.mInitialDownX) * ((float)x - this.mInitialDownX) + ((float)y - this.mInitialDownY) * ((float)y - this.mInitialDownY) <= (float)this.TOUCH_SLOP_SQUARED;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.mCanPickRange) {
            return super.onTouchEvent(ev);
        }
        if (this.mCheckForLongPress != null) {
            this.removeCallbacks(this.mCheckForLongPress);
        }
        if (this.mIsLongPressed && ev.getAction() == 1 || ev.getAction() == 3) {
            if (ev.getAction() == 1 && this.mDayPickerPagerAdapter != null) {
                this.mTempSelectedDate = this.mDayPickerPagerAdapter.resolveEndDateForRange((int)ev.getX(), (int)ev.getY(), this.getCurrentItem(), false);
                this.mDayPickerPagerAdapter.onDateRangeSelectionEnded(this.mTempSelectedDate);
            }
            this.mIsLongPressed = false;
            this.mInitialDownX = -1.0f;
            this.mInitialDownY = -1.0f;
            this.mScrollingDirection = 0;
            if (this.mScrollerRunnable != null) {
                this.removeCallbacks(this.mScrollerRunnable);
            }
        } else if (this.mIsLongPressed && ev.getAction() == 0) {
            this.mScrollingDirection = 0;
        } else if (this.mIsLongPressed && ev.getAction() == 2) {
            boolean directionChanged;
            int direction = this.resolveDirectionForScroll(ev.getX());
            boolean bl = directionChanged = this.mScrollingDirection != direction;
            if (directionChanged && this.mScrollerRunnable != null) {
                this.removeCallbacks(this.mScrollerRunnable);
            }
            if (this.mScrollerRunnable == null) {
                this.mScrollerRunnable = new ScrollerRunnable();
            }
            this.mScrollingDirection = direction;
            if (this.mScrollingDirection == 0) {
                if (this.mDayPickerPagerAdapter != null) {
                    this.mTempSelectedDate = this.mDayPickerPagerAdapter.resolveEndDateForRange((int)ev.getX(), (int)ev.getY(), this.getCurrentItem(), true);
                    if (this.mTempSelectedDate != null) {
                        this.mDayPickerPagerAdapter.onDateRangeSelectionUpdated(this.mTempSelectedDate);
                    }
                }
            } else if (directionChanged) {
                this.post(this.mScrollerRunnable);
            }
        }
        return this.mIsLongPressed || super.onTouchEvent(ev);
    }

    private int resolveDirectionForScroll(float x) {
        if (x - (float)this.getLeft() < (float)this.MONTH_SCROLL_THRESHOLD) {
            return -1;
        }
        if ((float)this.getRight() - x < (float)this.MONTH_SCROLL_THRESHOLD) {
            return 1;
        }
        return 0;
    }

    public void setAdapter(PagerAdapter adapter) {
        super.setAdapter(adapter);
        if (adapter instanceof DayPickerPagerAdapter) {
            this.mDayPickerPagerAdapter = (DayPickerPagerAdapter)adapter;
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        super.onRestoreInstanceState(state);
    }

    private class ScrollerRunnable
    implements Runnable {
        private ScrollerRunnable() {
        }

        @Override
        public void run() {
            if (DayPickerViewPager.this.mScrollingDirection == 0) {
                return;
            }
            int direction = DayPickerViewPager.this.mScrollingDirection;
            boolean animate = true;
            DayPickerViewPager.this.setCurrentItem(DayPickerViewPager.this.getCurrentItem() + direction, true);
            DayPickerViewPager.this.postDelayed(this, 1000L);
        }
    }

    private class CheckForLongPress
    implements Runnable {
        private CheckForLongPress() {
        }

        @Override
        public void run() {
            if (DayPickerViewPager.this.mDayPickerPagerAdapter != null) {
                DayPickerViewPager.this.mTempSelectedDate = DayPickerViewPager.this.mDayPickerPagerAdapter.resolveStartDateForRange((int)DayPickerViewPager.this.mInitialDownX, (int)DayPickerViewPager.this.mInitialDownY, DayPickerViewPager.this.getCurrentItem());
                if (DayPickerViewPager.this.mTempSelectedDate != null) {
                    DayPickerViewPager.this.mIsLongPressed = true;
                    DayPickerViewPager.this.mDayPickerPagerAdapter.onDateRangeSelectionStarted(DayPickerViewPager.this.mTempSelectedDate);
                }
            }
        }
    }
}

