/*
 * Decompiled with CFR 0.152.
 */
package com.kp.md.picker.datepicker;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityManager;
import android.widget.ImageButton;
import android.widget.ImageView;
import com.kp.md.picker.R;
import com.kp.md.picker.datepicker.DayPickerPagerAdapter;
import com.kp.md.picker.datepicker.DayPickerViewPager;
import com.kp.md.picker.datepicker.SelectedDate;
import com.kp.md.picker.datepicker.SimpleMonthView;
import com.kp.md.picker.utilities.MUtils;
import java.util.Calendar;

class DayPickerView
extends ViewGroup {
    private static final String TAG = DayPickerView.class.getSimpleName();
    private static final int[] ATTRS_TEXT_COLOR = new int[]{16842904};
    private SelectedDate mSelectedDay = null;
    private final Calendar mMinDate = Calendar.getInstance();
    private final Calendar mMaxDate = Calendar.getInstance();
    private final AccessibilityManager mAccessibilityManager;
    private final DayPickerViewPager mViewPager;
    private final ImageButton mPrevButton;
    private final ImageButton mNextButton;
    private final DayPickerPagerAdapter mAdapter;
    private Calendar mTempCalendar;
    private ProxyDaySelectionEventListener mProxyDaySelectionEventListener;

    public DayPickerView(Context context) {
        this(context, null);
    }

    public DayPickerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.spDayPickerStyle);
    }

    public DayPickerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super((Context)MUtils.createThemeWrapper(context, R.attr.mPickerStyle, R.style.MPickerStyleLight, defStyleAttr, R.style.DayPickerViewStyle), attrs);
        int viewPagerIdToUse;
        int layoutIdToUse;
        context = this.getContext();
        this.mAccessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DayPickerView, defStyleAttr, R.style.DayPickerViewStyle);
        int monthTextAppearanceResId = a.getResourceId(R.styleable.DayPickerView_spMonthTextAppearance, R.style.SPMonthLabelTextAppearance);
        int dayOfWeekTextAppearanceResId = a.getResourceId(R.styleable.DayPickerView_spWeekDayTextAppearance, R.style.SPWeekDayLabelTextAppearance);
        int dayTextAppearanceResId = a.getResourceId(R.styleable.DayPickerView_spDateTextAppearance, R.style.SPDayTextAppearance);
        ColorStateList daySelectorColor = a.getColorStateList(R.styleable.DayPickerView_spDaySelectorColor);
        a.recycle();
        this.mAdapter = new DayPickerPagerAdapter(context, R.layout.date_picker_month_item, R.id.month_view);
        this.mAdapter.setMonthTextAppearance(monthTextAppearanceResId);
        this.mAdapter.setDayOfWeekTextAppearance(dayOfWeekTextAppearanceResId);
        this.mAdapter.setDayTextAppearance(dayTextAppearanceResId);
        this.mAdapter.setDaySelectorColor(daySelectorColor);
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        if (this.getTag() != null && this.getTag() instanceof String && this.getResources().getString(R.string.recurrence_end_date_picker_tag).equals(this.getTag())) {
            layoutIdToUse = R.layout.day_picker_content_redp;
            viewPagerIdToUse = R.id.redp_view_pager;
        } else {
            layoutIdToUse = R.layout.day_picker_content_sdp;
            viewPagerIdToUse = R.id.sdp_view_pager;
        }
        inflater.inflate(layoutIdToUse, (ViewGroup)this, true);
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                int direction;
                if (v == DayPickerView.this.mPrevButton) {
                    direction = -1;
                } else if (v == DayPickerView.this.mNextButton) {
                    direction = 1;
                } else {
                    return;
                }
                boolean animate = !DayPickerView.this.mAccessibilityManager.isEnabled();
                int nextItem = DayPickerView.this.mViewPager.getCurrentItem() + direction;
                DayPickerView.this.mViewPager.setCurrentItem(nextItem, animate);
            }
        };
        this.mPrevButton = (ImageButton)this.findViewById(R.id.prev);
        this.mPrevButton.setOnClickListener(onClickListener);
        this.mNextButton = (ImageButton)this.findViewById(R.id.next);
        this.mNextButton.setOnClickListener(onClickListener);
        ViewPager.OnPageChangeListener onPageChangedListener = new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                float alpha = Math.abs(0.5f - positionOffset) * 2.0f;
                DayPickerView.this.mPrevButton.setAlpha(alpha);
                DayPickerView.this.mNextButton.setAlpha(alpha);
            }

            public void onPageScrollStateChanged(int state) {
            }

            public void onPageSelected(int position) {
                DayPickerView.this.updateButtonVisibility(position);
            }
        };
        this.mViewPager = (DayPickerViewPager)this.findViewById(viewPagerIdToUse);
        this.mViewPager.setAdapter(this.mAdapter);
        this.mViewPager.addOnPageChangeListener(onPageChangedListener);
        if (monthTextAppearanceResId != 0) {
            TypedArray ta = context.obtainStyledAttributes(null, ATTRS_TEXT_COLOR, 0, monthTextAppearanceResId);
            ColorStateList monthColor = ta.getColorStateList(0);
            if (monthColor != null) {
                MUtils.setImageTintList((ImageView)this.mPrevButton, monthColor);
                MUtils.setImageTintList((ImageView)this.mNextButton, monthColor);
            }
            ta.recycle();
        }
        this.mAdapter.setDaySelectionEventListener(new DayPickerPagerAdapter.DaySelectionEventListener(){

            @Override
            public void onDaySelected(DayPickerPagerAdapter adapter, Calendar day) {
                if (DayPickerView.this.mProxyDaySelectionEventListener != null) {
                    DayPickerView.this.mProxyDaySelectionEventListener.onDaySelected(DayPickerView.this, day);
                }
            }

            @Override
            public void onDateRangeSelectionStarted(@NonNull SelectedDate selectedDate) {
                if (DayPickerView.this.mProxyDaySelectionEventListener != null) {
                    DayPickerView.this.mProxyDaySelectionEventListener.onDateRangeSelectionStarted(selectedDate);
                }
            }

            @Override
            public void onDateRangeSelectionEnded(@Nullable SelectedDate selectedDate) {
                if (DayPickerView.this.mProxyDaySelectionEventListener != null) {
                    DayPickerView.this.mProxyDaySelectionEventListener.onDateRangeSelectionEnded(selectedDate);
                }
            }

            @Override
            public void onDateRangeSelectionUpdated(@NonNull SelectedDate selectedDate) {
                if (DayPickerView.this.mProxyDaySelectionEventListener != null) {
                    DayPickerView.this.mProxyDaySelectionEventListener.onDateRangeSelectionUpdated(selectedDate);
                }
            }
        });
    }

    public void setCanPickRange(boolean canPickRange) {
        this.mViewPager.setCanPickRange(canPickRange);
    }

    private void updateButtonVisibility(int position) {
        boolean hasPrev = position > 0;
        boolean hasNext = position < this.mAdapter.getCount() - 1;
        this.mPrevButton.setVisibility(hasPrev ? 0 : 4);
        this.mNextButton.setVisibility(hasNext ? 0 : 4);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        DayPickerViewPager viewPager = this.mViewPager;
        this.measureChild((View)viewPager, widthMeasureSpec, heightMeasureSpec);
        int measuredWidthAndState = viewPager.getMeasuredWidthAndState();
        int measuredHeightAndState = viewPager.getMeasuredHeightAndState();
        this.setMeasuredDimension(measuredWidthAndState, measuredHeightAndState);
        int pagerWidth = viewPager.getMeasuredWidth();
        int pagerHeight = viewPager.getMeasuredHeight();
        int buttonWidthSpec = View.MeasureSpec.makeMeasureSpec((int)pagerWidth, (int)Integer.MIN_VALUE);
        int buttonHeightSpec = View.MeasureSpec.makeMeasureSpec((int)pagerHeight, (int)Integer.MIN_VALUE);
        this.mPrevButton.measure(buttonWidthSpec, buttonHeightSpec);
        this.mNextButton.measure(buttonWidthSpec, buttonHeightSpec);
    }

    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        this.requestLayout();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        ImageButton rightButton;
        ImageButton leftButton;
        if (MUtils.isLayoutRtlCompat((View)this)) {
            leftButton = this.mNextButton;
            rightButton = this.mPrevButton;
        } else {
            leftButton = this.mPrevButton;
            rightButton = this.mNextButton;
        }
        int width = right - left;
        int height = bottom - top;
        this.mViewPager.layout(0, 0, width, height);
        SimpleMonthView monthView = (SimpleMonthView)this.mViewPager.getChildAt(0).findViewById(R.id.month_view);
        int monthHeight = monthView.getMonthHeight();
        int cellWidth = monthView.getCellWidth();
        int leftDW = leftButton.getMeasuredWidth();
        int leftDH = leftButton.getMeasuredHeight();
        int leftIconTop = monthView.getPaddingTop() + (monthHeight - leftDH) / 2;
        int leftIconLeft = monthView.getPaddingLeft() + (cellWidth - leftDW) / 2;
        leftButton.layout(leftIconLeft, leftIconTop, leftIconLeft + leftDW, leftIconTop + leftDH);
        int rightDW = rightButton.getMeasuredWidth();
        int rightDH = rightButton.getMeasuredHeight();
        int rightIconTop = monthView.getPaddingTop() + (monthHeight - rightDH) / 2;
        int rightIconRight = width - monthView.getPaddingRight() - (cellWidth - rightDW) / 2;
        rightButton.layout(rightIconRight - rightDW, rightIconTop, rightIconRight, rightIconTop + rightDH);
    }

    public void setDayOfWeekTextAppearance(int resId) {
        this.mAdapter.setDayOfWeekTextAppearance(resId);
    }

    public int getDayOfWeekTextAppearance() {
        return this.mAdapter.getDayOfWeekTextAppearance();
    }

    public void setDayTextAppearance(int resId) {
        this.mAdapter.setDayTextAppearance(resId);
    }

    public int getDayTextAppearance() {
        return this.mAdapter.getDayTextAppearance();
    }

    public void setDate(SelectedDate date) {
        this.setDate(date, false);
    }

    public void setDate(SelectedDate date, boolean animate) {
        this.setDate(date, animate, true, true);
    }

    public void setDate(SelectedDate date, boolean animate, boolean goToPosition) {
        this.setDate(date, animate, true, goToPosition);
    }

    private void setDate(SelectedDate date, boolean animate, boolean setSelected, boolean goToPosition) {
        if (setSelected) {
            this.mSelectedDay = date;
        }
        int position = this.getPositionFromDay(this.mSelectedDay == null ? Calendar.getInstance().getTimeInMillis() : this.mSelectedDay.getStartDate().getTimeInMillis());
        if (goToPosition && position != this.mViewPager.getCurrentItem()) {
            this.mViewPager.setCurrentItem(position, animate);
        }
        this.mAdapter.setSelectedDay(new SelectedDate(this.mSelectedDay));
    }

    public SelectedDate getDate() {
        return this.mSelectedDay;
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.mAdapter.setFirstDayOfWeek(firstDayOfWeek);
    }

    public int getFirstDayOfWeek() {
        return this.mAdapter.getFirstDayOfWeek();
    }

    public void setMinDate(long timeInMillis) {
        this.mMinDate.setTimeInMillis(timeInMillis);
        this.onRangeChanged();
    }

    public long getMinDate() {
        return this.mMinDate.getTimeInMillis();
    }

    public void setMaxDate(long timeInMillis) {
        this.mMaxDate.setTimeInMillis(timeInMillis);
        this.onRangeChanged();
    }

    public long getMaxDate() {
        return this.mMaxDate.getTimeInMillis();
    }

    private void onRangeChanged() {
        this.mAdapter.setRange(this.mMinDate, this.mMaxDate);
        this.setDate(this.mSelectedDay, false, false, true);
        this.updateButtonVisibility(this.mViewPager.getCurrentItem());
    }

    public void setProxyDaySelectionEventListener(ProxyDaySelectionEventListener listener) {
        this.mProxyDaySelectionEventListener = listener;
    }

    private int getDiffMonths(Calendar start, Calendar end) {
        int diffYears = end.get(1) - start.get(1);
        return end.get(2) - start.get(2) + 12 * diffYears;
    }

    private int getPositionFromDay(long timeInMillis) {
        int diffMonthMax = this.getDiffMonths(this.mMinDate, this.mMaxDate);
        int diffMonth = this.getDiffMonths(this.mMinDate, this.getTempCalendarForTime(timeInMillis));
        return MUtils.constrain(diffMonth, 0, diffMonthMax);
    }

    private Calendar getTempCalendarForTime(long timeInMillis) {
        if (this.mTempCalendar == null) {
            this.mTempCalendar = Calendar.getInstance();
        }
        this.mTempCalendar.setTimeInMillis(timeInMillis);
        return this.mTempCalendar;
    }

    public int getMostVisiblePosition() {
        return this.mViewPager.getCurrentItem();
    }

    public void setPosition(int position) {
        this.mViewPager.setCurrentItem(position, false);
    }

    public static interface ProxyDaySelectionEventListener {
        public void onDaySelected(DayPickerView var1, Calendar var2);

        public void onDateRangeSelectionStarted(@NonNull SelectedDate var1);

        public void onDateRangeSelectionEnded(@Nullable SelectedDate var1);

        public void onDateRangeSelectionUpdated(@NonNull SelectedDate var1);
    }
}

