/*
 * Decompiled with CFR 0.152.
 */
package com.kp.md.picker.datepicker;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.kp.md.picker.R;
import com.kp.md.picker.datepicker.SelectedDate;
import com.kp.md.picker.datepicker.SimpleMonthView;
import com.kp.md.picker.utilities.MUtils;
import java.util.Calendar;

class DayPickerPagerAdapter
extends PagerAdapter {
    private static final String TAG = DayPickerPagerAdapter.class.getSimpleName();
    private static final int MONTHS_IN_YEAR = 12;
    private final Calendar mMinDate = Calendar.getInstance();
    private final Calendar mMaxDate = Calendar.getInstance();
    private final SparseArray<ViewHolder> mItems = new SparseArray();
    private final LayoutInflater mInflater;
    private final int mLayoutResId;
    private final int mCalendarViewId;
    private SelectedDate mSelectedDay = null;
    private int mMonthTextAppearance;
    private int mDayOfWeekTextAppearance;
    private int mDayTextAppearance;
    private ColorStateList mCalendarTextColor;
    private ColorStateList mDaySelectorColor;
    private final ColorStateList mDayHighlightColor;
    private DaySelectionEventListener mDaySelectionEventListener;
    private int mCount;
    private int mFirstDayOfWeek;
    private final SelectedDate mTempSelectedDay = new SelectedDate(Calendar.getInstance());
    private final SimpleMonthView.OnDayClickListener mOnDayClickListener = new SimpleMonthView.OnDayClickListener(){

        @Override
        public void onDayClick(SimpleMonthView view, Calendar day) {
            if (day != null && DayPickerPagerAdapter.this.mDaySelectionEventListener != null) {
                DayPickerPagerAdapter.this.mDaySelectionEventListener.onDaySelected(DayPickerPagerAdapter.this, day);
            }
        }
    };

    public DayPickerPagerAdapter(@NonNull Context context, @LayoutRes int layoutResId, @IdRes int calendarViewId) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.mLayoutResId = layoutResId;
        this.mCalendarViewId = calendarViewId;
        TypedArray ta = context.obtainStyledAttributes(new int[]{R.attr.colorControlHighlight});
        this.mDayHighlightColor = ta.getColorStateList(0);
        ta.recycle();
    }

    public void setRange(@NonNull Calendar min, @NonNull Calendar max) {
        this.mMinDate.setTimeInMillis(min.getTimeInMillis());
        this.mMaxDate.setTimeInMillis(max.getTimeInMillis());
        int diffYear = this.mMaxDate.get(1) - this.mMinDate.get(1);
        int diffMonth = this.mMaxDate.get(2) - this.mMinDate.get(2);
        this.mCount = diffMonth + 12 * diffYear + 1;
        this.notifyDataSetChanged();
    }

    public void setFirstDayOfWeek(int weekStart) {
        this.mFirstDayOfWeek = weekStart;
        int count = this.mItems.size();
        for (int i = 0; i < count; ++i) {
            SimpleMonthView monthView = ((ViewHolder)this.mItems.valueAt((int)i)).calendar;
            monthView.setFirstDayOfWeek(weekStart);
        }
    }

    public int getFirstDayOfWeek() {
        return this.mFirstDayOfWeek;
    }

    public void setSelectedDay(@Nullable SelectedDate day) {
        boolean shouldClearOldPosition;
        int[] oldPosition = this.getPositionsForDay(this.mSelectedDay);
        int[] newPosition = this.getPositionsForDay(day);
        boolean bl = shouldClearOldPosition = oldPosition != null;
        if (shouldClearOldPosition) {
            for (int i = oldPosition[0]; i <= oldPosition[oldPosition.length - 1]; ++i) {
                ViewHolder oldMonthView = (ViewHolder)this.mItems.get(i, null);
                if (oldMonthView == null) continue;
                oldMonthView.calendar.setSelectedDays(-1, -1, SelectedDate.Type.SINGLE);
            }
        }
        if (newPosition != null) {
            if (newPosition.length == 1) {
                ViewHolder newMonthView = (ViewHolder)this.mItems.get(newPosition[0], null);
                if (newMonthView != null) {
                    int dayOfMonth = day.getFirstDate().get(5);
                    newMonthView.calendar.setSelectedDays(dayOfMonth, dayOfMonth, SelectedDate.Type.SINGLE);
                }
            } else if (newPosition.length == 2) {
                boolean rangeIsInSameMonth;
                boolean bl2 = rangeIsInSameMonth = newPosition[0] == newPosition[1];
                if (rangeIsInSameMonth) {
                    ViewHolder newMonthView = (ViewHolder)this.mItems.get(newPosition[0], null);
                    if (newMonthView != null) {
                        int startDayOfMonth = day.getFirstDate().get(5);
                        int endDayOfMonth = day.getSecondDate().get(5);
                        newMonthView.calendar.setSelectedDays(startDayOfMonth, endDayOfMonth, SelectedDate.Type.RANGE);
                    }
                } else {
                    ViewHolder newMonthViewStart = (ViewHolder)this.mItems.get(newPosition[0], null);
                    if (newMonthViewStart != null) {
                        int startDayOfMonth = day.getFirstDate().get(5);
                        int endDayOfMonth = day.getFirstDate().getActualMaximum(5);
                        newMonthViewStart.calendar.setSelectedDays(startDayOfMonth, endDayOfMonth, SelectedDate.Type.RANGE);
                    }
                    for (int i = newPosition[0] + 1; i < newPosition[1]; ++i) {
                        ViewHolder newMonthView = (ViewHolder)this.mItems.get(i, null);
                        if (newMonthView == null) continue;
                        newMonthView.calendar.selectAllDays();
                    }
                    ViewHolder newMonthViewEnd = (ViewHolder)this.mItems.get(newPosition[1], null);
                    if (newMonthViewEnd != null) {
                        int startDayOfMonth = day.getSecondDate().getMinimum(5);
                        int endDayOfMonth = day.getSecondDate().get(5);
                        newMonthViewEnd.calendar.setSelectedDays(startDayOfMonth, endDayOfMonth, SelectedDate.Type.RANGE);
                    }
                }
            }
        }
        this.mSelectedDay = day;
    }

    public void setDaySelectionEventListener(DaySelectionEventListener listener) {
        this.mDaySelectionEventListener = listener;
    }

    void setCalendarTextColor(ColorStateList calendarTextColor) {
        this.mCalendarTextColor = calendarTextColor;
    }

    void setDaySelectorColor(ColorStateList selectorColor) {
        this.mDaySelectorColor = selectorColor;
    }

    void setMonthTextAppearance(int resId) {
        this.mMonthTextAppearance = resId;
    }

    void setDayOfWeekTextAppearance(int resId) {
        this.mDayOfWeekTextAppearance = resId;
    }

    int getDayOfWeekTextAppearance() {
        return this.mDayOfWeekTextAppearance;
    }

    void setDayTextAppearance(int resId) {
        this.mDayTextAppearance = resId;
    }

    int getDayTextAppearance() {
        return this.mDayTextAppearance;
    }

    public int getCount() {
        return this.mCount;
    }

    public boolean isViewFromObject(View view, Object object) {
        ViewHolder holder = (ViewHolder)object;
        return view == holder.container;
    }

    private int getMonthForPosition(int position) {
        return (position + this.mMinDate.get(2)) % 12;
    }

    private int getYearForPosition(int position) {
        int yearOffset = (position + this.mMinDate.get(2)) / 12;
        return yearOffset + this.mMinDate.get(1);
    }

    private int getPositionForDay(@Nullable Calendar day) {
        if (day == null) {
            return -1;
        }
        int yearOffset = day.get(1) - this.mMinDate.get(1);
        int monthOffset = day.get(2) - this.mMinDate.get(2);
        return yearOffset * 12 + monthOffset;
    }

    private int[] getPositionsForDay(@Nullable SelectedDate day) {
        if (day == null) {
            return null;
        }
        SelectedDate.Type typeOfDay = day.getType();
        int[] positions = null;
        if (typeOfDay == SelectedDate.Type.SINGLE) {
            positions = new int[1];
            int yearOffset = day.getFirstDate().get(1) - this.mMinDate.get(1);
            int monthOffset = day.getFirstDate().get(2) - this.mMinDate.get(2);
            positions[0] = yearOffset * 12 + monthOffset;
        } else if (typeOfDay == SelectedDate.Type.RANGE) {
            positions = new int[2];
            int yearOffsetFirstDate = day.getFirstDate().get(1) - this.mMinDate.get(1);
            int monthOffsetFirstDate = day.getFirstDate().get(2) - this.mMinDate.get(2);
            positions[0] = yearOffsetFirstDate * 12 + monthOffsetFirstDate;
            int yearOffsetSecondDate = day.getSecondDate().get(1) - this.mMinDate.get(1);
            int monthOffsetSecondDate = day.getSecondDate().get(2) - this.mMinDate.get(2);
            positions[1] = yearOffsetSecondDate * 12 + monthOffsetSecondDate;
        }
        return positions;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        View itemView = this.mInflater.inflate(this.mLayoutResId, container, false);
        SimpleMonthView v = (SimpleMonthView)itemView.findViewById(this.mCalendarViewId);
        v.setOnDayClickListener(this.mOnDayClickListener);
        v.setMonthTextAppearance(this.mMonthTextAppearance);
        v.setDayOfWeekTextAppearance(this.mDayOfWeekTextAppearance);
        v.setDayTextAppearance(this.mDayTextAppearance);
        if (this.mDaySelectorColor != null) {
            v.setDaySelectorColor(this.mDaySelectorColor);
        }
        if (this.mDayHighlightColor != null) {
            v.setDayHighlightColor(this.mDayHighlightColor);
        }
        if (this.mCalendarTextColor != null) {
            v.setMonthTextColor(this.mCalendarTextColor);
            v.setDayOfWeekTextColor(this.mCalendarTextColor);
            v.setDayTextColor(this.mCalendarTextColor);
        }
        int month = this.getMonthForPosition(position);
        int year = this.getYearForPosition(position);
        int[] selectedDay = this.resolveSelectedDayBasedOnType(month, year);
        int enabledDayRangeStart = this.mMinDate.get(2) == month && this.mMinDate.get(1) == year ? this.mMinDate.get(5) : 1;
        int enabledDayRangeEnd = this.mMaxDate.get(2) == month && this.mMaxDate.get(1) == year ? this.mMaxDate.get(5) : 31;
        v.setMonthParams(month, year, this.mFirstDayOfWeek, enabledDayRangeStart, enabledDayRangeEnd, selectedDay[0], selectedDay[1], this.mSelectedDay != null ? this.mSelectedDay.getType() : null);
        ViewHolder holder = new ViewHolder(position, itemView, v);
        this.mItems.put(position, (Object)holder);
        container.addView(itemView);
        return holder;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        ViewHolder holder = (ViewHolder)object;
        container.removeView(holder.container);
        this.mItems.remove(position);
    }

    public int getItemPosition(Object object) {
        ViewHolder holder = (ViewHolder)object;
        return holder.position;
    }

    public CharSequence getPageTitle(int position) {
        SimpleMonthView v = ((ViewHolder)this.mItems.get((int)position)).calendar;
        if (v != null) {
            return v.getTitle();
        }
        return null;
    }

    public SelectedDate resolveStartDateForRange(int x, int y, int position) {
        int dayOfMonth;
        Calendar selectedDayStart;
        ViewHolder newMonthView;
        if (position >= 0 && (newMonthView = (ViewHolder)this.mItems.get(position, null)) != null && (selectedDayStart = newMonthView.calendar.composeDate(dayOfMonth = newMonthView.calendar.getDayAtLocation(x, y))) != null) {
            this.mTempSelectedDay.setDate(selectedDayStart);
            return this.mTempSelectedDay;
        }
        return null;
    }

    public SelectedDate resolveEndDateForRange(int x, int y, int position, boolean updateIfNecessary) {
        int dayOfMonth;
        Calendar selectedDayEnd;
        ViewHolder newMonthView;
        if (!(position < 0 || (newMonthView = (ViewHolder)this.mItems.get(position, null)) == null || (selectedDayEnd = newMonthView.calendar.composeDate(dayOfMonth = newMonthView.calendar.getDayAtLocation(x, y))) == null || updateIfNecessary && this.mSelectedDay.getSecondDate().getTimeInMillis() == selectedDayEnd.getTimeInMillis())) {
            this.mTempSelectedDay.setSecondDate(selectedDayEnd);
            return this.mTempSelectedDay;
        }
        return null;
    }

    private int[] resolveSelectedDayBasedOnType(int month, int year) {
        if (this.mSelectedDay == null) {
            return new int[]{-1, -1};
        }
        if (this.mSelectedDay.getType() == SelectedDate.Type.SINGLE) {
            return this.resolveSelectedDayForTypeSingle(month, year);
        }
        if (this.mSelectedDay.getType() == SelectedDate.Type.RANGE) {
            return this.resolveSelectedDayForTypeRange(month, year);
        }
        return new int[]{-1, -1};
    }

    private int[] resolveSelectedDayForTypeSingle(int month, int year) {
        if (this.mSelectedDay.getFirstDate().get(2) == month && this.mSelectedDay.getFirstDate().get(1) == year) {
            int resolvedDay = this.mSelectedDay.getFirstDate().get(5);
            return new int[]{resolvedDay, resolvedDay};
        }
        return new int[]{-1, -1};
    }

    private int[] resolveSelectedDayForTypeRange(int month, int year) {
        float startDateQuan = (float)this.mSelectedDay.getStartDate().get(1) + (float)(this.mSelectedDay.getStartDate().get(2) + 1) / 100.0f;
        float endDateQuan = (float)this.mSelectedDay.getEndDate().get(1) + (float)(this.mSelectedDay.getEndDate().get(2) + 1) / 100.0f;
        float dateQuan = (float)year + (float)(month + 1) / 100.0f;
        if (dateQuan >= startDateQuan && dateQuan <= endDateQuan) {
            int startDay = dateQuan == startDateQuan ? this.mSelectedDay.getStartDate().get(5) : 1;
            int endDay = dateQuan == endDateQuan ? this.mSelectedDay.getEndDate().get(5) : MUtils.getDaysInMonth(month, year);
            return new int[]{startDay, endDay};
        }
        return new int[]{-1, -1};
    }

    public void onDateRangeSelectionStarted(SelectedDate selectedDate) {
        if (this.mDaySelectionEventListener != null) {
            this.mDaySelectionEventListener.onDateRangeSelectionStarted(selectedDate);
        }
    }

    public void onDateRangeSelectionEnded(SelectedDate selectedDate) {
        if (this.mDaySelectionEventListener != null) {
            this.mDaySelectionEventListener.onDateRangeSelectionEnded(selectedDate);
        }
    }

    public void onDateRangeSelectionUpdated(SelectedDate selectedDate) {
        if (this.mDaySelectionEventListener != null) {
            this.mDaySelectionEventListener.onDateRangeSelectionUpdated(selectedDate);
        }
    }

    public static interface DaySelectionEventListener {
        public void onDaySelected(DayPickerPagerAdapter var1, Calendar var2);

        public void onDateRangeSelectionStarted(@NonNull SelectedDate var1);

        public void onDateRangeSelectionEnded(@Nullable SelectedDate var1);

        public void onDateRangeSelectionUpdated(@NonNull SelectedDate var1);
    }

    private static class ViewHolder {
        public final int position;
        public final View container;
        public final SimpleMonthView calendar;

        public ViewHolder(int position, View container, SimpleMonthView calendar) {
            this.position = position;
            this.container = container;
            this.calendar = calendar;
        }
    }
}

