/*
 * Decompiled with CFR 0.152.
 */
package com.kp.md.picker.datepicker;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.widget.TextView;
import com.kp.md.picker.R;

class CircularIndicatorTextView
extends TextView {
    private static final int SELECTED_CIRCLE_ALPHA = 60;
    private final Paint mCirclePaint = new Paint();
    private final String mItemIsSelectedText;
    private int mCircleColor;
    private boolean mDrawIndicator;

    public CircularIndicatorTextView(Context context) {
        this(context, null);
    }

    public CircularIndicatorTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircularIndicatorTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public CircularIndicatorTextView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs);
        Resources res = context.getResources();
        this.mItemIsSelectedText = res.getString(R.string.item_is_selected);
        this.init();
    }

    private void init() {
        this.mCirclePaint.setTypeface(Typeface.create((Typeface)this.mCirclePaint.getTypeface(), (int)1));
        this.mCirclePaint.setAntiAlias(true);
        this.mCirclePaint.setTextAlign(Paint.Align.CENTER);
        this.mCirclePaint.setStyle(Paint.Style.FILL);
    }

    public void setCircleColor(int color2) {
        if (color2 != this.mCircleColor) {
            this.mCircleColor = color2;
            this.mCirclePaint.setColor(this.mCircleColor);
            this.mCirclePaint.setAlpha(60);
            this.requestLayout();
        }
    }

    public void setDrawIndicator(boolean drawIndicator) {
        this.mDrawIndicator = drawIndicator;
    }

    public void onDraw(@NonNull Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDrawIndicator) {
            int width = this.getWidth();
            int height = this.getHeight();
            int radius = Math.min(width, height) / 2;
            canvas.drawCircle((float)(width / 2), (float)(height / 2), (float)radius, this.mCirclePaint);
        }
    }

    public CharSequence getContentDescription() {
        CharSequence itemText = this.getText();
        if (this.mDrawIndicator) {
            return String.format(this.mItemIsSelectedText, itemText);
        }
        return itemText;
    }
}

