/*
 * Decompiled with CFR 0.152.
 */
package com.kp.md.picker.common;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.kp.md.picker.R;
import com.kp.md.picker.utilities.MUtils;

public class DecisionButtonLayout
extends LinearLayout
implements View.OnClickListener {
    View mPositiveButton;
    View mNegativeButton;
    int mIconOverlayColor;
    int mDisabledAlpha;
    int mButtonBarBgColor;
    Callback mCallback;

    public DecisionButtonLayout(Context context) {
        this(context, null);
    }

    public DecisionButtonLayout(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.spButtonLayoutStyle);
    }

    public DecisionButtonLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super((Context)MUtils.createThemeWrapper(context, R.attr.mPickerStyle, R.style.MPickerStyleLight, R.attr.spButtonLayoutStyle, R.style.ButtonLayoutStyle), attrs, defStyleAttr);
        this.initialize();
    }

    @TargetApi(value=21)
    public DecisionButtonLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super((Context)MUtils.createThemeWrapper(context, R.attr.mPickerStyle, R.style.MPickerStyleLight, R.attr.spButtonLayoutStyle, R.style.ButtonLayoutStyle), attrs, defStyleAttr, defStyleRes);
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() {
        Context context = this.getContext();
        Resources res = this.getResources();
        TypedArray a = context.obtainStyledAttributes(R.styleable.ButtonLayout);
        if (MUtils.isApi_17_OrHigher()) {
            this.setLayoutDirection(3);
        }
        this.setOrientation(0);
        this.setGravity(80);
        this.setPadding(res.getDimensionPixelSize(R.dimen.sp_button_bar_padding_start), res.getDimensionPixelSize(R.dimen.sp_button_bar_padding_top), res.getDimensionPixelSize(R.dimen.sp_button_bar_padding_end), res.getDimensionPixelSize(R.dimen.sp_button_bar_padding_bottom));
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater.inflate(R.layout.decision_button_layout, (ViewGroup)this, true);
        Button bPositive = (Button)this.findViewById(R.id.buttonPositive);
        Button bNegative = (Button)this.findViewById(R.id.buttonNegative);
        ImageView ivPositive = (ImageView)this.findViewById(R.id.imageViewPositive);
        ImageView ivNegative = (ImageView)this.findViewById(R.id.imageViewNegative);
        try {
            TypedValue typedValueDisabledAlpha = new TypedValue();
            this.getContext().getTheme().resolveAttribute(0x1010033, typedValueDisabledAlpha, true);
            this.mDisabledAlpha = typedValueDisabledAlpha.type == 4 ? (int)(typedValueDisabledAlpha.getFloat() * 255.0f) : 122;
            int presentation = a.getInt(R.styleable.ButtonLayout_spPresentation, 0);
            int bgColor = a.getColor(R.styleable.ButtonLayout_spButtonBgColor, MUtils.COLOR_BUTTON_NORMAL);
            int pressedBgColor = a.getColor(R.styleable.ButtonLayout_spButtonPressedBgColor, MUtils.COLOR_CONTROL_HIGHLIGHT);
            this.mButtonBarBgColor = a.getColor(R.styleable.ButtonLayout_spButtonBarBgColor, 0);
            this.setBackgroundColor(this.mButtonBarBgColor);
            if (presentation == 0) {
                bPositive.setVisibility(0);
                bNegative.setVisibility(0);
                bPositive.setText((CharSequence)res.getString(R.string.ok));
                bNegative.setText((CharSequence)res.getString(R.string.cancel));
                MUtils.setViewBackground((View)bPositive, MUtils.createButtonBg(context, bgColor, pressedBgColor));
                MUtils.setViewBackground((View)bNegative, MUtils.createButtonBg(context, bgColor, pressedBgColor));
                this.mPositiveButton = bPositive;
                this.mNegativeButton = bNegative;
            } else {
                ivPositive.setVisibility(0);
                ivNegative.setVisibility(0);
                this.mIconOverlayColor = a.getColor(R.styleable.ButtonLayout_spIconColor, MUtils.COLOR_ACCENT);
                ivPositive.setColorFilter(this.mIconOverlayColor, PorterDuff.Mode.MULTIPLY);
                ivNegative.setColorFilter(this.mIconOverlayColor, PorterDuff.Mode.MULTIPLY);
                MUtils.setViewBackground((View)ivPositive, MUtils.createImageViewBg(bgColor, pressedBgColor));
                MUtils.setViewBackground((View)ivNegative, MUtils.createImageViewBg(bgColor, pressedBgColor));
                this.mPositiveButton = ivPositive;
                this.mNegativeButton = ivNegative;
            }
        }
        finally {
            a.recycle();
        }
        this.mPositiveButton.setOnClickListener((View.OnClickListener)this);
        this.mNegativeButton.setOnClickListener((View.OnClickListener)this);
    }

    public void applyOptions(@NonNull Callback callback) {
        this.mCallback = callback;
    }

    public void updateValidity(boolean valid) {
        this.mPositiveButton.setEnabled(valid);
        if (this.mPositiveButton instanceof ImageView) {
            int color2 = this.mIconOverlayColor;
            if (!valid) {
                color2 = this.mDisabledAlpha << 24 | this.mIconOverlayColor & 0xFFFFFF;
            }
            ((ImageView)this.mPositiveButton).setColorFilter(color2, PorterDuff.Mode.MULTIPLY);
        }
    }

    public void onClick(View v) {
        if (v == this.mPositiveButton) {
            this.mCallback.onOkay();
        } else if (v == this.mNegativeButton) {
            this.mCallback.onCancel();
        }
    }

    public static interface Callback {
        public void onOkay();

        public void onCancel();
    }
}

