/*
 * Decompiled with CFR 0.152.
 */
package com.kp.md.picker.common;

import android.support.annotation.NonNull;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DateTimePatternHelper {
    private static final String TAG = DateTimePatternHelper.class.getSimpleName();
    public static final int PATTERN_EMMMd = 0;
    public static final int PATTERN_MMMMy = 1;
    public static final int PATTERN_hm = 2;
    public static final int PATTERN_Hm = 3;
    private static final String[] sDefaultDateTimePattern = new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"};
    private static final Map<String, String[]> sDateTimePatterns = new HashMap<String, String[]>();
    private static final Map<String, String[]> sLoadedDateTimePatterns = new HashMap<String, String[]>();

    private static String[] loadLocaleInternal(@NonNull Locale locale) {
        String[] loadedLocalePattern;
        if (!DateTimePatternHelper.isLocaleLoaded(locale)) {
            loadedLocalePattern = sDateTimePatterns.get(locale.toString());
            sLoadedDateTimePatterns.put(locale.toString(), loadedLocalePattern);
        } else {
            loadedLocalePattern = sLoadedDateTimePatterns.get(locale.toString());
        }
        return loadedLocalePattern;
    }

    private static boolean isLocaleLoaded(@NonNull Locale locale) {
        return sLoadedDateTimePatterns.containsKey(locale.toString());
    }

    public static String getBestDateTimePattern(@NonNull Locale givenLocale, int patternIndex) {
        String[] patterns;
        if (sDateTimePatterns.isEmpty()) {
            DateTimePatternHelper.initMap();
        }
        if ((patterns = DateTimePatternHelper.loadLocaleInternal(givenLocale)) != null && patterns.length > patternIndex) {
            return patterns[patternIndex];
        }
        return sDefaultDateTimePattern[patternIndex];
    }

    /*
     * Opcode count of 14192 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void initMap() {
        sDateTimePatterns.put("af", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("af_NA", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("af_ZA", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("agq", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("agq_CM", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ak", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ak_GH", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("am", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("am_ET", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_001", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_AE", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_BH", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_DJ", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_DZ", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_EG", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_EH", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_ER", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_IL", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_IQ", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_JO", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_KM", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_KW", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_LB", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_LY", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_MA", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_MR", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_OM", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_PS", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_QA", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_SA", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_SD", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_SO", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_SS", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_SY", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_TD", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_TN", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ar_YE", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("as", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("as_IN", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("asa", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("asa_TZ", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("az", new String[]{"d MMM, EEE", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("az__#Cyrl", new String[]{"EEE, d, MMM", "MMMM, y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("az_AZ_#Cyrl", new String[]{"EEE, d, MMM", "MMMM, y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("az__#Latn", new String[]{"d MMM, EEE", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("az_AZ_#Latn", new String[]{"d MMM, EEE", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("bas", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("bas_CM", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("be", new String[]{"EEE, d MMM", "LLLL y", "h.mm a", "HH.mm"});
        sDateTimePatterns.put("be_BY", new String[]{"EEE, d MMM", "LLLL y", "h.mm a", "HH.mm"});
        sDateTimePatterns.put("bem", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("bem_ZM", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("bez", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("bez_TZ", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("bg", new String[]{"EEE, d.MM", "MMMM y '\u0433'.", "h:mm a", "H:mm"});
        sDateTimePatterns.put("bg_BG", new String[]{"EEE, d.MM", "MMMM y '\u0433'.", "h:mm a", "H:mm"});
        sDateTimePatterns.put("bm", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("bm_ML", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("bn", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("bn_BD", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("bn_IN", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("bo", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("bo_CN", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("bo_IN", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("br", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("br_FR", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("brx", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("brx_IN", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("bs", new String[]{"EEE, dd. MMM", "MMMM y.", "hh:mm a", "HH:mm"});
        sDateTimePatterns.put("bs__#Cyrl", new String[]{"EEE, dd. MMM", "MMMM y.", "hh:mm a", "HH:mm"});
        sDateTimePatterns.put("bs_BA_#Cyrl", new String[]{"EEE, dd. MMM", "MMMM y.", "hh:mm a", "HH:mm"});
        sDateTimePatterns.put("bs__#Latn", new String[]{"EEE, dd. MMM", "MMMM y.", "hh:mm a", "HH:mm"});
        sDateTimePatterns.put("bs_BA_#Latn", new String[]{"EEE, dd. MMM", "MMMM y.", "hh:mm a", "HH:mm"});
        sDateTimePatterns.put("ca", new String[]{"EEE d MMM", "LLLL 'de' y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ca_AD", new String[]{"EEE d MMM", "LLLL 'de' y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ca_ES", new String[]{"EEE d MMM", "LLLL 'de' y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ca_FR", new String[]{"EEE d MMM", "LLLL 'de' y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ca_IT", new String[]{"EEE d MMM", "LLLL 'de' y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("cgg", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("cgg_UG", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("chr", new String[]{"MMM d, EEE", "MMMM y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("chr_US", new String[]{"MMM d, EEE", "MMMM y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("cs", new String[]{"EEE d. M.", "LLLL y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("cs_CZ", new String[]{"EEE d. M.", "LLLL y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("cy", new String[]{"EEE, d MMM", "MMMM y", "h.mm a", "HH:mm"});
        sDateTimePatterns.put("cy_GB", new String[]{"EEE, d MMM", "MMMM y", "h.mm a", "HH:mm"});
        sDateTimePatterns.put("da", new String[]{"EEE d. MMM", "MMMM y", "h.mm a", "HH.mm"});
        sDateTimePatterns.put("da_DK", new String[]{"EEE d. MMM", "MMMM y", "h.mm a", "HH.mm"});
        sDateTimePatterns.put("da_GL", new String[]{"EEE d. MMM", "MMMM y", "h.mm a", "HH.mm"});
        sDateTimePatterns.put("dav", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("dav_KE", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("de", new String[]{"EEE, d. MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("de_AT", new String[]{"EEE, d. MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("de_BE", new String[]{"EEE, d. MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("de_CH", new String[]{"EEE, d. MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("de_DE", new String[]{"EEE, d. MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("de_LI", new String[]{"EEE, d. MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("de_LU", new String[]{"EEE, d. MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("dje", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("dje_NE", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("dua", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("dua_CM", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("dyo", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("dyo_SN", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("dz", new String[]{"EEE, \u0f66\u0fa4\u0fb1\u0f72\u0f0bLLL \u0f5a\u0f7a\u0f0bd", "y \u0f66\u0fa4\u0fb1\u0f72\u0f0b\u0f5f\u0fb3\u0f0bMMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("dz_BT", new String[]{"EEE, \u0f66\u0fa4\u0fb1\u0f72\u0f0bLLL \u0f5a\u0f7a\u0f0bd", "y \u0f66\u0fa4\u0fb1\u0f72\u0f0b\u0f5f\u0fb3\u0f0bMMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ebu", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ebu_KE", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ee", new String[]{"EEE, MMM d 'lia'", "MMMM y", "a 'ga' h:mm", "HH:mm"});
        sDateTimePatterns.put("ee_GH", new String[]{"EEE, MMM d 'lia'", "MMMM y", "a 'ga' h:mm", "HH:mm"});
        sDateTimePatterns.put("ee_TG", new String[]{"EEE, MMM d 'lia'", "MMMM y", "a 'ga' h:mm", "HH:mm"});
        sDateTimePatterns.put("el", new String[]{"EEE, d MMM", "LLLL y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("el_CY", new String[]{"EEE, d MMM", "LLLL y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("el_GR", new String[]{"EEE, d MMM", "LLLL y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_001", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_150", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_AG", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_AI", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_AS", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_AU", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_BB", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_BE", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_BM", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_BS", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_BW", new String[]{"EEE dd MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_BZ", new String[]{"EEE dd MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_CA", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_CC", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_CK", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_CM", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_CX", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_DG", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_DM", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_ER", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_FJ", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_FK", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_FM", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_GB", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_GD", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_GG", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_GH", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_GI", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_GM", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_GU", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_GY", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_HK", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_IE", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_IM", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_IN", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_IO", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_JE", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_JM", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_KE", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_KI", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_KN", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_KY", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_LC", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_LR", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_LS", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_MG", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_MH", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_MO", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_MP", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_MS", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_MT", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_MU", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_MW", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_NA", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_NF", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_NG", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_NR", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_NU", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_NZ", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_PG", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_PH", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_PK", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_PN", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_PR", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_PW", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_RW", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_SB", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_SC", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_SD", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_SG", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_SH", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_SL", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_SS", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_SX", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_SZ", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_TC", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_TK", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_TO", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_TT", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_TV", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_TZ", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_UG", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_UM", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_US", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_US_POSIX", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_VC", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_VG", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_VI", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_VU", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_WS", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_ZA", new String[]{"EEE dd MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_ZM", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("en_ZW", new String[]{"EEE dd MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("eo", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("es", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_419", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_AR", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_BO", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_CL", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_CO", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_CR", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_CU", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_DO", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_EA", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_EC", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_ES", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_GQ", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_GT", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_HN", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_IC", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_MX", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "hh:mm a", "HH:mm"});
        sDateTimePatterns.put("es_NI", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_PA", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_PE", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_PH", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_PR", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_PY", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_SV", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_US", new String[]{"EEE, MMM d", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_UY", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("es_VE", new String[]{"EEE d 'de' MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("et", new String[]{"EEE, d. MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("et_EE", new String[]{"EEE, d. MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("eu", new String[]{"MMM d, EEE", "y('e')'ko' MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("eu_ES", new String[]{"MMM d, EEE", "y('e')'ko' MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ewo", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ewo_CM", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fa", new String[]{"EEE d LLL", "MMMM y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("fa_AF", new String[]{"EEE d LLL", "MMMM y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("fa_IR", new String[]{"EEE d LLL", "MMMM y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("ff", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ff_SN", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fi", new String[]{"ccc d. MMM", "LLLL y", "h.mm a", "H.mm"});
        sDateTimePatterns.put("fi_FI", new String[]{"ccc d. MMM", "LLLL y", "h.mm a", "H.mm"});
        sDateTimePatterns.put("fil", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fil_PH", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fo", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fo_FO", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_BE", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_BF", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_BI", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_BJ", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_BL", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_CA", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_CD", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_CF", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_CG", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_CH", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_CI", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_CM", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_DJ", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_DZ", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_FR", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_GA", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_GF", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_GN", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_GP", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_GQ", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_HT", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_KM", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_LU", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_MA", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_MC", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_MF", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_MG", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_ML", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_MQ", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_MR", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_MU", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_NC", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_NE", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_PF", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_PM", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_RE", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_RW", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_SC", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_SN", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_SY", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_TD", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_TG", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_TN", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_VU", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_WF", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("fr_YT", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ga", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ga_IE", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("gl", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("gl_ES", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("gsw", new String[]{"EEE d. MMM", "MMMM y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("gsw_CH", new String[]{"EEE d. MMM", "MMMM y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("gsw_LI", new String[]{"EEE d. MMM", "MMMM y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("gu", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("gu_IN", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("guz", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("guz_KE", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("gv", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("gv_IM", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ha", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ha__#Latn", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ha_GH_#Latn", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ha_NE_#Latn", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ha_NG_#Latn", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("haw", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("haw_US", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("iw", new String[]{"EEE, d \u05d1MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("iw_IL", new String[]{"EEE, d \u05d1MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("hi", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("hi_IN", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("hr", new String[]{"EEE, d. MMM", "LLLL y.", "hh:mm a", "HH:mm"});
        sDateTimePatterns.put("hr_BA", new String[]{"EEE, d. MMM", "LLLL y.", "hh:mm a", "HH:mm"});
        sDateTimePatterns.put("hr_HR", new String[]{"EEE, d. MMM", "LLLL y.", "hh:mm a", "HH:mm"});
        sDateTimePatterns.put("hu", new String[]{"MMM d., EEE", "y. MMMM", "a h:mm", "H:mm"});
        sDateTimePatterns.put("hu_HU", new String[]{"MMM d., EEE", "y. MMMM", "a h:mm", "H:mm"});
        sDateTimePatterns.put("hy", new String[]{"d MMM, EEE", "y\u0569. LLLL", "h:mm a", "H:mm"});
        sDateTimePatterns.put("hy_AM", new String[]{"d MMM, EEE", "y\u0569. LLLL", "h:mm a", "H:mm"});
        sDateTimePatterns.put("in", new String[]{"EEE, d MMM", "MMMM y", "h.mm a", "HH.mm"});
        sDateTimePatterns.put("in_ID", new String[]{"EEE, d MMM", "MMMM y", "h.mm a", "HH.mm"});
        sDateTimePatterns.put("ig", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ig_NG", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ii", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ii_CN", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("is", new String[]{"EEE, d. MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("is_IS", new String[]{"EEE, d. MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("it", new String[]{"EEE d MMM", "MMMM y", "hh:mm a", "HH:mm"});
        sDateTimePatterns.put("it_CH", new String[]{"EEE d MMM", "MMMM y", "hh:mm a", "HH:mm"});
        sDateTimePatterns.put("it_IT", new String[]{"EEE d MMM", "MMMM y", "hh:mm a", "HH:mm"});
        sDateTimePatterns.put("it_SM", new String[]{"EEE d MMM", "MMMM y", "hh:mm a", "HH:mm"});
        sDateTimePatterns.put("ja", new String[]{"M\u6708d\u65e5(EEE)", "y\u5e74M\u6708", "aK:mm", "H:mm"});
        sDateTimePatterns.put("ja_JP", new String[]{"M\u6708d\u65e5(EEE)", "y\u5e74M\u6708", "aK:mm", "H:mm"});
        sDateTimePatterns.put("jgo", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("jgo_CM", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("jmc", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("jmc_TZ", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ka", new String[]{"EEE, d MMM", "MMMM, y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ka_GE", new String[]{"EEE, d MMM", "MMMM, y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kab", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kab_DZ", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kam", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kam_KE", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kde", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kde_TZ", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kea", new String[]{"EEE, d MMM", "MMMM 'di' y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kea_CV", new String[]{"EEE, d MMM", "MMMM 'di' y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("khq", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("khq_ML", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ki", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ki_KE", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kk", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kk__#Cyrl", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kk_KZ_#Cyrl", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kkj", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kkj_CM", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kl", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kl_GL", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kln", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kln_KE", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("km", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("km_KH", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kn", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kn_IN", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ko", new String[]{"MMM d\uc77c (EEE)", "y\ub144 MMMM", "a h:mm", "HH:mm"});
        sDateTimePatterns.put("ko_KP", new String[]{"MMM d\uc77c (EEE)", "y\ub144 MMMM", "a h:mm", "HH:mm"});
        sDateTimePatterns.put("ko_KR", new String[]{"MMM d\uc77c (EEE)", "y\ub144 MMMM", "a h:mm", "HH:mm"});
        sDateTimePatterns.put("kok", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kok_IN", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ks", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ks__#Arab", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ks_IN_#Arab", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ksb", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ksb_TZ", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ksf", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ksf_CM", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kw", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("kw_GB", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ky", new String[]{"d-MMM, EEE", "y-'\u0436'. MMMM", "a h:mm", "HH:mm"});
        sDateTimePatterns.put("ky__#Cyrl", new String[]{"d-MMM, EEE", "y-'\u0436'. MMMM", "a h:mm", "HH:mm"});
        sDateTimePatterns.put("ky_KG_#Cyrl", new String[]{"d-MMM, EEE", "y-'\u0436'. MMMM", "a h:mm", "HH:mm"});
        sDateTimePatterns.put("lag", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("lag_TZ", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("lg", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("lg_UG", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("lkt", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("lkt_US", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ln", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ln_AO", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ln_CD", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ln_CF", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ln_CG", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("lo", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("lo_LA", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("lt", new String[]{"MMM d, EEE", "y MMMM", "hh:mm a", "HH:mm"});
        sDateTimePatterns.put("lt_LT", new String[]{"MMM d, EEE", "y MMMM", "hh:mm a", "HH:mm"});
        sDateTimePatterns.put("lu", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("lu_CD", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("luo", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("luo_KE", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("luy", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("luy_KE", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("lv", new String[]{"EEE, d. MMM", "y. 'g'. MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("lv_LV", new String[]{"EEE, d. MMM", "y. 'g'. MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mas", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mas_KE", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mas_TZ", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mer", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mer_KE", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mfe", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mfe_MU", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mg", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mg_MG", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mgh", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mgh_MZ", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mgo", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mgo_CM", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mk", new String[]{"EEE d MMM", "MMMM y '\u0433'.", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mk_MK", new String[]{"EEE d MMM", "MMMM y '\u0433'.", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ml", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ml_IN", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mn", new String[]{"EEE MMM d", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mn__#Cyrl", new String[]{"EEE MMM d", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mn_MN_#Cyrl", new String[]{"EEE MMM d", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mr", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("mr_IN", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("ms", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ms__#Latn", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ms_BN_#Latn", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ms_MY_#Latn", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ms_SG_#Latn", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mt", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mt_MT", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mua", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("mua_CM", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("my", new String[]{"EEE, MMM d", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("my_MM", new String[]{"EEE, MMM d", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("naq", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("naq_NA", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("nb", new String[]{"EEE d. MMM", "MMMM y", "h.mm a", "HH.mm"});
        sDateTimePatterns.put("nb_NO", new String[]{"EEE d. MMM", "MMMM y", "h.mm a", "HH.mm"});
        sDateTimePatterns.put("nb_SJ", new String[]{"EEE d. MMM", "MMMM y", "h.mm a", "HH.mm"});
        sDateTimePatterns.put("nd", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("nd_ZW", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ne", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ne_IN", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ne_NP", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("nl", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("nl_AW", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("nl_BE", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("nl_BQ", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("nl_CW", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("nl_NL", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("nl_SR", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("nl_SX", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("nmg", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("nmg_CM", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("nn", new String[]{"EEE d. MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("nn_NO", new String[]{"EEE d. MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("nnh", new String[]{"MMM d, EEE", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("nnh_CM", new String[]{"MMM d, EEE", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("nus", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("nus_SD", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("nyn", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("nyn_UG", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("om", new String[]{"MMM d, EEE", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("om_ET", new String[]{"MMM d, EEE", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("om_KE", new String[]{"MMM d, EEE", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("or", new String[]{"MMM d, EEE", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("or_IN", new String[]{"MMM d, EEE", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("pa", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("pa__#Arab", new String[]{"MMM d, EEE", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("pa_PK_#Arab", new String[]{"MMM d, EEE", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("pa__#Guru", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("pa_IN_#Guru", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("pl", new String[]{"EEE, d MMM", "LLLL y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("pl_PL", new String[]{"EEE, d MMM", "LLLL y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ps", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "H:mm"});
        sDateTimePatterns.put("ps_AF", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "H:mm"});
        sDateTimePatterns.put("pt", new String[]{"EEE, d 'de' MMM", "MMMM 'de' y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("pt_AO", new String[]{"EEE, d/MM", "MMMM 'de' y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("pt_BR", new String[]{"EEE, d 'de' MMM", "MMMM 'de' y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("pt_CV", new String[]{"EEE, d/MM", "MMMM 'de' y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("pt_GW", new String[]{"EEE, d/MM", "MMMM 'de' y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("pt_MO", new String[]{"EEE, d/MM", "MMMM 'de' y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("pt_MZ", new String[]{"EEE, d/MM", "MMMM 'de' y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("pt_PT", new String[]{"EEE, d/MM", "MMMM 'de' y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("pt_ST", new String[]{"EEE, d/MM", "MMMM 'de' y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("pt_TL", new String[]{"EEE, d/MM", "MMMM 'de' y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("rm", new String[]{"EEE d. MMM", "MMMM y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("rm_CH", new String[]{"EEE d. MMM", "MMMM y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("rn", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("rn_BI", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ro", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ro_MD", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ro_RO", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("rof", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("rof_TZ", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ru", new String[]{"ccc, d MMM", "LLLL y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("ru_BY", new String[]{"ccc, d MMM", "LLLL y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("ru_KG", new String[]{"ccc, d MMM", "LLLL y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("ru_KZ", new String[]{"ccc, d MMM", "LLLL y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("ru_MD", new String[]{"ccc, d MMM", "LLLL y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("ru_RU", new String[]{"ccc, d MMM", "LLLL y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("ru_UA", new String[]{"ccc, d MMM", "LLLL y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("rw", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("rw_RW", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("rwk", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("rwk_TZ", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("saq", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("saq_KE", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("sbp", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("sbp_TZ", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("seh", new String[]{"EEE, d MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("seh_MZ", new String[]{"EEE, d MMM", "MMMM 'de' y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("ses", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ses_ML", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("sg", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("sg_CF", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("shi", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("shi__#Latn", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("shi_MA_#Latn", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("shi__#Tfng", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("shi_MA_#Tfng", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("si", new String[]{"MMM d EEE", "y MMMM", "a h.mm", "HH:mm"});
        sDateTimePatterns.put("si_LK", new String[]{"MMM d EEE", "y MMMM", "a h.mm", "HH:mm"});
        sDateTimePatterns.put("sk", new String[]{"EEE, d. MMM.", "LLLL y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("sk_SK", new String[]{"EEE, d. MMM.", "LLLL y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("sl", new String[]{"EEE, d. MMM", "MMMM y", "h.mm a", "HH.mm"});
        sDateTimePatterns.put("sl_SI", new String[]{"EEE, d. MMM", "MMMM y", "h.mm a", "HH.mm"});
        sDateTimePatterns.put("sn", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("sn_ZW", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("so", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("so_DJ", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("so_ET", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("so_KE", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("so_SO", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("sq", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("sq_AL", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("sq_MK", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("sq_XK", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("sr", new String[]{"EEE d. MMM", "MMMM y.", "hh.mm a", "HH.mm"});
        sDateTimePatterns.put("sr__#Cyrl", new String[]{"EEE d. MMM", "MMMM y.", "hh.mm a", "HH.mm"});
        sDateTimePatterns.put("sr_BA_#Cyrl", new String[]{"EEE d. MMM", "MMMM y.", "hh.mm a", "HH.mm"});
        sDateTimePatterns.put("sr_ME_#Cyrl", new String[]{"EEE d. MMM", "MMMM y.", "hh.mm a", "HH.mm"});
        sDateTimePatterns.put("sr_RS_#Cyrl", new String[]{"EEE d. MMM", "MMMM y.", "hh.mm a", "HH.mm"});
        sDateTimePatterns.put("sr_XK_#Cyrl", new String[]{"EEE d. MMM", "MMMM y.", "hh.mm a", "HH.mm"});
        sDateTimePatterns.put("sr__#Latn", new String[]{"EEE d. MMM", "MMMM y.", "hh.mm a", "HH.mm"});
        sDateTimePatterns.put("sr_BA_#Latn", new String[]{"EEE d. MMM", "MMMM y.", "hh.mm a", "HH.mm"});
        sDateTimePatterns.put("sr_ME_#Latn", new String[]{"EEE d. MMM", "MMMM y.", "hh.mm a", "HH.mm"});
        sDateTimePatterns.put("sr_RS_#Latn", new String[]{"EEE d. MMM", "MMMM y.", "hh.mm a", "HH.mm"});
        sDateTimePatterns.put("sr_XK_#Latn", new String[]{"EEE d. MMM", "MMMM y.", "hh.mm a", "HH.mm"});
        sDateTimePatterns.put("sv", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("sv_AX", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("sv_FI", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("sv_SE", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("sw", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("sw_KE", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("sw_TZ", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("sw_UG", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("swc", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("swc_CD", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ta", new String[]{"MMM d, EEE", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ta_IN", new String[]{"MMM d, EEE", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ta_LK", new String[]{"MMM d, EEE", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ta_MY", new String[]{"MMM d, EEE", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ta_SG", new String[]{"MMM d, EEE", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("te", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("te_IN", new String[]{"EEE, d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("teo", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("teo_KE", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("teo_UG", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("th", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("th_TH", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ti", new String[]{"MMM d, EEE", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ti_ER", new String[]{"MMM d, EEE", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ti_ET", new String[]{"MMM d, EEE", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("to", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("to_TO", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("tr", new String[]{"d MMMM EEE", "MMMM y", "a h:mm", "HH:mm"});
        sDateTimePatterns.put("tr_CY", new String[]{"d MMMM EEE", "MMMM y", "a h:mm", "HH:mm"});
        sDateTimePatterns.put("tr_TR", new String[]{"d MMMM EEE", "MMMM y", "a h:mm", "HH:mm"});
        sDateTimePatterns.put("twq", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("twq_NE", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("tzm", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("tzm__#Latn", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("tzm_MA_#Latn", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ug", new String[]{"EEE\u060c MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ug__#Arab", new String[]{"EEE\u060c MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ug_CN_#Arab", new String[]{"EEE\u060c MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("uk", new String[]{"EEE, d MMM", "LLLL y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("uk_UA", new String[]{"EEE, d MMM", "LLLL y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ur", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ur_IN", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("ur_PK", new String[]{"EEE\u060c d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("uz", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("uz__#Arab", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("uz_AF_#Arab", new String[]{"MMM d, EEE", "G y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("uz__#Cyrl", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("uz_UZ_#Cyrl", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("uz__#Latn", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("uz_UZ_#Latn", new String[]{"MMM d, EEE", "y MMMM", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("vai", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("vai__#Latn", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("vai_LR_#Latn", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("vai__#Vaii", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("vai_LR_#Vaii", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("vi", new String[]{"EEE, dd MMM", "MMMM y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("vi_VN", new String[]{"EEE, dd MMM", "MMMM y", "h:mm a", "H:mm"});
        sDateTimePatterns.put("vun", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("vun_TZ", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("xog", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("xog_UG", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("yav", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("yav_CM", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("yo", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("yo_BJ", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("yo_NG", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("zgh", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("zgh_MA", new String[]{"EEE d MMM", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("zh", new String[]{"M\u6708d\u65e5EEE", "y\u5e74M\u6708", "ah:mm", "HH:mm"});
        sDateTimePatterns.put("zh__#Hans", new String[]{"M\u6708d\u65e5EEE", "y\u5e74M\u6708", "ah:mm", "HH:mm"});
        sDateTimePatterns.put("zh_CN_#Hans", new String[]{"M\u6708d\u65e5EEE", "y\u5e74M\u6708", "ah:mm", "HH:mm"});
        sDateTimePatterns.put("zh_HK_#Hans", new String[]{"M\u6708d\u65e5EEE", "y\u5e74M\u6708", "ah:mm", "HH:mm"});
        sDateTimePatterns.put("zh_MO_#Hans", new String[]{"M\u6708d\u65e5EEE", "y\u5e74M\u6708", "ah:mm", "HH:mm"});
        sDateTimePatterns.put("zh_SG_#Hans", new String[]{"M\u6708d\u65e5EEE", "y\u5e74M\u6708", "ah:mm", "HH:mm"});
        sDateTimePatterns.put("zh__#Hant", new String[]{"M\u6708d\u65e5EEE", "y\u5e74M\u6708", "ah:mm", "HH:mm"});
        sDateTimePatterns.put("zh_HK_#Hant", new String[]{"M\u6708d\u65e5 (EEE)", "y \u5e74 M \u6708", "ah:mm", "HH:mm"});
        sDateTimePatterns.put("zh_MO_#Hant", new String[]{"M\u6708d\u65e5 (EEE)", "y \u5e74 M \u6708", "ah:mm", "HH:mm"});
        sDateTimePatterns.put("zh_TW_#Hant", new String[]{"M\u6708d\u65e5EEE", "y\u5e74M\u6708", "ah:mm", "HH:mm"});
        sDateTimePatterns.put("zu", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
        sDateTimePatterns.put("zu_ZA", new String[]{"EEE, MMM d", "MMMM y", "h:mm a", "HH:mm"});
    }
}

