/*
 * Decompiled with CFR 0.152.
 */
package com.kp.md.picker.common;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import com.kp.md.picker.MPicker;
import com.kp.md.picker.R;
import com.kp.md.picker.common.ButtonLayout;
import com.kp.md.picker.helpers.MOptions;
import com.kp.md.picker.utilities.MUtils;

public class ButtonHandler
implements View.OnClickListener {
    private boolean mIsInLandscapeMode;
    private ButtonLayout mPortraitButtonHandler;
    View mPositiveButtonDP;
    View mPositiveButtonTP;
    View mNegativeButtonDP;
    View mNegativeButtonTP;
    Button mSwitcherButtonDP;
    Button mSwitcherButtonTP;
    Callback mCallback;
    int mIconOverlayColor;
    int mDisabledAlpha;
    int mButtonBarBgColor;

    public ButtonHandler(@NonNull MPicker mPicker) {
        Context context = mPicker.getContext();
        boolean bl = this.mIsInLandscapeMode = context.getResources().getConfiguration().orientation == 2;
        if (this.mIsInLandscapeMode) {
            this.initializeForLandscape(mPicker);
        } else {
            this.mPortraitButtonHandler = (ButtonLayout)mPicker.findViewById(R.id.button_layout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeForLandscape(MPicker mMaterialPicker) {
        ContextThemeWrapper context = MUtils.createThemeWrapper(mMaterialPicker.getContext(), R.attr.mPickerStyle, R.style.MPickerStyleLight, R.attr.spButtonLayoutStyle, R.style.ButtonLayoutStyle);
        Resources res = context.getResources();
        TypedArray a = context.obtainStyledAttributes(R.styleable.ButtonLayout);
        this.mSwitcherButtonDP = (Button)mMaterialPicker.findViewById(R.id.buttonSwitcherDP);
        this.mSwitcherButtonTP = (Button)mMaterialPicker.findViewById(R.id.buttonSwitcherTP);
        Button bPositiveDP = (Button)mMaterialPicker.findViewById(R.id.buttonPositiveDP);
        Button bPositiveTP = (Button)mMaterialPicker.findViewById(R.id.buttonPositiveTP);
        Button bNegativeDP = (Button)mMaterialPicker.findViewById(R.id.buttonNegativeDP);
        Button bNegativeTP = (Button)mMaterialPicker.findViewById(R.id.buttonNegativeTP);
        ImageView ivPositiveDP = (ImageView)mMaterialPicker.findViewById(R.id.imageViewPositiveDP);
        ImageView ivPositiveTP = (ImageView)mMaterialPicker.findViewById(R.id.imageViewPositiveTP);
        ImageView ivNegativeDP = (ImageView)mMaterialPicker.findViewById(R.id.imageViewNegativeDP);
        ImageView ivNegativeTP = (ImageView)mMaterialPicker.findViewById(R.id.imageViewNegativeTP);
        try {
            TypedValue typedValueDisabledAlpha = new TypedValue();
            context.getTheme().resolveAttribute(0x1010033, typedValueDisabledAlpha, true);
            this.mDisabledAlpha = typedValueDisabledAlpha.type == 4 ? (int)(typedValueDisabledAlpha.getFloat() * 255.0f) : 122;
            int presentation = a.getInt(R.styleable.ButtonLayout_spPresentation, 0);
            int bgColor = a.getColor(R.styleable.ButtonLayout_spButtonBgColor, MUtils.COLOR_BUTTON_NORMAL);
            int pressedBgColor = a.getColor(R.styleable.ButtonLayout_spButtonPressedBgColor, MUtils.COLOR_CONTROL_HIGHLIGHT);
            this.mButtonBarBgColor = a.getColor(R.styleable.ButtonLayout_spButtonBarBgColor, 0);
            int buttonInvertedBgColor = a.getColor(R.styleable.ButtonLayout_spButtonInvertedBgColor, MUtils.COLOR_ACCENT);
            int buttonPressedInvertedBgColor = a.getColor(R.styleable.ButtonLayout_spButtonPressedInvertedBgColor, ContextCompat.getColor((Context)context, (int)R.color.sp_ripple_material_dark));
            MUtils.setViewBackground((View)this.mSwitcherButtonDP, MUtils.createButtonBg((Context)context, buttonInvertedBgColor, buttonPressedInvertedBgColor));
            MUtils.setViewBackground((View)this.mSwitcherButtonTP, MUtils.createButtonBg((Context)context, buttonInvertedBgColor, buttonPressedInvertedBgColor));
            if (presentation == 0) {
                bPositiveDP.setVisibility(0);
                bPositiveTP.setVisibility(0);
                bNegativeDP.setVisibility(0);
                bNegativeTP.setVisibility(0);
                bPositiveDP.setText((CharSequence)res.getString(R.string.ok));
                bPositiveTP.setText((CharSequence)res.getString(R.string.ok));
                bNegativeDP.setText((CharSequence)res.getString(R.string.cancel));
                bNegativeTP.setText((CharSequence)res.getString(R.string.cancel));
                MUtils.setViewBackground((View)bPositiveDP, MUtils.createButtonBg((Context)context, bgColor, pressedBgColor));
                MUtils.setViewBackground((View)bPositiveTP, MUtils.createButtonBg((Context)context, bgColor, pressedBgColor));
                MUtils.setViewBackground((View)bNegativeDP, MUtils.createButtonBg((Context)context, bgColor, pressedBgColor));
                MUtils.setViewBackground((View)bNegativeTP, MUtils.createButtonBg((Context)context, bgColor, pressedBgColor));
                this.mPositiveButtonDP = bPositiveDP;
                this.mPositiveButtonTP = bPositiveTP;
                this.mNegativeButtonDP = bNegativeDP;
                this.mNegativeButtonTP = bNegativeTP;
            } else {
                ivPositiveDP.setVisibility(0);
                ivPositiveTP.setVisibility(0);
                ivNegativeDP.setVisibility(0);
                ivNegativeTP.setVisibility(0);
                this.mIconOverlayColor = a.getColor(R.styleable.ButtonLayout_spIconColor, MUtils.COLOR_ACCENT);
                ivPositiveDP.setColorFilter(this.mIconOverlayColor, PorterDuff.Mode.MULTIPLY);
                ivPositiveTP.setColorFilter(this.mIconOverlayColor, PorterDuff.Mode.MULTIPLY);
                ivNegativeDP.setColorFilter(this.mIconOverlayColor, PorterDuff.Mode.MULTIPLY);
                ivNegativeTP.setColorFilter(this.mIconOverlayColor, PorterDuff.Mode.MULTIPLY);
                MUtils.setViewBackground((View)ivPositiveDP, MUtils.createImageViewBg(bgColor, pressedBgColor));
                MUtils.setViewBackground((View)ivPositiveTP, MUtils.createImageViewBg(bgColor, pressedBgColor));
                MUtils.setViewBackground((View)ivNegativeDP, MUtils.createImageViewBg(bgColor, pressedBgColor));
                MUtils.setViewBackground((View)ivNegativeTP, MUtils.createImageViewBg(bgColor, pressedBgColor));
                this.mPositiveButtonDP = ivPositiveDP;
                this.mPositiveButtonTP = ivPositiveTP;
                this.mNegativeButtonDP = ivNegativeDP;
                this.mNegativeButtonTP = ivNegativeTP;
            }
        }
        finally {
            a.recycle();
        }
        this.mPositiveButtonDP.setOnClickListener((View.OnClickListener)this);
        this.mPositiveButtonTP.setOnClickListener((View.OnClickListener)this);
        this.mNegativeButtonDP.setOnClickListener((View.OnClickListener)this);
        this.mNegativeButtonTP.setOnClickListener((View.OnClickListener)this);
        this.mSwitcherButtonDP.setOnClickListener((View.OnClickListener)this);
        this.mSwitcherButtonTP.setOnClickListener((View.OnClickListener)this);
    }

    public void applyOptions(boolean switcherRequired, @NonNull Callback callback) {
        this.mCallback = callback;
        if (this.mIsInLandscapeMode) {
            this.mSwitcherButtonDP.setVisibility(switcherRequired ? 0 : 8);
            this.mSwitcherButtonTP.setVisibility(switcherRequired ? 0 : 8);
        } else {
            this.mPortraitButtonHandler.applyOptions(switcherRequired, callback);
        }
    }

    public boolean isSwitcherButtonEnabled() {
        return this.mIsInLandscapeMode ? this.mSwitcherButtonDP.getVisibility() == 0 || this.mSwitcherButtonTP.getVisibility() == 0 : this.mPortraitButtonHandler.isSwitcherButtonEnabled();
    }

    public void updateSwitcherText(@NonNull MOptions.Picker displayedPicker, CharSequence text) {
        if (this.mIsInLandscapeMode) {
            if (displayedPicker == MOptions.Picker.DATE_PICKER) {
                this.mSwitcherButtonDP.setText(text);
            } else if (displayedPicker == MOptions.Picker.TIME_PICKER) {
                this.mSwitcherButtonTP.setText(text);
            }
        } else {
            this.mPortraitButtonHandler.updateSwitcherText(text);
        }
    }

    public void updateValidity(boolean valid) {
        if (this.mIsInLandscapeMode) {
            this.mPositiveButtonDP.setEnabled(valid);
            this.mPositiveButtonTP.setEnabled(valid);
            if (this.mPositiveButtonDP instanceof ImageView) {
                int color2 = this.mIconOverlayColor;
                if (!valid) {
                    color2 = this.mDisabledAlpha << 24 | this.mIconOverlayColor & 0xFFFFFF;
                }
                ((ImageView)this.mPositiveButtonDP).setColorFilter(color2, PorterDuff.Mode.MULTIPLY);
                ((ImageView)this.mPositiveButtonTP).setColorFilter(color2, PorterDuff.Mode.MULTIPLY);
            }
        } else {
            this.mPortraitButtonHandler.updateValidity(valid);
        }
    }

    public void onClick(View v) {
        if (v == this.mPositiveButtonDP || v == this.mPositiveButtonTP) {
            this.mCallback.onOkay();
        } else if (v == this.mNegativeButtonDP || v == this.mNegativeButtonTP) {
            this.mCallback.onCancel();
        } else if (v == this.mSwitcherButtonDP || v == this.mSwitcherButtonTP) {
            this.mCallback.onSwitch();
        }
    }

    public static interface Callback {
        public void onOkay();

        public void onCancel();

        public void onSwitch();
    }
}

