/*
 * Decompiled with CFR 0.152.
 */
package com.kp.md.picker;

import android.animation.LayoutTransition;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.kp.md.picker.R;
import com.kp.md.picker.common.ButtonHandler;
import com.kp.md.picker.datepicker.MDatePicker;
import com.kp.md.picker.datepicker.SelectedDate;
import com.kp.md.picker.drawables.OverflowDrawable;
import com.kp.md.picker.helpers.MListenerAdapter;
import com.kp.md.picker.helpers.MOptions;
import com.kp.md.picker.recurrencepicker.MRecurrencePicker;
import com.kp.md.picker.timepicker.MTimePicker;
import com.kp.md.picker.utilities.MUtils;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class MPicker
extends FrameLayout
implements MDatePicker.OnDateChangedListener,
MDatePicker.DatePickerValidationCallback,
MTimePicker.TimePickerValidationCallback {
    private static final String TAG = MPicker.class.getSimpleName();
    private static final long MONTH_IN_MILLIS = 2620800000L;
    private LinearLayout llMainContentHolder;
    private ImageView ivRecurrenceOptionsDP;
    private ImageView ivRecurrenceOptionsTP;
    private MRecurrencePicker mMRecurrencePicker;
    private MRecurrencePicker.RecurrenceOption mCurrentRecurrenceOption = MRecurrencePicker.RecurrenceOption.DOES_NOT_REPEAT;
    private String mRecurrenceRule;
    private MOptions.Picker mCurrentPicker;
    private MOptions.Picker mHiddenPicker;
    private MDatePicker mDatePicker;
    private MTimePicker mTimePicker;
    private MListenerAdapter mListener;
    private MOptions mOptions;
    private ButtonHandler mButtonLayout;
    private boolean mDatePickerValid = true;
    private boolean mTimePickerValid = true;
    private boolean mDatePickerEnabled;
    private boolean mTimePickerEnabled;
    private boolean mRecurrencePickerEnabled;
    private boolean mDatePickerSyncStateCalled;
    private DateFormat mDefaultDateFormatter;
    private DateFormat mDefaultTimeFormatter;
    private final MRecurrencePicker.OnRepeatOptionSetListener mRepeatOptionSetListener = new MRecurrencePicker.OnRepeatOptionSetListener(){

        @Override
        public void onRepeatOptionSet(MRecurrencePicker.RecurrenceOption option, String recurrenceRule) {
            MPicker.this.mCurrentRecurrenceOption = option;
            MPicker.this.mRecurrenceRule = recurrenceRule;
            this.onDone();
        }

        @Override
        public void onDone() {
            if (MPicker.this.mDatePickerEnabled || MPicker.this.mTimePickerEnabled) {
                MPicker.this.updateCurrentPicker();
                MPicker.this.updateDisplay();
            } else {
                MPicker.this.mButtonLayoutCallback.onOkay();
            }
        }
    };
    private final ButtonHandler.Callback mButtonLayoutCallback = new ButtonHandler.Callback(){

        @Override
        public void onOkay() {
            SelectedDate selectedDate = null;
            if (MPicker.this.mDatePickerEnabled) {
                selectedDate = MPicker.this.mDatePicker.getSelectedDate();
            }
            int hour = -1;
            int minute = -1;
            if (MPicker.this.mTimePickerEnabled) {
                hour = MPicker.this.mTimePicker.getCurrentHour();
                minute = MPicker.this.mTimePicker.getCurrentMinute();
            }
            MRecurrencePicker.RecurrenceOption recurrenceOption = MRecurrencePicker.RecurrenceOption.DOES_NOT_REPEAT;
            String recurrenceRule = null;
            if (MPicker.this.mRecurrencePickerEnabled && (recurrenceOption = MPicker.this.mCurrentRecurrenceOption) == MRecurrencePicker.RecurrenceOption.CUSTOM) {
                recurrenceRule = MPicker.this.mRecurrenceRule;
            }
            MPicker.this.mListener.onDateTimeRecurrenceSet(MPicker.this, selectedDate, hour, minute, recurrenceOption, recurrenceRule);
        }

        @Override
        public void onCancel() {
            MPicker.this.mListener.onCancelled();
        }

        @Override
        public void onSwitch() {
            MPicker.this.mCurrentPicker = MPicker.this.mCurrentPicker == MOptions.Picker.DATE_PICKER ? MOptions.Picker.TIME_PICKER : MOptions.Picker.DATE_PICKER;
            MPicker.this.updateDisplay();
        }
    };

    public MPicker(Context context) {
        this(context, null);
    }

    public MPicker(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.mPickerStyle);
    }

    public MPicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super((Context)MPicker.createThemeWrapper(context), attrs, defStyleAttr);
        this.initializeLayout();
    }

    @TargetApi(value=21)
    public MPicker(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super((Context)MPicker.createThemeWrapper(context), attrs, defStyleAttr, defStyleRes);
        this.initializeLayout();
    }

    private static ContextThemeWrapper createThemeWrapper(Context context) {
        TypedArray forParent = context.obtainStyledAttributes(new int[]{R.attr.mPickerStyle});
        int parentStyle = forParent.getResourceId(0, R.style.MPickerStyleLight);
        forParent.recycle();
        return new ContextThemeWrapper(context, parentStyle);
    }

    private void initializeLayout() {
        Context context = this.getContext();
        MUtils.initializeResources(context);
        LayoutInflater.from((Context)context).inflate(R.layout.m_picker_view_layout, (ViewGroup)this, true);
        this.mDefaultDateFormatter = DateFormat.getDateInstance(2, Locale.getDefault());
        this.mDefaultTimeFormatter = DateFormat.getTimeInstance(3, Locale.getDefault());
        this.mDefaultTimeFormatter.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        this.llMainContentHolder = (LinearLayout)this.findViewById(R.id.llMainContentHolder);
        this.mButtonLayout = new ButtonHandler(this);
        this.initializeRecurrencePickerSwitch();
        this.mDatePicker = (MDatePicker)this.findViewById(R.id.datePicker);
        this.mTimePicker = (MTimePicker)this.findViewById(R.id.timePicker);
        this.mMRecurrencePicker = (MRecurrencePicker)this.findViewById(R.id.repeat_option_picker);
    }

    public void initializePicker(MOptions options, MListenerAdapter listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null.");
        }
        if (options != null) {
            options.verifyValidity();
        } else {
            options = new MOptions();
        }
        this.mOptions = options;
        this.mListener = listener;
        this.processOptions();
        this.updateDisplay();
    }

    private void updateHiddenPicker() {
        this.mHiddenPicker = this.mDatePickerEnabled && this.mTimePickerEnabled ? (this.mDatePicker.getVisibility() == 0 ? MOptions.Picker.DATE_PICKER : MOptions.Picker.TIME_PICKER) : (this.mDatePickerEnabled ? MOptions.Picker.DATE_PICKER : (this.mTimePickerEnabled ? MOptions.Picker.TIME_PICKER : MOptions.Picker.INVALID));
    }

    private void updateCurrentPicker() {
        if (this.mHiddenPicker == MOptions.Picker.INVALID) {
            throw new RuntimeException("Logic issue: No valid option for mCurrentPicker");
        }
        this.mCurrentPicker = this.mHiddenPicker;
    }

    private void updateDisplay() {
        if (this.mCurrentPicker == MOptions.Picker.DATE_PICKER) {
            if (this.mTimePickerEnabled) {
                this.mTimePicker.setVisibility(8);
            }
            if (this.mRecurrencePickerEnabled) {
                this.mMRecurrencePicker.setVisibility(8);
            }
            this.mDatePicker.setVisibility(0);
            this.llMainContentHolder.setVisibility(0);
            if (this.mButtonLayout.isSwitcherButtonEnabled()) {
                Date toFormat = new Date((long)this.mTimePicker.getCurrentHour() * 3600000L + (long)this.mTimePicker.getCurrentMinute() * 60000L);
                CharSequence switchButtonText = this.mListener.formatTime(toFormat);
                if (TextUtils.isEmpty((CharSequence)switchButtonText)) {
                    switchButtonText = this.mDefaultTimeFormatter.format(toFormat);
                }
                this.mButtonLayout.updateSwitcherText(MOptions.Picker.DATE_PICKER, switchButtonText);
            }
            if (!this.mDatePickerSyncStateCalled) {
                this.mDatePickerSyncStateCalled = true;
            }
        } else if (this.mCurrentPicker == MOptions.Picker.TIME_PICKER) {
            if (this.mDatePickerEnabled) {
                this.mDatePicker.setVisibility(8);
            }
            if (this.mRecurrencePickerEnabled) {
                this.mMRecurrencePicker.setVisibility(8);
            }
            this.mTimePicker.setVisibility(0);
            this.llMainContentHolder.setVisibility(0);
            if (this.mButtonLayout.isSwitcherButtonEnabled()) {
                SelectedDate selectedDate = this.mDatePicker.getSelectedDate();
                CharSequence switchButtonText = this.mListener.formatDate(selectedDate);
                if (TextUtils.isEmpty((CharSequence)switchButtonText)) {
                    if (selectedDate.getType() == SelectedDate.Type.SINGLE) {
                        Date toFormat = new Date(this.mDatePicker.getSelectedDateInMillis());
                        switchButtonText = this.mDefaultDateFormatter.format(toFormat);
                    } else if (selectedDate.getType() == SelectedDate.Type.RANGE) {
                        switchButtonText = this.formatDateRange(selectedDate);
                    }
                }
                this.mButtonLayout.updateSwitcherText(MOptions.Picker.TIME_PICKER, switchButtonText);
            }
        } else if (this.mCurrentPicker == MOptions.Picker.REPEAT_OPTION_PICKER) {
            this.updateHiddenPicker();
            this.mMRecurrencePicker.updateView();
            if (this.mDatePickerEnabled || this.mTimePickerEnabled) {
                this.llMainContentHolder.setVisibility(8);
            }
            this.mMRecurrencePicker.setVisibility(0);
        }
    }

    private String formatDateRange(SelectedDate selectedDate) {
        Calendar startDate = selectedDate.getStartDate();
        Calendar endDate = selectedDate.getEndDate();
        startDate.set(14, 0);
        startDate.set(13, 0);
        startDate.set(12, 0);
        startDate.set(10, 0);
        endDate.set(14, 0);
        endDate.set(13, 0);
        endDate.set(12, 0);
        endDate.set(10, 0);
        endDate.add(5, 1);
        float elapsedTime = endDate.getTimeInMillis() - startDate.getTimeInMillis();
        if (elapsedTime >= 3.14496E10f) {
            float years = elapsedTime / 3.14496E10f;
            boolean roundUp = years - (float)((int)years) > 0.5f;
            int yearsVal = roundUp ? (int)(years + 1.0f) : (int)years;
            return "~" + yearsVal + " " + (yearsVal == 1 ? "year" : "years");
        }
        if (elapsedTime >= 2.6208E9f) {
            float months = elapsedTime / 2.6208E9f;
            boolean roundUp = months - (float)((int)months) > 0.5f;
            int monthsVal = roundUp ? (int)(months + 1.0f) : (int)months;
            return "~" + monthsVal + " " + (monthsVal == 1 ? "month" : "months");
        }
        float days = elapsedTime / 8.64E7f;
        boolean roundUp = days - (float)((int)days) > 0.5f;
        int daysVal = roundUp ? (int)(days + 1.0f) : (int)days;
        return "~" + daysVal + " " + (daysVal == 1 ? "day" : "days");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRecurrencePickerSwitch() {
        int pressedStateBgColor;
        int iconColor;
        this.ivRecurrenceOptionsDP = (ImageView)this.findViewById(R.id.ivRecurrenceOptionsDP);
        this.ivRecurrenceOptionsTP = (ImageView)this.findViewById(R.id.ivRecurrenceOptionsTP);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(R.styleable.MPicker);
        try {
            iconColor = typedArray.getColor(R.styleable.MPicker_spOverflowIconColor, MUtils.COLOR_TEXT_PRIMARY_INVERSE);
            pressedStateBgColor = typedArray.getColor(R.styleable.MPicker_spOverflowIconPressedBgColor, MUtils.COLOR_TEXT_PRIMARY);
        }
        finally {
            typedArray.recycle();
        }
        this.ivRecurrenceOptionsDP.setImageDrawable((Drawable)new OverflowDrawable(this.getContext(), iconColor));
        MUtils.setViewBackground((View)this.ivRecurrenceOptionsDP, MUtils.createOverflowButtonBg(pressedStateBgColor));
        this.ivRecurrenceOptionsTP.setImageDrawable((Drawable)new OverflowDrawable(this.getContext(), iconColor));
        MUtils.setViewBackground((View)this.ivRecurrenceOptionsTP, MUtils.createOverflowButtonBg(pressedStateBgColor));
        this.ivRecurrenceOptionsDP.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MPicker.this.mCurrentPicker = MOptions.Picker.REPEAT_OPTION_PICKER;
                MPicker.this.updateDisplay();
            }
        });
        this.ivRecurrenceOptionsTP.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MPicker.this.mCurrentPicker = MOptions.Picker.REPEAT_OPTION_PICKER;
                MPicker.this.updateDisplay();
            }
        });
    }

    protected Parcelable onSaveInstanceState() {
        return new SavedState(super.onSaveInstanceState(), this.mCurrentPicker, this.mHiddenPicker, this.mCurrentRecurrenceOption, this.mRecurrenceRule);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        View.BaseSavedState bss = (View.BaseSavedState)state;
        super.onRestoreInstanceState(bss.getSuperState());
        SavedState ss = (SavedState)bss;
        this.mCurrentPicker = ss.getCurrentPicker();
        this.mCurrentRecurrenceOption = ss.getCurrentRepeatOption();
        this.mRecurrenceRule = ss.getRecurrenceRule();
        this.mHiddenPicker = ss.getHiddenPicker();
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        super.dispatchRestoreInstanceState(container);
        this.updateDisplay();
    }

    private void processOptions() {
        if (this.mOptions.animateLayoutChanges()) {
            LayoutTransition layoutTransition = new LayoutTransition();
            if (MUtils.isApi_16_OrHigher()) {
                layoutTransition.enableTransitionType(4);
            }
            this.setLayoutTransition(layoutTransition);
        } else {
            this.setLayoutTransition(null);
        }
        this.mDatePickerEnabled = this.mOptions.isDatePickerActive();
        this.mTimePickerEnabled = this.mOptions.isTimePickerActive();
        this.mRecurrencePickerEnabled = this.mOptions.isRecurrencePickerActive();
        if (this.mDatePickerEnabled) {
            this.mDatePicker.init(this.mOptions.getDateParams(), this.mOptions.canPickDateRange(), this);
            long[] dateRange = this.mOptions.getDateRange();
            if (dateRange[0] != Long.MIN_VALUE) {
                this.mDatePicker.setMinDate(dateRange[0]);
            }
            if (dateRange[1] != Long.MIN_VALUE) {
                this.mDatePicker.setMaxDate(dateRange[1]);
            }
            this.mDatePicker.setValidationCallback(this);
            this.ivRecurrenceOptionsDP.setVisibility(this.mRecurrencePickerEnabled ? 0 : 8);
        } else {
            this.llMainContentHolder.removeView((View)this.mDatePicker);
            this.mDatePicker = null;
        }
        if (this.mTimePickerEnabled) {
            int[] timeParams = this.mOptions.getTimeParams();
            this.mTimePicker.setCurrentHour(timeParams[0]);
            this.mTimePicker.setCurrentMinute(timeParams[1]);
            this.mTimePicker.setIs24HourView(this.mOptions.is24HourView());
            this.mTimePicker.setValidationCallback(this);
            this.ivRecurrenceOptionsTP.setVisibility(this.mRecurrencePickerEnabled ? 0 : 8);
        } else {
            this.llMainContentHolder.removeView((View)this.mTimePicker);
            this.mTimePicker = null;
        }
        if (this.mDatePickerEnabled && this.mTimePickerEnabled) {
            this.mButtonLayout.applyOptions(true, this.mButtonLayoutCallback);
        } else {
            this.mButtonLayout.applyOptions(false, this.mButtonLayoutCallback);
        }
        if (!this.mDatePickerEnabled && !this.mTimePickerEnabled) {
            this.removeView((View)this.llMainContentHolder);
            this.llMainContentHolder = null;
            this.mButtonLayout = null;
        }
        if (this.mRecurrencePickerEnabled) {
            Calendar cal = this.mDatePickerEnabled ? this.mDatePicker.getSelectedDate().getStartDate() : MUtils.getCalendarForLocale(null, Locale.getDefault());
            this.mMRecurrencePicker.initializeData(this.mRepeatOptionSetListener, this.mCurrentRecurrenceOption, this.mRecurrenceRule, cal.getTimeInMillis());
        } else {
            this.removeView((View)this.mMRecurrencePicker);
            this.mMRecurrencePicker = null;
        }
        this.mCurrentPicker = this.mOptions.getPickerToShow();
        this.mHiddenPicker = MOptions.Picker.INVALID;
    }

    private void reassessValidity() {
        this.mButtonLayout.updateValidity(this.mDatePickerValid && this.mTimePickerValid);
    }

    @Override
    public void onDateChanged(MDatePicker view, SelectedDate selectedDate) {
        this.mDatePicker.init(selectedDate, this.mOptions.canPickDateRange(), this);
    }

    @Override
    public void onDatePickerValidationChanged(boolean valid) {
        this.mDatePickerValid = valid;
        this.reassessValidity();
    }

    @Override
    public void onTimePickerValidationChanged(boolean valid) {
        this.mTimePickerValid = valid;
        this.reassessValidity();
    }

    private static class SavedState
    extends View.BaseSavedState {
        private final MOptions.Picker sCurrentPicker;
        private final MOptions.Picker sHiddenPicker;
        private final MRecurrencePicker.RecurrenceOption sCurrentRecurrenceOption;
        private final String sRecurrenceRule;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, MOptions.Picker currentPicker, MOptions.Picker hiddenPicker, MRecurrencePicker.RecurrenceOption recurrenceOption, String recurrenceRule) {
            super(superState);
            this.sCurrentPicker = currentPicker;
            this.sHiddenPicker = hiddenPicker;
            this.sCurrentRecurrenceOption = recurrenceOption;
            this.sRecurrenceRule = recurrenceRule;
        }

        private SavedState(Parcel in) {
            super(in);
            this.sCurrentPicker = MOptions.Picker.valueOf(in.readString());
            this.sHiddenPicker = MOptions.Picker.valueOf(in.readString());
            this.sCurrentRecurrenceOption = MRecurrencePicker.RecurrenceOption.valueOf(in.readString());
            this.sRecurrenceRule = in.readString();
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeString(this.sCurrentPicker.name());
            dest.writeString(this.sHiddenPicker.name());
            dest.writeString(this.sCurrentRecurrenceOption.name());
            dest.writeString(this.sRecurrenceRule);
        }

        public MOptions.Picker getCurrentPicker() {
            return this.sCurrentPicker;
        }

        public MOptions.Picker getHiddenPicker() {
            return this.sHiddenPicker;
        }

        public MRecurrencePicker.RecurrenceOption getCurrentRepeatOption() {
            return this.sCurrentRecurrenceOption;
        }

        public String getRecurrenceRule() {
            return this.sRecurrenceRule;
        }
    }
}

