/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.impl;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.util.ArrayMap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.util.DialogXFloatingWindowActivity;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;

public class ActivityLifecycleImpl
implements Application.ActivityLifecycleCallbacks {
    private onActivityResumeCallBack onActivityResumeCallBack;
    private static ActivityLifecycleImpl activityLifecycle;
    private static Application application;

    public ActivityLifecycleImpl(onActivityResumeCallBack onActivityResumeCallBack2) {
        this.onActivityResumeCallBack = onActivityResumeCallBack2;
    }

    public static void init(Context context, onActivityResumeCallBack onActivityResumeCallBack2) {
        if (context != null) {
            Application application = ActivityLifecycleImpl.getApplicationContext(context);
            if (application == null) {
                DialogX.error("DialogX \u672a\u521d\u59cb\u5316(E1)\u3002\n\u8bf7\u68c0\u67e5\u662f\u5426\u5728\u542f\u52a8\u5bf9\u8bdd\u6846\u524d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\uff0c\u4f7f\u7528\u4ee5\u4e0b\u4ee3\u7801\u8fdb\u884c\u521d\u59cb\u5316\uff1a\nDialogX.init(context);\n\n\u53e6\u5916\u5efa\u8bae\u60a8\u524d\u5f80\u67e5\u770b DialogX \u7684\u6587\u6863\u8fdb\u884c\u4f7f\u7528\uff1ahttps://github.com/kongzue/DialogX");
                return;
            }
            ActivityLifecycleImpl.application = application;
            if (activityLifecycle != null) {
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityLifecycle);
            }
            activityLifecycle = new ActivityLifecycleImpl(onActivityResumeCallBack2);
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityLifecycle);
        } else if (application != null) {
            ActivityLifecycleImpl.init((Context)application, onActivityResumeCallBack2);
        }
    }

    public static Application getApplicationContext(Context context) {
        if (context != null) {
            return (Application)context.getApplicationContext();
        }
        try {
            Application application = (Application)Class.forName("android.app.ActivityThread").getMethod("currentApplication", new Class[0]).invoke(null, (Object[])null);
            return application;
        }
        catch (Exception application) {
            try {
                Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
                Object activityThread = activityThreadClass.getDeclaredMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
                Method getApplicationMethod = activityThreadClass.getDeclaredMethod("getApplication", new Class[0]);
                Application application2 = (Application)getApplicationMethod.invoke(activityThread, new Object[0]);
                return application2;
            }
            catch (Exception activityThreadClass) {
                try {
                    Application application3 = (Application)Class.forName("android.app.AppGlobals").getMethod("getInitialApplication", new Class[0]).invoke(null, (Object[])null);
                    return application3;
                }
                catch (Exception exception) {
                    DialogX.error("DialogX.init: \u521d\u59cb\u5316\u5f02\u5e38\uff0c\u8bf7\u786e\u4fddinit\u65b9\u6cd5\u5185\u4f20\u5165\u7684Context\u662f\u6709\u6548\u7684\u3002");
                    return null;
                }
            }
        }
    }

    public static Application getApplicationContext() {
        if (application != null) {
            return application;
        }
        try {
            Application application = (Application)Class.forName("android.app.ActivityThread").getMethod("currentApplication", new Class[0]).invoke(null, (Object[])null);
            return application;
        }
        catch (Exception application) {
            try {
                Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
                Object activityThread = activityThreadClass.getDeclaredMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
                Method getApplicationMethod = activityThreadClass.getDeclaredMethod("getApplication", new Class[0]);
                Application application2 = (Application)getApplicationMethod.invoke(activityThread, new Object[0]);
                return application2;
            }
            catch (Exception activityThreadClass) {
                try {
                    Application application3 = (Application)Class.forName("android.app.AppGlobals").getMethod("getInitialApplication", new Class[0]).invoke(null, (Object[])null);
                    return application3;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
    }

    public static Activity getTopActivity() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Object activityThread = activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            Field activitiesField = activityThreadClass.getDeclaredField("mActivities");
            activitiesField.setAccessible(true);
            HashMap activities = Build.VERSION.SDK_INT < 19 ? (HashMap)activitiesField.get(activityThread) : (ArrayMap)activitiesField.get(activityThread);
            if (activities.size() < 1) {
                return null;
            }
            for (Object activityRecord : activities.values()) {
                Class<?> activityRecordClass = activityRecord.getClass();
                Field pausedField = activityRecordClass.getDeclaredField("paused");
                pausedField.setAccessible(true);
                if (pausedField.getBoolean(activityRecord)) continue;
                Field activityField = activityRecordClass.getDeclaredField("activity");
                activityField.setAccessible(true);
                Activity activity = (Activity)activityField.get(activityRecord);
                return activity;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        if (this.onActivityResumeCallBack != null) {
            if (activity instanceof DialogXFloatingWindowActivity) {
                return;
            }
            this.onActivityResumeCallBack.getActivity(activity);
        }
    }

    public void onActivityStarted(@NonNull Activity activity) {
        if (application == null) {
            BaseDialog.init((Context)activity);
        }
    }

    public void onActivityPreResumed(@NonNull Activity activity) {
        super.onActivityPreResumed(activity);
        if (Build.VERSION.SDK_INT >= 29) {
            this.callOnResume(activity);
        }
    }

    public void onActivityResumed(@NonNull Activity activity) {
        if (activity.isDestroyed() || activity.isFinishing() || activity instanceof DialogXFloatingWindowActivity) {
            return;
        }
        if (Build.VERSION.SDK_INT < 29) {
            this.callOnResume(activity);
        }
        BaseDialog.onActivityResume(activity);
    }

    private void callOnResume(Activity activity) {
        if (activity.isDestroyed() || activity.isFinishing() || activity instanceof DialogXFloatingWindowActivity) {
            return;
        }
        if (this.onActivityResumeCallBack != null) {
            this.onActivityResumeCallBack.getActivity(activity);
        }
    }

    public void onActivityPaused(@NonNull Activity activity) {
    }

    public void onActivityStopped(@NonNull Activity activity) {
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
        if (BaseDialog.getTopActivity() == activity) {
            BaseDialog.cleanContext();
        }
        if (Build.VERSION.SDK_INT < 29) {
            BaseDialog.recycleDialog(activity);
        }
    }

    public void onActivityPreDestroyed(@NonNull Activity activity) {
        if (Build.VERSION.SDK_INT >= 29) {
            BaseDialog.recycleDialog(activity);
        }
    }

    public static boolean isExemptActivities(Activity activity) {
        if (activity == null) {
            return true;
        }
        for (String packageName : DialogX.unsupportedActivitiesPackageNames) {
            if (!activity.getClass().getName().contains(packageName)) continue;
            return true;
        }
        return false;
    }

    public static interface onActivityResumeCallBack {
        public void getActivity(Activity var1);
    }
}

