/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import kong.unirest.core.json.JSONException;
import kong.unirest.core.json.JsonEngine;
import kong.unirest.jackson.JacksonArray;
import kong.unirest.jackson.JacksonObject;
import kong.unirest.jackson.JacksonPrimitive;

class JacksonElement<T extends JsonNode>
implements JsonEngine.Element {
    protected T element;

    JacksonElement(T element) {
        this.element = element;
    }

    static JsonEngine.Element wrap(JsonNode node) {
        if (node == null || node.isNull()) {
            return new JacksonPrimitive((ValueNode)NullNode.getInstance());
        }
        if (node.isArray()) {
            return new JacksonArray((ArrayNode)node);
        }
        if (node.isObject()) {
            return new JacksonObject((ObjectNode)node);
        }
        if (node.isValueNode()) {
            return new JacksonPrimitive((ValueNode)node);
        }
        return new JacksonPrimitive((ValueNode)NullNode.getInstance());
    }

    public JsonEngine.Object getAsJsonObject() {
        if (this.element.isObject()) {
            return new JacksonObject((ObjectNode)this.element);
        }
        throw new IllegalStateException("Not an object");
    }

    public boolean isJsonNull() {
        return this.element instanceof NullNode;
    }

    public JsonEngine.Primitive getAsJsonPrimitive() {
        return new JacksonPrimitive((ValueNode)this.element);
    }

    public JsonEngine.Array getAsJsonArray() {
        if (!this.element.isArray()) {
            throw new IllegalStateException("Not an Array");
        }
        return new JacksonArray((ArrayNode)this.element);
    }

    public float getAsFloat() {
        if (!this.element.isFloat()) {
            throw new NumberFormatException("not a float");
        }
        return this.element.floatValue();
    }

    public double getAsDouble() {
        if (!this.element.isNumber()) {
            throw new NumberFormatException("not a double");
        }
        return this.element.asDouble();
    }

    public String getAsString() {
        return this.element.asText();
    }

    public long getAsLong() {
        if (!this.element.isLong() && !this.element.isIntegralNumber()) {
            throw new NumberFormatException("not a long");
        }
        return this.element.asLong();
    }

    public int getAsInt() {
        if (!this.element.isIntegralNumber()) {
            throw new NumberFormatException("Not a number");
        }
        return this.element.asInt();
    }

    public boolean getAsBoolean() {
        return this.element.asBoolean();
    }

    public BigInteger getAsBigInteger() {
        if (!this.element.isIntegralNumber()) {
            throw new NumberFormatException("Not a integer");
        }
        return this.element.bigIntegerValue();
    }

    public BigDecimal getAsBigDecimal() {
        if (!this.element.isNumber()) {
            throw new NumberFormatException("Not a decimal");
        }
        return this.element.decimalValue();
    }

    public JsonEngine.Primitive getAsPrimitive() {
        if (this.element.isValueNode()) {
            return new JacksonPrimitive((ValueNode)this.element);
        }
        throw new JSONException("Not a value type");
    }

    public boolean isJsonArray() {
        return this.element.isArray();
    }

    public boolean isJsonPrimitive() {
        return this.element.isValueNode();
    }

    public boolean isJsonObject() {
        return this.element.isObject();
    }

    public <T> T getEngineElement() {
        return this.element;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JacksonElement that = (JacksonElement)o;
        return Objects.equals(this.element, that.element);
    }

    public int hashCode() {
        return Objects.hash(this.element);
    }
}

