/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import kong.unirest.core.Config;
import kong.unirest.core.GetRequest;
import kong.unirest.core.HttpMethod;
import kong.unirest.core.HttpRequestBody;
import kong.unirest.core.HttpRequestJsonPatch;
import kong.unirest.core.HttpRequestNoBody;
import kong.unirest.core.HttpRequestWithBody;
import kong.unirest.core.JsonPatchRequest;
import kong.unirest.core.SseRequestImpl;
import kong.unirest.core.WebSocketRequest;
import kong.unirest.core.WebSocketRequestImpl;

public class UnirestInstance
implements AutoCloseable {
    private final Config config;

    public UnirestInstance(Config config) {
        this.config = config;
    }

    public Config config() {
        return this.config;
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean clearOptions) {
        this.config.reset(clearOptions);
    }

    public GetRequest get(String url) {
        return new HttpRequestNoBody(this.config, HttpMethod.GET, url);
    }

    public GetRequest head(String url) {
        return new HttpRequestNoBody(this.config, HttpMethod.HEAD, url);
    }

    public GetRequest options(String url) {
        return new HttpRequestNoBody(this.config, HttpMethod.OPTIONS, url);
    }

    public HttpRequestWithBody post(String url) {
        return new HttpRequestBody(this.config, HttpMethod.POST, url);
    }

    public HttpRequestWithBody delete(String url) {
        return new HttpRequestBody(this.config, HttpMethod.DELETE, url);
    }

    public HttpRequestWithBody patch(String url) {
        return new HttpRequestBody(this.config, HttpMethod.PATCH, url);
    }

    public HttpRequestWithBody put(String url) {
        return new HttpRequestBody(this.config, HttpMethod.PUT, url);
    }

    public JsonPatchRequest jsonPatch(String url) {
        return new HttpRequestJsonPatch(this.config, url);
    }

    public HttpRequestWithBody request(String method, String url) {
        return new HttpRequestBody(this.config, HttpMethod.valueOf(method), url);
    }

    @Override
    public void close() {
        this.reset(true);
    }

    public WebSocketRequest webSocket(String url) {
        return new WebSocketRequestImpl(this.config, url);
    }

    public SseRequestImpl sse(String url) {
        return new SseRequestImpl(this.config, url);
    }
}

