/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core.java;

import java.net.http.HttpRequest;
import java.util.Objects;
import kong.unirest.core.Headers;

class Part {
    private final Headers headers;
    private final HttpRequest.BodyPublisher bodyPublisher;
    private final String fieldName;
    private final String filename;

    Part(String fieldName, String filename, HttpRequest.BodyPublisher bodyPublisher) {
        Objects.requireNonNull(bodyPublisher, "bodyPublisher");
        this.fieldName = fieldName;
        this.filename = filename;
        this.headers = Part.getFormHeaders(fieldName, filename);
        this.bodyPublisher = bodyPublisher;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFilename() {
        return this.filename;
    }

    public Headers headers() {
        return this.headers;
    }

    public HttpRequest.BodyPublisher bodyPublisher() {
        return this.bodyPublisher;
    }

    private static Headers getFormHeaders(String name, String filename) {
        StringBuilder disposition = new StringBuilder();
        Part.appendEscaped(disposition.append("form-data; name="), name);
        if (filename != null) {
            Part.appendEscaped(disposition.append("; filename="), filename);
        }
        Headers headers = new Headers();
        headers.add("Content-Disposition", disposition.toString());
        return headers;
    }

    private static void appendEscaped(StringBuilder target, String field) {
        target.append("\"");
        int len = field.length();
        for (int i = 0; i < len; ++i) {
            char c = field.charAt(i);
            if (c == '\\' || c == '\"') {
                target.append('\\');
            }
            target.append(c);
        }
        target.append("\"");
    }
}

