/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.hash.HashOverflowException;
import com.koloboke.collect.impl.CharArrays;
import com.koloboke.collect.impl.PrimitiveConstants;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.HashConfigWrapper;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVCharQHash;
import com.koloboke.collect.impl.hash.UpdatableQHash;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public abstract class UpdatableSeparateKVCharQHashSO
extends UpdatableQHash
implements SeparateKVCharQHash,
PrimitiveConstants,
UnsafeConstants {
    char freeValue;
    char[] set;

    void copy(SeparateKVCharQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = (char[])hash.keys().clone();
    }

    void move(SeparateKVCharQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = hash.keys();
    }

    final void init(HashConfigWrapper configWrapper, int size, char freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public char freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public char removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains(((Character)key).charValue());
    }

    public boolean contains(char key) {
        return this.index(key) >= 0;
    }

    int index(char key) {
        char free = this.freeValue;
        if (key != free) {
            char[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVCharKeyMixing.mix((char)key) % capacity;
            char cur = keys[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == key) {
                    return bIndex;
                }
                if (cur == free) {
                    return -1;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == key) {
                    return fIndex;
                }
                if (cur == free) {
                    return -1;
                }
                step += 2;
            }
        }
        return -1;
    }

    private char findNewFreeOrRemoved() {
        char newFree;
        block6: {
            int mc = this.modCount();
            int size = this.size();
            if (size >= 65535) {
                throw new HashOverflowException();
            }
            char free = this.freeValue;
            ThreadLocalRandom random = ThreadLocalRandom.current();
            if (size > 49152) {
                int nf = ((Random)random).nextInt(65536) * 21859;
                for (int i = 0; i < 65536; ++i) {
                    newFree = (char)(nf += 21859);
                    if (newFree == free || this.index(newFree) >= 0) {
                        continue;
                    }
                    break block6;
                }
                if (mc != this.modCount()) {
                    throw new ConcurrentModificationException();
                }
                throw new AssertionError((Object)"Impossible state");
            }
            while ((newFree = (char)((Random)random).nextInt()) == free || this.index(newFree) >= 0) {
            }
        }
        return newFree;
    }

    char changeFree() {
        int mc = this.modCount();
        char newFree = this.findNewFreeOrRemoved();
        this.incrementModCount();
        CharArrays.replaceAll((char[])this.set, (char)this.freeValue, (char)newFree);
        this.freeValue = newFree;
        if (++mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newFree;
    }

    @Override
    void allocateArrays(int capacity) {
        this.set = new char[capacity];
        if (this.freeValue != '\u0000') {
            Arrays.fill(this.set, this.freeValue);
        }
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.set, this.freeValue);
    }
}

