/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.ByteCollection;
import com.koloboke.collect.ByteCursor;
import com.koloboke.collect.ByteIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractByteValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjByteMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjByteMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.MutableQHashSeparateKVObjByteMapSO;
import com.koloboke.collect.impl.hash.ObjHash;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVObjByteQHash;
import com.koloboke.collect.map.ObjByteCursor;
import com.koloboke.collect.set.ByteSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.ByteBinaryOperator;
import com.koloboke.function.ByteConsumer;
import com.koloboke.function.BytePredicate;
import com.koloboke.function.ObjByteConsumer;
import com.koloboke.function.ObjBytePredicate;
import com.koloboke.function.ObjByteToByteFunction;
import com.koloboke.function.ToByteFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class MutableQHashSeparateKVObjByteMapGO<K>
extends MutableQHashSeparateKVObjByteMapSO<K> {
    @Override
    final void copy(SeparateKVObjByteQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVObjByteQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public byte defaultValue() {
        return 0;
    }

    public boolean containsEntry(Object key, byte value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Byte get(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public byte getByte(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    public Byte getOrDefault(Object key, Byte defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public byte getOrDefault(Object key, byte defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super K, ? super Byte> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        byte[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                action.accept(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                action.accept(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void forEach(ObjByteConsumer<? super K> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        byte[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                action.accept(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                action.accept(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean forEachWhile(ObjBytePredicate<? super K> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        byte[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ObjByteCursor<K> cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonObjByteMapOps.containsAllEntries((InternalObjByteMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalObjByteMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        Object[] keys = this.set;
        byte[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalObjByteMapOps<? super K> m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        byte[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                m.justPut(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                m.justPut(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<K, Byte>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ByteCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        byte[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                hashCode += this.nullableKeyHashCode(key) ^ vals[i];
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                hashCode += this.nullableKeyHashCode(key) ^ vals[i];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        byte[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Map)");
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Map)");
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        Object[] keys = this.set;
        byte[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        Object[] newKeys = this.set;
        int capacity = newKeys.length;
        byte[] newVals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                int index = QHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(key)) % capacity;
                if (newKeys[index] != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                int index = QHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(key)) % capacity;
                if (newKeys[index] != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Byte put(K key, Byte value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        byte[] vals = this.values;
        byte prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    public byte put(K key, byte value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        byte[] vals = this.values;
        byte prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    public Byte putIfAbsent(K key, Byte value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    public byte putIfAbsent(K key, byte value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    public void justPut(K key, byte value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    public Byte compute(K key, BiFunction<? super K, ? super Byte, ? extends Byte> remappingFunction) {
        block31: {
            Byte newValue;
            int index;
            byte[] vals;
            block29: {
                Byte newValue2;
                block30: {
                    Byte newValue3;
                    int firstRemoved;
                    Object cur;
                    int capacity;
                    Object[] keys;
                    block33: {
                        block32: {
                            if (key == null) break block31;
                            if (remappingFunction == null) {
                                throw new NullPointerException();
                            }
                            keys = this.set;
                            vals = this.values;
                            capacity = keys.length;
                            index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) % capacity;
                            cur = keys[index];
                            if (cur == key) break block29;
                            if (cur == FREE) break block30;
                            if (cur == REMOVED) break block32;
                            if (this.keyEquals(key, cur)) break block29;
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block30;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block30;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                            break block33;
                        }
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block29;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block30;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block29;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block29;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block30;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block29;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    if ((newValue3 = remappingFunction.apply(key, null)) != null) {
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = newValue3;
                        this.postRemovedSlotInsertHook();
                        return newValue3;
                    }
                    return null;
                }
                if ((newValue2 = remappingFunction.apply(key, null)) != null) {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = newValue2;
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
            if ((newValue = remappingFunction.apply(key, vals[index])) != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.incrementModCount();
            keys[index] = REMOVED;
            this.postRemoveHook();
            return null;
        }
        return this.computeNullKey(remappingFunction);
    }

    Byte computeNullKey(BiFunction<? super K, ? super Byte, ? extends Byte> remappingFunction) {
        Byte newValue;
        int index;
        byte[] vals;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                Byte newValue2;
                block26: {
                    if (cur != FREE) {
                        Byte newValue3;
                        int firstRemoved;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == null) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == null) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply(null, null)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = null;
                            vals[firstRemoved] = newValue3;
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply(null, null)) != null) {
                    this.incrementModCount();
                    keys[index] = null;
                    vals[index] = newValue2;
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(null, vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return null;
    }

    public byte compute(K key, ObjByteToByteFunction<? super K> remappingFunction) {
        block28: {
            byte newValue;
            int index;
            byte[] vals;
            block26: {
                block27: {
                    int firstRemoved;
                    Object cur;
                    int capacity;
                    Object[] keys;
                    block30: {
                        block29: {
                            if (key == null) break block28;
                            if (remappingFunction == null) {
                                throw new NullPointerException();
                            }
                            keys = this.set;
                            vals = this.values;
                            capacity = keys.length;
                            index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) % capacity;
                            cur = keys[index];
                            if (cur == key) break block26;
                            if (cur == FREE) break block27;
                            if (cur == REMOVED) break block29;
                            if (this.keyEquals(key, cur)) break block26;
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                            break block30;
                        }
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block26;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block27;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block26;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block26;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block27;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block26;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    byte newValue2 = remappingFunction.applyAsByte(key, this.defaultValue());
                    this.incrementModCount();
                    keys[firstRemoved] = key;
                    vals[firstRemoved] = newValue2;
                    this.postRemovedSlotInsertHook();
                    return newValue2;
                }
                newValue = remappingFunction.applyAsByte(key, this.defaultValue());
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
            vals[index] = newValue = remappingFunction.applyAsByte(key, vals[index]);
            return newValue;
        }
        return this.computeNullKey(remappingFunction);
    }

    byte computeNullKey(ObjByteToByteFunction<? super K> remappingFunction) {
        byte newValue;
        int index;
        byte[] vals;
        block22: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                block23: {
                    if (cur != FREE) {
                        int firstRemoved;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == null) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block23;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == null) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block23;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                index = bIndex;
                                break block22;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block23;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                index = fIndex;
                                break block22;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block23;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        byte newValue2 = remappingFunction.applyAsByte(null, this.defaultValue());
                        this.incrementModCount();
                        keys[firstRemoved] = null;
                        vals[firstRemoved] = newValue2;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = remappingFunction.applyAsByte(null, this.defaultValue());
                this.incrementModCount();
                keys[index] = null;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsByte(null, vals[index]);
        return newValue;
    }

    public Byte computeIfAbsent(K key, Function<? super K, ? extends Byte> mappingFunction) {
        if (key != null) {
            Byte value;
            block34: {
                if (mappingFunction == null) {
                    throw new NullPointerException();
                }
                Object[] keys = this.set;
                byte[] vals = this.values;
                int capacity = keys.length;
                int index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) % capacity;
                Object cur = keys[index];
                if (cur == key) {
                    return vals[index];
                }
                if (cur != FREE) {
                    Byte value2;
                    int firstRemoved;
                    if (cur != REMOVED) {
                        if (this.keyEquals(key, cur)) {
                            return vals[index];
                        }
                        if (this.noRemoved()) {
                            int bIndex = index;
                            int fIndex = index;
                            int step = 1;
                            while (true) {
                                if ((bIndex -= step) < 0) {
                                    bIndex += capacity;
                                }
                                if ((cur = keys[bIndex]) == key) {
                                    return vals[bIndex];
                                }
                                if (cur == FREE) {
                                    index = bIndex;
                                    break block34;
                                }
                                if (this.keyEquals(key, cur)) {
                                    return vals[bIndex];
                                }
                                int t = (fIndex += step) - capacity;
                                if (t >= 0) {
                                    fIndex = t;
                                }
                                if ((cur = keys[fIndex]) == key) {
                                    return vals[fIndex];
                                }
                                if (cur == FREE) {
                                    index = fIndex;
                                    break block34;
                                }
                                if (this.keyEquals(key, cur)) {
                                    return vals[fIndex];
                                }
                                step += 2;
                            }
                        }
                        firstRemoved = -1;
                    } else {
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            return vals[bIndex];
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block34;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                return vals[bIndex];
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            return vals[fIndex];
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block34;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                return vals[fIndex];
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    if ((value2 = mappingFunction.apply(key)) != null) {
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = value2;
                        this.postRemovedSlotInsertHook();
                        return value2;
                    }
                    return null;
                }
            }
            if ((value = mappingFunction.apply(key)) != null) {
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
            return null;
        }
        return this.computeIfAbsentNullKey(mappingFunction);
    }

    Byte computeIfAbsentNullKey(Function<? super K, ? extends Byte> mappingFunction) {
        Byte value;
        block24: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            byte[] vals = this.values;
            int capacity = keys.length;
            int index = 0;
            Object cur = keys[0];
            if (cur == null) {
                return vals[index];
            }
            if (cur != FREE) {
                Byte value2;
                int firstRemoved;
                if (cur != REMOVED) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                return vals[bIndex];
                            }
                            if (cur == FREE) {
                                index = bIndex;
                                break block24;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                return vals[fIndex];
                            }
                            if (cur == FREE) {
                                index = fIndex;
                                break block24;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == null) {
                        return vals[bIndex];
                    }
                    if (cur == FREE) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block24;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == null) {
                        return vals[fIndex];
                    }
                    if (cur == FREE) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block24;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                if ((value2 = mappingFunction.apply(null)) != null) {
                    this.incrementModCount();
                    keys[firstRemoved] = null;
                    vals[firstRemoved] = value2;
                    this.postRemovedSlotInsertHook();
                    return value2;
                }
                return null;
            }
        }
        if ((value = mappingFunction.apply(null)) != null) {
            this.incrementModCount();
            keys[index] = null;
            vals[index] = value;
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    public byte computeIfAbsent(K key, ToByteFunction<? super K> mappingFunction) {
        if (key != null) {
            block32: {
                if (mappingFunction == null) {
                    throw new NullPointerException();
                }
                Object[] keys = this.set;
                byte[] vals = this.values;
                int capacity = keys.length;
                int index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) % capacity;
                Object cur = keys[index];
                if (cur == key) {
                    return vals[index];
                }
                if (cur != FREE) {
                    int firstRemoved;
                    if (cur != REMOVED) {
                        if (this.keyEquals(key, cur)) {
                            return vals[index];
                        }
                        if (this.noRemoved()) {
                            int bIndex = index;
                            int fIndex = index;
                            int step = 1;
                            while (true) {
                                if ((bIndex -= step) < 0) {
                                    bIndex += capacity;
                                }
                                if ((cur = keys[bIndex]) == key) {
                                    return vals[bIndex];
                                }
                                if (cur == FREE) {
                                    index = bIndex;
                                    break block32;
                                }
                                if (this.keyEquals(key, cur)) {
                                    return vals[bIndex];
                                }
                                int t = (fIndex += step) - capacity;
                                if (t >= 0) {
                                    fIndex = t;
                                }
                                if ((cur = keys[fIndex]) == key) {
                                    return vals[fIndex];
                                }
                                if (cur == FREE) {
                                    index = fIndex;
                                    break block32;
                                }
                                if (this.keyEquals(key, cur)) {
                                    return vals[fIndex];
                                }
                                step += 2;
                            }
                        }
                        firstRemoved = -1;
                    } else {
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            return vals[bIndex];
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block32;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                return vals[bIndex];
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            return vals[fIndex];
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block32;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                return vals[fIndex];
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    byte value = mappingFunction.applyAsByte(key);
                    this.incrementModCount();
                    keys[firstRemoved] = key;
                    vals[firstRemoved] = value;
                    this.postRemovedSlotInsertHook();
                    return value;
                }
            }
            byte value = mappingFunction.applyAsByte(key);
            this.incrementModCount();
            keys[index] = key;
            vals[index] = value;
            this.postFreeSlotInsertHook();
            return value;
        }
        return this.computeIfAbsentNullKey(mappingFunction);
    }

    byte computeIfAbsentNullKey(ToByteFunction<? super K> mappingFunction) {
        block22: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            byte[] vals = this.values;
            int capacity = keys.length;
            int index = 0;
            Object cur = keys[0];
            if (cur == null) {
                return vals[index];
            }
            if (cur != FREE) {
                int firstRemoved;
                if (cur != REMOVED) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                return vals[bIndex];
                            }
                            if (cur == FREE) {
                                index = bIndex;
                                break block22;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                return vals[fIndex];
                            }
                            if (cur == FREE) {
                                index = fIndex;
                                break block22;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == null) {
                        return vals[bIndex];
                    }
                    if (cur == FREE) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block22;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == null) {
                        return vals[fIndex];
                    }
                    if (cur == FREE) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block22;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                byte value = mappingFunction.applyAsByte(null);
                this.incrementModCount();
                keys[firstRemoved] = null;
                vals[firstRemoved] = value;
                this.postRemovedSlotInsertHook();
                return value;
            }
        }
        byte value = mappingFunction.applyAsByte(null);
        this.incrementModCount();
        keys[index] = null;
        vals[index] = value;
        this.postFreeSlotInsertHook();
        return value;
    }

    public Byte computeIfPresent(K key, BiFunction<? super K, ? super Byte, ? extends Byte> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            byte[] vals = this.values;
            Byte newValue = remappingFunction.apply(key, vals[index]);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.incrementModCount();
            this.set[index] = REMOVED;
            this.postRemoveHook();
            return null;
        }
        return null;
    }

    public byte computeIfPresent(K key, ObjByteToByteFunction<? super K> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            byte newValue;
            byte[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsByte(key, vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    public Byte merge(K key, Byte value, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        block30: {
            Byte newValue;
            int index;
            byte[] vals;
            block28: {
                block29: {
                    int firstRemoved;
                    Object cur;
                    int capacity;
                    Object[] keys;
                    block32: {
                        block31: {
                            if (key == null) break block30;
                            if (value == null) {
                                throw new NullPointerException();
                            }
                            if (remappingFunction == null) {
                                throw new NullPointerException();
                            }
                            keys = this.set;
                            vals = this.values;
                            capacity = keys.length;
                            index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) % capacity;
                            cur = keys[index];
                            if (cur == key) break block28;
                            if (cur == FREE) break block29;
                            if (cur == REMOVED) break block31;
                            if (this.keyEquals(key, cur)) break block28;
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                            break block32;
                        }
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block28;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block29;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block28;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block28;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block29;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block28;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    this.incrementModCount();
                    keys[firstRemoved] = key;
                    vals[firstRemoved] = value;
                    this.postRemovedSlotInsertHook();
                    return value;
                }
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
            if ((newValue = remappingFunction.apply((Byte)vals[index], value)) != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.incrementModCount();
            keys[index] = REMOVED;
            this.postRemoveHook();
            return null;
        }
        return this.mergeNullKey(value, remappingFunction);
    }

    Byte mergeNullKey(Byte value, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        Byte newValue;
        int index;
        byte[] vals;
        block24: {
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                block25: {
                    if (cur != FREE) {
                        int firstRemoved;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == null) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == null) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = null;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = null;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Byte)vals[index], value)) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return null;
    }

    public byte merge(K key, byte value, ByteBinaryOperator remappingFunction) {
        block28: {
            byte newValue;
            int index;
            byte[] vals;
            block26: {
                block27: {
                    int firstRemoved;
                    Object cur;
                    int capacity;
                    Object[] keys;
                    block30: {
                        block29: {
                            if (key == null) break block28;
                            if (remappingFunction == null) {
                                throw new NullPointerException();
                            }
                            keys = this.set;
                            vals = this.values;
                            capacity = keys.length;
                            index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) % capacity;
                            cur = keys[index];
                            if (cur == key) break block26;
                            if (cur == FREE) break block27;
                            if (cur == REMOVED) break block29;
                            if (this.keyEquals(key, cur)) break block26;
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                            break block30;
                        }
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block26;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block27;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block26;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block26;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block27;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block26;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    this.incrementModCount();
                    keys[firstRemoved] = key;
                    vals[firstRemoved] = value;
                    this.postRemovedSlotInsertHook();
                    return value;
                }
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
            vals[index] = newValue = remappingFunction.applyAsByte(vals[index], value);
            return newValue;
        }
        return this.mergeNullKey(value, remappingFunction);
    }

    byte mergeNullKey(byte value, ByteBinaryOperator remappingFunction) {
        byte newValue;
        int index;
        byte[] vals;
        block22: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                block23: {
                    if (cur != FREE) {
                        int firstRemoved;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == null) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block23;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == null) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block23;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                index = bIndex;
                                break block22;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block23;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                index = fIndex;
                                break block22;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block23;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = null;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = null;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsByte(vals[index], value);
        return newValue;
    }

    public byte addValue(K key, byte value) {
        block27: {
            byte newValue;
            int index;
            byte[] vals;
            block25: {
                block26: {
                    int firstRemoved;
                    Object cur;
                    int capacity;
                    Object[] keys;
                    block29: {
                        block28: {
                            if (key == null) break block27;
                            keys = this.set;
                            vals = this.values;
                            capacity = keys.length;
                            index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) % capacity;
                            cur = keys[index];
                            if (cur == key) break block25;
                            if (cur == FREE) break block26;
                            if (cur == REMOVED) break block28;
                            if (this.keyEquals(key, cur)) break block25;
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                            break block29;
                        }
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block25;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block26;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block25;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block25;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block26;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block25;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    byte newValue2 = (byte)(this.defaultValue() + value);
                    this.incrementModCount();
                    keys[firstRemoved] = key;
                    vals[firstRemoved] = newValue2;
                    this.postRemovedSlotInsertHook();
                    return newValue2;
                }
                newValue = (byte)(this.defaultValue() + value);
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
            vals[index] = newValue = (byte)(vals[index] + value);
            return newValue;
        }
        return this.addValueNullKey(value);
    }

    byte addValueNullKey(byte value) {
        byte newValue;
        int index;
        byte[] vals;
        block21: {
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                block22: {
                    if (cur != FREE) {
                        int firstRemoved;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == null) {
                                        index = bIndex;
                                        break block21;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == null) {
                                        index = fIndex;
                                        break block21;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                index = bIndex;
                                break block21;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block22;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                index = fIndex;
                                break block21;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block22;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        byte newValue2 = (byte)(this.defaultValue() + value);
                        this.incrementModCount();
                        keys[firstRemoved] = null;
                        vals[firstRemoved] = newValue2;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = (byte)(this.defaultValue() + value);
                this.incrementModCount();
                keys[index] = null;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = (byte)(vals[index] + value);
        return newValue;
    }

    public byte addValue(K key, byte addition, byte initialValue) {
        block27: {
            byte newValue;
            int index;
            byte[] vals;
            block25: {
                block26: {
                    int firstRemoved;
                    Object cur;
                    int capacity;
                    Object[] keys;
                    block29: {
                        block28: {
                            if (key == null) break block27;
                            keys = this.set;
                            vals = this.values;
                            capacity = keys.length;
                            index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) % capacity;
                            cur = keys[index];
                            if (cur == key) break block25;
                            if (cur == FREE) break block26;
                            if (cur == REMOVED) break block28;
                            if (this.keyEquals(key, cur)) break block25;
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                            break block29;
                        }
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block25;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block26;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block25;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block25;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block26;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block25;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    byte newValue2 = (byte)(initialValue + addition);
                    this.incrementModCount();
                    keys[firstRemoved] = key;
                    vals[firstRemoved] = newValue2;
                    this.postRemovedSlotInsertHook();
                    return newValue2;
                }
                newValue = (byte)(initialValue + addition);
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
            vals[index] = newValue = (byte)(vals[index] + addition);
            return newValue;
        }
        return this.addValueWithInitialNullKey(addition, initialValue);
    }

    byte addValueWithInitialNullKey(byte addition, byte initialValue) {
        byte newValue;
        int index;
        byte[] vals;
        block21: {
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                block22: {
                    if (cur != FREE) {
                        int firstRemoved;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == null) {
                                        index = bIndex;
                                        break block21;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == null) {
                                        index = fIndex;
                                        break block21;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                index = bIndex;
                                break block21;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block22;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                index = fIndex;
                                break block21;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block22;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        byte newValue2 = (byte)(initialValue + addition);
                        this.incrementModCount();
                        keys[firstRemoved] = null;
                        vals[firstRemoved] = newValue2;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = (byte)(initialValue + addition);
                this.incrementModCount();
                keys[index] = null;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = (byte)(vals[index] + addition);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends K, ? extends Byte> m) {
        CommonObjByteMapOps.putAll((InternalObjByteMapOps)this, m);
    }

    public Byte replace(K key, Byte value) {
        int index = this.index(key);
        if (index >= 0) {
            byte[] vals = this.values;
            byte oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return null;
    }

    public byte replace(K key, byte value) {
        int index = this.index(key);
        if (index >= 0) {
            byte[] vals = this.values;
            byte oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(K key, Byte oldValue, Byte newValue) {
        return this.replace(key, (byte)oldValue, (byte)newValue);
    }

    public boolean replace(K key, byte oldValue, byte newValue) {
        int index = this.index(key);
        if (index >= 0) {
            byte[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super K, ? super Byte, ? extends Byte> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        byte[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                vals[i] = function.apply(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                vals[i] = function.apply(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ObjByteToByteFunction<? super K> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        byte[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                vals[i] = function.applyAsByte(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                vals[i] = function.applyAsByte(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.postRemoveHook();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Byte remove(Object key) {
        if (key == null) {
            return this.removeNullKey();
        }
        Object k = key;
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(k)) % capacity;
        Object cur = keys[index];
        if (cur != k) {
            int bIndex;
            if (cur == FREE) {
                return null;
            }
            if (cur != REMOVED) {
                if (!this.keyEquals(k, cur)) {
                    if (!this.noRemoved()) {
                    } else {
                        bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return null;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = bIndex;
                                break;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return null;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                }
            } else {
                bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return null;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return null;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
        }
        byte val = this.values[index];
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return val;
    }

    Byte removeNullKey() {
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == null) {
                    index = bIndex;
                    break;
                }
                if (cur == FREE) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == null) {
                    index = fIndex;
                    break;
                }
                if (cur == FREE) {
                    return null;
                }
                step += 2;
            }
        }
        byte val = this.values[index];
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return val;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean justRemove(Object key) {
        if (key == null) {
            return this.justRemoveNullKey();
        }
        Object k = key;
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(k)) % capacity;
        Object cur = keys[index];
        if (cur != k) {
            if (cur == FREE) {
                return false;
            }
            if (cur != REMOVED) {
                if (!this.keyEquals(k, cur)) {
                    if (!this.noRemoved()) {
                    } else {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = bIndex;
                                break;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                }
            } else {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
        }
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return true;
    }

    boolean justRemoveNullKey() {
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == null) {
                    index = bIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == null) {
                    index = fIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte removeAsByte(Object key) {
        if (key == null) {
            return this.removeAsByteNullKey();
        }
        Object k = key;
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(k)) % capacity;
        Object cur = keys[index];
        if (cur != k) {
            int bIndex;
            if (cur == FREE) {
                return this.defaultValue();
            }
            if (cur != REMOVED) {
                if (!this.keyEquals(k, cur)) {
                    if (!this.noRemoved()) {
                    } else {
                        bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return this.defaultValue();
                            }
                            if (this.keyEquals(k, cur)) {
                                index = bIndex;
                                break;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return this.defaultValue();
                            }
                            if (this.keyEquals(k, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                }
            } else {
                bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return this.defaultValue();
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return this.defaultValue();
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
        }
        byte val = this.values[index];
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return val;
    }

    byte removeAsByteNullKey() {
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == null) {
                    index = bIndex;
                    break;
                }
                if (cur == FREE) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == null) {
                    index = fIndex;
                    break;
                }
                if (cur == FREE) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        byte val = this.values[index];
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return val;
    }

    public boolean remove(Object key, Object value) {
        return this.remove(key, (Byte)value);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean remove(Object key, byte value) {
        if (key == null) {
            return this.removeEntryNullKey(value);
        }
        Object k = key;
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(k)) % capacity;
        Object cur = keys[index];
        if (cur != k) {
            if (cur == FREE) {
                return false;
            }
            if (cur != REMOVED) {
                if (!this.keyEquals(k, cur)) {
                    if (!this.noRemoved()) {
                    } else {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = bIndex;
                                break;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                }
            } else {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
        }
        if (this.values[index] == value) {
            this.incrementModCount();
            keys[index] = REMOVED;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    boolean removeEntryNullKey(byte value) {
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == null) {
                    index = bIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == null) {
                    index = fIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                step += 2;
            }
        }
        if (this.values[index] == value) {
            this.incrementModCount();
            keys[index] = REMOVED;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIf(ObjBytePredicate<? super K> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        byte[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = REMOVED;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = REMOVED;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedMapCursor
    implements ObjByteCursor<K> {
        final Object[] keys;
        final byte[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        byte curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ObjByteConsumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            byte[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public K key() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public byte value() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(byte value) {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                Object[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements ObjByteCursor<K> {
        final Object[] keys;
        final byte[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        byte curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ObjByteConsumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            byte[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public K key() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public byte value() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(byte value) {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                Object[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements ByteCursor {
        final Object[] keys;
        final byte[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        byte curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            byte[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public byte elem() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                Object[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements ByteIterator {
        final Object[] keys;
        final byte[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        byte next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            this.vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            if (this.expectedModCount == MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    Object[] keys = this.keys;
                    byte prev = this.next;
                    while (--nextI >= 0) {
                        Object key = keys[nextI];
                        if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            byte[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept((Byte)vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            byte[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
            this.keys[index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements ByteCursor {
        final Object[] keys;
        final byte[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        byte curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            byte[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public byte elem() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                Object[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements ByteIterator {
        final Object[] keys;
        final byte[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        byte next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            this.vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == ObjHash.FREE) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            if (this.expectedModCount == MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    Object[] keys = this.keys;
                    byte prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == ObjHash.FREE) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            byte[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept((Byte)vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            byte[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
            this.keys[index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, Byte>> {
        final Object[] keys;
        final byte[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        byte curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            byte[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public Map.Entry<K, Byte> elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                Object[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, Byte>> {
        final Object[] keys;
        final byte[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            this.vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, Byte>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            byte[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, Byte> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    Object[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        Object key = keys[nextI];
                        if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
            this.keys[index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, Byte>> {
        final Object[] keys;
        final byte[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        byte curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            byte[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public Map.Entry<K, Byte> elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                Object[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, Byte>> {
        final Object[] keys;
        final byte[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            this.vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, Byte>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            byte[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, Byte> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    Object[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        Object key = keys[nextI];
                        if (key == ObjHash.FREE) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
            this.keys[index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractByteValueView {
        ValueView() {
        }

        public int size() {
            return MutableQHashSeparateKVObjByteMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVObjByteMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return MutableQHashSeparateKVObjByteMapGO.this.containsValue(o);
        }

        public boolean contains(byte v) {
            return MutableQHashSeparateKVObjByteMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Byte> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    action.accept((Byte)vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    action.accept((Byte)vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    action.accept(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    action.accept(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(BytePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(ByteCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(ByteCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    changed |= c.add(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= c.add(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(ByteSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    changed |= s.removeByte(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= s.removeByte(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ByteIterator iterator() {
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            if (!MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ByteCursor cursor() {
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            if (!MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    result[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    result[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    a[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    a[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public byte[] toByteArray() {
            int size = this.size();
            byte[] result = new byte[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    result[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    result[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public byte[] toArray(byte[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new byte[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    a[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    a[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    sb.append(' ').append(vals[i]).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    sb.append(' ').append(vals[i]).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeByte((Byte)o);
        }

        public boolean removeByte(byte v) {
            return MutableQHashSeparateKVObjByteMapGO.this.removeValue(v);
        }

        public void clear() {
            MutableQHashSeparateKVObjByteMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Byte> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || !filter.test((Byte)vals[i])) continue;
                    MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !filter.test((Byte)vals[i])) continue;
                    MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(BytePredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof ByteCollection) {
                return this.removeAll((ByteCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(ByteCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof ByteCollection) {
                return this.retainAll((ByteCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(ByteCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends ObjByteEntry {
        private K key;
        private byte value;

        ReusableEntry() {
        }

        ReusableEntry with(K key, byte value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ObjByteEntry {
        final int modCount;
        private final int index;
        final K key;
        private byte value;

        MutableEntry(int modCount, int index, K key, byte value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }

        public Byte setValue(Byte newValue) {
            byte unwrappedNewValue;
            if (this.modCount != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            byte oldValue = this.value;
            this.value = unwrappedNewValue = newValue.byteValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(byte newValue) {
            MutableQHashSeparateKVObjByteMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class ObjByteEntry
    extends AbstractEntry<K, Byte> {
        ObjByteEntry() {
        }

        abstract K key();

        public final K getKey() {
            return this.key();
        }

        abstract byte value();

        public final Byte getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                Object k2 = e2.getKey();
                byte v2 = (Byte)e2.getValue();
                return MutableQHashSeparateKVObjByteMapGO.this.nullableKeyEquals(k2, this.key()) && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return MutableQHashSeparateKVObjByteMapGO.this.nullableKeyHashCode(this.key()) ^ Primitives.hashCode((byte)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<K, Byte>>
    implements HashObjSet<Map.Entry<K, Byte>>,
    InternalObjCollectionOps<Map.Entry<K, Byte>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<K, Byte>> equivalence() {
            return Equivalence.entryEquivalence(MutableQHashSeparateKVObjByteMapGO.this.keyEquivalence(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashSeparateKVObjByteMapGO.this.hashConfig();
        }

        public int size() {
            return MutableQHashSeparateKVObjByteMapGO.this.size;
        }

        public double currentLoad() {
            return MutableQHashSeparateKVObjByteMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashSeparateKVObjByteMapGO.this.containsEntry(e.getKey(), (Byte)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<K, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<K, Byte>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || predicate.test((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || predicate.test((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<K, Byte>> iterator() {
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            if (!MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<K, Byte>> cursor() {
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            if (!MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<K, Byte>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return MutableQHashSeparateKVObjByteMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    sb.append(' ');
                    sb.append(key != this ? key : "(this Collection)");
                    sb.append('=');
                    sb.append(vals[i]);
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    sb.append(' ');
                    sb.append(key != this ? key : "(this Collection)");
                    sb.append('=');
                    sb.append(vals[i]);
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVObjByteMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                byte value = (Byte)e.getValue();
                return MutableQHashSeparateKVObjByteMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<K, Byte>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || !filter.test((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !filter.test((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || !c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVObjByteMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = MutableQHashSeparateKVObjByteMapGO.this.values;
            if (MutableQHashSeparateKVObjByteMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVObjByteMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public void clear() {
            MutableQHashSeparateKVObjByteMapGO.this.doClear();
        }
    }
}

