/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.ByteCollection;
import com.koloboke.collect.ByteCursor;
import com.koloboke.collect.ByteIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.FloatCollection;
import com.koloboke.collect.FloatCursor;
import com.koloboke.collect.FloatIterator;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractByteValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonFloatByteMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalFloatByteMapOps;
import com.koloboke.collect.impl.InternalFloatCollectionOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.MutableLHashSeparateKVFloatByteMapSO;
import com.koloboke.collect.impl.hash.MutableSeparateKVFloatLHashGO;
import com.koloboke.collect.impl.hash.SeparateKVFloatByteLHash;
import com.koloboke.collect.map.FloatByteCursor;
import com.koloboke.collect.set.ByteSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashFloatSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.ByteBinaryOperator;
import com.koloboke.function.ByteConsumer;
import com.koloboke.function.BytePredicate;
import com.koloboke.function.FloatByteConsumer;
import com.koloboke.function.FloatBytePredicate;
import com.koloboke.function.FloatByteToByteFunction;
import com.koloboke.function.FloatPredicate;
import com.koloboke.function.FloatToByteFunction;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class MutableLHashSeparateKVFloatByteMapGO
extends MutableLHashSeparateKVFloatByteMapSO {
    @Override
    final void copy(SeparateKVFloatByteLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVFloatByteLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public byte defaultValue() {
        return 0;
    }

    public boolean containsEntry(float key, byte value) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public boolean containsEntry(int key, byte value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Byte get(Object key) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public byte get(float key) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    public Byte getOrDefault(Object key, Byte defaultValue) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public byte getOrDefault(float key, byte defaultValue) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Float, ? super Byte> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.valueOf(Float.intBitsToFloat(key)), (Byte)vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(FloatByteConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.intBitsToFloat(key), vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(FloatBytePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        int[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE || predicate.test(Float.intBitsToFloat(key), vals[i])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public FloatByteCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonFloatByteMapOps.containsAllEntries((InternalFloatByteMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalFloatByteMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        int[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalFloatByteMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Float, Byte>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ByteCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        int[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            hashCode += key ^ vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        int[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            sb.append(' ');
            sb.append(Float.intBitsToFloat(key));
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        int[] keys = this.set;
        byte[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        int[] newKeys = this.set;
        int capacityMask = newKeys.length - 1;
        byte[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            int index = LHash.SeparateKVFloatKeyMixing.mix((int)key) & capacityMask;
            if (newKeys[index] != 0x7FFFFFFE) {
                while (newKeys[index = index - 1 & capacityMask] != 0x7FFFFFFE) {
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Byte put(Float key, Byte value) {
        int k = Float.floatToIntBits(key.floatValue());
        int index = this.insert(k, value);
        if (index < 0) {
            return null;
        }
        byte[] vals = this.values;
        byte prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    public byte put(float key, byte value) {
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return this.defaultValue();
        }
        byte[] vals = this.values;
        byte prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    public Byte putIfAbsent(Float key, Byte value) {
        int k = Float.floatToIntBits(key.floatValue());
        int index = this.insert(k, value);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    public byte putIfAbsent(float key, byte value) {
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    public void justPut(float key, byte value) {
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    public void justPut(int key, byte value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    /*
     * Unable to fully structure code
     */
    public Byte compute(Float key, BiFunction<? super Float, ? super Byte, ? extends Byte> remappingFunction) {
        block4: {
            k = Float.floatToIntBits(key.floatValue());
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVFloatKeyMixing.mix((int)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block4;
            if (cur == 0x7FFFFFFE) ** GOTO lbl13
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl13:
                // 2 sources

                if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue;
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), (Byte)vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public byte compute(float key, FloatByteToByteFunction remappingFunction) {
        block2: {
            k = Float.floatToIntBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVFloatKeyMixing.mix((int)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block2;
            if (cur == 0x7FFFFFFE) ** GOTO lbl13
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl13:
                // 2 sources

                newValue = remappingFunction.applyAsByte(Float.intBitsToFloat(k), this.defaultValue());
                this.incrementModCount();
                keys[index] = k;
                vals[index] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsByte(Float.intBitsToFloat(k), vals[index]);
        return newValue;
    }

    public Byte computeIfAbsent(Float key, Function<? super Float, ? extends Byte> mappingFunction) {
        Byte value;
        int k = Float.floatToIntBits(key.floatValue());
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        int[] keys = this.set;
        byte[] vals = this.values;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVFloatKeyMixing.mix((int)k) & capacityMask;
        int cur = keys[index];
        if (cur == k) {
            return vals[index];
        }
        if (cur != 0x7FFFFFFE) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != k) continue;
                return vals[index];
            } while (cur != 0x7FFFFFFE);
        }
        if ((value = mappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)))) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = value;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public byte computeIfAbsent(float key, FloatToByteFunction mappingFunction) {
        int k = Float.floatToIntBits(key);
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        int[] keys = this.set;
        byte[] vals = this.values;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVFloatKeyMixing.mix((int)k) & capacityMask;
        int cur = keys[index];
        if (cur == k) {
            return vals[index];
        }
        if (cur != 0x7FFFFFFE) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != k) continue;
                return vals[index];
            } while (cur != 0x7FFFFFFE);
        }
        byte value = mappingFunction.applyAsByte(Float.intBitsToFloat(k));
        this.incrementModCount();
        keys[index] = k;
        vals[index] = value;
        this.postInsertHook();
        return value;
    }

    public Byte computeIfPresent(Float key, BiFunction<? super Float, ? super Byte, ? extends Byte> remappingFunction) {
        int k = Float.floatToIntBits(key.floatValue());
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            byte[] vals = this.values;
            Byte newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), (Byte)vals[index]);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.removeAt(index);
            return null;
        }
        return null;
    }

    public byte computeIfPresent(float key, FloatByteToByteFunction remappingFunction) {
        int k = Float.floatToIntBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            byte newValue;
            byte[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsByte(Float.intBitsToFloat(k), vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    public Byte merge(Float key, Byte value, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        block4: {
            k = Float.floatToIntBits(key.floatValue());
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVFloatKeyMixing.mix((int)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block4;
            if (cur == 0x7FFFFFFE) ** GOTO lbl15
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl15:
                // 2 sources

                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Byte)vals[index], value)) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public byte merge(float key, byte value, ByteBinaryOperator remappingFunction) {
        block2: {
            k = Float.floatToIntBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVFloatKeyMixing.mix((int)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block2;
            if (cur == 0x7FFFFFFE) ** GOTO lbl13
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl13:
                // 2 sources

                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsByte(vals[index], value);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public byte addValue(float key, byte value) {
        block1: {
            k = Float.floatToIntBits(key);
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVFloatKeyMixing.mix((int)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block1;
            if (cur == 0x7FFFFFFE) ** GOTO lbl11
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl11:
                // 2 sources

                newValue = (byte)(this.defaultValue() + value);
                this.incrementModCount();
                keys[index] = k;
                vals[index] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = (byte)(vals[index] + value);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public byte addValue(float key, byte addition, byte initialValue) {
        block1: {
            k = Float.floatToIntBits(key);
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVFloatKeyMixing.mix((int)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block1;
            if (cur == 0x7FFFFFFE) ** GOTO lbl11
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl11:
                // 2 sources

                newValue = (byte)(initialValue + addition);
                this.incrementModCount();
                keys[index] = k;
                vals[index] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = (byte)(vals[index] + addition);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Float, ? extends Byte> m) {
        CommonFloatByteMapOps.putAll((InternalFloatByteMapOps)this, m);
    }

    public Byte replace(Float key, Byte value) {
        int k = Float.floatToIntBits(key.floatValue());
        int index = this.index(k);
        if (index >= 0) {
            byte[] vals = this.values;
            byte oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return null;
    }

    public byte replace(float key, byte value) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            byte[] vals = this.values;
            byte oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(Float key, Byte oldValue, Byte newValue) {
        return this.replace(key.floatValue(), (byte)oldValue, (byte)newValue);
    }

    public boolean replace(float key, byte oldValue, byte newValue) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            byte[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Float, ? super Byte, ? extends Byte> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            vals[i] = function.apply(Float.valueOf(Float.intBitsToFloat(key)), (Byte)vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(FloatByteToByteFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            vals[i] = function.applyAsByte(Float.intBitsToFloat(key), vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        int keyToShift;
        int indexToRemove;
        int[] keys = this.set;
        byte[] vals = this.values;
        int capacityMask = keys.length - 1;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
            if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        keys[indexToRemove] = 0x7FFFFFFE;
        this.postRemoveHook();
    }

    public Byte remove(Object key) {
        int keyToShift;
        int indexToRemove;
        int k = Float.floatToIntBits(((Float)key).floatValue());
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVFloatKeyMixing.mix((int)k) & capacityMask;
        int cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return null;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return null;
            }
        }
        byte[] vals = this.values;
        byte val = vals[index];
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
            if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        keys[indexToRemove] = 0x7FFFFFFE;
        this.postRemoveHook();
        return val;
    }

    @Override
    public boolean justRemove(float key) {
        int keyToShift;
        int indexToRemove;
        int k = Float.floatToIntBits(key);
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVFloatKeyMixing.mix((int)k) & capacityMask;
        int cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return false;
            }
        }
        byte[] vals = this.values;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
            if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        keys[indexToRemove] = 0x7FFFFFFE;
        this.postRemoveHook();
        return true;
    }

    @Override
    public boolean justRemove(int key) {
        int keyToShift;
        int indexToRemove;
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVFloatKeyMixing.mix((int)key) & capacityMask;
        int cur = keys[index];
        if (cur != key) {
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != 0x7FFFFFFE) continue;
                return false;
            }
        }
        byte[] vals = this.values;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
            if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        keys[indexToRemove] = 0x7FFFFFFE;
        this.postRemoveHook();
        return true;
    }

    public byte remove(float key) {
        int keyToShift;
        int indexToRemove;
        int k = Float.floatToIntBits(key);
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVFloatKeyMixing.mix((int)k) & capacityMask;
        int cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return this.defaultValue();
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return this.defaultValue();
            }
        }
        byte[] vals = this.values;
        byte val = vals[index];
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
            if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        keys[indexToRemove] = 0x7FFFFFFE;
        this.postRemoveHook();
        return val;
    }

    public boolean remove(Object key, Object value) {
        return this.remove(((Float)key).floatValue(), (Byte)value);
    }

    public boolean remove(float key, byte value) {
        byte[] vals;
        int k = Float.floatToIntBits(key);
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVFloatKeyMixing.mix((int)k) & capacityMask;
        int cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return false;
            }
        }
        if ((vals = this.values)[index] == value) {
            int keyToShift;
            int indexToRemove;
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = 0x7FFFFFFE;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public boolean removeIf(FloatBytePredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || !filter.test(Float.intBitsToFloat(key), vals[i])) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                        if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Integer.MAX_VALUE;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFE;
                    this.postRemoveHook();
                } else {
                    keys[i] = Integer.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(Predicate<? super Float> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || !filter.test(Float.valueOf(Float.intBitsToFloat(key)))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                        if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Integer.MAX_VALUE;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFE;
                    this.postRemoveHook();
                } else {
                    keys[i] = Integer.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(FloatPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || !filter.test(Float.intBitsToFloat(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                        if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Integer.MAX_VALUE;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFE;
                    this.postRemoveHook();
                } else {
                    keys[i] = Integer.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeAll(@Nonnull HashFloatSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof InternalFloatCollectionOps) {
            return this.removeAll(thisC, (InternalFloatCollectionOps)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block12: {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || !c.contains(Float.valueOf(Float.intBitsToFloat(key)))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                        if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Integer.MAX_VALUE;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFE;
                    this.postRemoveHook();
                } else {
                    keys[i] = Integer.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashFloatSet thisC, @Nonnull FloatCollection c) {
        if (c instanceof InternalFloatCollectionOps) {
            return this.removeAll(thisC, (InternalFloatCollectionOps)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block12: {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || !c.contains(Float.intBitsToFloat(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                        if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Integer.MAX_VALUE;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFE;
                    this.postRemoveHook();
                } else {
                    keys[i] = Integer.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashFloatSet thisC, @Nonnull InternalFloatCollectionOps c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                        if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Integer.MAX_VALUE;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFE;
                    this.postRemoveHook();
                } else {
                    keys[i] = Integer.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull HashFloatSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof FloatCollection) {
            return this.retainAll(thisC, (FloatCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block13: {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || c.contains(Float.valueOf(Float.intBitsToFloat(key)))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                        if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Integer.MAX_VALUE;
                                break block13;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFE;
                    this.postRemoveHook();
                } else {
                    keys[i] = Integer.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashFloatSet thisC, @Nonnull FloatCollection c) {
        if (c instanceof InternalFloatCollectionOps) {
            return this.retainAll(thisC, (InternalFloatCollectionOps)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block13: {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || c.contains(Float.intBitsToFloat(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                        if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Integer.MAX_VALUE;
                                break block13;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFE;
                    this.postRemoveHook();
                } else {
                    keys[i] = Integer.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashFloatSet thisC, @Nonnull InternalFloatCollectionOps c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block12: {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                        if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Integer.MAX_VALUE;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFE;
                    this.postRemoveHook();
                } else {
                    keys[i] = Integer.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    void closeDelayedRemoved(int firstDelayedRemoved) {
        int[] keys = this.set;
        byte[] vals = this.values;
        int capacityMask = keys.length - 1;
        for (int i = firstDelayedRemoved; i >= 0; --i) {
            int keyToShift;
            int indexToRemove;
            if (keys[i] != Integer.MAX_VALUE) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                if (keyToShift != Integer.MAX_VALUE && (LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + i) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = 0x7FFFFFFE;
            this.postRemoveHook();
        }
    }

    @Override
    public FloatIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedKeyIterator(mc);
    }

    @Override
    public FloatCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedKeyCursor(mc);
    }

    class NoRemovedMapCursor
    implements FloatByteCursor {
        int[] keys;
        byte[] vals;
        final int capacityMask;
        int expectedModCount;
        int index;
        int curKey;
        byte curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(FloatByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat(key), vals[i]);
            }
            if (index != this.index || mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public float key() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(curKey);
            }
            throw new IllegalStateException();
        }

        public byte value() {
            if (this.curKey != 0x7FFFFFFE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValue(byte value) {
            if (this.curKey == 0x7FFFFFFE) throw new IllegalStateException();
            if (this.expectedModCount != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.vals[this.index] = value;
            if (this.vals == MutableLHashSeparateKVFloatByteMapGO.this.values) return;
            MutableLHashSeparateKVFloatByteMapGO.this.values[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                int[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int curKey = this.curKey;
            if (curKey == 0x7FFFFFFE) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = 0x7FFFFFFE;
            int index = this.index;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            if (keys == MutableLHashSeparateKVFloatByteMapGO.this.set) {
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVFloatByteMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                    if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = 0x7FFFFFFE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = 0x7FFFFFFE;
                MutableLHashSeparateKVFloatByteMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVFloatByteMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueCursor
    implements ByteCursor {
        int[] keys;
        byte[] vals;
        final int capacityMask;
        int expectedModCount;
        int index;
        int curKey;
        byte curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public byte elem() {
            if (this.curKey != 0x7FFFFFFE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                int[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int curKey = this.curKey;
            if (curKey == 0x7FFFFFFE) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = 0x7FFFFFFE;
            int index = this.index;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            if (keys == MutableLHashSeparateKVFloatByteMapGO.this.set) {
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVFloatByteMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                    if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = 0x7FFFFFFE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = 0x7FFFFFFE;
                MutableLHashSeparateKVFloatByteMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVFloatByteMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueIterator
    implements ByteIterator {
        int[] keys;
        byte[] vals;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        byte next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] >= 0x7FFFFFFE) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            if (this.expectedModCount == MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    int[] keys = this.keys;
                    byte prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] >= 0x7FFFFFFE) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept((Byte)vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            if (keys == MutableLHashSeparateKVFloatByteMapGO.this.set) {
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVFloatByteMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                    if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = 0x7FFFFFFE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = vals[indexToShift];
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = 0x7FFFFFFE;
                MutableLHashSeparateKVFloatByteMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVFloatByteMapGO.this.justRemove(keys[index]);
            }
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Float, Byte>> {
        int[] keys;
        byte[] vals;
        final int capacityMask;
        int expectedModCount;
        int index;
        int curKey;
        byte curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(Consumer<? super Map.Entry<Float, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Map.Entry<Float, Byte>)((Object)new MutableEntry2(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public Map.Entry<Float, Byte> elem() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return new MutableEntry2(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                int[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int curKey = this.curKey;
            if (curKey == 0x7FFFFFFE) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = 0x7FFFFFFE;
            int index = this.index;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            if (keys == MutableLHashSeparateKVFloatByteMapGO.this.set) {
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVFloatByteMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                    if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = 0x7FFFFFFE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = 0x7FFFFFFE;
                MutableLHashSeparateKVFloatByteMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVFloatByteMapGO.this.justRemove(curKey);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, int key, byte value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(byte newValue) {
                if (NoRemovedEntryCursor.this.vals == MutableLHashSeparateKVFloatByteMapGO.this.values) {
                    NoRemovedEntryCursor.this.vals[NoRemovedEntryCursor.this.index] = newValue;
                } else {
                    MutableLHashSeparateKVFloatByteMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Float, Byte>> {
        int[] keys;
        byte[] vals;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                int key = keys[nextI];
                if (key >= 0x7FFFFFFE) continue;
                this.next = new MutableEntry2(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Float, Byte>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Map.Entry<Float, Byte>)((Object)new MutableEntry2(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Float, Byte> next() {
            int mc = this.expectedModCount;
            if (mc == MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    int[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int key = keys[nextI];
                        if (key >= 0x7FFFFFFE) continue;
                        this.next = new MutableEntry2(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            if (keys == MutableLHashSeparateKVFloatByteMapGO.this.set) {
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVFloatByteMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                    if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = 0x7FFFFFFE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = new MutableEntry2(MutableLHashSeparateKVFloatByteMapGO.this.modCount(), indexToShift, keyToShift, vals[indexToShift]);
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = 0x7FFFFFFE;
                MutableLHashSeparateKVFloatByteMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVFloatByteMapGO.this.justRemove(keys[index]);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, int key, byte value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(byte newValue) {
                if (NoRemovedEntryIterator.this.vals == MutableLHashSeparateKVFloatByteMapGO.this.values) {
                    NoRemovedEntryIterator.this.vals[NoRemovedEntryIterator.this.index] = newValue;
                } else {
                    MutableLHashSeparateKVFloatByteMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class ValueView
    extends AbstractByteValueView {
        ValueView() {
        }

        public int size() {
            return MutableLHashSeparateKVFloatByteMapGO.this.size();
        }

        public boolean shrink() {
            return MutableLHashSeparateKVFloatByteMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return MutableLHashSeparateKVFloatByteMapGO.this.containsValue(o);
        }

        public boolean contains(byte v) {
            return MutableLHashSeparateKVFloatByteMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Byte> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept((Byte)vals[i]);
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept(vals[i]);
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(BytePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(ByteCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(ByteCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(ByteSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                changed |= s.removeByte(vals[i]);
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ByteIterator iterator() {
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ByteCursor cursor() {
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public byte[] toByteArray() {
            int size = this.size();
            byte[] result = new byte[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public byte[] toArray(byte[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new byte[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeByte((Byte)o);
        }

        public boolean removeByte(byte v) {
            return MutableLHashSeparateKVFloatByteMapGO.this.removeValue(v);
        }

        public void clear() {
            MutableLHashSeparateKVFloatByteMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Byte> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    if (keys[i] >= 0x7FFFFFFE || !filter.test((Byte)vals[i])) continue;
                    MutableLHashSeparateKVFloatByteMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                            if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Integer.MAX_VALUE;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFE;
                        MutableLHashSeparateKVFloatByteMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Integer.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVFloatByteMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(BytePredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    if (keys[i] >= 0x7FFFFFFE || !filter.test(vals[i])) continue;
                    MutableLHashSeparateKVFloatByteMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                            if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Integer.MAX_VALUE;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFE;
                        MutableLHashSeparateKVFloatByteMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Integer.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVFloatByteMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof ByteCollection) {
                return this.removeAll((ByteCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    if (keys[i] >= 0x7FFFFFFE || !c.contains(vals[i])) continue;
                    MutableLHashSeparateKVFloatByteMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                            if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Integer.MAX_VALUE;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFE;
                        MutableLHashSeparateKVFloatByteMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Integer.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVFloatByteMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(ByteCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    if (keys[i] >= 0x7FFFFFFE || !c.contains(vals[i])) continue;
                    MutableLHashSeparateKVFloatByteMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                            if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Integer.MAX_VALUE;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFE;
                        MutableLHashSeparateKVFloatByteMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Integer.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVFloatByteMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof ByteCollection) {
                return this.retainAll((ByteCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block13: {
                    if (keys[i] >= 0x7FFFFFFE || c.contains(vals[i])) continue;
                    MutableLHashSeparateKVFloatByteMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                            if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Integer.MAX_VALUE;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFE;
                        MutableLHashSeparateKVFloatByteMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Integer.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVFloatByteMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(ByteCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    if (keys[i] >= 0x7FFFFFFE || c.contains(vals[i])) continue;
                    MutableLHashSeparateKVFloatByteMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                            if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Integer.MAX_VALUE;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFE;
                        MutableLHashSeparateKVFloatByteMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Integer.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVFloatByteMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends FloatByteEntry {
        private int key;
        private byte value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, byte value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }

    class MutableEntry
    extends FloatByteEntry {
        final int modCount;
        private final int index;
        final int key;
        private byte value;

        MutableEntry(int modCount, int index, int key, byte value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }

        public Byte setValue(Byte newValue) {
            byte unwrappedNewValue;
            if (this.modCount != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            byte oldValue = this.value;
            this.value = unwrappedNewValue = newValue.byteValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(byte newValue) {
            MutableLHashSeparateKVFloatByteMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class FloatByteEntry
    extends AbstractEntry<Float, Byte> {
        FloatByteEntry() {
        }

        abstract int key();

        public final Float getKey() {
            return Float.valueOf(Float.intBitsToFloat(this.key()));
        }

        abstract byte value();

        public final Byte getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = Float.floatToIntBits(((Float)e2.getKey()).floatValue());
                byte v2 = (Byte)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((int)this.key()) ^ Primitives.hashCode((byte)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Float, Byte>>
    implements HashObjSet<Map.Entry<Float, Byte>>,
    InternalObjCollectionOps<Map.Entry<Float, Byte>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Float, Byte>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableLHashSeparateKVFloatByteMapGO.this.hashConfig();
        }

        public int size() {
            return MutableLHashSeparateKVFloatByteMapGO.this.size;
        }

        public double currentLoad() {
            return MutableLHashSeparateKVFloatByteMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableLHashSeparateKVFloatByteMapGO.this.containsEntry(((Float)e.getKey()).floatValue(), (byte)((Byte)e.getValue()));
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Float, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Map.Entry<Float, Byte>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Float, Byte>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || predicate.test((Map.Entry<Float, Byte>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Float, Byte>> iterator() {
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Float, Byte>> cursor() {
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Float, Byte>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return MutableLHashSeparateKVFloatByteMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                sb.append(' ');
                sb.append(Float.intBitsToFloat(key));
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableLHashSeparateKVFloatByteMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                float key = ((Float)e.getKey()).floatValue();
                byte value = (Byte)e.getValue();
                return MutableLHashSeparateKVFloatByteMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Float, Byte>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE || !filter.test((Map.Entry<Float, Byte>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    MutableLHashSeparateKVFloatByteMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                            if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Integer.MAX_VALUE;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFE;
                        MutableLHashSeparateKVFloatByteMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Integer.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVFloatByteMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block13: {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE || !c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableLHashSeparateKVFloatByteMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                            if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Integer.MAX_VALUE;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFE;
                        MutableLHashSeparateKVFloatByteMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Integer.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVFloatByteMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVFloatByteMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatByteMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte[] vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE || c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableLHashSeparateKVFloatByteMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                            if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Integer.MAX_VALUE;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFE;
                        MutableLHashSeparateKVFloatByteMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Integer.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVFloatByteMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public void clear() {
            MutableLHashSeparateKVFloatByteMapGO.this.doClear();
        }
    }

    class NoRemovedKeyCursor
    extends MutableSeparateKVFloatLHashGO.NoRemovedCursor {
        byte[] vals;

        private NoRemovedKeyCursor(int mc) {
            super(MutableLHashSeparateKVFloatByteMapGO.this, mc);
            this.vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int curKey = this.curKey;
            if (curKey == 0x7FFFFFFE) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = 0x7FFFFFFE;
            int index = this.index;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            if (keys == MutableLHashSeparateKVFloatByteMapGO.this.set) {
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVFloatByteMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                    if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = 0x7FFFFFFE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = 0x7FFFFFFE;
                MutableLHashSeparateKVFloatByteMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVFloatByteMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedKeyIterator
    extends MutableSeparateKVFloatLHashGO.NoRemovedIterator {
        byte[] vals;

        private NoRemovedKeyIterator(int mc) {
            super(MutableLHashSeparateKVFloatByteMapGO.this, mc);
            this.vals = MutableLHashSeparateKVFloatByteMapGO.this.values;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVFloatByteMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            int[] keys = this.keys;
            byte[] vals = this.vals;
            if (keys == MutableLHashSeparateKVFloatByteMapGO.this.set) {
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVFloatByteMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                    if ((LHash.SeparateKVFloatKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = 0x7FFFFFFE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = Float.intBitsToFloat(keyToShift);
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = 0x7FFFFFFE;
                MutableLHashSeparateKVFloatByteMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVFloatByteMapGO.this.justRemove(keys[index]);
            }
        }
    }
}

