/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.FloatCollection;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.hash.FloatLHashFactory;
import com.koloboke.collect.impl.hash.ImmutableLHashFloatSet;
import com.koloboke.collect.impl.hash.ImmutableLHashFloatSetGO;
import com.koloboke.collect.impl.hash.MutableLHashFloatSet;
import com.koloboke.collect.impl.hash.MutableLHashFloatSetGO;
import com.koloboke.collect.impl.hash.SeparateKVFloatLHash;
import com.koloboke.collect.impl.hash.UpdatableLHashFloatSet;
import com.koloboke.collect.impl.hash.UpdatableLHashFloatSetGO;
import com.koloboke.collect.set.hash.HashFloatSetFactory;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class LHashFloatSetFactorySO
extends FloatLHashFactory
implements HashFloatSetFactory {
    LHashFloatSetFactorySO(HashConfig hashConf, int defaultExpectedSize) {
        super(hashConf, defaultExpectedSize);
    }

    MutableLHashFloatSetGO uninitializedMutableSet() {
        return new MutableLHashFloatSet();
    }

    UpdatableLHashFloatSetGO uninitializedUpdatableSet() {
        return new UpdatableLHashFloatSet();
    }

    ImmutableLHashFloatSetGO uninitializedImmutableSet() {
        return new ImmutableLHashFloatSet();
    }

    @Nonnull
    public MutableLHashFloatSetGO newMutableSet(int expectedSize) {
        MutableLHashFloatSet set = new MutableLHashFloatSet();
        set.init(this.configWrapper, expectedSize);
        return set;
    }

    @Nonnull
    public UpdatableLHashFloatSetGO newUpdatableSet(int expectedSize) {
        UpdatableLHashFloatSet set = new UpdatableLHashFloatSet();
        set.init(this.configWrapper, expectedSize);
        return set;
    }

    @Nonnull
    public UpdatableLHashFloatSetGO newUpdatableSet(Iterable<Float> elements, int expectedSize) {
        if (elements instanceof FloatCollection) {
            SeparateKVFloatLHash hash;
            if (elements instanceof SeparateKVFloatLHash && (hash = (SeparateKVFloatLHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableLHashFloatSet set = new UpdatableLHashFloatSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableLHashFloatSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableLHashFloatSetGO set = this.newUpdatableSet(size);
        for (float e : elements) {
            set.add(e);
        }
        return set;
    }
}

