/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalObjFloatMapOps;
import com.koloboke.collect.map.ObjFloatMap;
import com.koloboke.function.ObjFloatConsumer;
import com.koloboke.function.ObjFloatPredicate;
import java.util.Map;

public final class CommonObjFloatMapOps {
    public static boolean containsAllEntries(final InternalObjFloatMapOps<?> map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ObjFloatMap) {
            ObjFloatMap m2 = (ObjFloatMap)another;
            if (m2.keyEquivalence().equals((Object)map.keyEquivalence())) {
                if (map.size() < m2.size()) {
                    return false;
                }
                if (m2 instanceof InternalObjFloatMapOps) {
                    return ((InternalObjFloatMapOps)m2).allEntriesContainingIn(map);
                }
            }
            return m2.forEachWhile(new ObjFloatPredicate(){

                public boolean test(Object a, float b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(e.getKey(), ((Float)e.getValue()).floatValue())) continue;
            return false;
        }
        return true;
    }

    public static <K> void putAll(final InternalObjFloatMapOps<K> map, Map<? extends K, ? extends Float> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ObjFloatMap) {
            if (another instanceof InternalObjFloatMapOps) {
                ((InternalObjFloatMapOps)another).reversePutAllTo(map);
            } else {
                ((ObjFloatMap)another).forEach(new ObjFloatConsumer<K>(){

                    public void accept(K key, float value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<K, Float> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue().floatValue());
            }
        }
    }

    private CommonObjFloatMapOps() {
    }
}

