/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalObjDoubleMapOps;
import com.koloboke.collect.map.ObjDoubleMap;
import com.koloboke.function.ObjDoublePredicate;
import java.util.Map;
import java.util.function.ObjDoubleConsumer;

public final class CommonObjDoubleMapOps {
    public static boolean containsAllEntries(final InternalObjDoubleMapOps<?> map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ObjDoubleMap) {
            ObjDoubleMap m2 = (ObjDoubleMap)another;
            if (m2.keyEquivalence().equals((Object)map.keyEquivalence())) {
                if (map.size() < m2.size()) {
                    return false;
                }
                if (m2 instanceof InternalObjDoubleMapOps) {
                    return ((InternalObjDoubleMapOps)m2).allEntriesContainingIn(map);
                }
            }
            return m2.forEachWhile(new ObjDoublePredicate(){

                public boolean test(Object a, double b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(e.getKey(), (Double)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static <K> void putAll(final InternalObjDoubleMapOps<K> map, Map<? extends K, ? extends Double> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ObjDoubleMap) {
            if (another instanceof InternalObjDoubleMapOps) {
                ((InternalObjDoubleMapOps)another).reversePutAllTo(map);
            } else {
                ((ObjDoubleMap)another).forEach(new ObjDoubleConsumer<K>(){

                    @Override
                    public void accept(K key, double value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<K, Double> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonObjDoubleMapOps() {
    }
}

