/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalFloatByteMapOps;
import com.koloboke.collect.map.FloatByteMap;
import com.koloboke.function.FloatByteConsumer;
import com.koloboke.function.FloatBytePredicate;
import java.util.Map;

public final class CommonFloatByteMapOps {
    public static boolean containsAllEntries(final InternalFloatByteMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof FloatByteMap) {
            FloatByteMap m2 = (FloatByteMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalFloatByteMapOps) {
                return ((InternalFloatByteMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new FloatBytePredicate(){

                public boolean test(float a, byte b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(((Float)e.getKey()).floatValue(), (byte)((Byte)e.getValue()))) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalFloatByteMapOps map, Map<? extends Float, ? extends Byte> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof FloatByteMap) {
            if (another instanceof InternalFloatByteMapOps) {
                ((InternalFloatByteMapOps)another).reversePutAllTo(map);
            } else {
                ((FloatByteMap)another).forEach(new FloatByteConsumer(){

                    public void accept(float key, byte value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Float, ? extends Byte> e : another.entrySet()) {
                map.justPut(e.getKey().floatValue(), (byte)e.getValue());
            }
        }
    }

    private CommonFloatByteMapOps() {
    }
}

