/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.tipc;

import java.io.FileDescriptor;
import java.io.IOException;
import java.math.BigInteger;
import java.net.SocketException;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketFactory;
import org.newsclub.net.unix.AFSocketImpl;
import org.newsclub.net.unix.AFTIPCSocketAddress;
import org.newsclub.net.unix.AFTIPCSocketImplExtensions;
import org.newsclub.net.unix.tipc.AFTIPCDestName;
import org.newsclub.net.unix.tipc.AFTIPCErrInfo;
import org.newsclub.net.unix.tipc.AFTIPCSocketChannel;
import org.newsclub.net.unix.tipc.AFTIPCSocketExtensions;
import org.newsclub.net.unix.tipc.AFTIPCSocketFactory;
import org.newsclub.net.unix.tipc.AFTIPCSocketImpl;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFTIPCSocket
extends AFSocket<AFTIPCSocketAddress>
implements AFTIPCSocketExtensions {
    private static AFTIPCSocketImplExtensions staticExtensions = null;

    AFTIPCSocket(FileDescriptor fdObj, AFSocketFactory<AFTIPCSocketAddress> factory) throws SocketException {
        super((AFSocketImpl)new AFTIPCSocketImpl(fdObj), factory);
    }

    private static synchronized AFTIPCSocketImplExtensions getStaticImplExtensions() throws IOException {
        if (staticExtensions == null) {
            try (AFTIPCSocket socket = new AFTIPCSocket(null, null);){
                staticExtensions = (AFTIPCSocketImplExtensions)socket.getImplExtensions();
            }
        }
        return staticExtensions;
    }

    public static boolean isSupported() {
        return AFSocket.isSupported() && AFSocket.supports((AFSocketCapability)AFSocketCapability.CAPABILITY_TIPC);
    }

    protected AFTIPCSocketChannel newChannel() {
        return new AFTIPCSocketChannel(this);
    }

    public static AFTIPCSocket newInstance() throws IOException {
        return (AFTIPCSocket)AFSocket.newInstance(AFTIPCSocket::new, (AFSocketFactory)null);
    }

    static AFTIPCSocket newInstance(AFTIPCSocketFactory factory) throws SocketException {
        return (AFTIPCSocket)AFSocket.newInstance(AFTIPCSocket::new, (AFSocketFactory)factory);
    }

    public static AFTIPCSocket newStrictInstance() throws IOException {
        return (AFTIPCSocket)AFSocket.newInstance(AFTIPCSocket::new, (AFSocketFactory)null);
    }

    public static AFTIPCSocket connectTo(AFTIPCSocketAddress addr) throws IOException {
        return (AFTIPCSocket)AFSocket.connectTo(AFTIPCSocket::new, (AFSocketAddress)addr);
    }

    public AFTIPCSocketChannel getChannel() {
        return (AFTIPCSocketChannel)super.getChannel();
    }

    public static void main(String[] args) {
        System.out.print(AFTIPCSocket.class.getName() + ".isSupported(): ");
        System.out.flush();
        System.out.println(AFTIPCSocket.isSupported());
    }

    @Override
    public AFTIPCErrInfo getErrInfo() {
        return AFTIPCErrInfo.of(((AFTIPCSocketImplExtensions)this.getImplExtensions()).getTIPCErrInfo());
    }

    @Override
    public AFTIPCDestName getDestName() {
        return AFTIPCDestName.of(((AFTIPCSocketImplExtensions)this.getImplExtensions()).getTIPCDestName());
    }

    public static byte[] getNodeIdentity(int peerId) throws IOException {
        return AFTIPCSocket.getStaticImplExtensions().getTIPCNodeId(peerId);
    }

    public byte[] getNodeIdentity(AFTIPCSocketAddress address) throws IOException {
        return AFTIPCSocket.getNodeIdentity(address.getTIPCNodeHash());
    }

    public static String getNodeIdHexString(int peerId) throws IOException {
        byte[] id = AFTIPCSocket.getNodeIdentity(peerId);
        return id == null ? null : new BigInteger(1, id).toString(16);
    }

    public static String getLinkName(int peerId, int bearerId) throws IOException {
        return AFTIPCSocket.getStaticImplExtensions().getTIPCLinkName(peerId, bearerId);
    }
}

