/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.tipc;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.newsclub.net.unix.AFTIPCSocketAddress;
import org.newsclub.net.unix.NamedIntegerBitmask;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NonNullByDefault
public final class AFTIPCGroupRequest {
    public static final AFTIPCGroupRequest NONE = new AFTIPCGroupRequest(0, 0, AFTIPCSocketAddress.Scope.SCOPE_NOT_SPECIFIED, GroupRequestFlags.NONE);
    private final int type;
    private final int instance;
    private final AFTIPCSocketAddress.Scope scope;
    private final GroupRequestFlags flags;

    private AFTIPCGroupRequest(int type, int instance, AFTIPCSocketAddress.Scope scope, GroupRequestFlags flags) {
        this.type = type;
        this.instance = instance;
        this.scope = scope;
        this.flags = flags;
    }

    public static AFTIPCGroupRequest with(int type, int instance, AFTIPCSocketAddress.Scope scope, GroupRequestFlags flags) {
        if (type == 0 && instance == 0 && scope.value() == 0 && flags.value() == 0) {
            return NONE;
        }
        return new AFTIPCGroupRequest(type, instance, scope, flags);
    }

    public static AFTIPCGroupRequest with(int type, int instance, GroupRequestFlags flags) {
        return AFTIPCGroupRequest.with(type, instance, AFTIPCSocketAddress.Scope.SCOPE_CLUSTER, flags);
    }

    static AFTIPCGroupRequest fromNative(int type, int instance, int scopeId, int flags) {
        return AFTIPCGroupRequest.with(type, instance, AFTIPCSocketAddress.Scope.ofValue((int)scopeId), GroupRequestFlags.ofValue(flags));
    }

    public int getType() {
        return this.type;
    }

    public int getInstance() {
        return this.instance;
    }

    public AFTIPCSocketAddress.Scope getScope() {
        return this.scope;
    }

    int getScopeId() {
        return this.scope.value();
    }

    int getFlagsValue() {
        return this.flags.value();
    }

    public GroupRequestFlags getFlags() {
        return this.flags;
    }

    public String toString() {
        return this.getClass().getName() + (String)(this == NONE ? "(no group)" : "(type=" + this.type + ";instance=" + this.instance + ";scope=" + String.valueOf(this.scope) + ";flags=" + String.valueOf((Object)this.flags) + ")");
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class GroupRequestFlags
    extends NamedIntegerBitmask<GroupRequestFlags> {
        private static final long serialVersionUID = 1L;
        public static final GroupRequestFlags NONE = new GroupRequestFlags("NONE", 0);
        public static final GroupRequestFlags GROUP_LOOPBACK = new GroupRequestFlags("GROUP_LOOPBACK", 1);
        public static final GroupRequestFlags GROUP_MEMBER_EVTS = new GroupRequestFlags("GROUP_MEMBER_EVTS", 2);
        private static final @NonNull GroupRequestFlags[] VALUES = new GroupRequestFlags[]{GROUP_LOOPBACK, GROUP_MEMBER_EVTS};

        private GroupRequestFlags(@Nullable String name, int flags) {
            super(name, flags);
        }

        public static GroupRequestFlags ofValue(int v) {
            return (GroupRequestFlags)GroupRequestFlags.resolve((NamedIntegerBitmask[])VALUES, (NamedIntegerBitmask)NONE, GroupRequestFlags::new, (int)v);
        }

        public static GroupRequestFlags withFlags(GroupRequestFlags ... flags) {
            return (GroupRequestFlags)GroupRequestFlags.resolve((NamedIntegerBitmask[])VALUES, (NamedIntegerBitmask)NONE, GroupRequestFlags::new, (NamedIntegerBitmask[])flags);
        }

        public GroupRequestFlags combineWith(GroupRequestFlags other) {
            return (GroupRequestFlags)this.combineWith(VALUES, NONE, GroupRequestFlags::new, other);
        }
    }
}

