/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.tipc;

import java.io.FileDescriptor;
import java.io.IOException;
import org.newsclub.net.unix.AFDatagramSocket;
import org.newsclub.net.unix.AFDatagramSocketImpl;
import org.newsclub.net.unix.AFSocketType;
import org.newsclub.net.unix.AFTIPCSocketAddress;
import org.newsclub.net.unix.AFTIPCSocketImplExtensions;
import org.newsclub.net.unix.tipc.AFTIPCDatagramChannel;
import org.newsclub.net.unix.tipc.AFTIPCDatagramSocketImpl;
import org.newsclub.net.unix.tipc.AFTIPCDestName;
import org.newsclub.net.unix.tipc.AFTIPCErrInfo;
import org.newsclub.net.unix.tipc.AFTIPCSocketExtensions;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFTIPCDatagramSocket
extends AFDatagramSocket<AFTIPCSocketAddress>
implements AFTIPCSocketExtensions {
    public static final int TIPC_MAX_USER_MSG_SIZE = 66000;

    AFTIPCDatagramSocket(FileDescriptor fd) throws IOException {
        this(fd, AFSocketType.SOCK_DGRAM);
    }

    AFTIPCDatagramSocket(FileDescriptor fd, AFSocketType socketType) throws IOException {
        super((AFDatagramSocketImpl)new AFTIPCDatagramSocketImpl(fd, socketType));
    }

    protected AFTIPCDatagramChannel newChannel() {
        return new AFTIPCDatagramChannel(this);
    }

    public static AFTIPCDatagramSocket newInstance() throws IOException {
        return (AFTIPCDatagramSocket)AFTIPCDatagramSocket.newInstance(AFTIPCDatagramSocket::new);
    }

    public static AFTIPCDatagramSocket newInstance(AFSocketType socketType) throws IOException {
        return (AFTIPCDatagramSocket)AFTIPCDatagramSocket.newInstance(fd -> new AFTIPCDatagramSocket(fd, socketType));
    }

    public AFTIPCDatagramChannel getChannel() {
        return (AFTIPCDatagramChannel)super.getChannel();
    }

    @Override
    public AFTIPCErrInfo getErrInfo() {
        return AFTIPCErrInfo.of(((AFTIPCSocketImplExtensions)this.getImplExtensions()).getTIPCErrInfo());
    }

    @Override
    public AFTIPCDestName getDestName() {
        return AFTIPCDestName.of(((AFTIPCSocketImplExtensions)this.getImplExtensions()).getTIPCDestName());
    }
}

