/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AFUNIXSocketServer {
    private final SocketAddress listenAddress;
    private int maxConcurrentConnections = Runtime.getRuntime().availableProcessors();
    private int serverTimeout = 0;
    private int socketTimeout = (int)TimeUnit.SECONDS.toMillis(60L);
    private int serverBusyTimeout = (int)TimeUnit.SECONDS.toMillis(1L);
    private Thread listenThread = null;
    private ServerSocket serverSocket;
    private boolean stopRequested = false;
    private final Object connectionsMonitor = new Object();
    private ForkJoinPool connectionPool;

    public AFUNIXSocketServer(SocketAddress listenAddress) {
        Objects.requireNonNull(listenAddress, "listenAddress");
        this.listenAddress = listenAddress;
    }

    public int getMaxConcurrentConnections() {
        return this.maxConcurrentConnections;
    }

    public void setMaxConcurrentConnections(int maxConcurrentConnections) {
        if (this.connectionPool != null) {
            throw new IllegalStateException("Already configured");
        }
        this.maxConcurrentConnections = maxConcurrentConnections;
    }

    public int getServerTimeout() {
        return this.serverTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerTimeout(int serverTimeout) {
        AFUNIXSocketServer aFUNIXSocketServer = this;
        synchronized (aFUNIXSocketServer) {
            if (this.serverSocket != null) {
                throw new IllegalStateException("Already configured");
            }
            this.serverTimeout = serverTimeout;
        }
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getServerBusyTimeout() {
        return this.serverBusyTimeout;
    }

    public void setServerBusyTimeout(int serverFullTimeout) {
        this.serverBusyTimeout = serverFullTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        AFUNIXSocketServer aFUNIXSocketServer = this;
        synchronized (aFUNIXSocketServer) {
            return this.listenThread != null && this.listenThread.isAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        AFUNIXSocketServer aFUNIXSocketServer = this;
        synchronized (aFUNIXSocketServer) {
            if (this.isRunning()) {
                return;
            }
            if (this.connectionPool == null) {
                this.connectionPool = new ForkJoinPool(this.maxConcurrentConnections, ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, true);
            }
            Thread t = new Thread(this.toString() + " listening thread"){

                @Override
                public void run() {
                    try {
                        AFUNIXSocketServer.this.listen();
                    }
                    catch (Exception e) {
                        AFUNIXSocketServer.this.onListenException(e);
                    }
                }
            };
            t.start();
            this.listenThread = t;
        }
    }

    protected ServerSocket newServerSocket() throws IOException {
        if (this.listenAddress instanceof AFUNIXSocketAddress) {
            return AFUNIXServerSocket.newInstance();
        }
        return new ServerSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listen() throws IOException {
        ServerSocket server;
        AFUNIXSocketServer aFUNIXSocketServer = this;
        synchronized (aFUNIXSocketServer) {
            if (this.serverSocket != null) {
                throw new IllegalStateException("The server is already listening");
            }
            server = this.serverSocket = this.newServerSocket();
        }
        this.onServerStarting();
        try {
            server.bind(this.listenAddress);
            this.onServerBound(this.listenAddress);
            server.setSoTimeout(this.serverTimeout);
            long busyStartTime = 0L;
            while (!this.stopRequested && !Thread.interrupted()) {
                try {
                    Socket socket;
                    while (!this.stopRequested && this.connectionPool.getActiveThreadCount() >= this.maxConcurrentConnections) {
                        if (busyStartTime == 0L) {
                            busyStartTime = System.currentTimeMillis();
                        }
                        this.onServerBusy(busyStartTime);
                        Object object = this.connectionsMonitor;
                        synchronized (object) {
                            try {
                                this.connectionsMonitor.wait(this.serverBusyTimeout);
                            }
                            catch (InterruptedException e) {
                                throw (InterruptedIOException)new InterruptedIOException("Interrupted while waiting on server resources").initCause(e);
                            }
                        }
                    }
                    busyStartTime = 0L;
                    if (this.stopRequested) break;
                    if (server == null) {
                        break;
                    }
                    this.onServerReady(this.connectionPool.getActiveThreadCount());
                    try {
                        socket = server.accept();
                    }
                    catch (SocketException e) {
                        if (server.isClosed()) {
                            break;
                        }
                        this.onSocketExceptionDuringAccept(e);
                        throw e;
                    }
                    try {
                        socket.setSoTimeout(this.socketTimeout);
                    }
                    catch (SocketException e) {
                        this.onSocketExceptionAfterAccept(socket, e);
                        socket.close();
                        continue;
                    }
                    this.onSubmitted(socket, this.submit(socket, this.connectionPool));
                }
                catch (SocketTimeoutException e) {
                    if (!this.connectionPool.isQuiescent()) continue;
                    this.onServerShuttingDown();
                    this.connectionPool.shutdown();
                    break;
                }
            }
        }
        finally {
            this.stop();
            this.onServerStopped(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        AFUNIXSocketServer aFUNIXSocketServer = this;
        synchronized (aFUNIXSocketServer) {
            this.stopRequested = true;
            ServerSocket theServerSocket = this.serverSocket;
            this.serverSocket = null;
            if (theServerSocket == null) {
                return;
            }
            theServerSocket.close();
        }
    }

    private Future<?> submit(final Socket socket, ExecutorService executor) {
        return executor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AFUNIXSocketServer.this.onBeforeServingSocket(socket);
                try {
                    AFUNIXSocketServer.this.doServeSocket(socket);
                }
                catch (Exception e) {
                    AFUNIXSocketServer.this.onServingException(socket, e);
                }
                finally {
                    Object object = AFUNIXSocketServer.this.connectionsMonitor;
                    synchronized (object) {
                        AFUNIXSocketServer.this.connectionsMonitor.notifyAll();
                    }
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                    AFUNIXSocketServer.this.onAfterServingSocket(socket);
                }
            }
        });
    }

    protected abstract void doServeSocket(Socket var1) throws IOException;

    protected void onServerStarting() {
    }

    protected void onServerBound(SocketAddress address) {
    }

    protected void onServerReady(int activeCount) {
    }

    protected void onServerBusy(long busyStartTime) {
    }

    protected void onServerStopped(ServerSocket socket) {
    }

    protected void onSubmitted(Socket socket, Future<?> submission) {
    }

    protected void onServerShuttingDown() {
    }

    protected void onSocketExceptionDuringAccept(SocketException e) {
    }

    protected void onSocketExceptionAfterAccept(Socket socket, SocketException e) {
    }

    protected void onBeforeServingSocket(Socket socket) {
    }

    protected void onServingException(Socket socket, Exception e) {
    }

    protected void onAfterServingSocket(Socket socket) {
    }

    protected void onListenException(Exception e) {
    }
}

