/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.domain;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;
import com.kohlschutter.util.ProcessUtil;
import java.io.File;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFDatagramUtil;
import org.newsclub.net.unix.AFInputStream;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.AFUNIXDatagramSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketCredentials;
import org.newsclub.net.unix.SocketTestBase;
import org.newsclub.net.unix.domain.AFUNIXAddressSpecifics;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DOMAIN, AFSocketCapability.CAPABILITY_PEER_CREDENTIALS})
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public final class PeerCredentialsTest
extends SocketTestBase<AFUNIXSocketAddress> {
    private static AFUNIXSocketCredentials credsSockets = null;
    private static AFUNIXSocketCredentials credsDatagramSockets = null;

    public PeerCredentialsTest() {
        super(AFUNIXAddressSpecifics.INSTANCE);
    }

    @Test
    public void testSocketsSameProcess() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(10L), () -> {
            final CompletableFuture clientCredsFuture = new CompletableFuture();
            final Semaphore sema = new Semaphore(0);
            try (SocketTestBase.AFUNIXServerThread serverThread = new SocketTestBase.AFUNIXServerThread(this){
                final /* synthetic */ PeerCredentialsTest this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                protected void handleConnection(AFUNIXSocket socket) throws IOException {
                    AFUNIXSocketCredentials clientCreds = socket.getPeerCredentials();
                    clientCredsFuture.complete(clientCreds);
                    try {
                        sema.acquire();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
                 AFUNIXSocket socket = (AFUNIXSocket)this.connectTo(serverThread.getServerAddress());
                 AFInputStream unused = socket.getInputStream();){
                AFUNIXSocketCredentials serverCreds = socket.getPeerCredentials();
                AFUNIXSocketCredentials clientCreds = (AFUNIXSocketCredentials)clientCredsFuture.get();
                sema.release();
                Assertions.assertEquals((Object)clientCreds, (Object)serverCreds, (String)"Since our tests run in the same process, the peer credentials must be identical");
                Assertions.assertEquals((Object)clientCreds.toString(), (Object)serverCreds.toString(), (String)"Since our tests run in the same process, the peer credentials must be identical");
                Assertions.assertEquals((long)clientCreds.getGid(), (long)serverCreds.getGid(), (String)"Since our tests run in the same process, the peer credentials must be identical");
                Assertions.assertArrayEquals((long[])clientCreds.getGids(), (long[])serverCreds.getGids(), (String)"Since our tests run in the same process, the peer credentials must be identical");
                Assertions.assertEquals((long)clientCreds.getUid(), (long)serverCreds.getUid(), (String)"Since our tests run in the same process, the peer credentials must be identical");
                Assertions.assertEquals((long)clientCreds.getPid(), (long)serverCreds.getPid(), (String)"Since our tests run in the same process, the peer credentials must be identical");
                Assertions.assertEquals((Object)clientCreds.getUUID(), (Object)serverCreds.getUUID(), (String)"Since our tests run in the same process, the peer credentials must be identical");
                if (clientCreds.getPid() != -1L) {
                    Assertions.assertEquals((long)ProcessUtil.getPid(), (long)clientCreds.getPid(), (String)"The returned PID must be the one of our process");
                }
                PeerCredentialsTest.setCredsSockets(clientCreds);
            }
        });
    }

    private static void checkCredentialFeatures(StringBuilder sbYes, StringBuilder sbNo, String key, boolean supported) {
        (supported ? sbYes : sbNo).append(' ').append(key);
    }

    private static void checkCredentialFeatures(AFUNIXSocketCredentials creds) {
        StringBuilder sbYes = new StringBuilder(32);
        StringBuilder sbNo = new StringBuilder(32);
        PeerCredentialsTest.checkCredentialFeatures(sbYes, sbNo, "pid", creds.getPid() > 0L);
        PeerCredentialsTest.checkCredentialFeatures(sbYes, sbNo, "uid", creds.getUid() != -1L);
        PeerCredentialsTest.checkCredentialFeatures(sbYes, sbNo, "gid", creds.getGid() != -1L);
        PeerCredentialsTest.checkCredentialFeatures(sbYes, sbNo, "additional_gids", creds.getGids() != null && creds.getGids().length > 0);
        PeerCredentialsTest.checkCredentialFeatures(sbYes, sbNo, "uuid", creds.getUUID() != null);
        System.out.print("Supported credentials:  ");
        if (sbYes.length() == 0) {
            System.out.println(" (none)");
        } else {
            System.out.println(sbYes);
        }
        System.out.print("Unsupported credentials:");
        if (sbNo.length() == 0) {
            System.out.println(" (none)");
        } else {
            System.out.println(sbNo);
        }
    }

    @AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DATAGRAMS})
    @Test
    public void testDatagramSocket() throws Exception {
        AFUNIXSocketAddress ds1Addr = AFUNIXSocketAddress.of((File)PeerCredentialsTest.newTempFile());
        AFUNIXSocketAddress ds2Addr = AFUNIXSocketAddress.of((File)PeerCredentialsTest.newTempFile());
        try (AFUNIXDatagramSocket ds1 = AFUNIXDatagramSocket.newInstance();
             AFUNIXDatagramSocket ds2 = AFUNIXDatagramSocket.newInstance();){
            ds1.bind((SocketAddress)ds1Addr);
            ds2.bind((SocketAddress)ds2Addr);
            ds1.connect((SocketAddress)ds2Addr);
            ds2.connect((SocketAddress)ds1Addr);
            DatagramPacket dp = AFDatagramUtil.datagramWithCapacityAndPayload("Hello".getBytes(StandardCharsets.UTF_8));
            ds2.send(dp);
            dp = AFDatagramUtil.datagramWithCapacity(1024);
            ds1.receive(dp);
            AFUNIXSocketCredentials pc1 = ds1.getPeerCredentials();
            AFUNIXSocketCredentials pc2 = ds2.getPeerCredentials();
            Assertions.assertEquals((Object)pc1, (Object)pc2);
            PeerCredentialsTest.setCredsDatagramSockets(pc1);
        }
    }

    private static void setCredsSockets(AFUNIXSocketCredentials creds) {
        credsSockets = creds;
    }

    private static void setCredsDatagramSockets(AFUNIXSocketCredentials creds) {
        credsDatagramSockets = creds;
    }

    @AfterAll
    public static void ensureSameCreds() {
        if (credsSockets != null) {
            PeerCredentialsTest.checkCredentialFeatures(credsSockets);
            if (credsDatagramSockets != null) {
                if (credsDatagramSockets.isEmpty() && !credsSockets.isEmpty()) {
                    System.out.println("WARNING: No peer credentials for datagram sockets");
                } else {
                    if (credsSockets != null && !credsSockets.equals((Object)credsDatagramSockets) && credsDatagramSockets.getUid() == 0L && credsDatagramSockets.getGid() == 0L) {
                        throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_WITH_ISSUES, "Credentials received via AFUNIXDatagramSocket returned " + credsDatagramSockets + ", which may not be correct; expected: " + credsSockets + ". This could be a problem specific to your operating system");
                    }
                    Assertions.assertEquals((Object)credsSockets, (Object)credsDatagramSockets, (String)"The credentials received via Socket and via DatagramSocket should be the same");
                }
            }
        }
    }
}

