/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.darwin.system;

import java.io.IOException;
import java.net.SocketException;
import java.util.LinkedHashSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.darwin.system.AFSYSTEMDatagramSocket;
import org.newsclub.net.unix.darwin.system.WellKnownKernelControlNames;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class KernelControlNamesTest {
    @Test
    public void testStandardKernelControlNames() throws Exception {
        try (AFSYSTEMDatagramSocket socket = AFSYSTEMDatagramSocket.newInstance();){
            Assertions.assertThrows(IOException.class, () -> socket.getNodeIdentity("definitely.missing"));
            int errors = 0;
            LinkedHashSet<Integer> ids = new LinkedHashSet<Integer>();
            for (WellKnownKernelControlNames n : WellKnownKernelControlNames.values()) {
                try {
                    int id = socket.getNodeIdentity(n.getControlName());
                    Assertions.assertTrue((id > 0 ? 1 : 0) != 0, (String)"id should be a positive integer");
                    ids.add(id);
                }
                catch (SocketException e) {
                    ++errors;
                }
            }
            System.out.println("Resolved control names " + ids.size() + "/" + WellKnownKernelControlNames.values().length);
            Assertions.assertEquals((int)(WellKnownKernelControlNames.values().length - errors), (int)ids.size());
        }
    }
}

