/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.testutil.AssertUtil;
import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import java.util.Arrays;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFAddressFamily;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketProtocol;
import org.newsclub.net.unix.AFSocketType;
import org.newsclub.net.unix.AFTIPCSocketAddress;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFTIPCSocketAddressTest {
    @Test
    public void testSchemesAvailable() throws Exception {
        AssertUtil.assertSetContains((Set)AFAddressFamily.uriSchemes(), Arrays.asList("tipc", "http+tipc", "https+tipc"));
    }

    @Test
    public void testParseFail() throws Exception {
        Assertions.assertThrows(SocketException.class, () -> AFTIPCSocketAddress.of((URI)URI.create("tipc://invalid")));
        Assertions.assertThrows(SocketException.class, () -> AFTIPCSocketAddress.of((URI)URI.create("tipc://socket.23/")));
    }

    private AFTIPCSocketAddress validateAddress(String uri) throws IOException {
        URI u = URI.create(uri);
        AFTIPCSocketAddress address = AFTIPCSocketAddress.of((URI)u);
        URI u2 = address.toURI(u.getScheme(), null);
        Assertions.assertEquals((Object)address, (Object)AFTIPCSocketAddress.of((URI)u2));
        return address;
    }

    @Test
    public void testSocketURI() throws Exception {
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofSocket((int)1, (int)2), (Object)this.validateAddress("tipc://socket.1.2"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofSocket((int)1, (int)2), (Object)this.validateAddress("tipc://socket.1.2.0"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofSocket((int)1, (int)2), (Object)this.validateAddress("tipc://0-socket.1.2.0"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofSocket((int)1, (int)2), (Object)this.validateAddress("tipc://0-3.1.2.0"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofSocket((int)4, (int)1, (int)2), (Object)this.validateAddress("tipc://0-socket.1.2.0:4"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofSocket((int)-1, (int)-1), (Object)this.validateAddress("tipc://socket.4294967295.4294967295"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofSocket((int)-1, (int)-1), (Object)this.validateAddress("tipc://socket.0xffffffff.0xffffffff"));
    }

    @Test
    public void testServiceURI() throws Exception {
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofService((int)1, (int)2), (Object)this.validateAddress("tipc://1.2"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofService((int)1, (int)2), (Object)this.validateAddress("tipc://service.1.2"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofService((int)1, (int)2), (Object)this.validateAddress("tipc://service.1.2.0"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofService((AFTIPCSocketAddress.Scope)AFTIPCSocketAddress.Scope.SCOPE_NOT_SPECIFIED, (int)1, (int)2), (Object)this.validateAddress("tipc://0-service.1.2.0"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofService((int)1, (int)2), (Object)this.validateAddress("tipc://2-2.1.2.0"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofService((AFTIPCSocketAddress.Scope)AFTIPCSocketAddress.Scope.SCOPE_CLUSTER, (int)1, (int)2, (int)3), (Object)this.validateAddress("tipc://2-2.1.2.3"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofService((int)4, (AFTIPCSocketAddress.Scope)AFTIPCSocketAddress.Scope.SCOPE_CLUSTER, (int)1, (int)2, (int)3), (Object)this.validateAddress("tipc://2-2.1.2.3:4"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofService((AFTIPCSocketAddress.Scope)AFTIPCSocketAddress.Scope.SCOPE_CLUSTER, (int)-1, (int)-1, (int)-1), (Object)this.validateAddress("tipc://service.4294967295.4294967295.4294967295"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofService((int)12345, (AFTIPCSocketAddress.Scope)AFTIPCSocketAddress.Scope.SCOPE_CLUSTER, (int)-1, (int)-1, (int)-1), (Object)this.validateAddress("tipc://service.4294967295.4294967295.4294967295:12345"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofService((int)-1, (int)-1), (Object)this.validateAddress("tipc://service.0xffffffff.0xffffffff"));
    }

    @Test
    public void testServiceRangeURI() throws Exception {
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofServiceRange((int)1, (int)2, (int)3), (Object)this.validateAddress("tipc://service-range.1.2.3"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofServiceRange((int)1, (int)2, (int)2), (Object)this.validateAddress("tipc://service-range.1.2"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofServiceRange((int)1, (int)2, (int)3), (Object)this.validateAddress("tipc://service-range.1.2.3"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofServiceRange((AFTIPCSocketAddress.Scope)AFTIPCSocketAddress.Scope.SCOPE_NOT_SPECIFIED, (int)1, (int)2, (int)3), (Object)this.validateAddress("tipc://0-service-range.1.2.3"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofServiceRange((int)1, (int)2, (int)3), (Object)this.validateAddress("tipc://2-1.1.2.3"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofServiceRange((int)4, (AFTIPCSocketAddress.Scope)AFTIPCSocketAddress.Scope.SCOPE_CLUSTER, (int)1, (int)2, (int)3), (Object)this.validateAddress("tipc://service-range.1.2.3:4"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofServiceRange((int)4, (AFTIPCSocketAddress.Scope)AFTIPCSocketAddress.Scope.SCOPE_CLUSTER, (int)1, (int)2, (int)3), (Object)this.validateAddress("tipc://cluster-service-range.1.2.3:4"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofServiceRange((int)4, (AFTIPCSocketAddress.Scope)AFTIPCSocketAddress.Scope.SCOPE_NODE, (int)1, (int)2, (int)3), (Object)this.validateAddress("tipc://node-service-range.1.2.3:4"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofServiceRange((int)12345, (AFTIPCSocketAddress.Scope)AFTIPCSocketAddress.Scope.SCOPE_CLUSTER, (int)-1, (int)-1, (int)-1), (Object)this.validateAddress("tipc://service-range.4294967295.4294967295.4294967295:12345"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofServiceRange((int)-1, (int)-1, (int)-1), (Object)this.validateAddress("tipc://service-range.0xffffffff.0xffffffff"));
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofServiceRange((int)-1, (int)-1, (int)-1), (Object)this.validateAddress("tipc://service-range.0xffffffff.0xffffffff.0xffffffff"));
    }

    @Test
    public void testGeneric() throws Exception {
        Assertions.assertEquals((Object)AFTIPCSocketAddress.ofServiceRange((int)4, (AFTIPCSocketAddress.Scope)AFTIPCSocketAddress.Scope.ofValue((int)56), (int)1, (int)2, (int)3), (Object)this.validateAddress("tipc://56-service-range.1.2.3:4"));
    }

    @Test
    public void testSocatString() throws Exception {
        String socatString;
        try {
            socatString = AFTIPCSocketAddress.ofService((int)123, (int)456).toSocatAddressString(AFSocketType.SOCK_STREAM, AFSocketProtocol.DEFAULT);
            Assertions.assertNotNull((Object)socatString);
        }
        catch (SocketException e) {
            if (AFSocket.supports((AFSocketCapability)AFSocketCapability.CAPABILITY_TIPC)) {
                throw e;
            }
            return;
        }
        Assertions.assertTrue((boolean)socatString.contains(":"));
    }
}

