/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.testutil.AssertUtil;
import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import java.util.Arrays;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFAddressFamily;
import org.newsclub.net.unix.AFSYSTEMSocketAddress;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketProtocol;
import org.newsclub.net.unix.AFSocketType;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFSYSTEMSocketAddressTest {
    @Test
    public void testSchemesAvailable() throws Exception {
        AssertUtil.assertSetContains((Set)AFAddressFamily.uriSchemes(), Arrays.asList("afsystem"));
    }

    @Test
    public void testParseFail() throws Exception {
        Assertions.assertThrows(SocketException.class, () -> AFSYSTEMSocketAddress.of((URI)URI.create("afsystem://invalid")));
        Assertions.assertThrows(SocketException.class, () -> AFSYSTEMSocketAddress.of((URI)URI.create("afsystem://socket.23/")));
    }

    private AFSYSTEMSocketAddress validateAddress(String uri) throws IOException {
        URI u = URI.create(uri);
        AFSYSTEMSocketAddress address = AFSYSTEMSocketAddress.of((URI)u);
        URI u2 = address.toURI(u.getScheme(), null);
        Assertions.assertEquals((Object)address, (Object)AFSYSTEMSocketAddress.of((URI)u2));
        return address;
    }

    @Test
    public void testURI() throws Exception {
        Assertions.assertEquals((Object)AFSYSTEMSocketAddress.ofSysAddrIdUnit((AFSYSTEMSocketAddress.SysAddr)AFSYSTEMSocketAddress.SysAddr.AF_SYS_CONTROL, (int)3, (int)4), (Object)this.validateAddress("afsystem://2.3.4"));
    }

    @Test
    public void testSocatString() throws Exception {
        String socatString;
        try {
            socatString = AFSYSTEMSocketAddress.ofSysAddrIdUnit((AFSYSTEMSocketAddress.SysAddr)AFSYSTEMSocketAddress.SysAddr.AF_SYS_CONTROL, (int)3, (int)4).toSocatAddressString(AFSocketType.SOCK_STREAM, AFSocketProtocol.DEFAULT);
            Assertions.assertNotNull((Object)socatString);
        }
        catch (SocketException e) {
            if (AFSocket.supports((AFSocketCapability)AFSocketCapability.CAPABILITY_DARWIN)) {
                throw e;
            }
            return;
        }
        Assertions.assertTrue((boolean)socatString.contains(":"));
    }
}

