/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.domain;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.TestAbortedNotAnIssueException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.AFSocketType;
import org.newsclub.net.unix.AFUNIXDatagramChannel;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketPair;
import org.newsclub.net.unix.OperationNotSupportedSocketException;
import org.newsclub.net.unix.domain.AFUNIXAddressSpecifics;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DOMAIN, AFSocketCapability.CAPABILITY_UNIX_DATAGRAMS})
@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public final class DatagramSocketTest
extends org.newsclub.net.unix.DatagramSocketTest<AFUNIXSocketAddress> {
    public DatagramSocketTest() {
        super(AFUNIXAddressSpecifics.INSTANCE);
    }

    @Test
    public void testSeqPacket() throws Exception {
        AFUNIXSocketPair pair;
        try {
            pair = AFUNIXSocketPair.openDatagram((AFSocketType)AFSocketType.SOCK_SEQPACKET);
        }
        catch (OperationNotSupportedSocketException e) {
            throw new TestAbortedNotAnIssueException("SEQPACKET not supported", (Throwable)e);
        }
        String msg = "Hello World";
        ByteBuffer buf = ByteBuffer.wrap(msg.getBytes(StandardCharsets.UTF_8));
        ByteBuffer dst = ByteBuffer.allocate(64);
        ((AFUNIXDatagramChannel)pair.getSocket1()).send(buf, null);
        int r = ((AFUNIXDatagramChannel)pair.getSocket2()).read(dst);
        Assertions.assertEquals((int)buf.limit(), (int)r);
        dst.flip();
        Assertions.assertEquals((int)buf.limit(), (int)dst.limit());
        Assertions.assertEquals((Object)msg, (Object)StandardCharsets.UTF_8.decode(dst).toString());
    }
}

