/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.selftest;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;
import com.kohlschutter.util.ConsolePrintStream;
import com.kohlschutter.util.SystemPropertyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.junit.jupiter.engine.JupiterTestEngine;
import org.junit.jupiter.engine.discovery.DiscoverySelectorResolver;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestEngine;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.newsclub.lib.junixsocket.custom.NarMetadata;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.selftest.SelftestExecutor;
import org.newsclub.net.unix.selftest.SelftestProvider;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Selftest {
    private static final Class<? extends Annotation> CAP_ANNOTATION_CLASS = Selftest.getAFUNIXSocketCapabilityRequirementClass();
    private final ConsolePrintStream out = ConsolePrintStream.wrapSystemOut();
    private final Map<String, ModuleResult> results = new LinkedHashMap<String, ModuleResult>();
    private final List<AFSocketCapability> supportedCapabilites = new ArrayList<AFSocketCapability>();
    private final List<AFSocketCapability> unsupportedCapabilites = new ArrayList<AFSocketCapability>();
    private boolean withIssues = false;
    private boolean fail = false;
    private boolean modified = false;
    private boolean isSupportedAFUNIX = false;
    private final List<String> important = new ArrayList<String>();
    private boolean inconclusive = false;

    /*
     * Enabled aggressive block sorting
     */
    @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
    public static void main(String[] args) throws Exception {
        int rc;
        Selftest st = new Selftest();
        st.printExplanation();
        st.dumpSystemProperties();
        st.dumpOSReleaseFiles();
        st.checkSupported();
        st.checkCapabilities();
        SelftestProvider sp = new SelftestProvider();
        Set<String> disabledModules = sp.modulesDisabledByDefault();
        ArrayList<String> messagesAtEnd = new ArrayList<String>();
        for (Map.Entry<String, Class<?>[]> en : sp.tests().entrySet()) {
            String module;
            block8: {
                module = en.getKey();
                if (disabledModules.contains(module)) {
                    if (SystemPropertyUtil.getBooleanSystemProperty((String)("selftest.enable-module." + module), (boolean)false)) {
                        st.modified = true;
                        break block8;
                    } else {
                        messagesAtEnd.add("Skipping optional module: " + module + "; enable by launching with -Dselftest.enable-module." + module + "=true");
                        continue;
                    }
                }
                if (SystemPropertyUtil.getBooleanSystemProperty((String)("selftest.disable-module." + module), (boolean)false)) {
                    messagesAtEnd.add("Skipping required module: " + module + "; this taints the test");
                    st.withIssues = true;
                }
            }
            st.runTests(module, en.getValue());
        }
        if (!messagesAtEnd.isEmpty()) {
            for (String m : messagesAtEnd) {
                System.out.println(m);
            }
        }
        st.checkInitError();
        st.dumpResults();
        int n = rc = st.isFail() ? 1 : 0;
        if (SystemPropertyUtil.getBooleanSystemProperty((String)"selftest.wait.at-end", (boolean)false)) {
            System.gc();
            System.out.print("Press any key to end test. ");
            System.out.flush();
            System.in.read();
            System.out.println("RC=" + rc);
        }
        System.out.flush();
        System.exit(rc);
    }

    public void printExplanation() throws IOException {
        this.out.println("This program determines whether junixsocket is supported on the current platform.");
        this.out.println("The final line should say whether the selftest passed or failed.");
        this.out.println();
        this.out.println("If the selftest failed, please visit https://github.com/kohlschutter/junixsocket/issues");
        this.out.println("and file a new bug report with the output below.");
        this.out.println();
        this.out.println("junixsocket selftest version " + AFUNIXSocket.getVersion());
        this.out.println();
    }

    public void dumpSystemProperties() {
        this.out.println("System properties:");
        this.out.println();
        for (Map.Entry<Object, Object> en : new TreeMap<Object, Object>(System.getProperties()).entrySet()) {
            String key = String.valueOf(en.getKey());
            String value = String.valueOf(en.getValue());
            StringBuilder sb = new StringBuilder();
            block6: for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '\n': {
                        sb.append("\\n");
                        continue block6;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block6;
                    }
                    case '\t': {
                        sb.append("\\r");
                        continue block6;
                    }
                    default: {
                        if (c < ' ' || c >= '\u007f') {
                            sb.append(String.format(Locale.ENGLISH, "\\u%04x", (int)c));
                        }
                        sb.append(c);
                    }
                }
            }
            this.out.println(key + ": " + sb.toString());
        }
        this.out.println();
    }

    public void checkSupported() {
        this.out.print("AFSocket.isSupported: ");
        this.out.flush();
        boolean isSupported = AFSocket.isSupported();
        this.out.println(isSupported);
        this.out.println();
        this.out.flush();
        if (!isSupported) {
            this.out.println("FAIL: junixsocket is not supported on this platform");
            this.out.println();
            this.fail = true;
        }
        this.out.print("AFUNIXSocket.isSupported: ");
        this.out.flush();
        this.isSupportedAFUNIX = AFUNIXSocket.isSupported();
        this.out.println(this.isSupportedAFUNIX);
        this.out.println();
        this.out.flush();
        if (!this.isSupportedAFUNIX) {
            this.out.println("WARNING: AF_UNIX sockets are not supported on this platform");
            this.out.println();
            this.withIssues = true;
        }
    }

    public void checkCapabilities() {
        for (AFSocketCapability cap : AFSocketCapability.values()) {
            boolean supported = AFSocket.supports(cap);
            (supported ? this.supportedCapabilites : this.unsupportedCapabilites).add(cap);
        }
    }

    public boolean isFail() {
        return this.fail;
    }

    private void checkInitError() {
        Throwable t = Selftest.retrieveInitError();
        if (t == null) {
            return;
        }
        this.important.add("The native library failed to load.");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        String ts = sw.toString();
        String tsLower = ts.toLowerCase(Locale.ENGLISH);
        if (tsLower.contains("not permitted") || ts.contains("permission")) {
            this.important.add("It looks like there were some permission errors.");
        }
        if (tsLower.contains("failed to map segment")) {
            this.important.add("Your temporary directory is probably mounted with \"noexec\", which prevents the native library from loading.");
            this.important.add("see: https://github.com/kohlschutter/junixsocket/issues/99");
            Object tmpDir = Selftest.retrieveTempDir();
            if (tmpDir == null) {
                tmpDir = System.getProperty("java.io.tmpdir");
            }
            if (tmpDir != null) {
                this.important.add("Temp dir: " + tmpDir);
            }
            this.important.add("You can specify a different directory using -Dorg.newsclub.net.unix.library.tmpdir=");
        }
    }

    public void dumpResults() {
        if (this.modified) {
            this.important.add("Selftest was modified, for example to exclude/include certain tests.");
            this.inconclusive = true;
        }
        if (!this.isSupportedAFUNIX) {
            this.important.add("Environment does not support UNIX sockets, which is an important part of junixsocket.");
        }
        if (this.inconclusive) {
            this.important.add("Selftest results may be inconclusive.");
        }
        if (this.withIssues) {
            this.important.add("\"With issues\": Please carefully check the output above; the software may not be able to do what you want.");
        }
        this.out.println();
        this.out.println("Selftest results:");
        for (Map.Entry<String, ModuleResult> en : this.results.entrySet()) {
            String extra;
            String result;
            ModuleResult res = en.getValue();
            String string = result = res == null ? null : res.result.name();
            if (res == null) {
                result = "SKIP";
                extra = "(skipped by user request)";
            } else if (res.summary == null) {
                extra = res.throwable == null ? "(unknown error)" : res.throwable.toString();
                this.fail = true;
            } else {
                TestExecutionSummary summary = res.summary;
                long nSucceeded = summary.getTestsSucceededCount() + res.getNumAbortedNonIssues();
                extra = nSucceeded + "/" + summary.getTestsFoundCount();
                long nSkipped = summary.getTestsSkippedCount();
                if (nSkipped > 0L) {
                    extra = extra + " (" + nSkipped + " skipped)";
                }
            }
            this.out.println(result + "\t" + en.getKey() + "\t" + extra);
        }
        this.out.println();
        if (!this.important.isEmpty()) {
            for (String l : this.important) {
                this.out.println("IMPORTANT: " + l);
            }
            this.out.println();
        }
        this.out.println("Supported capabilities:   " + this.supportedCapabilites);
        this.out.println("Unsupported capabilities: " + this.unsupportedCapabilites);
        this.out.println();
        if (this.fail || this.withIssues) {
            if (this.inconclusive || this.modified) {
                this.out.println("Selftest INCONCLUSIVE");
            } else if (this.fail) {
                this.out.println("Selftest FAILED");
            } else if (this.withIssues) {
                this.out.println("Selftest PASSED WITH ISSUES");
            }
        } else {
            this.out.println("Selftest PASSED");
        }
    }

    private static Class<? extends Annotation> getAFUNIXSocketCapabilityRequirementClass() {
        try {
            return Class.forName("org.newsclub.net.unix.AFUNIXSocketCapabilityRequirement");
        }
        catch (ClassNotFoundException e1) {
            return null;
        }
    }

    private boolean checkIfCapabilitiesSupported(String className) {
        block7: {
            if (CAP_ANNOTATION_CLASS != null) {
                try {
                    Class<?> klass = Class.forName(className);
                    Annotation annotation = klass.getAnnotation(CAP_ANNOTATION_CLASS);
                    if (annotation == null) break block7;
                    try {
                        AFSocketCapability[] caps = (AFSocketCapability[])annotation.getClass().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
                        if (caps != null) {
                            for (AFSocketCapability cap : caps) {
                                if (AFSocket.supports(cap)) continue;
                                this.out.println("Skipping class " + className + "; unsupported capability: " + (Object)((Object)cap));
                                return false;
                            }
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    }
                }
                catch (ClassNotFoundException e) {
                    this.out.println("Class not found: " + className);
                    this.withIssues = true;
                }
            }
        }
        return true;
    }

    public void runTests(String module, Class<?>[] testClasses) {
        ModuleResult moduleResult;
        String prefix = "Testing \"" + module + "\"... ";
        this.out.markPosition();
        this.out.update(prefix);
        this.out.flush();
        String only = System.getProperty("selftest.only", "");
        if (!only.isEmpty()) {
            this.modified = true;
        }
        if (Boolean.valueOf(System.getProperty("selftest.skip." + module, "false")).booleanValue()) {
            this.out.println("Skipping module " + module + "; skipped by request");
            this.withIssues = true;
            this.modified = true;
            moduleResult = new ModuleResult(Result.SKIP, null, null);
        } else {
            ArrayList list = new ArrayList(testClasses.length);
            for (Class<?> testClass : testClasses) {
                boolean skipFullyQualified;
                if (testClass == null) continue;
                String className = testClass.getName();
                String simpleName = testClass.getSimpleName();
                if (!only.isEmpty() && !only.equals(className) && !only.equals(simpleName)) continue;
                String skipFullyQualifiedProp = System.getProperty("selftest.skip." + className, "");
                boolean bl = skipFullyQualified = !skipFullyQualifiedProp.isEmpty() && Boolean.valueOf(skipFullyQualifiedProp) != false;
                if (skipFullyQualified || Boolean.valueOf(System.getProperty("selftest.skip." + simpleName, "false")).booleanValue()) {
                    this.out.println("Skipping test class " + className + "; skipped by request");
                    this.modified = true;
                    this.withIssues = true;
                    continue;
                }
                if (!this.checkIfCapabilitiesSupported(className)) continue;
                list.add(testClass);
            }
            TestExecutionSummary summary = null;
            Exception exception = null;
            long numAbortedNonIssues = 0L;
            try {
                SelftestExecutor ex = new SelftestExecutor(list, prefix);
                summary = ex.execute(this.out);
                for (Map.Entry<TestIdentifier, TestExecutionResult> en : ex.getTestsWithWarnings().entrySet()) {
                    TestIdentifier tid = en.getKey();
                    TestExecutionResult res = en.getValue();
                    Optional t = res.getThrowable();
                    if (!t.isPresent() || !(t.get() instanceof TestAbortedWithImportantMessageException)) continue;
                    String key = module + ": " + ex.getTestIdentifier((String)tid.getParentId().get()).getDisplayName() + "." + tid.getDisplayName();
                    TestAbortedWithImportantMessageException ime = (TestAbortedWithImportantMessageException)t.get();
                    TestAbortedWithImportantMessageException.MessageType messageType = ime.messageType();
                    if (messageType.isIncludeTestInfo()) {
                        this.important.add(key + ": " + ime.getMessage());
                    } else {
                        this.important.add(ime.getMessage());
                    }
                    if (messageType.isWithIssues()) continue;
                    ++numAbortedNonIssues;
                }
            }
            catch (Exception e) {
                e.printStackTrace((PrintStream)this.out);
                exception = e;
            }
            if (exception != null || summary == null) {
                moduleResult = new ModuleResult(Result.FAIL, null, exception);
                this.fail = true;
            } else {
                Result result;
                if (summary.getTestsFailedCount() > 0L) {
                    result = Result.FAIL;
                    this.fail = true;
                } else if (summary.getTestsFoundCount() == 0L) {
                    result = Result.NONE;
                    this.fail = true;
                } else if (summary.getTestsSucceededCount() + summary.getTestsSkippedCount() + numAbortedNonIssues == summary.getTestsFoundCount()) {
                    result = Result.PASS;
                } else if (summary.getTestsAbortedCount() > 0L) {
                    result = Result.DONE;
                    this.withIssues = true;
                } else {
                    result = Result.DONE;
                }
                moduleResult = new ModuleResult(result, summary, null);
                moduleResult.numAbortedNonIssues = numAbortedNonIssues;
            }
        }
        this.results.put(module, moduleResult);
    }

    private void dumpContentsOfSystemConfigFile(File file) {
        if (!file.exists()) {
            return;
        }
        String p = file.getAbsolutePath();
        System.out.println("BEGIN contents of file: " + p);
        int maxToRead = 4096;
        char[] buf = new char[4096];
        try (InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset());
            int read = -1;
            boolean lastWasNewline = false;
            for (int numRead = 0; numRead < 4096 && (read = isr.read(buf)) != -1; numRead += read) {
                outWriter.write(buf, 0, read);
                outWriter.flush();
                lastWasNewline = read > 0 && buf[read - 1] == '\n';
            }
            if (!lastWasNewline) {
                System.out.println();
            }
            if (read != -1) {
                System.out.println("[...]");
            }
        }
        catch (Exception e) {
            System.out.println("ERROR while reading contents of file: " + p + ": " + e);
        }
        System.out.println("=END= contents of file: " + p);
        System.out.println();
    }

    public void dumpOSReleaseFiles() throws IOException {
        HashSet<Path> canonicalPaths = new HashSet<Path>();
        for (String f : new String[]{"/etc/os-release", "/etc/lsb-release", "/etc/lsb_release", "/etc/system-release", "/etc/system-release-cpe", "/etc/debian_version", "/etc/fedora-release", "/etc/redhat-release", "/etc/centos-release", "/etc/centos-release-upstream", "/etc/SuSE-release", "/etc/arch-release", "/etc/gentoo-release", "/etc/ubuntu-release"}) {
            File file = new File(f);
            if (!file.exists() || file.isDirectory()) continue;
            Path p = file.toPath().toAbsolutePath();
            for (int i = 0; i < 2; ++i) {
                Path p2;
                if (!Files.isSymbolicLink(p) || (p2 = Files.readSymbolicLink(p)).isAbsolute()) continue;
                p = new File(p.toFile().getParentFile(), p2.toString()).toPath().toAbsolutePath();
            }
            if (!canonicalPaths.add(p)) continue;
            this.dumpContentsOfSystemConfigFile(file);
        }
    }

    private static Throwable retrieveInitError() {
        try {
            Class<?> clazz = Class.forName("org.newsclub.net.unix.SelftestDiagnosticsHelper");
            return (Throwable)clazz.getMethod("initError", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static File retrieveTempDir() {
        try {
            Class<?> clazz = Class.forName("org.newsclub.net.unix.SelftestDiagnosticsHelper");
            return (File)clazz.getMethod("tempDir", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class ModuleResult {
        private final Result result;
        private final TestExecutionSummary summary;
        private final Throwable throwable;
        private long numAbortedNonIssues = 0L;

        ModuleResult(Result result, TestExecutionSummary summary, Throwable t) {
            Objects.requireNonNull(result);
            this.result = result;
            this.summary = summary;
            this.throwable = t;
        }

        long getNumAbortedNonIssues() {
            return this.numAbortedNonIssues;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static enum Result {
        SKIP,
        PASS,
        DONE,
        NONE,
        FAIL;

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
    static final class MinimizeJarDependencies {
        JupiterTestEngine jte;
        HierarchicalTestEngine<?> hte;
        EngineDescriptor ed;
        DiscoverySelectorResolver dsr;
        org.newsclub.lib.junixsocket.common.NarMetadata nmCommon;
        NarMetadata nmCustom;

        MinimizeJarDependencies() {
        }
    }
}

