/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public abstract class SelectorTest<A extends SocketAddress>
extends SocketTestBase<A> {
    protected SelectorTest(AddressSpecifics<A> asp) throws IOException {
        super(asp);
    }

    private static void assertChangeToNonBlocking(ServerSocketChannel as) throws IOException {
        Assertions.assertTrue((boolean)as.isBlocking());
        as.configureBlocking(false);
        Assertions.assertFalse((boolean)as.isBlocking());
    }

    private static void assertSelect(int expected, Selector sel, boolean block) throws IOException {
        int now = sel.selectNow();
        if (now != 0) {
            Assertions.assertEquals((int)expected, (int)now);
        }
        if (block) {
            now = Math.max(now, sel.select());
            Assertions.assertEquals((int)expected, (int)now);
        }
        Assertions.assertEquals((int)expected, (int)Math.max(now, sel.selectNow()));
        Assertions.assertEquals((int)expected, (int)sel.selectedKeys().size());
    }

    @Test
    public void testNonBlockingAccept() throws IOException, InterruptedException {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
            AbstractSelector sscSel = this.selectorProvider().openSelector();
            Assertions.assertTrue((boolean)sscSel.selectedKeys().isEmpty());
            try (ServerSocketChannel ssc = this.selectorProvider().openServerSocketChannel();){
                ssc.bind(this.newTempAddress());
                SelectorTest.assertChangeToNonBlocking(ssc);
                SelectionKey key = ssc.register(sscSel, 16);
                Assertions.assertEquals(Collections.singleton(key), sscSel.keys());
                Assertions.assertTrue((boolean)sscSel.selectedKeys().isEmpty());
                Assertions.assertNull((Object)ssc.accept());
                Assertions.assertEquals((int)0, (int)sscSel.selectNow());
                try (SocketChannel sc = this.selectorProvider().openSocketChannel();){
                    CompletableFuture future = new CompletableFuture();
                    new Thread(() -> {
                        try {
                            future.complete(sc.connect(ssc.getLocalAddress()));
                        }
                        catch (IOException e) {
                            future.completeExceptionally(e);
                        }
                    }).start();
                    SelectorTest.assertSelect(1, sscSel, true);
                    Assertions.assertEquals(Collections.singleton(key), sscSel.selectedKeys());
                    SocketChannel sscsc = ssc.accept();
                    Assertions.assertNotNull((Object)sscsc);
                    Assertions.assertTrue((boolean)((Boolean)future.get()));
                    Assertions.assertNull((Object)ssc.accept());
                }
            }
            SelectorTest.assertSelect(0, sscSel, false);
        });
    }

    @Test
    public void testCancelSelect() throws Exception {
        block2: {
            final AbstractSelector selector = this.selectorProvider().openSelector();
            final CompletableFuture cf = new CompletableFuture();
            new Thread(){

                @Override
                public void run() {
                    int num;
                    try {
                        num = selector.select();
                    }
                    catch (IOException e) {
                        cf.completeExceptionally(e);
                        return;
                    }
                    cf.complete(num);
                }
            }.start();
            selector.wakeup();
            try {
                Assertions.assertEquals((int)0, (Integer)((Integer)cf.get(5L, TimeUnit.SECONDS)));
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof SocketException && e.getCause().getMessage().contains("closed")) break block2;
                throw e;
            }
        }
    }

    private Future<Integer> newHelloClient(SocketAddress serverAddr, Semaphore sema) {
        return Executors.newFixedThreadPool(1).submit(() -> {
            try (Socket sock = this.connectTo(serverAddr);
                 OutputStream out = sock.getOutputStream();){
                out.write("Hello".getBytes(StandardCharsets.UTF_8));
                out.flush();
                if (sema != null) {
                    sema.tryAcquire(1, 10000L, TimeUnit.MILLISECONDS);
                }
            }
            return 0;
        });
    }

    @Test
    public void testConnectionCloseEventualClientDisconnect() throws Exception {
        this.testConnectionClose(false, false);
    }

    @Test
    public void testConnectionCloseImmediateClientDisconnect() throws Exception {
        this.testConnectionClose(true, false);
    }

    @Test
    public void testConnectionCloseEventualClientDisconnectKeepLooping() throws Exception {
        this.testConnectionClose(false, true);
    }

    @Test
    public void testConnectionCloseImmediateClientDisconnectKeepLooping() throws Exception {
        this.testConnectionClose(true, true);
    }

    private void testConnectionClose(boolean clientCloseImmediately, boolean checkInvalid) throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(512);
        SelectorProvider provider = this.selectorProvider();
        try (ServerSocketChannel server = provider.openServerSocketChannel();){
            server.bind(this.newTempAddress());
            server.configureBlocking(false);
            AbstractSelector selector = provider.openSelector();
            server.register(selector, 16);
            Semaphore mayCloseSema = new Semaphore(0);
            Future<Integer> threadFuture = this.newHelloClient(server.getLocalAddress(), clientCloseImmediately ? null : mayCloseSema);
            int numAcceptable = 0;
            int numReadable = 0;
            int numClosedChannelException = 0;
            int timeout = 5000;
            block11: while (timeout > 0) {
                long time = System.currentTimeMillis();
                while (selector.select(timeout) != 0) {
                    for (SelectionKey key : selector.selectedKeys()) {
                        SocketChannel channel;
                        if (numAcceptable > 3 || numReadable > 2) break block11;
                        if (checkInvalid && !key.isValid()) {
                            key.cancel();
                            timeout = 10;
                            continue;
                        }
                        if (key.isAcceptable()) {
                            channel = server.accept();
                            if (channel == null) continue;
                            ++numAcceptable;
                            channel.configureBlocking(false);
                            channel.register(selector, 1);
                            if (!clientCloseImmediately) {
                                Assertions.assertNotNull((Object)channel.getLocalAddress());
                            } else {
                                channel.getLocalAddress();
                            }
                            channel.getRemoteAddress();
                        }
                        if (!key.isReadable()) continue;
                        ++numReadable;
                        channel = (SocketChannel)key.channel();
                        try {
                            buffer.clear();
                            int numRead = channel.read(buffer);
                            switch (numReadable) {
                                case 1: {
                                    Assertions.assertEquals((Object)"Hello", (Object)new String(buffer.array(), 0, numRead, StandardCharsets.UTF_8));
                                    break;
                                }
                                case 2: {
                                    Assertions.fail((String)"Should have thrown ClosedChannelException");
                                    break;
                                }
                                default: {
                                    Assertions.fail((String)"Should not have been reached");
                                    break;
                                }
                            }
                        }
                        catch (ClosedChannelException e) {
                            ++numClosedChannelException;
                            if (checkInvalid) continue;
                            key.cancel();
                            if (numReadable < 2) continue;
                        }
                        break block11;
                    }
                }
                timeout = (int)((long)timeout - (System.currentTimeMillis() - time));
            }
            mayCloseSema.release();
            Assertions.assertEquals((int)1, (int)numAcceptable);
            if (checkInvalid) {
                if (numClosedChannelException == 0) {
                    if (clientCloseImmediately && numReadable != 0) {
                        Assertions.assertEquals((int)1, (int)numReadable);
                    }
                } else {
                    Assertions.assertEquals((int)2, (int)numReadable);
                    Assertions.assertEquals((int)1, (int)numClosedChannelException);
                }
            }
            threadFuture.get(1L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testClosedSelectorSelect() throws Exception {
        Assertions.assertThrows(ClosedSelectorException.class, () -> {
            AbstractSelector sel = this.selectorProvider().openSelector();
            ((Selector)sel).close();
            sel.select();
        });
    }

    @Test
    public void testClosedSelectorWakeup() throws Exception {
        AbstractSelector sel = this.selectorProvider().openSelector();
        ((Selector)sel).close();
        Assertions.assertEquals((Object)sel, (Object)sel.wakeup());
    }
}

