/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFTIPCSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketAddress;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public class FinalizeTestClient {
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    public static void main(String[] args) throws Exception {
        AFSocketAddress addr;
        String socketType = System.getProperty("test.junixsocket.socket.type", "");
        String socketName = System.getProperty("test.junixsocket.socket", "");
        if (socketType.isEmpty() || socketName.isEmpty()) {
            throw new IllegalArgumentException("Both test.junixsocket.socket and test.junixsocket.socket.type must be specified as system properties");
        }
        if ("UNIX".equals(socketType)) {
            addr = AFUNIXSocketAddress.unwrap(socketName, 0);
        } else if ("TIPC".equals(socketType)) {
            addr = AFTIPCSocketAddress.unwrap(socketName, 0);
        } else {
            throw new IllegalArgumentException("Unsupported socket type: " + socketType);
        }
        AFSocket<?> socket = AFSocket.connectTo((AFSocketAddress)Objects.requireNonNull(addr));
        ((Socket)socket).getInputStream().read();
        while (true) {
            new String("junixsocket".getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
        }
    }
}

