/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class SocketChannelTest<A extends SocketAddress>
extends SocketTestBase<A> {
    protected SocketChannelTest(AddressSpecifics<A> asp) {
        super(asp);
    }

    @Test
    public void testNonBlockingConnect() throws IOException {
        SocketAddress sa = this.newTempAddress();
        ServerSocketChannel ssc = this.selectorProvider().openServerSocketChannel();
        ssc.configureBlocking(false);
        ssc.bind(sa, 1);
        SocketChannel sc = this.selectorProvider().openSocketChannel();
        sc.configureBlocking(false);
        if (!sc.connect(sa)) {
            Assertions.assertTrue((sc.isConnected() || sc.isConnectionPending() ? 1 : 0) != 0);
            long now = System.currentTimeMillis();
            while (!sc.finishConnect()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (System.currentTimeMillis() - now > 1000L) {
                    Assertions.fail((String)"Non-blocking connect not connected after 1s");
                    break;
                }
                if (!Thread.interrupted()) continue;
            }
            Assertions.assertTrue((boolean)sc.finishConnect());
        }
        Assertions.assertTrue((boolean)sc.isConnected());
        Assertions.assertFalse((boolean)sc.isConnectionPending());
    }
}

