/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CancelAcceptTest
extends SocketTestBase {
    private boolean serverSocketClosed = false;

    @Test
    public void issue6test1() throws Exception {
        this.serverSocketClosed = false;
        final AtomicBoolean ignoreServerSocketClosedException = new AtomicBoolean(false);
        try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

            @Override
            protected void handleConnection(AFUNIXSocket sock) throws IOException {
            }

            @Override
            protected void onServerSocketClose() {
                CancelAcceptTest.this.serverSocketClosed = true;
            }

            @Override
            protected SocketTestBase.ExceptionHandlingDecision handleException(Exception e) {
                ServerSocket serverSocket;
                if (ignoreServerSocketClosedException.get() && e instanceof SocketException && (serverSocket = this.getServerSocket()) != null && serverSocket.isClosed()) {
                    return SocketTestBase.ExceptionHandlingDecision.IGNORE;
                }
                return SocketTestBase.ExceptionHandlingDecision.RAISE;
            }
        };){
            AFUNIXSocket sock3;
            AFUNIXSocket sock2 = this.connectToServer();
            if (sock2 != null) {
                sock2.close();
            }
            if ((sock2 = this.connectToServer()) != null) {
                sock2.close();
            }
            ServerSocket serverSocket = serverThread.getServerSocket();
            Assertions.assertFalse((this.serverSocketClosed && !serverSocket.isClosed() ? 1 : 0) != 0, (String)"ServerSocket should not be closed now");
            ignoreServerSocketClosedException.set(true);
            serverSocket.close();
            try {
                sock3 = this.connectToServer();
                if (sock3 != null) {
                    sock3.close();
                }
                Assertions.fail((String)"Did not throw SocketException");
            }
            catch (SocketException sock3) {
                // empty catch block
            }
            Assertions.assertTrue((this.serverSocketClosed || serverSocket.isClosed() ? 1 : 0) != 0, (String)"ServerSocket should be closed now");
            try {
                sock3 = this.connectToServer();
                try {
                    Assertions.fail((String)"ServerSocket should have been closed already");
                }
                finally {
                    if (sock3 != null) {
                        sock3.close();
                    }
                }
                Assertions.fail((String)"Did not throw SocketException");
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }
}

