/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AvailableTest
extends SocketTestBase {
    private static final int BYTES_SENT = 23;
    private static final int TIME_TO_SLEEP = 100;

    private void receiveBytes(Socket sock, int expected) throws IOException {
        InputStream in = sock.getInputStream();
        int toExpect = expected;
        int firstChar = 65;
        int available = in.available();
        if (available == 0 && expected != 0) {
            int r = in.read();
            Assertions.assertEquals((int)65, (int)r, (String)"Available returned 0, so we tried to read the first byte (which should be 65=='A')");
            --toExpect;
            available = in.available();
            firstChar = 66;
        }
        Assertions.assertEquals((int)toExpect, (int)available);
        byte[] buf = new byte[expected];
        int numRead = in.read(buf);
        Assertions.assertEquals((int)toExpect, (int)numRead);
        for (int i = 0; i < numRead; ++i) {
            Assertions.assertEquals((int)(firstChar + i), (int)(buf[i] & 0xFF));
        }
        Assertions.assertEquals((int)0, (int)in.available());
    }

    private void sendBytes(Socket sock) throws IOException {
        OutputStream out = sock.getOutputStream();
        byte[] buf = new byte[23];
        for (int i = 0; i < 23; ++i) {
            buf[i] = (byte)(i + 65);
        }
        out.write(buf);
        out.flush();
    }

    @Test
    public void testAvailableAtClient() {
        Assertions.assertTimeout((Duration)Duration.ofSeconds(2L), () -> {
            SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

                @Override
                protected void handleConnection(Socket sock) throws IOException {
                    AvailableTest.this.sendBytes(sock);
                    AvailableTest.this.sleepFor(100);
                    AvailableTest.this.receiveBytes(sock, 23);
                    this.stopAcceptingConnections();
                }
            };
            try (AFUNIXSocket sock = this.connectToServer();){
                this.sleepFor(100);
                this.receiveBytes((Socket)sock, 23);
                this.sendBytes((Socket)sock);
            }
            serverThread.getServerSocket().close();
            serverThread.checkException();
        });
    }

    @Test
    public void testAvailableAtServer() {
        Assertions.assertTimeout((Duration)Duration.ofSeconds(2L), () -> {
            SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

                @Override
                protected void handleConnection(Socket sock) throws IOException {
                    AvailableTest.this.sleepFor(100);
                    AvailableTest.this.receiveBytes(sock, 23);
                    AvailableTest.this.sendBytes(sock);
                    this.stopAcceptingConnections();
                }
            };
            try (AFUNIXSocket sock = this.connectToServer();){
                this.sendBytes((Socket)sock);
                this.sleepFor(100);
                this.receiveBytes((Socket)sock, 23);
            }
            serverThread.getServerSocket().close();
            serverThread.checkException();
        });
    }
}

