/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.IOException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.rmi.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.rmi.RemoteCloseable;
import org.newsclub.net.unix.rmi.RemoteCloseableThing;
import org.newsclub.net.unix.rmi.TestBase;
import org.newsclub.net.unix.rmi.TestService;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DOMAIN})
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public class RemoteCloseableTest
extends TestBase {
    @Test
    public void testRemoteCloseableWithACloseableThing() throws IOException, NotBoundException {
        RemoteCloseableThing.IsCloseable unused;
        RemoteCloseable<RemoteCloseableThing.IsCloseable> remoteCloseable2;
        TestService svc;
        block22: {
            svc = this.lookupTestService();
            svc.remoteCloseableThingResetNumberOfCloseCalls(RemoteCloseableThing.IsCloseable.class);
            try {
                remoteCloseable2 = svc.remoteCloseable(RemoteCloseableThing.IsCloseable.class);
                try {
                    unused = (RemoteCloseableThing.IsCloseable)remoteCloseable2.get();
                    try {
                        Assertions.assertEquals((int)0, (int)svc.remoteCloseableThingNumberOfCloseCalls(RemoteCloseableThing.IsCloseable.class));
                        remoteCloseable2.close();
                        Assertions.assertEquals((int)1, (int)svc.remoteCloseableThingNumberOfCloseCalls(RemoteCloseableThing.IsCloseable.class));
                        remoteCloseable2.close();
                        Assertions.fail((String)"Should have thrown an exception");
                    }
                    finally {
                        if (unused != null) {
                            unused.close();
                        }
                    }
                }
                finally {
                    if (remoteCloseable2 != null) {
                        remoteCloseable2.close();
                    }
                }
            }
            catch (NoSuchObjectException remoteCloseable2) {
            }
            catch (IllegalArgumentException e) {
                if (e.getCause() instanceof NoSuchMethodException) break block22;
                throw e;
            }
        }
        Assertions.assertEquals((int)1, (int)svc.remoteCloseableThingNumberOfCloseCalls(RemoteCloseableThing.IsCloseable.class));
        remoteCloseable2 = svc.remoteCloseable(RemoteCloseableThing.IsCloseable.class);
        try {
            unused = (RemoteCloseableThing.IsCloseable)remoteCloseable2.get();
            if (unused != null) {
                unused.close();
            }
        }
        finally {
            if (remoteCloseable2 != null) {
                remoteCloseable2.close();
            }
        }
        Assertions.assertEquals((int)2, (int)svc.remoteCloseableThingNumberOfCloseCalls(RemoteCloseableThing.IsCloseable.class));
    }

    @Test
    public void testRemoteCloseableWithANotCloseableThing() throws IOException, NotBoundException {
        TestService svc;
        block10: {
            svc = this.lookupTestService();
            svc.remoteCloseableThingResetNumberOfCloseCalls(RemoteCloseableThing.NotCloseable.class);
            try (RemoteCloseable<RemoteCloseableThing.NotCloseable> remoteCloseable2 = svc.remoteCloseable(RemoteCloseableThing.NotCloseable.class);){
                @NonNull RemoteCloseableThing testNotCloseable = (RemoteCloseableThing)remoteCloseable2.get();
                Objects.requireNonNull(testNotCloseable.toString());
                Assertions.assertEquals((int)0, (int)svc.remoteCloseableThingNumberOfCloseCalls(RemoteCloseableThing.NotCloseable.class));
                remoteCloseable2.close();
                Assertions.assertEquals((int)0, (int)svc.remoteCloseableThingNumberOfCloseCalls(RemoteCloseableThing.NotCloseable.class));
                remoteCloseable2.close();
                Assertions.fail((String)"Should have thrown an exception");
            }
            catch (NoSuchObjectException remoteCloseable2) {
            }
            catch (IllegalArgumentException e) {
                if (e.getCause() instanceof NoSuchMethodException) break block10;
                throw e;
            }
        }
        Assertions.assertEquals((int)0, (int)svc.remoteCloseableThingNumberOfCloseCalls(RemoteCloseableThing.NotCloseable.class));
        RemoteCloseable<RemoteCloseableThing.NotCloseable> unused = svc.remoteCloseable(RemoteCloseableThing.NotCloseable.class);
        if (unused != null) {
            unused.close();
        }
        Assertions.assertEquals((int)0, (int)svc.remoteCloseableThingNumberOfCloseCalls(RemoteCloseableThing.NotCloseable.class));
    }
}

