/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ShutdownHookSupport {
    private static final List<Thread> HOOKS = "true".equals(System.getProperty("org.newsclub.net.unix.rmi.collect-shutdown-hooks", "false")) ? new ArrayList() : null;

    ShutdownHookSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Thread addWeakShutdownHook(ShutdownHook hook) {
        ShutdownThread t = new ShutdownThread(new WeakReference<ShutdownHook>(hook));
        Runtime.getRuntime().addShutdownHook(t);
        if (HOOKS != null) {
            List<Thread> list = HOOKS;
            synchronized (list) {
                HOOKS.add(t);
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"RU_INVOKE_RUN"})
    static void runHooks() {
        if (HOOKS != null) {
            ArrayList<Thread> list;
            List<Thread> list2 = HOOKS;
            synchronized (list2) {
                list = new ArrayList<Thread>(HOOKS);
                HOOKS.clear();
            }
            for (Thread t : list) {
                t.run();
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class ShutdownThread
    extends Thread {
        private final WeakReference<ShutdownHook> ref;

        ShutdownThread(WeakReference<ShutdownHook> ref) {
            this.ref = ref;
        }

        @Override
        public void run() {
            ShutdownHook hook = (ShutdownHook)this.ref.get();
            this.ref.clear();
            try {
                if (hook != null) {
                    hook.onRuntimeShutdown(this);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static interface ShutdownHook {
        @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
        public void onRuntimeShutdown(Thread var1) throws Exception;
    }
}

