/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.annotation.NonNull;
import org.newsclub.net.unix.rmi.AFNamingProvider;
import org.newsclub.net.unix.rmi.AFNamingRef;
import org.newsclub.net.unix.rmi.AFRMIService;
import org.newsclub.net.unix.rmi.AFRMIServiceImpl;
import org.newsclub.net.unix.rmi.AFRMISocketFactory;
import org.newsclub.net.unix.rmi.AFRegistry;
import org.newsclub.net.unix.rmi.AFRegistryAccess;
import org.newsclub.net.unix.rmi.ShutdownException;
import org.newsclub.net.unix.rmi.ShutdownHookSupport;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AFNaming
extends AFRegistryAccess {
    private static final String RMI_SERVICE_NAME = AFRMIService.class.getName();
    private static final Map<AFNamingRef, AFNaming> INSTANCES = new HashMap<AFNamingRef, AFNaming>();
    private AFRegistry registry = null;
    private AFRMIService rmiService = null;
    private final int registryPort;
    private final int servicePort;
    AFRMISocketFactory socketFactory;
    private boolean remoteShutdownAllowed = true;
    private final AtomicBoolean shutdownInProgress = new AtomicBoolean(false);
    private final AtomicBoolean addedShutdownHook = new AtomicBoolean(false);

    protected AFNaming(int registryPort, int servicePort) throws IOException {
        this.registryPort = registryPort;
        this.servicePort = servicePort;
    }

    protected abstract AFRegistry newAFRegistry(Registry var1) throws RemoteException;

    protected abstract AFRMISocketFactory initSocketFactory() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends AFNaming> T getInstance(int registryPort, @NonNull AFNamingProvider<T> provider) throws RemoteException {
        Objects.requireNonNull(provider);
        AFNamingRef sap = new AFNamingRef(provider, registryPort);
        Class<AFNaming> clazz = AFNaming.class;
        synchronized (AFNaming.class) {
            AFNaming instance = INSTANCES.get(sap);
            if (instance == null) {
                try {
                    instance = provider.newInstance(registryPort);
                    Objects.requireNonNull(instance);
                    instance.socketFactory = instance.initSocketFactory();
                }
                catch (RemoteException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw new RemoteException(e.getMessage(), e);
                }
                INSTANCES.put(sap, instance);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return (T)instance;
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public synchronized AFRMISocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public final int getRegistryPort() {
        return this.registryPort;
    }

    AFRMIService getRMIService() throws RemoteException, NotBoundException {
        return this.getRMIService(this.getRegistry());
    }

    AFRMIService getRMIService(AFRegistry reg) throws RemoteException, NotBoundException {
        if (this.rmiService == null) {
            this.rmiService = this.getRMIServiceFromRegistry(reg);
        }
        return this.rmiService;
    }

    AFRMIService getRMIServiceFromRegistry(AFRegistry reg) throws RemoteException, NotBoundException {
        AFRMIService service = (AFRMIService)reg.lookup(RMI_SERVICE_NAME, 5L, TimeUnit.SECONDS);
        this.remoteShutdownAllowed = service.isShutdownAllowed();
        return service;
    }

    private void closeUponRuntimeShutdown() {
        if (this.addedShutdownHook.compareAndSet(false, true)) {
            ShutdownHookSupport.addWeakShutdownHook(new ShutdownHookSupport.ShutdownHook(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onRuntimeShutdown(Thread thread) throws IOException {
                    Class<AFNaming> clazz = AFNaming.class;
                    synchronized (AFNaming.class) {
                        if (AFNaming.this.registry != null && AFNaming.this.registry.isLocal()) {
                            AFNaming.this.shutdownRegistry();
                        }
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
    }

    private void rebindRMIService(AFRMIService assigner) throws RemoteException {
        this.rmiService = assigner;
        this.getRegistry().rebind(RMI_SERVICE_NAME, assigner);
    }

    @Override
    public AFRegistry getRegistry() throws RemoteException {
        return this.getRegistry(0L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AFRegistry getRegistry(long timeout, TimeUnit unit) throws RemoteException {
        if (this.shutdownInProgress.get()) {
            throw new ShutdownException();
        }
        Class<AFNaming> clazz = AFNaming.class;
        synchronized (AFNaming.class) {
            AFRegistry reg = this.getRegistry(false);
            if (reg == null) {
                reg = this.openRegistry(timeout, unit);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return reg;
        }
    }

    protected abstract AFRegistry openRegistry(long var1, TimeUnit var3) throws RemoteException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AFRegistry getRegistry(boolean create) throws RemoteException {
        if (this.shutdownInProgress.get()) {
            throw new ShutdownException();
        }
        Class<AFNaming> clazz = AFNaming.class;
        synchronized (AFNaming.class) {
            if (this.registry != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.registry;
            }
            if (!this.socketFactory.hasRegisteredPort(this.registryPort)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return create ? this.createRegistry() : null;
            }
            AFRegistry reg = this.locateRegistry();
            this.setRegistry(reg);
            try {
                this.getRMIService(reg);
            }
            catch (ConnectIOException | NoSuchObjectException | NotBoundException e) {
                if (create) {
                    this.setRegistry(null);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.createRegistry();
                }
                throw new ServerException("Could not access " + AFRMIService.class.getName(), e);
            }
            return this.registry;
        }
    }

    private AFRegistry locateRegistry() throws RemoteException {
        Registry regImpl = LocateRegistry.getRegistry(null, this.registryPort, this.socketFactory);
        return regImpl == null ? null : this.newAFRegistry(regImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownRegistry() throws RemoteException {
        Class<AFNaming> clazz = AFNaming.class;
        synchronized (AFNaming.class) {
            if (this.registry == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            AFRegistry registryToBeClosed = this.registry;
            AFRMIService rmiServiceToBeClosed = this.rmiService;
            if (!registryToBeClosed.isLocal()) {
                if (!this.isRemoteShutdownAllowed()) {
                    throw new ServerException("The server refuses to be shutdown remotely");
                }
                this.setRegistry(null);
                try {
                    this.shutdownViaRMIService(registryToBeClosed, rmiServiceToBeClosed);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            this.setRegistry(null);
            if (!this.shutdownInProgress.compareAndSet(false, true)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                this.unexportRMIService(registryToBeClosed, (AFRMIServiceImpl)rmiServiceToBeClosed);
                this.forceUnexportBound(registryToBeClosed);
                this.closeSocketFactory();
                this.shutdownRegistryFinishingTouches();
            }
            finally {
                this.shutdownInProgress.set(false);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected abstract void shutdownRegistryFinishingTouches();

    private void unexportRMIService(AFRegistry reg, AFRMIServiceImpl serv) throws AccessException, RemoteException {
        if (serv != null) {
            serv.shutdownRegisteredCloseables();
        }
        try {
            if (serv != null) {
                AFNaming.unexportObject(serv);
            }
            reg.unbind(RMI_SERVICE_NAME);
        }
        catch (NotBoundException | ShutdownException exception) {
            // empty catch block
        }
        this.rmiService = null;
    }

    private void forceUnexportBound(AFRegistry reg) {
        try {
            reg.forceUnexportBound();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSocketFactory() {
        if (this.socketFactory != null) {
            try {
                this.socketFactory.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void shutdownViaRMIService(AFRegistry reg, AFRMIService serv) throws RemoteException {
        try {
            if (serv == null) {
                serv = this.getRMIService(reg);
            }
            if (serv.isShutdownAllowed()) {
                serv.shutdown();
            }
        }
        catch (ConnectIOException | NotBoundException | ServerException exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AFRegistry createRegistry() throws RemoteException {
        Class<AFNaming> clazz = AFNaming.class;
        synchronized (AFNaming.class) {
            AFRegistry existingRegistry = this.registry;
            if (existingRegistry == null) {
                try {
                    existingRegistry = this.getRegistry(false);
                }
                catch (ServerException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof NotBoundException || cause instanceof ConnectIOException) {
                        existingRegistry = null;
                    }
                    throw e;
                }
            }
            if (existingRegistry != null) {
                if (!this.isRemoteShutdownAllowed()) {
                    throw new ServerException("The server refuses to be shutdown remotely");
                }
                this.shutdownRegistry();
            }
            this.initRegistryPrerequisites();
            this.setRegistry(this.newAFRegistry(LocateRegistry.createRegistry(this.registryPort, this.socketFactory, this.socketFactory)));
            AFRMIServiceImpl service = new AFRMIServiceImpl(this);
            UnicastRemoteObject.exportObject(service, this.servicePort, this.socketFactory, this.socketFactory);
            this.rebindRMIService(service);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.registry;
        }
    }

    protected abstract void initRegistryPrerequisites() throws ServerException;

    public boolean isRemoteShutdownAllowed() {
        return this.remoteShutdownAllowed;
    }

    public void setRemoteShutdownAllowed(boolean remoteShutdownAllowed) {
        this.remoteShutdownAllowed = remoteShutdownAllowed;
    }

    public void exportAndBind(String name, Remote obj) throws RemoteException, AlreadyBoundException {
        AFNaming.exportObject(obj, this.getSocketFactory());
        this.getRegistry().bind(name, obj);
    }

    public void exportAndRebind(String name, Remote obj) throws RemoteException {
        AFNaming.exportObject(obj, this.getSocketFactory());
        this.getRegistry().rebind(name, obj);
    }

    public void unexportAndUnbind(String name, Remote obj) throws RemoteException {
        AFNaming.unexportObject(obj);
        try {
            this.unbind(name);
        }
        catch (MalformedURLException | NotBoundException exception) {
            // empty catch block
        }
    }

    public static Remote exportObject(Remote obj, RMISocketFactory socketFactory) throws RemoteException {
        return UnicastRemoteObject.exportObject(obj, 0, socketFactory, socketFactory);
    }

    public static void unexportObject(Remote obj) {
        try {
            UnicastRemoteObject.unexportObject(obj, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRegistry(AFRegistry registry) {
        Class<AFNaming> clazz = AFNaming.class;
        synchronized (AFNaming.class) {
            this.registry = registry;
            if (registry == null) {
                this.rmiService = null;
            } else if (registry.isLocal()) {
                this.closeUponRuntimeShutdown();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

