/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import java.io.IOException;
import java.io.ObjectOutput;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteObjectInvocationHandler;
import org.newsclub.net.unix.AFUNIXSocketCredentials;
import org.newsclub.net.unix.rmi.AFUNIXRMISocketFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class RemotePeerInfo {
    private RMISocketFactory socketFactory;
    String host;
    int port;
    private AFUNIXSocketCredentials peerCredentials;

    RemotePeerInfo() {
    }

    public RMISocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public AFUNIXSocketCredentials getPeerCredentials() {
        return this.peerCredentials;
    }

    public static AFUNIXSocketCredentials remotePeerCredentials() {
        return AFUNIXSocketCredentials.remotePeerCredentials();
    }

    public static AFUNIXSocketCredentials remotePeerCredentials(Remote obj) throws IOException {
        return RemotePeerInfo.getConnectionInfo(obj).getPeerCredentials();
    }

    public static RemotePeerInfo getConnectionInfo(Remote obj) throws IOException {
        try (ExtractingObjectOutput eoo = new ExtractingObjectOutput();){
            RemoteObjectInvocationHandler roih = (RemoteObjectInvocationHandler)Proxy.getInvocationHandler(RemoteObject.toStub(obj));
            roih.getRef().writeExternal(eoo);
            if (!eoo.validate()) {
                throw new IOException("Unexpected data format for " + obj.getClass());
            }
            RemotePeerInfo data = eoo.data;
            if (data.socketFactory instanceof AFUNIXRMISocketFactory) {
                AFUNIXRMISocketFactory sf = (AFUNIXRMISocketFactory)data.socketFactory;
                data.peerCredentials = sf.peerCredentialsFor(data);
                if (data.peerCredentials == null && sf.isLocalServer(data.port)) {
                    data.peerCredentials = AFUNIXSocketCredentials.SAME_PROCESS;
                }
            }
            RemotePeerInfo remotePeerInfo = data;
            return remotePeerInfo;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.host + ":" + this.port + ";socketFactory=" + this.socketFactory + ";peerCredentials=" + this.peerCredentials + "]";
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class ExtractingObjectOutput
    implements ObjectOutput {
        private int callId = 0;
        private boolean done = false;
        private boolean invalid = false;
        private int format = -1;
        final RemotePeerInfo data = new RemotePeerInfo();

        private void setInvalid() {
            this.done = true;
            this.invalid = true;
        }

        private void call(int id, Object v) {
            switch (id) {
                case 1: {
                    if (!(v instanceof Integer)) break;
                    switch ((Integer)v) {
                        case 0: {
                            this.format = 0;
                            return;
                        }
                        case 1: {
                            this.format = 1;
                            return;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!(v instanceof String)) break;
                    this.data.host = (String)v;
                    return;
                }
                case 3: {
                    if (this.format == 0) {
                        this.done = true;
                    }
                    if (!(v instanceof Integer)) break;
                    this.data.port = (Integer)v;
                    if (this.data.port <= 0) {
                        this.setInvalid();
                    }
                    return;
                }
                case 4: {
                    if (!(v instanceof RMISocketFactory) || this.format != 1) break;
                    this.data.socketFactory = (RMISocketFactory)v;
                    return;
                }
                default: {
                    this.done = true;
                    return;
                }
            }
            this.setInvalid();
        }

        @Override
        public void writeBoolean(boolean v) {
            if (this.done) {
                return;
            }
            this.call(++this.callId, v);
        }

        @Override
        public void writeByte(int v) {
            if (this.done) {
                return;
            }
            this.call(++this.callId, v);
        }

        @Override
        public void writeShort(int v) {
            if (this.done) {
                return;
            }
            this.call(++this.callId, v);
        }

        @Override
        public void writeChar(int v) {
            if (this.done) {
                return;
            }
            this.call(++this.callId, v);
        }

        @Override
        public void writeInt(int v) {
            if (this.done) {
                return;
            }
            this.call(++this.callId, v);
        }

        @Override
        public void writeLong(long v) {
            if (this.done) {
                return;
            }
            this.call(++this.callId, v);
        }

        @Override
        public void writeFloat(float v) {
            if (this.done) {
                return;
            }
            this.call(++this.callId, Float.valueOf(v));
        }

        @Override
        public void writeDouble(double v) {
            if (this.done) {
                return;
            }
            this.call(++this.callId, v);
        }

        @Override
        public void writeBytes(String s) {
            if (this.done) {
                return;
            }
            this.call(++this.callId, s);
        }

        @Override
        public void writeChars(String s) {
            if (this.done) {
                return;
            }
            this.call(++this.callId, s);
        }

        @Override
        public void writeUTF(String s) {
            if (this.done) {
                return;
            }
            this.call(++this.callId, s);
        }

        @Override
        public void writeObject(Object obj) {
            if (this.done) {
                return;
            }
            this.call(++this.callId, obj);
        }

        @Override
        public void write(int b) {
            if (this.done) {
                return;
            }
            this.call(++this.callId, b);
        }

        @Override
        public void write(byte[] b) {
            if (this.done) {
                return;
            }
            this.call(++this.callId, b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            if (this.done) {
                return;
            }
            this.setInvalid();
        }

        @Override
        public void flush() {
        }

        public boolean validate() {
            this.done = true;
            if (this.callId < 3) {
                this.setInvalid();
            }
            return !this.invalid;
        }

        @Override
        public void close() {
        }
    }
}

