/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.rmi.NotBoundException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.rmi.AFUNIXNaming;
import org.newsclub.net.unix.rmi.DefaultRMIClientSocketFactory;
import org.newsclub.net.unix.rmi.DefaultRMIServerSocketFactory;
import org.newsclub.net.unix.rmi.PortAssigner;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFUNIXRMISocketFactory
extends RMISocketFactory
implements Externalizable {
    static final String DEFAULT_SOCKET_FILE_PREFIX = "";
    static final String DEFAULT_SOCKET_FILE_SUFFIX = ".rmi";
    private static final long serialVersionUID = 1L;
    private RMIClientSocketFactory defaultClientFactory;
    private RMIServerSocketFactory defaultServerFactory;
    private File socketDir;
    private AFUNIXNaming naming;
    private String socketPrefix;
    private String socketSuffix;
    private PortAssigner generator = null;

    public AFUNIXRMISocketFactory() {
    }

    public AFUNIXRMISocketFactory(AFUNIXNaming naming, File socketDir) throws IOException {
        this(naming, socketDir, DefaultRMIClientSocketFactory.getInstance(), DefaultRMIServerSocketFactory.getInstance());
    }

    public AFUNIXRMISocketFactory(AFUNIXNaming naming, File socketDir, RMIClientSocketFactory defaultClientFactory, RMIServerSocketFactory defaultServerFactory) throws IOException {
        this(naming, socketDir, defaultClientFactory, defaultServerFactory, null, null);
    }

    public AFUNIXRMISocketFactory(AFUNIXNaming naming, File socketDir, RMIClientSocketFactory defaultClientFactory, RMIServerSocketFactory defaultServerFactory, String socketPrefix, String socketSuffix) throws IOException {
        this.naming = naming;
        this.socketDir = socketDir;
        this.defaultClientFactory = defaultClientFactory;
        this.defaultServerFactory = defaultServerFactory;
        this.socketPrefix = socketPrefix == null ? DEFAULT_SOCKET_FILE_PREFIX : socketPrefix;
        this.socketSuffix = socketSuffix == null ? DEFAULT_SOCKET_FILE_SUFFIX : socketSuffix;
    }

    public int hashCode() {
        return this.socketDir == null ? super.hashCode() : this.socketDir.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof AFUNIXRMISocketFactory)) {
            return false;
        }
        AFUNIXRMISocketFactory sf = (AFUNIXRMISocketFactory)other;
        return sf.socketDir.equals(this.socketDir);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        RMIClientSocketFactory cf = this.defaultClientFactory;
        if (cf != null && port < 100000) {
            return cf.createSocket(host, port);
        }
        AFUNIXSocketAddress addr = new AFUNIXSocketAddress(this.getFile(port), port);
        return AFUNIXSocket.connectTo((AFUNIXSocketAddress)addr);
    }

    public File getSocketDir() {
        return this.socketDir;
    }

    private File getFile(int port) {
        if (this.naming.getRegistryPort() == Integer.MAX_VALUE) {
            return this.socketDir;
        }
        return new File(this.socketDir, this.socketPrefix + port + this.socketSuffix);
    }

    public void close() {
    }

    protected int newPort() throws IOException {
        if (this.generator == null) {
            try {
                this.generator = this.naming.getPortAssigner();
            }
            catch (NotBoundException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        return this.generator.newPort();
    }

    protected void returnPort(int port) throws IOException {
        if (this.generator == null) {
            try {
                this.generator = this.naming.getPortAssigner();
            }
            catch (NotBoundException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        this.generator.returnPort(port);
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        if (port == 0) {
            port = this.newPort();
            AFUNIXSocketAddress addr = new AFUNIXSocketAddress(this.getFile(port), port);
            AnonymousServerSocket ass = new AnonymousServerSocket(port);
            ass.bind((SocketAddress)addr);
            return ass;
        }
        RMIServerSocketFactory sf = this.defaultServerFactory;
        if (sf != null && port < 100000) {
            return sf.createServerSocket(port);
        }
        AFUNIXSocketAddress addr = new AFUNIXSocketAddress(this.getFile(port), port);
        return AFUNIXServerSocket.bindOn((AFUNIXSocketAddress)addr);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.socketDir = new File(in.readUTF());
        int port = in.readInt();
        this.naming = AFUNIXNaming.getInstance(this.socketDir, port);
        this.defaultClientFactory = (RMIClientSocketFactory)in.readObject();
        this.defaultServerFactory = (RMIServerSocketFactory)in.readObject();
        this.socketPrefix = in.readUTF();
        this.socketSuffix = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.socketDir.getAbsolutePath());
        out.writeInt(this.naming.getRegistryPort());
        out.writeObject(this.defaultClientFactory);
        out.writeObject(this.defaultServerFactory);
        out.writeUTF(this.socketPrefix);
        out.writeUTF(this.socketSuffix);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private final class AnonymousServerSocket
    extends AFUNIXServerSocket {
        private final int returnPort;

        protected AnonymousServerSocket(int returnPort) throws IOException {
            this.returnPort = returnPort;
        }

        public void close() throws IOException {
            super.close();
            AFUNIXRMISocketFactory.this.returnPort(this.returnPort);
        }
    }
}

