/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo.ssl;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.DestroyFailedException;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.ssl.SSLContextBuilder;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SSLDemoClient {
    public static void main(String[] args) throws InterruptedException, IOException, GeneralSecurityException, DestroyFailedException {
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.of((File)new File("/tmp/ssldemo"));
        SSLSocketFactory clientSocketFactory = SSLContextBuilder.forClient().withKeyStore(new File("juxclient.p12"), () -> "clientpass".toCharArray()).withTrustStore(new File("juxclient.truststore"), () -> "clienttrustpass".toCharArray()).withDefaultSSLParameters(p -> {}).buildAndDestroyBuilder().getSocketFactory();
        System.out.println("Connecting to " + addr);
        try (AFUNIXSocket plainSocket = AFUNIXSocket.connectTo((AFUNIXSocketAddress)addr);
             SSLSocket sslSocket = (SSLSocket)clientSocketFactory.createSocket((Socket)plainSocket, "localhost.junixsocket", plainSocket.getPort(), false);
             InputStream in = sslSocket.getInputStream();
             OutputStream out = sslSocket.getOutputStream();){
            plainSocket.setOutboundFileDescriptors(new FileDescriptor[]{FileDescriptor.err});
            System.out.println("Writing byte...");
            out.write(175);
            out.flush();
            byte[] by = new byte[11];
            int r = in.read(by);
            System.out.println("Received string: " + new String(by, 0, r, StandardCharsets.UTF_8));
        }
    }
}

